/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CuckooHashSet<E>
extends AbstractSet<E> {
    private static final int DEFAULT_SIZE_LOG_2 = 5;
    protected int mLog2buckets = 5;
    protected Object[] mBuckets;
    protected E mStash;
    private int mSize;

    public CuckooHashSet(int size) {
        this.mLog2buckets = CuckooHashSet.log2(2 * size);
        this.mBuckets = new Object[1 << this.mLog2buckets];
    }

    public CuckooHashSet() {
        this.mLog2buckets = 5;
        this.mBuckets = new Object[32];
    }

    protected int hash(Object o) {
        return CuckooHashSet.hashJenkins(o.hashCode());
    }

    protected static int hashJenkins(int hash) {
        hash += hash << 12;
        hash ^= hash >>> 22;
        hash += hash << 4;
        hash ^= hash >>> 9;
        hash += hash << 10;
        hash ^= hash >>> 2;
        hash += hash << 7;
        hash ^= hash >>> 12;
        return hash;
    }

    protected final int hash1(int hash) {
        return hash & this.mBuckets.length - 1;
    }

    protected final int hash2(int hash) {
        hash = CuckooHashSet.hashJenkins(hash);
        hash = (hash >>> this.mLog2buckets & this.mBuckets.length - 1) + (hash & this.mBuckets.length - 1) + 1;
        hash = hash + (hash >>> this.mLog2buckets) & this.mBuckets.length - 1;
        return hash;
    }

    private boolean containsStash(Object object) {
        return object.equals(this.mStash);
    }

    @Override
    public boolean contains(Object object) {
        int hash = this.hash(object);
        int hash1 = this.hash1(hash);
        if (object.equals(this.mBuckets[hash1])) {
            return true;
        }
        if (object.equals(this.mBuckets[this.hash2(hash) ^ hash1])) {
            return true;
        }
        return this.mStash != null && this.containsStash(object);
    }

    private void resize() {
        Object[] oldbuckets = this.mBuckets;
        E oldstash = this.mStash;
        this.mStash = null;
        ++this.mLog2buckets;
        this.mBuckets = new Object[1 << this.mLog2buckets];
        for (int i = 0; i < oldbuckets.length; ++i) {
            if (oldbuckets[i] == null) continue;
            this.add_internal(this.hash1(this.hash(oldbuckets[i])), oldbuckets[i]);
        }
        this.add_internal(this.hash1(this.hash(oldstash)), oldstash);
    }

    private void add_internal(int hash, E toAdd) {
        int maxIter = this.mBuckets.length >> 2;
        boolean checkedStash = false;
        while (true) {
            assert (this.checkpos(hash));
            Object spill = this.mBuckets[hash];
            this.mBuckets[hash] = toAdd;
            assert (this.checkpos(hash));
            if (spill == null) {
                return;
            }
            toAdd = spill;
            hash ^= this.hash2(this.hash(toAdd));
            if (maxIter-- != 0) continue;
            if (this.mStash == null) {
                this.mStash = toAdd;
                return;
            }
            if (!checkedStash) {
                E oldstash = this.mStash;
                this.mStash = toAdd;
                toAdd = oldstash;
                checkedStash = true;
            } else {
                this.resize();
            }
            maxIter = this.mBuckets.length >> 2;
            hash = this.hash1(this.hash(toAdd));
        }
    }

    private boolean checkpos(int i) {
        if (this.mBuckets[i] != null) {
            int hash = this.hash(this.mBuckets[i]);
            int hash1 = this.hash1(hash);
            int hash2 = hash1 ^ this.hash2(hash);
            assert (hash1 == i || hash2 == i);
        }
        return true;
    }

    private boolean invariant() {
        assert (this.mSize >= 0);
        int cnt = 0;
        for (int i = 0; i < this.mBuckets.length; ++i) {
            assert (this.checkpos(i));
            if (this.mBuckets[i] == null) continue;
            ++cnt;
        }
        if (this.mStash != null) {
            ++cnt;
        }
        assert (this.mSize == cnt);
        return true;
    }

    @Override
    public boolean add(E toAdd) {
        int hash = this.hash(toAdd);
        int hash1 = this.hash1(hash);
        if (toAdd.equals(this.mBuckets[hash1])) {
            return false;
        }
        if (toAdd.equals(this.mBuckets[this.hash2(hash) ^ hash1])) {
            return false;
        }
        if (this.mStash != null && this.containsStash(toAdd)) {
            return false;
        }
        if (this.mBuckets[hash1] == null) {
            this.mBuckets[hash1] = toAdd;
        } else {
            this.add_internal(hash1, toAdd);
        }
        ++this.mSize;
        return true;
    }

    @Override
    public boolean remove(Object toRemove) {
        int hash = this.hash(toRemove);
        int hash1 = this.hash1(hash);
        if (toRemove.equals(this.mBuckets[hash1])) {
            --this.mSize;
            assert (this.mSize >= 0);
            this.mBuckets[hash1] = null;
            return true;
        }
        if (toRemove.equals(this.mBuckets[hash1 ^= this.hash2(hash)])) {
            --this.mSize;
            assert (this.mSize >= 0);
            this.mBuckets[hash1] = null;
            return true;
        }
        if (this.mStash != null && toRemove.equals(this.mStash)) {
            --this.mSize;
            assert (this.mSize >= 0);
            this.mStash = null;
            return true;
        }
        return false;
    }

    private static final int log2(int size) {
        int i = 4;
        int j = 2;
        while (i < size) {
            i += i;
            ++j;
        }
        return j;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            int mLastPos = -1;
            int mPos = 0;

            @Override
            public boolean hasNext() {
                while (this.mPos < CuckooHashSet.this.mBuckets.length && CuckooHashSet.this.mBuckets[this.mPos] == null) {
                    ++this.mPos;
                }
                if (this.mPos == CuckooHashSet.this.mBuckets.length && CuckooHashSet.this.mStash == null) {
                    ++this.mPos;
                }
                return this.mPos <= CuckooHashSet.this.mBuckets.length;
            }

            @Override
            public E next() {
                while (this.mPos < CuckooHashSet.this.mBuckets.length && CuckooHashSet.this.mBuckets[this.mPos] == null) {
                    ++this.mPos;
                }
                this.mLastPos = this.mPos;
                if (this.mPos < CuckooHashSet.this.mBuckets.length) {
                    return CuckooHashSet.this.mBuckets[this.mPos++];
                }
                if (this.mPos == CuckooHashSet.this.mBuckets.length && CuckooHashSet.this.mStash != null) {
                    ++this.mPos;
                    return CuckooHashSet.this.mStash;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                if (this.mLastPos < CuckooHashSet.this.mBuckets.length) {
                    CuckooHashSet.this.mBuckets[this.mLastPos] = null;
                } else {
                    CuckooHashSet.this.mStash = null;
                }
                CuckooHashSet.this.mSize--;
                assert (CuckooHashSet.this.mSize >= 0);
            }
        };
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public void clear() {
        this.mSize = 0;
        for (int i = 0; i < this.mBuckets.length; ++i) {
            this.mBuckets[i] = null;
        }
        this.mStash = null;
    }

    public E removeSome() {
        if (this.mSize == 0) {
            return null;
        }
        --this.mSize;
        assert (this.mSize >= 0);
        if (this.mStash != null) {
            E entry = this.mStash;
            this.mStash = null;
            return entry;
        }
        int i = 0;
        while (true) {
            if (this.mBuckets[i] != null) {
                Object entry = this.mBuckets[i];
                this.mBuckets[i] = null;
                return (E)entry;
            }
            ++i;
        }
    }
}

