/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashMap;
import java.util.Map;

public class DAGSize
extends NonRecursive {
    private final Map<Term, Long> mCache = new HashMap<Term, Long>();
    private boolean mComputeTreeSize;
    private long mSize = 0L;

    @Override
    public void reset() {
        super.reset();
        this.mCache.clear();
        this.mSize = 0L;
    }

    public int size(Term term) {
        this.mComputeTreeSize = false;
        this.run(new TermOnceWalker(new FormulaUnLet().unlet(term)));
        return (int)this.mSize;
    }

    public long treesize(Term term) {
        this.mComputeTreeSize = true;
        this.run(new TermOnceWalker(new FormulaUnLet().unlet(term)));
        return this.mSize;
    }

    private class TermOnceWalker
    extends NonRecursive.TermWalker {
        public TermOnceWalker(Term term) {
            super(term);
        }

        @Override
        public void walk(NonRecursive walker) {
            if (DAGSize.this.mCache.containsKey(this.mTerm)) {
                if (DAGSize.this.mComputeTreeSize) {
                    DAGSize.this.mSize += (Long)DAGSize.this.mCache.get(this.mTerm);
                }
                return;
            }
            if (DAGSize.this.mComputeTreeSize) {
                DAGSize.this.enqueueWalker(new TreeSizeCache(this.mTerm));
            } else {
                DAGSize.this.mCache.put(this.mTerm, 0L);
            }
            ++DAGSize.this.mSize;
            super.walk(walker);
        }

        @Override
        public void walk(NonRecursive walker, ConstantTerm term) {
        }

        @Override
        public void walk(NonRecursive walker, AnnotatedTerm term) {
            walker.enqueueWalker(new TermOnceWalker(term.getSubterm()));
        }

        @Override
        public void walk(NonRecursive walker, ApplicationTerm term) {
            for (Term t : term.getParameters()) {
                walker.enqueueWalker(new TermOnceWalker(t));
            }
        }

        @Override
        public void walk(NonRecursive walker, LetTerm term) {
            throw new InternalError("Input should be unletted");
        }

        @Override
        public void walk(NonRecursive walker, LambdaTerm term) {
            walker.enqueueWalker(new TermOnceWalker(term.getSubterm()));
        }

        @Override
        public void walk(NonRecursive walker, QuantifiedFormula term) {
            walker.enqueueWalker(new TermOnceWalker(term.getSubformula()));
        }

        @Override
        public void walk(NonRecursive walker, MatchTerm term) {
            walker.enqueueWalker(new TermOnceWalker(term.getDataTerm()));
            for (Term t : term.getCases()) {
                walker.enqueueWalker(new TermOnceWalker(t));
            }
        }

        @Override
        public void walk(NonRecursive walker, TermVariable term) {
        }
    }

    private class TreeSizeCache
    implements NonRecursive.Walker {
        long mSizeBefore = 0L;
        Term mTerm;

        public TreeSizeCache(Term term) {
            this.mSizeBefore = DAGSize.this.mSize;
            this.mTerm = term;
        }

        @Override
        public void walk(NonRecursive walker) {
            DAGSize.this.mCache.put(this.mTerm, DAGSize.this.mSize - this.mSizeBefore);
        }
    }
}

