/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FunctionalMap<K, V>
extends AbstractMap<K, V>
implements Map.Entry<K, V> {
    private static FunctionalMap<?, ?> EMPTY = new FunctionalMap();
    FunctionalMap<K, V> mLeft;
    FunctionalMap<K, V> mRight;
    K mKey;
    V mValue;
    int mSizeColor;

    public static <K, V> FunctionalMap<K, V> empty() {
        return EMPTY;
    }

    private FunctionalMap() {
        this.mLeft = null;
        this.mRight = null;
        this.mKey = null;
        this.mValue = null;
        this.mSizeColor = 0;
    }

    private FunctionalMap(FunctionalMap<K, V> left, FunctionalMap<K, V> right, K key, V value, int sizeColor) {
        this.mLeft = left;
        this.mRight = right;
        this.mKey = key;
        this.mValue = value;
        this.mSizeColor = sizeColor;
        assert (left != null && right != null);
        assert (key != null && value != null);
        assert (this.isTwoNode() || super.isTwoNode());
        assert (this.size() == left.size() + right.size() + 1);
        assert (this.mRight.getHeight() == this.getHeight() - (this.isTwoNode() ? 1 : 0));
    }

    private FunctionalMap(FunctionalMap<K, V> left, FunctionalMap<K, V> right, K key, V value, boolean isTwoNode) {
        this.mLeft = left;
        this.mRight = right;
        this.mKey = key;
        this.mValue = value;
        int size = left.size() + right.size() + 1;
        int n = this.mSizeColor = isTwoNode ? size : -size;
        assert (this.isTwoNode() || super.isTwoNode());
        assert (left == null && right == null || key != null && value != null);
        assert (left == null && right == null || this.mRight.getHeight() == this.getHeight() - (this.isTwoNode() ? 1 : 0));
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public V get(Object key) {
        int hash = key.hashCode();
        FunctionalMap<K, V> tree = this;
        while (tree != EMPTY) {
            if (hash < tree.mKey.hashCode()) {
                tree = tree.mLeft;
                continue;
            }
            if (hash == tree.mKey.hashCode()) {
                if (tree.mKey.equals(key)) {
                    return tree.mValue;
                }
                V leftValue = tree.mLeft.get(key);
                if (leftValue != null) {
                    return leftValue;
                }
            }
            tree = tree.mRight;
        }
        return null;
    }

    public FunctionalMap<K, V> insert(K key, V value) {
        int hash = key.hashCode();
        FunctionalMap<K, V> tree = this;
        ArrayDeque<FunctionalMap<K, V>> pathFromRoot = new ArrayDeque<FunctionalMap<K, V>>();
        boolean wentLeft = false;
        while (tree != EMPTY) {
            pathFromRoot.add(tree);
            if (hash < tree.mKey.hashCode()) {
                tree = tree.mLeft;
                wentLeft = true;
                continue;
            }
            tree = tree.mRight;
            wentLeft = false;
        }
        FunctionalMap<K, V> newNode = new FunctionalMap<K, V>(FunctionalMap.empty(), FunctionalMap.empty(), key, value, 1);
        boolean increaseHeight = true;
        while (!pathFromRoot.isEmpty()) {
            FunctionalMap parent = (FunctionalMap)pathFromRoot.removeLast();
            if (!increaseHeight) {
                newNode = new FunctionalMap<K, V>(wentLeft ? newNode : parent.mLeft, wentLeft ? parent.mRight : newNode, parent.mKey, parent.mValue, parent.mSizeColor < 0 ? parent.mSizeColor - 1 : parent.mSizeColor + 1);
            } else {
                FunctionalMap grandParent;
                boolean parentFull;
                FunctionalMap realParent = parent;
                boolean bl = parentFull = !parent.isTwoNode();
                if (!(parentFull || pathFromRoot.isEmpty() || (grandParent = (FunctionalMap)pathFromRoot.getLast()).isTwoNode() || grandParent.mRight != parent)) {
                    parentFull = true;
                    realParent = (FunctionalMap)pathFromRoot.removeLast();
                }
                if (parentFull) {
                    FunctionalMap<K, V> newLeft;
                    if (parent == realParent) {
                        newNode = new FunctionalMap<K, V>(newNode, realParent.mRight, realParent.mKey, realParent.mValue, true);
                    } else if (wentLeft) {
                        newLeft = new FunctionalMap<K, V>(realParent.mLeft, newNode.mLeft, realParent.mKey, realParent.mValue, true);
                        FunctionalMap<K, V> newRight = new FunctionalMap<K, V>(newNode.mRight, parent.mRight, parent.mKey, parent.mValue, true);
                        newNode = new FunctionalMap<K, V>(newLeft, newRight, newNode.mKey, newNode.mValue, true);
                    } else {
                        newLeft = new FunctionalMap<K, V>(realParent.mLeft, parent.mLeft, realParent.mKey, realParent.mValue, true);
                        newNode = new FunctionalMap<K, V>(newLeft, newNode, parent.mKey, parent.mValue, true);
                    }
                    parent = realParent;
                } else {
                    increaseHeight = false;
                    if (wentLeft) {
                        FunctionalMap<K, V> newRight = new FunctionalMap<K, V>(newNode.mRight, parent.mRight, parent.mKey, parent.mValue, true);
                        newNode = new FunctionalMap<K, V>(newNode.mLeft, newRight, newNode.mKey, newNode.mValue, false);
                    } else {
                        newNode = new FunctionalMap<K, V>(parent.mLeft, newNode, parent.mKey, parent.mValue, false);
                    }
                }
            }
            if (pathFromRoot.isEmpty()) continue;
            wentLeft = ((FunctionalMap)pathFromRoot.getLast()).mLeft == parent;
        }
        return newNode;
    }

    public FunctionalMap<K, V> delete(K key) {
        boolean decreaseHeight;
        FunctionalMap<K, V> newNode;
        int hash = key.hashCode();
        FunctionalMap<K, V> tree = this;
        ArrayList<FunctionalMap<K, V>> pathFromRoot = new ArrayList<FunctionalMap<K, V>>();
        BitSet wentLeftBits = new BitSet();
        while (tree != EMPTY) {
            boolean wentLeft;
            pathFromRoot.add(tree);
            if (hash < tree.mKey.hashCode()) {
                tree = tree.mLeft;
                wentLeft = true;
            } else if (hash == tree.mKey.hashCode()) {
                if (key.equals(tree.mKey)) break;
                if (tree.mLeft.get(key) != null) {
                    tree = tree.mLeft;
                    wentLeft = true;
                } else {
                    tree = tree.mRight;
                    wentLeft = false;
                }
            } else {
                tree = tree.mRight;
                wentLeft = false;
            }
            wentLeftBits.set(pathFromRoot.size() - 1, wentLeft);
        }
        if (tree == EMPTY) {
            return this;
        }
        if (tree.mLeft == EMPTY) {
            pathFromRoot.remove(pathFromRoot.size() - 1);
            newNode = tree.mRight;
            assert (newNode == EMPTY == super.isTwoNode());
            decreaseHeight = super.isTwoNode();
        } else {
            int removeHeight = pathFromRoot.size() - 1;
            FunctionalMap<K, V> removeTree = tree;
            tree = tree.mLeft;
            wentLeftBits.set(pathFromRoot.size() - 1, true);
            while (tree.mRight != EMPTY) {
                pathFromRoot.add(tree);
                tree = tree.mRight;
                wentLeftBits.set(pathFromRoot.size() - 1, false);
            }
            assert (tree.mLeft == EMPTY);
            newNode = FunctionalMap.empty();
            pathFromRoot.set(removeHeight, new FunctionalMap<K, V>(removeTree.mLeft, removeTree.mRight, tree.mKey, tree.mValue, removeTree.mSizeColor));
            decreaseHeight = true;
        }
        while (!pathFromRoot.isEmpty()) {
            FunctionalMap<K, V> newLeft;
            FunctionalMap<K, V> newRight;
            FunctionalMap<K, V> newRight2;
            FunctionalMap grandParent;
            boolean parentFull;
            FunctionalMap parent = (FunctionalMap)pathFromRoot.remove(pathFromRoot.size() - 1);
            boolean wentLeft = wentLeftBits.get(pathFromRoot.size());
            if (!decreaseHeight) {
                newNode = new FunctionalMap<K, V>(wentLeft ? newNode : parent.mLeft, wentLeft ? parent.mRight : newNode, parent.mKey, parent.mValue, parent.mSizeColor < 0 ? parent.mSizeColor + 1 : parent.mSizeColor - 1);
                continue;
            }
            FunctionalMap realParent = parent;
            boolean bl = parentFull = !parent.isTwoNode();
            if (!(parentFull || pathFromRoot.isEmpty() || (grandParent = (FunctionalMap)pathFromRoot.get(pathFromRoot.size() - 1)).isTwoNode() || grandParent.mRight != parent)) {
                parentFull = true;
                realParent = (FunctionalMap)pathFromRoot.remove(pathFromRoot.size() - 1);
            }
            if (parentFull) {
                FunctionalMap<K, V> newRightRight;
                FunctionalMap<K, V> newRight3;
                decreaseHeight = false;
                if (parent == realParent) {
                    if (wentLeft) {
                        FunctionalMap<K, V> newLeft2;
                        FunctionalMap<K, V> sibling = parent.mRight;
                        if (super.isTwoNode()) {
                            newLeft2 = new FunctionalMap<K, V>(newNode, sibling.mLeft, parent.mKey, parent.mValue, false);
                            newNode = new FunctionalMap<K, V>(newLeft2, sibling.mRight, sibling.mKey, sibling.mValue, true);
                        } else {
                            newLeft2 = new FunctionalMap<K, V>(newNode, sibling.mLeft.mLeft, parent.mKey, parent.mValue, true);
                            newRight3 = new FunctionalMap<K, V>(sibling.mLeft.mRight, sibling.mRight, sibling.mKey, sibling.mValue, true);
                            newNode = new FunctionalMap<K, V>(newLeft2, newRight3, sibling.mLeft.mKey, sibling.mLeft.mValue, false);
                        }
                    } else {
                        newNode = new FunctionalMap<K, V>(parent.mLeft, newNode, parent.mKey, parent.mValue, true);
                    }
                } else if (wentLeft) {
                    if (super.isTwoNode()) {
                        newRight2 = new FunctionalMap<K, V>(newNode, parent.mRight, parent.mKey, parent.mValue, false);
                        newNode = new FunctionalMap<K, V>(realParent.mLeft, newRight2, realParent.mKey, realParent.mValue, true);
                    } else {
                        FunctionalMap<K, V> newRightLeft = new FunctionalMap<K, V>(newNode, parent.mRight.mLeft, parent.mKey, parent.mValue, true);
                        newRight = new FunctionalMap<K, V>(newRightLeft, parent.mRight.mRight, parent.mRight.mKey, parent.mRight.mValue, true);
                        newNode = new FunctionalMap<K, V>(realParent.mLeft, newRight, realParent.mKey, realParent.mValue, false);
                    }
                } else if (super.isTwoNode()) {
                    newRightRight = new FunctionalMap<K, V>(parent.mLeft.mRight, newNode, parent.mKey, parent.mValue, true);
                    newRight = new FunctionalMap<K, V>(parent.mLeft.mLeft, newRightRight, parent.mLeft.mKey, parent.mLeft.mValue, false);
                    newNode = new FunctionalMap<K, V>(realParent.mLeft, newRight, realParent.mKey, realParent.mValue, true);
                } else {
                    newRightRight = new FunctionalMap<K, V>(parent.mLeft.mRight.mRight, newNode, parent.mKey, parent.mValue, true);
                    FunctionalMap<K, V> newRightLeft = new FunctionalMap<K, V>(parent.mLeft.mLeft, parent.mLeft.mRight.mLeft, parent.mLeft.mKey, parent.mLeft.mValue, true);
                    newRight3 = new FunctionalMap<K, V>(newRightLeft, newRightRight, parent.mLeft.mRight.mKey, parent.mLeft.mRight.mValue, true);
                    newNode = new FunctionalMap<K, V>(realParent.mLeft, newRight3, realParent.mKey, realParent.mValue, false);
                }
                parent = realParent;
                continue;
            }
            decreaseHeight = true;
            if (wentLeft) {
                if (super.isTwoNode()) {
                    newNode = new FunctionalMap<K, V>(newNode, parent.mRight, parent.mKey, parent.mValue, false);
                    continue;
                }
                newLeft = new FunctionalMap<K, V>(newNode, parent.mRight.mLeft, parent.mKey, parent.mValue, true);
                newNode = new FunctionalMap<K, V>(newLeft, parent.mRight.mRight, parent.mRight.mKey, parent.mRight.mValue, true);
                decreaseHeight = false;
                continue;
            }
            if (super.isTwoNode()) {
                newRight2 = new FunctionalMap<K, V>(parent.mLeft.mRight, newNode, parent.mKey, parent.mValue, true);
                newNode = new FunctionalMap<K, V>(parent.mLeft.mLeft, newRight2, parent.mLeft.mKey, parent.mLeft.mValue, false);
                continue;
            }
            newLeft = new FunctionalMap<K, V>(parent.mLeft.mLeft, parent.mLeft.mRight.mLeft, parent.mLeft.mKey, parent.mLeft.mValue, true);
            newRight = new FunctionalMap<K, V>(parent.mLeft.mRight.mRight, newNode, parent.mKey, parent.mValue, true);
            newNode = new FunctionalMap<K, V>(newLeft, newRight, parent.mLeft.mRight.mKey, parent.mLeft.mRight.mValue, true);
            decreaseHeight = false;
        }
        return newNode;
    }

    public int getHeight() {
        int height = 0;
        FunctionalMap<K, V> tree = this;
        while (tree != EMPTY) {
            ++height;
            tree = tree.mLeft;
        }
        return height;
    }

    @Override
    public K getKey() {
        return this.mKey;
    }

    @Override
    public V getValue() {
        return this.mValue;
    }

    @Override
    public V setValue(V newValue) {
        throw new UnsupportedOperationException("Functional Maps are read-only");
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public int size() {
        return Math.abs(this.mSizeColor);
    }

    private boolean isTwoNode() {
        return this.mSizeColor >= 0;
    }

    static class EntryIterator<K, V>
    implements Iterator<Map.Entry<K, V>> {
        ArrayDeque<FunctionalMap<K, V>> mPathFromRoot = new ArrayDeque();

        EntryIterator(FunctionalMap<K, V> tree) {
            while (tree != EMPTY) {
                this.mPathFromRoot.add(tree);
                tree = tree.mLeft;
            }
        }

        @Override
        public boolean hasNext() {
            return !this.mPathFromRoot.isEmpty();
        }

        @Override
        public Map.Entry<K, V> next() {
            FunctionalMap<K, V> next = this.mPathFromRoot.removeLast();
            FunctionalMap tree = next.mRight;
            while (tree != EMPTY) {
                this.mPathFromRoot.add(tree);
                tree = tree.mLeft;
            }
            return next;
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(FunctionalMap.this);
        }

        @Override
        public int size() {
            return FunctionalMap.this.size();
        }
    }
}

