/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import java.util.AbstractSet;
import java.util.HashSet;
import java.util.Iterator;

public class ListSet<E>
extends AbstractSet<E> {
    private final HashSet<ListSetElem<E>> mElems = new HashSet();
    private final ListSetElem<E> mRoot = new ListSetElem<Object>(null);

    public void beginScope() {
        ListSetElem<Object> marker = new ListSetElem<Object>(null);
        this.addToList(marker);
    }

    public void endScope() {
        ListSetElem walk = this.mRoot.mPrev;
        while (walk.mElem != null) {
            this.mElems.remove(walk);
            walk = this.remove(walk);
        }
    }

    private void addToList(ListSetElem<E> toAdd) {
        this.mRoot.mPrev.mNext = toAdd;
        toAdd.mNext = this.mRoot;
        toAdd.mPrev = this.mRoot.mPrev;
        this.mRoot.mPrev = toAdd;
    }

    @Override
    public boolean add(E elem) {
        ListSetElem<E> toAdd = new ListSetElem<E>(elem);
        if (this.mElems.add(toAdd)) {
            this.addToList(toAdd);
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return new Iterator<E>(){
            Iterator<ListSetElem<E>> mIt;
            ListSetElem<E> mData;
            {
                this.mIt = ListSet.this.mElems.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.mIt.hasNext();
            }

            @Override
            public E next() {
                this.mData = this.mIt.next();
                return this.mData.mElem;
            }

            @Override
            public void remove() {
                ListSet.this.remove(this.mData);
                this.mIt.remove();
            }
        };
    }

    private ListSetElem<E> remove(ListSetElem<E> elem) {
        ListSetElem prev = elem.mPrev;
        prev.mNext = elem.mNext;
        elem.mNext.mPrev = prev;
        elem.mPrev = elem;
        elem.mNext = elem.mPrev;
        return prev;
    }

    @Override
    public int size() {
        return this.mElems.size();
    }

    public ListSetIterator listIterator() {
        return new ListSetIterator(this.mRoot);
    }

    public ListSetIterator successors(ListSetIterator it) {
        return new ListSetIterator(it.mCur);
    }

    public Iterator<E> scopeIterator() {
        return new ScopeIterator();
    }

    public Iterable<E> scope() {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return ListSet.this.scopeIterator();
            }
        };
    }

    private static class ListSetElem<E> {
        E mElem;
        ListSetElem<E> mNext;
        ListSetElem<E> mPrev;

        public ListSetElem(E elem) {
            this.mElem = elem;
            this.mNext = this.mPrev = this;
        }

        public int hashCode() {
            return this.mElem == null ? 0 : this.mElem.hashCode();
        }

        public boolean equals(Object other) {
            if (other instanceof ListSetElem) {
                other = ((ListSetElem)other).mElem;
            }
            return this.mElem == null ? other == null : this.mElem.equals(other);
        }
    }

    public class ListSetIterator
    implements Iterator<E> {
        ListSetElem<E> mCur;

        ListSetIterator(ListSetElem<E> cur) {
            this.mCur = cur;
        }

        @Override
        public boolean hasNext() {
            ListSetElem walk = this.mCur.mNext;
            while (walk != ListSet.this.mRoot && walk.mElem == null) {
                walk = walk.mNext;
            }
            return walk != ListSet.this.mRoot;
        }

        @Override
        public E next() {
            ListSetElem walk = this.mCur.mNext;
            while (walk != ListSet.this.mRoot && walk.mElem == null) {
                walk = walk.mNext;
            }
            this.mCur = walk;
            return this.mCur.mElem;
        }

        @Override
        public void remove() {
            this.mCur = ListSet.this.remove(this.mCur);
            ListSet.this.mElems.remove(this.mCur);
        }
    }

    private class ScopeIterator
    implements Iterator<E> {
        ListSetElem<E> mCur;

        private ScopeIterator() {
            this.mCur = ListSet.this.mRoot;
        }

        @Override
        public boolean hasNext() {
            return this.mCur.mPrev.mElem != null;
        }

        @Override
        public E next() {
            this.mCur = this.mCur.mPrev;
            return this.mCur.mElem;
        }

        @Override
        public void remove() {
            this.mCur = ((ListSet)ListSet.this).remove(this.mCur).mNext;
            ListSet.this.mElems.remove(this.mCur);
        }
    }
}

