/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import de.uni_freiburg.informatik.ultimate.util.ScopeUtils;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class ScopedLinkedHashMap<K, V>
extends AbstractMap<K, V> {
    private final LinkedHashMap<K, V> mMap = new LinkedHashMap();
    private HashMap<K, V>[] mHistory = new HashMap[5];
    int mCurScope = -1;
    private final boolean mShrink;

    public ScopedLinkedHashMap() {
        this(true);
    }

    public ScopedLinkedHashMap(boolean shrink) {
        this.mShrink = shrink;
    }

    private HashMap<K, V> undoMap() {
        return this.mHistory[this.mCurScope];
    }

    private void recordUndo(K key, V value) {
        HashMap<K, V> old;
        if (this.mCurScope != -1 && !(old = this.undoMap()).containsKey(key)) {
            old.put(key, value);
        }
    }

    private void undoEntry(Map.Entry<K, V> old) {
        if (old.getValue() == null) {
            this.mMap.remove(old.getKey());
        } else {
            this.mMap.put(old.getKey(), old.getValue());
        }
    }

    public void beginScope() {
        if (this.mCurScope == this.mHistory.length - 1) {
            this.mHistory = ScopeUtils.grow(this.mHistory);
        }
        this.mHistory[++this.mCurScope] = new HashMap();
    }

    public void endScope() {
        for (Map.Entry<K, V> old : this.undoMap().entrySet()) {
            this.undoEntry(old);
        }
        this.mHistory[this.mCurScope--] = null;
        if (this.mShrink && ScopeUtils.shouldShrink(this.mHistory)) {
            this.mHistory = ScopeUtils.shrink(this.mHistory);
        }
    }

    @Override
    public void clear() {
        this.mMap.clear();
        this.mHistory = new HashMap[5];
    }

    @Override
    public boolean containsKey(Object key) {
        return this.mMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.mMap.containsValue(value);
    }

    @Override
    public V get(Object key) {
        return this.mMap.get(key);
    }

    @Override
    public boolean isEmpty() {
        return this.mMap.isEmpty();
    }

    public boolean isEmptyScope() {
        return this.mCurScope == -1;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new AbstractSet<Map.Entry<K, V>>(){

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    Iterator<Map.Entry<K, V>> mBacking;
                    Map.Entry<K, V> mLast;
                    {
                        this.mBacking = ScopedLinkedHashMap.this.mMap.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.mBacking.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        this.mLast = this.mBacking.next();
                        return this.mLast;
                    }

                    @Override
                    public void remove() {
                        this.mBacking.remove();
                        ScopedLinkedHashMap.this.recordUndo(this.mLast.getKey(), this.mLast.getValue());
                    }
                };
            }

            @Override
            public int size() {
                return ScopedLinkedHashMap.this.mMap.size();
            }
        };
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            throw new NullPointerException();
        }
        V oldval = this.mMap.put(key, value);
        this.recordUndo(key, oldval);
        return oldval;
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("ScopedLinkedHashMap doesn't allow remove");
    }

    @Override
    public int size() {
        return this.mMap.size();
    }

    public int getActiveScopeNum() {
        return this.mCurScope + 1;
    }

    public boolean overwritesKeyInScope(Object key, int scope) {
        assert (scope != 0);
        return this.mHistory[scope - 1].containsKey(key);
    }
}

