/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.util;

import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.TerminationRequest;

public class TimeoutHandler
implements TerminationRequest {
    TerminationRequest mStackedTermination;
    long mTimeoutStamp;
    boolean mTimeoutIsSet;

    public TimeoutHandler(TerminationRequest stacked) {
        this.mStackedTermination = stacked;
        this.clearTimeout();
    }

    public void clearTimeout() {
        this.mTimeoutStamp = Long.MAX_VALUE;
        this.mTimeoutIsSet = false;
    }

    public void setTimeout(long millis) {
        this.mTimeoutStamp = System.currentTimeMillis() + millis;
        this.mTimeoutIsSet = true;
    }

    public boolean timeoutIsSet() {
        return this.mTimeoutIsSet;
    }

    public long timeLeft() {
        if (!this.timeoutIsSet()) {
            return Long.MAX_VALUE;
        }
        return this.mTimeoutStamp - System.currentTimeMillis();
    }

    public TerminationRequest getTerminationRequest() {
        return this.mStackedTermination;
    }

    @Override
    public boolean isTerminationRequested() {
        if (this.mStackedTermination != null && this.mStackedTermination.isTerminationRequested()) {
            return true;
        }
        return System.currentTimeMillis() >= this.mTimeoutStamp;
    }
}

