/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

public final class HashUtils {
    private static final int BASE = -559038737;

    private HashUtils() {
    }

    public static int hashJenkins(int init, byte[] vals) {
        int c;
        if (vals == null || vals.length == 0) {
            return init;
        }
        int b = c = -559038737 + (vals.length << 2) + init;
        int a = c;
        int pos = 0;
        while (vals.length - pos > 12) {
            a += (vals[pos] & 0xFF) + ((vals[pos + 1] & 0xFF) << 8) + ((vals[pos + 2] & 0xFF) << 16) + ((vals[pos + 3] & 0xFF) << 24);
            a -= (c += (vals[pos + 8] & 0xFF) + ((vals[pos + 9] & 0xFF) << 8) + ((vals[pos + 10] & 0xFF) << 16) + ((vals[pos + 11] & 0xFF) << 24));
            a ^= c << 4 | c >>> 28;
            b -= a;
            b ^= a << 6 | a >>> 26;
            a += (c += (b += (vals[pos + 4] & 0xFF) + ((vals[pos + 5] & 0xFF) << 8) + ((vals[pos + 6] & 0xFF) << 16) + ((vals[pos + 7] & 0xFF) << 24)));
            c -= b;
            c ^= b << 8 | b >>> 24;
            b += a;
            a -= c;
            a ^= c << 16 | c >>> 16;
            c += b;
            b -= a;
            b ^= a << 19 | a >>> 13;
            a += c;
            c -= b;
            c ^= b << 4 | b >>> 28;
            b += a;
            pos += 3;
        }
        switch (vals.length - pos) {
            case 12: {
                c += (vals[pos + 11] & 0xFF) << 24;
            }
            case 11: {
                c += (vals[pos + 10] & 0xFF) << 16;
            }
            case 10: {
                c += (vals[pos + 9] & 0xFF) << 8;
            }
            case 9: {
                c += vals[pos + 8] & 0xFF;
            }
            case 8: {
                b += (vals[pos + 7] & 0xFF) << 24;
            }
            case 7: {
                b += (vals[pos + 6] & 0xFF) << 16;
            }
            case 6: {
                b += (vals[pos + 5] & 0xFF) << 8;
            }
            case 5: {
                b += vals[pos + 4] & 0xFF;
            }
            case 4: {
                a += (vals[pos + 3] & 0xFF) << 24;
            }
            case 3: {
                a += (vals[pos + 2] & 0xFF) << 16;
            }
            case 2: {
                a += (vals[pos + 1] & 0xFF) << 8;
            }
            case 1: {
                a += vals[pos] & 0xFF;
                c ^= b;
                a ^= (c -= b << 14 | b >>> 18);
                b ^= (a -= c << 11 | c >>> 21);
                c ^= (b -= a << 25 | a >>> 7);
                a ^= (c -= b << 16 | b >>> 16);
                b ^= (a -= c << 4 | c >>> 28);
                c ^= (b -= a << 14 | a >>> 18);
                c -= b << 24 | b >>> 8;
            }
        }
        return c;
    }

    public static int hashJenkins(int init, Object ... vals) {
        int c;
        if (vals == null || vals.length == 0) {
            return init;
        }
        int b = c = -559038737 + (vals.length << 2) + init;
        int a = c;
        int pos = 0;
        while (vals.length - pos > 3) {
            a += vals[pos].hashCode();
            a -= (c += vals[pos + 2].hashCode());
            a ^= c << 4 | c >>> 28;
            b -= a;
            b ^= a << 6 | a >>> 26;
            a += (c += (b += vals[pos + 1].hashCode()));
            c -= b;
            c ^= b << 8 | b >>> 24;
            b += a;
            a -= c;
            a ^= c << 16 | c >>> 16;
            c += b;
            b -= a;
            b ^= a << 19 | a >>> 13;
            a += c;
            c -= b;
            c ^= b << 4 | b >>> 28;
            b += a;
            pos += 3;
        }
        switch (vals.length - pos) {
            case 3: {
                c += vals[pos++].hashCode();
            }
            case 2: {
                b += vals[pos++].hashCode();
            }
            case 1: {
                a += vals[pos].hashCode();
                c ^= b;
                a ^= (c -= b << 14 | b >>> 18);
                b ^= (a -= c << 11 | c >>> 21);
                c ^= (b -= a << 25 | a >>> 7);
                a ^= (c -= b << 16 | b >>> 16);
                b ^= (a -= c << 4 | c >>> 28);
                c ^= (b -= a << 14 | a >>> 18);
                c -= b << 24 | b >>> 8;
            }
        }
        return c;
    }

    public static int hashJenkins(int init, Object val) {
        int b;
        int a = b = -559038733 + init;
        a += val.hashCode();
        int c = -(b << 14 | b >>> 18);
        a ^= c;
        b ^= (a -= c << 11 | c >>> 21);
        c ^= (b -= a << 25 | a >>> 7);
        a ^= (c -= b << 16 | b >>> 16);
        b ^= (a -= c << 4 | c >>> 28);
        c ^= (b -= a << 14 | a >>> 18);
        return c -= b << 24 | b >>> 8;
    }

    public static int hashHsieh(int init, Object ... vals) {
        if (vals == null || vals.length == 0) {
            return init;
        }
        int hash = init;
        for (Object o : vals) {
            int thingHash = o.hashCode();
            int tmp = (thingHash & 0xFFFF) << 11 ^ (hash += thingHash >>> 16);
            hash = hash << 16 ^ tmp;
            hash += hash >>> 11;
        }
        hash ^= hash << 3;
        hash += hash >>> 5;
        hash ^= hash << 4;
        hash += hash >>> 17;
        hash ^= hash << 25;
        hash += hash >>> 6;
        return hash;
    }

    public static int hashHsieh(int init, Object val) {
        int hash = init;
        int thingHash = val.hashCode();
        int tmp = (thingHash & 0xFFFF) << 11 ^ (hash += thingHash >>> 16);
        hash = hash << 16 ^ tmp;
        hash += hash >>> 11;
        hash ^= hash << 3;
        hash += hash >>> 5;
        hash ^= hash << 4;
        hash += hash >>> 17;
        hash ^= hash << 25;
        hash += hash >>> 6;
        return hash;
    }
}

