/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.datastructures;

import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class ScopedHashSet<E>
implements Set<E> {
    private final ScopedHashMap<E, Object> mBacking = new ScopedHashMap();

    public void beginScope() {
        this.mBacking.beginScope();
    }

    public void endScope() {
        this.mBacking.endScope();
    }

    @Override
    public boolean add(E e) {
        return this.mBacking.put(e, this) == null;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean changed = false;
        for (E e : c) {
            changed |= this.add(e);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.mBacking.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.mBacking.get(o) == this;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        return this.mBacking.isEmpty();
    }

    public boolean isEmptyScope() {
        return this.mBacking.isEmptyScope();
    }

    @Override
    public Iterator<E> iterator() {
        return this.mBacking.keySet().iterator();
    }

    public Iterable<E> currentScope() {
        return this.mBacking.currentScopeKeys();
    }

    @Override
    public boolean remove(Object o) {
        return this.mBacking.remove(o) != null;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean res = false;
        for (Object o : c) {
            res |= this.remove(o);
        }
        return res;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int size() {
        return this.mBacking.size();
    }

    @Override
    public Object[] toArray() {
        Object[] res = new Object[this.size()];
        int pos = -1;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            res[++pos] = it.next();
        }
        return res;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int s = this.size();
        T[] res = a.length >= s ? a : Arrays.copyOf(a, s);
        int pos = -1;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            res[++pos] = it.next();
        }
        return res;
    }

    public String toString() {
        return this.mBacking.keySet().toString();
    }
}

