/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractPostOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractStateBinaryOperator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IVariableProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.PartialOrderCache;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class DisjunctiveAbstractState<STATE extends IAbstractState<STATE>>
implements IAbstractState<DisjunctiveAbstractState<STATE>> {
    private final Set<STATE> mStates;
    private final int mMaxSize;

    public DisjunctiveAbstractState() {
        this(Collections.emptySet());
    }

    public DisjunctiveAbstractState(int maxSize, STATE state) {
        this(maxSize, Collections.singleton(state));
    }

    public DisjunctiveAbstractState(STATE state) {
        this(1, Collections.singleton(state));
    }

    private DisjunctiveAbstractState(Set<STATE> state) {
        this(state.size(), state);
    }

    private DisjunctiveAbstractState(int maxSize, Set<STATE> states) {
        assert (states != null);
        assert (this.haveSameVars(states));
        assert (states.stream().allMatch(a -> !(a instanceof DisjunctiveAbstractState))) : "Cannot nest AbstractMultiStates, use flatten() instead";
        assert (states.size() <= maxSize) : "Set too large";
        this.mMaxSize = maxSize;
        this.mStates = states;
    }

    private boolean haveSameVars(Set<STATE> states) {
        if (states.size() <= 1) {
            return true;
        }
        ImmutableSet<IProgramVarOrConst> firstVars = ((IAbstractState)states.iterator().next()).getVariables();
        return states.stream().allMatch(a -> firstVars.equals(a.getVariables()));
    }

    @Override
    public DisjunctiveAbstractState<STATE> addVariable(IProgramVarOrConst variable) {
        return this.map(a -> a.addVariable(variable));
    }

    @Override
    public DisjunctiveAbstractState<STATE> removeVariable(IProgramVarOrConst variable) {
        return this.map(a -> a.removeVariable(variable));
    }

    @Override
    public DisjunctiveAbstractState<STATE> addVariables(Collection<IProgramVarOrConst> variables) {
        return this.map(a -> a.addVariables(variables));
    }

    @Override
    public DisjunctiveAbstractState<STATE> removeVariables(Collection<IProgramVarOrConst> variables) {
        return this.map(a -> a.removeVariables(variables));
    }

    @Override
    public boolean containsVariable(IProgramVarOrConst var) {
        return this.mStates.stream().anyMatch(a -> a.containsVariable(var));
    }

    @Override
    public ImmutableSet<IProgramVarOrConst> getVariables() {
        if (this.mStates.isEmpty()) {
            return ImmutableSet.empty();
        }
        return ((IAbstractState)this.mStates.iterator().next()).getVariables();
    }

    @Override
    public DisjunctiveAbstractState<STATE> renameVariables(Map<IProgramVarOrConst, IProgramVarOrConst> old2newVars) {
        return this.map(a -> a.renameVariables(old2newVars));
    }

    @Override
    public DisjunctiveAbstractState<STATE> patch(DisjunctiveAbstractState<STATE> dominator) {
        assert (this.mStates.size() != dominator.mStates.size()) : "Cannot apply symmetrical with differently sized multi-states";
        Set<STATE> newSet = DisjunctiveAbstractState.newSet(this.mStates.size());
        Iterator<STATE> iter = this.mStates.iterator();
        Iterator<STATE> otherIter = dominator.mStates.iterator();
        while (iter.hasNext() && otherIter.hasNext()) {
            newSet.add(((IAbstractState)iter.next()).patch((IAbstractState)otherIter.next()));
        }
        return new DisjunctiveAbstractState<STATE>(this.mMaxSize, newSet);
    }

    @Override
    public boolean isEmpty() {
        return this.mStates.stream().anyMatch(a -> a.isEmpty());
    }

    @Override
    public boolean isBottom() {
        return this.mStates.isEmpty() || this.mStates.stream().allMatch(a -> a.isBottom());
    }

    @Override
    public boolean isEqualTo(DisjunctiveAbstractState<STATE> other) {
        if (other == null) {
            return false;
        }
        if (!other.getVariables().equals(this.getVariables())) {
            return false;
        }
        for (IAbstractState state : this.mStates) {
            if (other.mStates.stream().anyMatch(state::isEqualTo)) continue;
            return false;
        }
        return true;
    }

    @Override
    public IAbstractState.SubsetResult isSubsetOf(DisjunctiveAbstractState<STATE> other) {
        if (other == null) {
            return IAbstractState.SubsetResult.NONE;
        }
        if (other.isBottom() && this.isBottom()) {
            return IAbstractState.SubsetResult.EQUAL;
        }
        if (other.isBottom()) {
            return IAbstractState.SubsetResult.NONE;
        }
        if (this.isBottom()) {
            return IAbstractState.SubsetResult.STRICT;
        }
        if (!other.getVariables().equals(this.getVariables())) {
            return IAbstractState.SubsetResult.NONE;
        }
        if (other.mStates.isEmpty() && !this.mStates.isEmpty()) {
            return IAbstractState.SubsetResult.NONE;
        }
        IAbstractState.SubsetResult result = IAbstractState.SubsetResult.EQUAL;
        for (IAbstractState state : this.mStates) {
            IAbstractState.SubsetResult max = IAbstractState.SubsetResult.NONE;
            for (IAbstractState otherState : other.mStates) {
                max = state.isSubsetOf(otherState).max(max);
            }
            if ((result = result.min(max)) == IAbstractState.SubsetResult.NONE) break;
        }
        return result;
    }

    @Override
    public Term getTerm(Script script) {
        return SmtUtils.or((Script)script, (Collection)this.mStates.stream().map((? super T a) -> a.getTerm(script)).collect(Collectors.toSet()));
    }

    @Override
    public String toLogString() {
        StringBuilder sb = new StringBuilder();
        sb.append('#').append(this.mStates.size());
        for (IAbstractState state : this.mStates) {
            sb.append('{');
            String logStr = state.toLogString();
            if (logStr == null || logStr.isEmpty()) {
                sb.append("__");
            } else {
                sb.append(logStr);
            }
            sb.append('}');
            sb.append(", ");
        }
        if (!this.mStates.isEmpty()) {
            sb.delete(sb.length() - 2, sb.length());
        }
        return sb.toString();
    }

    @Override
    public DisjunctiveAbstractState<STATE> intersect(DisjunctiveAbstractState<STATE> other) {
        assert (other != null && other.getVariables().equals(this.getVariables())) : "Cannot intersect incompatible states";
        return this.crossProduct((a, b) -> a.intersect(b), other, this.mStates.size() * other.mStates.size());
    }

    @Override
    public DisjunctiveAbstractState<STATE> union(DisjunctiveAbstractState<STATE> other) {
        assert (other != null && other.getVariables().equals(this.getVariables())) : "Cannot merge incompatible states";
        Set<STATE> set = this.newSet(this.mStates, other.mStates);
        return new DisjunctiveAbstractState<STATE>(this.mMaxSize, this.reduce(set));
    }

    public DisjunctiveAbstractState<STATE> saturatedUnion(DisjunctiveAbstractState<STATE> other) {
        assert (other != null && other.getVariables().equals(this.getVariables())) : "Cannot merge incompatible states";
        Set<STATE> set = this.newSet(this.mStates, other.mStates);
        return new DisjunctiveAbstractState<STATE>(this.mMaxSize, DisjunctiveAbstractState.reduceByTopologicalOrder(set, this.mMaxSize));
    }

    public <ACTION> DisjunctiveAbstractState<STATE> defineVariablesAfter(IVariableProvider<STATE, ACTION> varProvider, ACTION transition, DisjunctiveAbstractState<STATE> hierachicalPreState) {
        return this.crossProduct((a, b) -> varProvider.defineVariablesAfter(transition, a, b), hierachicalPreState, this.mMaxSize);
    }

    public <ACTION> DisjunctiveAbstractState<STATE> createValidPostOpStateAfterLeaving(IVariableProvider<STATE, ACTION> varProvider, ACTION act, DisjunctiveAbstractState<STATE> hierachicalPreState) {
        if (hierachicalPreState == null) {
            return this.map(a -> varProvider.createValidPostOpStateAfterLeaving(act, a, null));
        }
        return this.crossProduct((a, b) -> varProvider.createValidPostOpStateAfterLeaving(act, a, b), hierachicalPreState, this.mStates.size() * hierachicalPreState.mStates.size());
    }

    @Override
    public DisjunctiveAbstractState<STATE> compact() {
        Set<IAbstractState> compactedStates = DisjunctiveAbstractState.newSet(this.mStates.size());
        HashSet<IProgramVarOrConst> vars = new HashSet<IProgramVarOrConst>();
        for (IAbstractState state : this.mStates) {
            Object compacted = state.compact();
            compactedStates.add((IAbstractState)compacted);
            vars.addAll((Collection<IProgramVarOrConst>)compacted.getVariables());
        }
        if (this.mStates.equals(compactedStates)) {
            return this;
        }
        Set<STATE> compactedSynchronizedStates = DisjunctiveAbstractState.newSet(this.mStates.size());
        for (IAbstractState state : compactedStates) {
            HashSet<IProgramVarOrConst> missing = new HashSet<IProgramVarOrConst>(vars);
            missing.removeAll((Collection<?>)state.getVariables());
            if (missing.isEmpty()) {
                compactedSynchronizedStates.add(state);
                continue;
            }
            compactedSynchronizedStates.add(state.addVariables(missing));
        }
        return new DisjunctiveAbstractState<STATE>(this.mMaxSize, compactedSynchronizedStates);
    }

    public <ACTION> DisjunctiveAbstractState<STATE> createValidPostOpStateBeforeLeaving(IVariableProvider<STATE, ACTION> varProvider, ACTION act) {
        return this.map(a -> varProvider.createValidPostOpStateBeforeLeaving(act, a));
    }

    public <ACTION> DisjunctiveAbstractState<STATE> apply(IAbstractTransformer<STATE, ACTION> op, ACTION transition) {
        return this.mapCollection(a -> op.apply(a, transition));
    }

    public <ACTION> DisjunctiveAbstractState<STATE> apply(IAbstractPostOperator<STATE, ACTION> postOp, DisjunctiveAbstractState<STATE> multiStateBeforeLeaving, ACTION transition) {
        return this.crossProductCollection((a, b) -> postOp.apply(b, a, transition), multiStateBeforeLeaving, this.mMaxSize);
    }

    public DisjunctiveAbstractState<STATE> widen(IAbstractStateBinaryOperator<STATE> op, DisjunctiveAbstractState<STATE> other) {
        Set<STATE> others = other.mStates.size() > 1 ? DisjunctiveAbstractState.reduceByOrderedMerge(other.mStates, 1) : other.mStates;
        Set<STATE> newSet = DisjunctiveAbstractState.newSet(this.mStates.size());
        for (IAbstractState localState : this.mStates) {
            for (IAbstractState otherState : others) {
                newSet.add(op.apply(localState, otherState));
            }
        }
        if (newSet.equals(this.mStates)) {
            return this;
        }
        return new DisjunctiveAbstractState<STATE>(this.mMaxSize, DisjunctiveAbstractState.reduceByTopologicalOrder(newSet, this.mMaxSize));
    }

    public static <STATE extends IAbstractState<STATE>> DisjunctiveAbstractState<STATE> createDisjunction(Collection<STATE> states) {
        HashSet<Object> disjuncts = new HashSet<Object>();
        for (IAbstractState state : states) {
            if (state instanceof DisjunctiveAbstractState) {
                disjuncts.addAll(((DisjunctiveAbstractState)state).getStates());
                continue;
            }
            disjuncts.add(state);
        }
        return new DisjunctiveAbstractState(DisjunctiveAbstractState.reduce(disjuncts, disjuncts.size()));
    }

    public static <STATE extends IAbstractState<STATE>> DisjunctiveAbstractState<STATE> createDisjunction(Collection<STATE> states, int maxSize) {
        HashSet<Object> disjuncts = new HashSet<Object>();
        for (IAbstractState state : states) {
            if (state instanceof DisjunctiveAbstractState) {
                disjuncts.addAll(((DisjunctiveAbstractState)state).getStates());
                continue;
            }
            disjuncts.add(state);
        }
        return new DisjunctiveAbstractState(maxSize, DisjunctiveAbstractState.reduce(disjuncts, maxSize));
    }

    public static <STATE extends IAbstractState<STATE>> STATE union(Collection<STATE> states) {
        if (states == null || states.isEmpty()) {
            return null;
        }
        if (states.size() == 1) {
            return (STATE)((IAbstractState)states.iterator().next());
        }
        HashSet<Object> disjuncts = new HashSet<Object>(states.size());
        for (IAbstractState state : states) {
            if (state instanceof DisjunctiveAbstractState) {
                disjuncts.addAll(((DisjunctiveAbstractState)state).getStates());
                continue;
            }
            disjuncts.add(state);
        }
        Set result = DisjunctiveAbstractState.reduce(disjuncts, 1);
        if (result.isEmpty()) {
            return null;
        }
        assert (result.size() == 1);
        return (STATE)((IAbstractState)result.iterator().next());
    }

    public String toString() {
        return this.toLogString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + this.mMaxSize;
        result = 31 * result + this.mStates.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DisjunctiveAbstractState other = (DisjunctiveAbstractState)obj;
        if (this.mMaxSize != other.mMaxSize) {
            return false;
        }
        return this.mStates.equals(other.mStates);
    }

    public Set<STATE> getStates() {
        return Collections.unmodifiableSet(this.mStates);
    }

    public STATE getSingleState(IAbstractStateBinaryOperator<STATE> mergeOp) {
        return (STATE)((IAbstractState)this.mStates.stream().reduce(mergeOp::apply).orElse(null));
    }

    private DisjunctiveAbstractState<STATE> crossProduct(BiFunction<STATE, STATE, STATE> funCreateState, DisjunctiveAbstractState<STATE> otherMultiState, int maxSize, IReduceUntil<STATE> funReduceToSize) {
        Set<STATE> newSet = DisjunctiveAbstractState.newSet(this.mStates.size() * otherMultiState.mStates.size());
        for (IAbstractState localState : this.mStates) {
            for (IAbstractState otherState : otherMultiState.mStates) {
                newSet.add((IAbstractState)funCreateState.apply(localState, otherState));
            }
        }
        if (newSet.equals(this.mStates)) {
            return this;
        }
        return new DisjunctiveAbstractState<STATE>(maxSize, funReduceToSize.reduce(newSet, maxSize));
    }

    private DisjunctiveAbstractState<STATE> crossProduct(BiFunction<STATE, STATE, STATE> funCreateState, DisjunctiveAbstractState<STATE> otherMultiState, int maxSize) {
        return this.crossProduct(funCreateState, otherMultiState, maxSize, DisjunctiveAbstractState::reduce);
    }

    private DisjunctiveAbstractState<STATE> crossProductCollection(BiFunction<STATE, STATE, Collection<STATE>> funCreateState, DisjunctiveAbstractState<STATE> otherMultiState, int maxSize) {
        Set<STATE> newSet = DisjunctiveAbstractState.newSet(this.mStates.size() * otherMultiState.mStates.size());
        for (IAbstractState localState : this.mStates) {
            for (IAbstractState otherState : otherMultiState.mStates) {
                newSet.addAll(funCreateState.apply(localState, otherState));
            }
        }
        if (newSet.equals(this.mStates)) {
            return this;
        }
        return new DisjunctiveAbstractState<STATE>(maxSize, this.reduce(newSet));
    }

    private DisjunctiveAbstractState<STATE> map(Function<STATE, STATE> func) {
        Set<STATE> newSet = DisjunctiveAbstractState.newSet(this.mStates.size());
        for (IAbstractState state : this.mStates) {
            newSet.add((IAbstractState)func.apply(state));
        }
        if (this.mStates.equals(newSet)) {
            return this;
        }
        return new DisjunctiveAbstractState<STATE>(this.mMaxSize, newSet);
    }

    private DisjunctiveAbstractState<STATE> mapCollection(Function<STATE, Collection<STATE>> func) {
        Set<STATE> newSet = this.newSet();
        for (IAbstractState state : this.mStates) {
            newSet.addAll(func.apply(state));
        }
        return new DisjunctiveAbstractState<STATE>(this.mMaxSize, DisjunctiveAbstractState.reduce(newSet, this.mMaxSize));
    }

    private Set<STATE> newSet() {
        return DisjunctiveAbstractState.newSet(this.mMaxSize);
    }

    private static <STATE> Set<STATE> newSet(int maxSize) {
        return new LinkedHashSet(maxSize, 1.0f);
    }

    @SafeVarargs
    private final Set<STATE> newSet(Set<STATE> ... sets) {
        if (sets == null || sets.length == 0) {
            return this.newSet();
        }
        int elems = Arrays.stream(sets).map((? super T a) -> a.size()).reduce((a, b) -> a + b).get();
        Set<STATE> set = DisjunctiveAbstractState.newSet(elems);
        Arrays.stream(sets).forEach(set::addAll);
        return set;
    }

    private Set<STATE> reduce(Set<STATE> states) {
        return DisjunctiveAbstractState.reduce(states, this.mMaxSize);
    }

    private static <STATE extends IAbstractState<STATE>> Set<STATE> reduce(Set<STATE> states, int maxsize) {
        Set<STATE> maximalElements = DisjunctiveAbstractState.getMaximalElements(states);
        if (maximalElements.size() <= maxsize) {
            return maximalElements;
        }
        return DisjunctiveAbstractState.reduceByOrderedMerge(maximalElements, maxsize);
    }

    private static <STATE extends IAbstractState<STATE>> Set<STATE> reduceByOrderedMerge(Set<STATE> states, int maxSize) {
        IAbstractState first = (IAbstractState)states.iterator().next();
        return first.union(states, maxSize);
    }

    private static <STATE extends IAbstractState<STATE>> Set<STATE> getMaximalElements(Set<STATE> states) {
        if (states.isEmpty() || states.size() == 1) {
            return states;
        }
        Set<STATE> maximalElements = DisjunctiveAbstractState.newSet(states.size());
        for (IAbstractState state : states) {
            Iterator<STATE> iter = maximalElements.iterator();
            boolean maximal = true;
            while (iter.hasNext()) {
                IAbstractState candidate = (IAbstractState)iter.next();
                IAbstractState.SubsetResult stateIsCovered = state.isSubsetOf(candidate);
                IAbstractState.SubsetResult stateCovers = candidate.isSubsetOf(state);
                if (stateIsCovered != IAbstractState.SubsetResult.NONE) {
                    maximal = false;
                    break;
                }
                if (stateCovers == IAbstractState.SubsetResult.NONE) continue;
                iter.remove();
            }
            if (!maximal) continue;
            maximalElements.add(state);
        }
        assert (maximalElements.stream().filter(IAbstractState::isBottom).count() <= 1L) : "There can be only one bottom element";
        return maximalElements;
    }

    private static <STATE extends IAbstractState<STATE>> List<STATE> getTopologicalOrder(Set<STATE> states) {
        IPartialComparator comparator = new IPartialComparator<STATE>(){

            public IPartialComparator.ComparisonResult compare(STATE first, STATE second) {
                IAbstractState.SubsetResult firstIsCoveredSecond = first.isSubsetOf(second);
                switch (firstIsCoveredSecond) {
                    case EQUAL: {
                        return IPartialComparator.ComparisonResult.EQUAL;
                    }
                    case STRICT: {
                        return IPartialComparator.ComparisonResult.STRICTLY_SMALLER;
                    }
                }
                IAbstractState.SubsetResult secondIsCoveredfirst = second.isSubsetOf(first);
                switch (secondIsCoveredfirst) {
                    case EQUAL: {
                        throw new AssertionError((Object)"Equal is symmetric");
                    }
                    case STRICT: {
                        return IPartialComparator.ComparisonResult.STRICTLY_GREATER;
                    }
                }
                return IPartialComparator.ComparisonResult.INCOMPARABLE;
            }
        };
        PartialOrderCache poCache = new PartialOrderCache(comparator);
        states.forEach(arg_0 -> ((PartialOrderCache)poCache).addElement(arg_0));
        List result = poCache.getReverseTopologicalOrdering();
        assert (DisjunctiveAbstractState.hasDescendingOrder(result)) : "states are not in descending order";
        return result;
    }

    private static <STATE extends IAbstractState<STATE>> boolean hasDescendingOrder(List<STATE> result) {
        Iterator<STATE> iterator = result.iterator();
        IAbstractState current = null;
        IAbstractState last = null;
        block7: while (iterator.hasNext()) {
            last = current;
            current = (IAbstractState)iterator.next();
            if (last == null || current == null) continue;
            IAbstractState.SubsetResult covering = current.isSubsetOf(last);
            switch (covering) {
                case EQUAL: {
                    return false;
                }
                case NONE: {
                    break;
                }
                default: {
                    continue block7;
                }
            }
            IAbstractState.SubsetResult isCovered = last.isSubsetOf(current);
            switch (isCovered) {
                case EQUAL: 
                case STRICT: {
                    return false;
                }
            }
        }
        return true;
    }

    private static <STATE extends IAbstractState<STATE>> Set<STATE> reduceByTopologicalOrder(Set<STATE> states, int maxSize) {
        if (states.size() <= maxSize) {
            return states;
        }
        List<STATE> ordered = DisjunctiveAbstractState.getTopologicalOrder(states);
        Set<STATE> rtr = DisjunctiveAbstractState.newSet(maxSize);
        Iterator<STATE> iter = ordered.iterator();
        int i = 1;
        while (iter.hasNext() && i < maxSize) {
            IAbstractState current = (IAbstractState)iter.next();
            rtr.add(current);
            ++i;
        }
        if (iter.hasNext()) {
            HashSet mergeDown = new HashSet();
            iter.forEachRemaining(mergeDown::add);
            Set reduced = DisjunctiveAbstractState.reduce(mergeDown, 1);
            rtr.add((IAbstractState)reduced.iterator().next());
        }
        assert (rtr.size() <= maxSize) : "reduceByTopologicalOrder left too many states";
        return rtr;
    }

    private static interface IReduceUntil<STATE> {
        public Set<STATE> reduce(Set<STATE> var1, int var2);
    }
}

