/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public interface IAbstractState<STATE extends IAbstractState<STATE>> {
    public static final /* synthetic */ boolean $assertionsDisabled;

    public STATE addVariable(IProgramVarOrConst var1);

    public STATE removeVariable(IProgramVarOrConst var1);

    public STATE addVariables(Collection<IProgramVarOrConst> var1);

    public STATE removeVariables(Collection<IProgramVarOrConst> var1);

    public boolean containsVariable(IProgramVarOrConst var1);

    public ImmutableSet<IProgramVarOrConst> getVariables();

    default public STATE renameVariable(IProgramVarOrConst oldVar, IProgramVarOrConst newVar) {
        return this.renameVariables(Collections.singletonMap(oldVar, newVar));
    }

    public STATE renameVariables(Map<IProgramVarOrConst, IProgramVarOrConst> var1);

    public STATE patch(STATE var1);

    public STATE intersect(STATE var1);

    public STATE union(STATE var1);

    default public Set<STATE> union(Set<STATE> states, int maxSize) {
        assert (states.size() > maxSize);
        assert (maxSize >= 1);
        assert (states.contains(this));
        int numberOfMerges = states.size() - maxSize;
        while (numberOfMerges > 0) {
            Iterator<STATE> iter = states.iterator();
            IAbstractState first = (IAbstractState)iter.next();
            iter.remove();
            IAbstractState second = (IAbstractState)iter.next();
            iter.remove();
            if (states.add(first.union(second))) {
                --numberOfMerges;
                continue;
            }
            numberOfMerges -= 2;
        }
        assert (states.size() <= maxSize);
        return states;
    }

    public boolean isEmpty();

    public boolean isBottom();

    public boolean isEqualTo(STATE var1);

    public SubsetResult isSubsetOf(STATE var1);

    public STATE compact();

    public Term getTerm(Script var1);

    public String toLogString();

    public static enum SubsetResult {
        EQUAL,
        NON_STRICT,
        STRICT,
        NONE;


        public SubsetResult min(SubsetResult other) {
            switch (this) {
                case EQUAL: {
                    if (other != EQUAL) break;
                    return this;
                }
                case NON_STRICT: {
                    if (other != NON_STRICT && other != EQUAL) break;
                    return this;
                }
                case STRICT: {
                    if (other == NONE) break;
                    return this;
                }
                case NONE: {
                    return this;
                }
                default: {
                    throw new UnsupportedOperationException("Unhandled case " + (Object)((Object)this));
                }
            }
            return other;
        }

        public SubsetResult max(SubsetResult other) {
            switch (this) {
                case EQUAL: {
                    return this;
                }
                case NON_STRICT: {
                    if (other == EQUAL) break;
                    return this;
                }
                case STRICT: {
                    if (other != NONE && other != STRICT) break;
                    return this;
                }
                case NONE: {
                    if (other != NONE) break;
                    return this;
                }
                default: {
                    throw new UnsupportedOperationException("Unhandled case " + (Object)((Object)this));
                }
            }
            return other;
        }
    }
}

