/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.CrossProducts;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintConjunction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;

public class CongruenceClosureSmtUtils {
    public static <NODE extends IEqNodeIdentifier<NODE>> Term congruenceClosureToTerm(Script script, CongruenceClosure<NODE> pa, Term literalDisequalities) {
        return SmtUtils.and((Script)script, CongruenceClosureSmtUtils.congruenceClosureToCube(script, pa, literalDisequalities));
    }

    public static <NODE extends IEqNodeIdentifier<NODE>> List<Term> congruenceClosureToCube(Script script, CongruenceClosure<NODE> pa, Term literalDisequalities) {
        if (pa.isInconsistent()) {
            return Collections.singletonList(script.term("false", new Term[0]));
        }
        List elementEqualities = pa.getSupportingElementEqualities().entrySet().stream().map(en -> SmtUtils.binaryEquality((Script)script, (Term)((IEqNodeIdentifier)en.getKey()).getTerm(), (Term)((IEqNodeIdentifier)en.getValue()).getTerm())).collect(Collectors.toList());
        List elementDisequalities = pa.getElementDisequalities().getSetOfPairs().stream().map(pair -> script.term("distinct", new Term[]{((IEqNodeIdentifier)pair.getKey()).getTerm(), ((IEqNodeIdentifier)pair.getValue()).getTerm()})).collect(Collectors.toList());
        ArrayList<Term> result = new ArrayList<Term>(elementEqualities.size() + elementDisequalities.size());
        result.addAll(elementEqualities);
        result.addAll(elementDisequalities);
        result.add(literalDisequalities);
        for (Map.Entry en2 : pa.getLiteralSetConstraints().getConstraints().entrySet()) {
            result.add(CongruenceClosureSmtUtils.literalSetConstraintToTerm(script, (SetConstraintConjunction)en2.getValue()));
        }
        return result;
    }

    private static <NODE extends IEqNodeIdentifier<NODE>> Term literalSetConstraintToTerm(Script script, SetConstraintConjunction<NODE> constraint) {
        HashSet<Term> conjuncts = new HashSet<Term>();
        for (Set set : constraint.getElementSets()) {
            HashSet<Term> disjuncts = new HashSet<Term>();
            for (IEqNodeIdentifier node : set) {
                disjuncts.add(SmtUtils.binaryEquality((Script)script, (Term)((IEqNodeIdentifier)constraint.getConstrainedElement()).getTerm(), (Term)node.getTerm()));
            }
            conjuncts.add(SmtUtils.or((Script)script, disjuncts));
        }
        return SmtUtils.and((Script)script, conjuncts);
    }

    public static List<Term> createDisequalityTermsForNonTheoryLiterals(Script script, Set<Term> literalTerms) {
        ArrayList<Term> nonTheoryLiteralDisequalities = new ArrayList<Term>();
        BiPredicate<Term, Term> pairSelector = (l1, l2) -> l1 != l2 && (!(l1 instanceof ConstantTerm) || !(l2 instanceof ConstantTerm)) && l1.getSort().getRealSort() == l2.getSort().getRealSort();
        for (Map.Entry en : CrossProducts.binarySelectiveCrossProduct(literalTerms, (boolean)false, pairSelector)) {
            nonTheoryLiteralDisequalities.add(script.term("not", new Term[]{SmtUtils.binaryEquality((Script)script, (Term)((Term)en.getKey()), (Term)((Term)en.getValue()))}));
        }
        return nonTheoryLiteralDisequalities;
    }
}

