/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraintFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.VPStatistics;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCcManager;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCongruenceClosure;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CCLiteralSetConstraints;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraint;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class EqConstraint<NODE extends IEqNodeIdentifier<NODE>> {
    private final WeqCongruenceClosure<NODE> mWeqCc;
    private boolean mIsFrozen;
    final EqConstraintFactory<NODE> mFactory;
    private ImmutableSet<IProgramVar> mVariables;
    private Set<IProgramVarOrConst> mPvocs;
    private Term mTerm;
    private final int mId;

    public EqConstraint(int id, WeqCongruenceClosure<NODE> cClosure, EqConstraintFactory<NODE> factory) {
        assert (id != Integer.MAX_VALUE) : "ran out of ids for EqConstraints";
        this.mId = id;
        this.mFactory = factory;
        this.mWeqCc = cClosure;
    }

    private void freezeAndDontClose() {
        assert (!this.isInconsistent()) : "use EqBottomConstraint instead!!";
        assert (this.sanityCheck());
        assert (!this.mIsFrozen);
        this.mWeqCc.freezeOmitPropagations();
        this.mIsFrozen = true;
    }

    public boolean isBottom() {
        assert (!this.isInconsistent()) : "this should only be called on EqConstraints that are either consistent or an instance of EqBottomConstraint";
        assert (!this.mWeqCc.isInconsistent());
        return false;
    }

    public Set<NODE> getAllNodes() {
        return this.mWeqCc.getAllElements();
    }

    public boolean reportEqualityInPlace(NODE node1, NODE node2) {
        assert (!this.isInconsistent());
        assert (!this.mIsFrozen);
        return this.mWeqCc.reportEquality(node1, node2, false);
    }

    public boolean reportDisequalityInPlace(NODE node1, NODE node2) {
        assert (!this.isInconsistent());
        assert (!this.mIsFrozen);
        boolean paHasChanged = this.mWeqCc.reportDisequality(node1, node2);
        return paHasChanged;
    }

    public void reportWeakEquivalenceInPlace(NODE array1, NODE array2, NODE storeIndex) {
        assert (!this.isInconsistent());
        assert (!this.mIsFrozen);
        this.mFactory.getWeqCcManager().reportWeakEquivalence(this.mWeqCc, array1, array2, storeIndex, true);
    }

    public boolean isFrozen() {
        assert (!this.mIsFrozen || !this.isInconsistent()) : "an inconsistent constraint that is not EqBottomConstraint should never be frozen.";
        return this.mIsFrozen;
    }

    public boolean isInconsistent() {
        return this.mWeqCc.isInconsistent();
    }

    public boolean areEqual(NODE node1, NODE node2, boolean addNodesIfNecessary) {
        if (addNodesIfNecessary) {
            WeqCongruenceClosure<NODE> unfrozen = this.getWeqCcWithAddedNodes(node1, node2);
            return unfrozen.getEqualityStatus(node1, node2) == EqualityStatus.EQUAL;
        }
        if (!this.mWeqCc.hasElement(node1) || !this.mWeqCc.hasElement(node2)) {
            return false;
        }
        return this.mWeqCc.getEqualityStatus(node1, node2) == EqualityStatus.EQUAL;
    }

    public boolean areUnequal(NODE node1, NODE node2, boolean addNodesIfNecessary) {
        if (addNodesIfNecessary) {
            WeqCongruenceClosure<NODE> unfrozen = this.getWeqCcWithAddedNodes(node1, node2);
            return unfrozen.getEqualityStatus(node1, node2) == EqualityStatus.NOT_EQUAL;
        }
        if (!this.mWeqCc.hasElement(node1) || !this.mWeqCc.hasElement(node2)) {
            return false;
        }
        return this.mWeqCc.getEqualityStatus(node1, node2) == EqualityStatus.NOT_EQUAL;
    }

    private WeqCongruenceClosure<NODE> getWeqCcWithAddedNodes(NODE node1, NODE node2) {
        assert (this.mWeqCc.isFrozen()) : "right?..";
        WeqCcManager<NODE> manager = this.mWeqCc.getManager();
        WeqCongruenceClosure<NODE> unfrozen = manager.unfreeze(this.mWeqCc);
        manager.addNode(node1, unfrozen, true, false);
        manager.addNode(node2, unfrozen, true, false);
        unfrozen.freezeAndClose();
        return unfrozen;
    }

    public Term getTerm(Script script) {
        assert (this.mIsFrozen) : "not yet frozen, term may not be final..";
        if (this.mTerm != null) {
            return this.mTerm;
        }
        Term result = WeqCcManager.weqCcToTerm(script, this.mWeqCc, this.mFactory.getWeqCcManager().getNonTheoryLiteralDisequalitiesIfNecessary());
        if (this.mIsFrozen) {
            this.mTerm = result;
        }
        return result;
    }

    public ImmutableSet<IProgramVar> getVariables(IIcfgSymbolTable symbolTable) {
        if (this.mVariables != null) {
            return this.mVariables;
        }
        Collection<TermVariable> allTvs = this.getAllTermVariables();
        this.mVariables = (ImmutableSet)allTvs.stream().map(symbolTable::getProgramVar).collect(ImmutableSet.collector());
        assert (!this.mVariables.stream().anyMatch(Objects::isNull));
        return this.mVariables;
    }

    public Set<IProgramVarOrConst> getPvocs(IIcfgSymbolTable symbolTable) {
        assert (this.mIsFrozen);
        if (this.mPvocs != null) {
            assert (!this.mPvocs.stream().anyMatch(Objects::isNull));
            return this.mPvocs;
        }
        this.mPvocs = new HashSet<IProgramVarOrConst>();
        this.mPvocs.addAll((Collection<IProgramVarOrConst>)this.getVariables(symbolTable));
        HashSet constants = new HashSet();
        this.mWeqCc.getAllElements().stream().forEach(node -> {
            boolean bl = constants.addAll(SmtUtils.extractConstants((Term)node.getTerm(), (boolean)false));
        });
        this.mPvocs.addAll(constants.stream().map(c -> symbolTable.getProgramConst((ApplicationTerm)c)).collect(Collectors.toSet()));
        assert (!this.mPvocs.stream().anyMatch(Objects::isNull));
        return this.mPvocs;
    }

    public boolean isTop() {
        return this.mWeqCc.isTautological();
    }

    public EqConstraint<NODE> join(EqConstraint<NODE> other) {
        if (this.isBottom()) {
            return other;
        }
        if (other.isBottom()) {
            return this;
        }
        if (this.isTop()) {
            return this;
        }
        if (other.isTop()) {
            return other;
        }
        WeqCongruenceClosure<NODE> newPartialArrangement = this.mFactory.getWeqCcManager().join(this.mWeqCc, other.mWeqCc, true);
        EqConstraint<NODE> res = this.mFactory.getEqConstraint(newPartialArrangement, true);
        return res;
    }

    public boolean isStrongerThan(EqConstraint<NODE> other) {
        return this.mFactory.getWeqCcManager().isStrongerThan(this.mWeqCc, other.mWeqCc);
    }

    public Collection<TermVariable> getAllTermVariables() {
        HashSet<TermVariable> allTvs = new HashSet<TermVariable>();
        for (IEqNodeIdentifier node : this.mWeqCc.getAllElements()) {
            if (node.isMixFunction()) {
                if (node.getMixFunction1() instanceof TermVariable) {
                    allTvs.add((TermVariable)node.getMixFunction1());
                }
                if (!(node.getMixFunction2() instanceof TermVariable)) continue;
                allTvs.add((TermVariable)node.getMixFunction2());
                continue;
            }
            allTvs.addAll(Arrays.asList(node.getTerm().getFreeVars()));
        }
        return allTvs;
    }

    boolean sanityCheck() {
        if (!this.mWeqCc.weqGraphFreeOfArrayEqualities()) {
            assert (false);
            return false;
        }
        return this.mWeqCc.sanityCheck();
    }

    public Integer getStatistics(VPStatistics stat) {
        switch (stat) {
            // Empty switch
        }
        return this.mWeqCc.getStatistics(stat);
    }

    public String toString() {
        return "EqConstraint#" + this.mId + "\n" + this.mWeqCc.toString();
    }

    public String toLogString() {
        return "EqConstraint#" + this.mId + "\n" + this.mWeqCc.toLogString();
    }

    public int hashCode() {
        return this.mId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EqConstraint other = (EqConstraint)obj;
        return this.mId == other.mId;
    }

    public WeqCongruenceClosure<NODE> getWeqCc() {
        return this.mWeqCc;
    }

    public void superficialFreeze() {
        assert (this.mWeqCc.isFrozen());
        this.mIsFrozen = true;
    }

    public void freezeIfNecessary() {
        if (!this.isFrozen()) {
            this.freezeAndDontClose();
        }
    }

    public Set<NODE> getAllLiteralNodes() {
        return this.mWeqCc.getAllLiterals();
    }

    public boolean isClosed() {
        return this.mWeqCc.isClosed();
    }

    public Set<NODE> getSetConstraintForExpression(NODE exp) {
        SetConstraint result;
        WeqCongruenceClosure<NODE> unfrozen = this.mFactory.getWeqCcManager().unfreezeIfNecessary(this.mWeqCc);
        unfrozen.addElement(exp, false);
        CCLiteralSetConstraints lsc = unfrozen.getCongruenceClosure().getLiteralSetConstraints();
        Set c = lsc.getContainsConstraint(exp);
        Optional<SetConstraint> cLits = c.stream().filter(sc -> sc.hasOnlyLiterals()).findFirst();
        try {
            result = cLits.get();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
        assert (result.hasOnlyLiterals());
        return result.getLiterals();
    }
}

