/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.ModelCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.AbstractNodeAndFunctionFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqBottomConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqDisjunctiveConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.VPDomainHelpers;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCcManager;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCongruenceClosure;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCongruenceClosureComparator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqSettings;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.CrossProducts;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosureComparator;
import de.uni_freiburg.informatik.ultimate.util.statistics.BenchmarkWithCounters;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class EqConstraintFactory<NODE extends IEqNodeIdentifier<NODE>> {
    private final EqConstraint<NODE> mBottomConstraint;
    private final EqConstraint<NODE> mEmptyConstraint;
    private final EqDisjunctiveConstraint<NODE> mEmptyDisjunctiveConstraint;
    private final AbstractNodeAndFunctionFactory<NODE, Term> mEqNodeAndFunctionFactory;
    private final IUltimateServiceProvider mServices;
    private int mConstraintIdCounter;
    private final WeqCcManager<NODE> mWeqCcManager;
    private final ManagedScript mMgdScript;
    private final boolean mIsDebugMode;
    private final ILogger mLogger;
    private final BenchmarkWithCounters mBenchmark;
    private final Set<IProgramConst> mNonTheoryLiterals;

    public EqConstraintFactory(AbstractNodeAndFunctionFactory<NODE, Term> eqNodeAndFunctionFactory, IUltimateServiceProvider services, ManagedScript mgdScript, WeqSettings settings, boolean debugMode, Set<IProgramConst> nonTheoryLiterals) {
        this.mLogger = services.getLoggingService().getLogger(ModelCheckerUtils.PLUGIN_ID);
        this.mMgdScript = mgdScript;
        this.mNonTheoryLiterals = nonTheoryLiterals;
        Set nonTheoryLiteralNodes = nonTheoryLiterals.stream().map(pc -> eqNodeAndFunctionFactory.getOrConstructNode(pc.getTerm())).collect(Collectors.toSet());
        this.mWeqCcManager = new WeqCcManager<NODE>(this.mLogger, new WeqCongruenceClosureComparator(), new CongruenceClosureComparator(), this.mMgdScript, eqNodeAndFunctionFactory, settings, debugMode, nonTheoryLiteralNodes);
        this.mBottomConstraint = new EqBottomConstraint(this);
        this.mBottomConstraint.freezeIfNecessary();
        this.mEmptyConstraint = new EqConstraint<NODE>(1, this.mWeqCcManager.getEmptyWeqCc(true), this);
        this.mEmptyConstraint.freezeIfNecessary();
        this.mEmptyDisjunctiveConstraint = new EqDisjunctiveConstraint<NODE>(Collections.singleton(this.mEmptyConstraint), this);
        this.mConstraintIdCounter = 2;
        this.mServices = services;
        this.mIsDebugMode = false;
        if (this.mIsDebugMode) {
            this.mBenchmark = new BenchmarkWithCounters();
            this.mBenchmark.registerCountersAndWatches(BmNames.getNames());
        } else {
            this.mBenchmark = null;
        }
        this.mEqNodeAndFunctionFactory = eqNodeAndFunctionFactory;
    }

    public EqConstraint<NODE> getEmptyConstraint(boolean modifiable) {
        if (modifiable) {
            return new EqConstraint<NODE>(this.mConstraintIdCounter++, this.mWeqCcManager.getEmptyWeqCc(true), this);
        }
        return this.mEmptyConstraint;
    }

    public EqConstraint<NODE> getBottomConstraint() {
        return this.mBottomConstraint;
    }

    public EqConstraint<NODE> unfreeze(EqConstraint<NODE> constraint) {
        assert (constraint.isFrozen());
        this.debugStart(BmNames.UNFREEZE);
        if (constraint.isBottom()) {
            this.debugEnd(BmNames.UNFREEZE);
            return constraint;
        }
        WeqCongruenceClosure<NODE> weqCcCopy = this.mWeqCcManager.copyWeqCc(constraint.getWeqCc(), false);
        EqConstraint<NODE> result = new EqConstraint<NODE>(this.mConstraintIdCounter++, weqCcCopy, this);
        this.debugEnd(BmNames.UNFREEZE);
        return result;
    }

    private void debugStart(BmNames name) {
        if (this.mIsDebugMode) {
            this.mBenchmark.incrementCounter(name.name());
            this.mBenchmark.unpauseWatch(name.name());
        }
    }

    private void debugEnd(BmNames name) {
        if (this.mIsDebugMode) {
            this.mBenchmark.pauseWatch(name.name());
        }
    }

    public EqConstraint<NODE> getEqConstraint(WeqCongruenceClosure<NODE> newWeqCc, boolean modifiable) {
        if (newWeqCc.isInconsistent(this.mWeqCcManager.getSettings().closeAllEqConstraints())) {
            return this.getBottomConstraint();
        }
        assert (modifiable != newWeqCc.isFrozen());
        EqConstraint<NODE> result = new EqConstraint<NODE>(this.mConstraintIdCounter++, newWeqCc, this);
        if (!modifiable) {
            result.superficialFreeze();
        }
        return result;
    }

    public EqDisjunctiveConstraint<NODE> getDisjunctiveConstraint(Collection<EqConstraint<NODE>> constraintList) {
        assert (!constraintList.stream().filter(cons -> cons == null).findAny().isPresent());
        if (constraintList.stream().filter(cons -> cons.isTop()).findAny().isPresent()) {
            return this.getEmptyDisjunctiveConstraint(false);
        }
        Collection bottomsFiltered = constraintList.stream().filter(cons -> !(cons instanceof EqBottomConstraint)).collect(Collectors.toSet());
        return new EqDisjunctiveConstraint(bottomsFiltered, this);
    }

    public EqConstraint<NODE> conjoin(EqConstraint<NODE> constraint1Raw, EqConstraint<NODE> constraint2, boolean inplace) {
        this.debugStart(BmNames.CONJOIN);
        if (constraint1Raw.isBottom()) {
            this.debugEnd(BmNames.CONJOIN);
            return constraint1Raw;
        }
        if (constraint2.isBottom() && !inplace) {
            this.debugEnd(BmNames.CONJOIN);
            return constraint2;
        }
        if (constraint1Raw.isTop() && !inplace) {
            this.debugEnd(BmNames.CONJOIN);
            return constraint2;
        }
        if (constraint2.isTop()) {
            this.debugEnd(BmNames.CONJOIN);
            return constraint1Raw;
        }
        EqConstraint<NODE> constraint1 = constraint1Raw;
        if (!inplace) {
            if (this.mWeqCcManager.getSettings().closeAllEqConstraints()) {
                constraint1 = this.closeIfNecessary(constraint1Raw);
            }
            constraint1.freezeIfNecessary();
        }
        assert (inplace != constraint1.isFrozen());
        WeqCongruenceClosure<NODE> newPa = this.mWeqCcManager.meet(constraint1.getWeqCc(), constraint2.getWeqCc(), inplace);
        assert (inplace != newPa.isFrozen());
        if (inplace) {
            this.debugEnd(BmNames.CONJOIN);
            return constraint1;
        }
        EqConstraint<NODE> res = this.getEqConstraint(newPa, false);
        this.debugEnd(BmNames.CONJOIN);
        return res;
    }

    public EqConstraint<NODE> closeIfNecessary(EqConstraint<NODE> constraint) {
        if (constraint.isBottom()) {
            return constraint;
        }
        WeqCongruenceClosure<NODE> weqcc = constraint.getWeqCc();
        if (weqcc.isClosed()) {
            return constraint;
        }
        WeqCongruenceClosure<NODE> weqccclosed = this.mWeqCcManager.closeIfNecessary(constraint.getWeqCc());
        return this.getEqConstraint(weqccclosed, true);
    }

    public EqDisjunctiveConstraint<NODE> conjoinDisjunctiveConstraints(List<EqDisjunctiveConstraint<NODE>> conjuncts) {
        this.debugStart(BmNames.CONJOIN_DISJUNCTIVE);
        List listOfConstraintSets = conjuncts.stream().map(conjunct -> conjunct.getConstraints()).collect(Collectors.toList());
        List crossProduct = CrossProducts.crossProductOfSets(listOfConstraintSets);
        List<EqConstraint<NODE>> constraintList = crossProduct.stream().map(tuple -> (EqConstraint)tuple.stream().reduce((constraint1, constraint2) -> this.conjoin((EqConstraint<NODE>)constraint1, (EqConstraint<NODE>)constraint2, false)).get()).collect(Collectors.toList());
        this.debugEnd(BmNames.CONJOIN_DISJUNCTIVE);
        return this.getDisjunctiveConstraint(constraintList);
    }

    public EqConstraint<NODE> addWeakEquivalence(NODE array1, NODE array2, NODE storeIndex, EqConstraint<NODE> inputConstraint, boolean inplace) {
        assert (VPDomainHelpers.haveSameType(array1, array2));
        this.debugStart(BmNames.ADD_WEAK_EQUALITY);
        if (inplace) {
            assert (!inputConstraint.isFrozen());
            this.mWeqCcManager.reportWeakEquivalence(inputConstraint.getWeqCc(), array1, array2, storeIndex, true);
            this.debugEnd(BmNames.ADD_WEAK_EQUALITY);
            return inputConstraint;
        }
        WeqCongruenceClosure<NODE> newWeqCc = this.mWeqCcManager.reportWeakEquivalence(inputConstraint.getWeqCc(), array1, array2, storeIndex, false);
        EqConstraint<NODE> result = this.getEqConstraint(newWeqCc, false);
        this.debugEnd(BmNames.ADD_WEAK_EQUALITY);
        return result;
    }

    public EqDisjunctiveConstraint<NODE> disjoinDisjunctiveConstraints(EqDisjunctiveConstraint<NODE> disjunct1, EqDisjunctiveConstraint<NODE> disjunct2) {
        this.debugStart(BmNames.DISJOIN_DISJUNCTIVE);
        HashSet<EqConstraint<NODE>> allConjunctiveConstraints = new HashSet<EqConstraint<NODE>>();
        allConjunctiveConstraints.addAll(disjunct1.getConstraints());
        allConjunctiveConstraints.addAll(disjunct2.getConstraints());
        EqDisjunctiveConstraint<NODE> result = this.getDisjunctiveConstraint(allConjunctiveConstraints);
        this.debugEnd(BmNames.DISJOIN_DISJUNCTIVE);
        return result;
    }

    public EqDisjunctiveConstraint<NODE> disjoinDisjunctiveConstraints(List<EqDisjunctiveConstraint<NODE>> disjuncts) {
        this.debugStart(BmNames.DISJOIN_DISJUNCTIVE);
        HashSet<EqConstraint<NODE>> allConjunctiveConstraints = new HashSet<EqConstraint<NODE>>();
        for (EqDisjunctiveConstraint<NODE> disjunct : disjuncts) {
            allConjunctiveConstraints.addAll(disjunct.getConstraints());
        }
        EqDisjunctiveConstraint<NODE> result = this.getDisjunctiveConstraint(allConjunctiveConstraints);
        this.debugEnd(BmNames.DISJOIN_DISJUNCTIVE);
        return result;
    }

    public EqConstraint<NODE> disjoin(EqConstraint<NODE> constraint1, EqConstraint<NODE> constraint2) {
        this.debugStart(BmNames.DISJOIN);
        ArrayList<EqConstraint<NODE>> disjuncts = new ArrayList<EqConstraint<NODE>>();
        disjuncts.add(constraint1);
        disjuncts.add(constraint2);
        EqConstraint<NODE> result = this.getDisjunctiveConstraint(disjuncts).flatten();
        this.debugEnd(BmNames.DISJOIN);
        return result;
    }

    public EqConstraint<NODE> addEquality(NODE node1, NODE node2, EqConstraint<NODE> inputConstraint, boolean inplace) {
        this.debugStart(BmNames.ADD_EQUALITY);
        if (inputConstraint.isBottom()) {
            this.debugEnd(BmNames.ADD_EQUALITY);
            return inputConstraint;
        }
        if (inputConstraint.areEqual(node1, node2, false)) {
            this.debugEnd(BmNames.ADD_EQUALITY);
            return inputConstraint;
        }
        if (inputConstraint.areUnequal(node1, node2, false) && !inplace) {
            this.debugEnd(BmNames.ADD_EQUALITY);
            return this.getBottomConstraint();
        }
        if (inplace) {
            this.mWeqCcManager.reportEquality(inputConstraint.getWeqCc(), node1, node2, true);
            this.debugEnd(BmNames.ADD_EQUALITY);
            return inputConstraint;
        }
        WeqCongruenceClosure<NODE> newWeqCc = this.mWeqCcManager.reportEquality(inputConstraint.getWeqCc(), node1, node2, false);
        EqConstraint<NODE> result = this.getEqConstraint(newWeqCc, false);
        this.debugEnd(BmNames.ADD_EQUALITY);
        return result;
    }

    public EqConstraint<NODE> addDisequality(NODE node1, NODE node2, EqConstraint<NODE> inputConstraint, boolean inplace) {
        assert (inplace != inputConstraint.isFrozen());
        this.debugStart(BmNames.ADD_DISEQUALITY);
        if (inputConstraint.isBottom()) {
            this.debugEnd(BmNames.ADD_DISEQUALITY);
            return inputConstraint;
        }
        if (inputConstraint.areUnequal(node1, node2, false)) {
            this.debugEnd(BmNames.ADD_DISEQUALITY);
            return inputConstraint;
        }
        if (inputConstraint.areEqual(node1, node2, false) && !inplace) {
            this.debugEnd(BmNames.ADD_DISEQUALITY);
            return this.getBottomConstraint();
        }
        if (inplace) {
            this.mWeqCcManager.reportDisequality(inputConstraint.getWeqCc(), node1, node2, true);
            this.debugEnd(BmNames.ADD_DISEQUALITY);
            return inputConstraint;
        }
        WeqCongruenceClosure<NODE> newWeqCc = this.mWeqCcManager.reportDisequality(inputConstraint.getWeqCc(), node1, node2, false);
        EqConstraint<NODE> result = this.getEqConstraint(newWeqCc, false);
        this.debugEnd(BmNames.ADD_DISEQUALITY);
        return result;
    }

    public EqDisjunctiveConstraint<NODE> renameVariables(EqDisjunctiveConstraint<NODE> constraint, Map<Term, Term> substitutionMapping) {
        this.debugStart(BmNames.RENAME_VARIABLES_DISJUNCTIVE);
        ArrayList<EqConstraint<NODE>> constraintList = new ArrayList<EqConstraint<NODE>>();
        for (EqConstraint<NODE> oldConstraint : constraint.getConstraints()) {
            EqConstraint<NODE> newConstraint = this.renameVariables(oldConstraint, substitutionMapping, false);
            constraintList.add(newConstraint);
        }
        EqDisjunctiveConstraint<NODE> result = this.getDisjunctiveConstraint(constraintList);
        this.debugEnd(BmNames.RENAME_VARIABLES_DISJUNCTIVE);
        return result;
    }

    private EqConstraint<NODE> renameVariables(EqConstraint<NODE> oldConstraint, Map<Term, Term> substitutionMapping, boolean inplace) {
        this.debugStart(BmNames.RENAME_VARIABLES);
        if (inplace) {
            this.mWeqCcManager.renameVariables(oldConstraint.getWeqCc(), substitutionMapping, true);
            this.debugEnd(BmNames.RENAME_VARIABLES);
            return oldConstraint;
        }
        WeqCongruenceClosure<NODE> newWeqCc = this.mWeqCcManager.renameVariables(oldConstraint.getWeqCc(), substitutionMapping, false);
        EqConstraint<NODE> result = this.getEqConstraint(newWeqCc, false);
        this.debugEnd(BmNames.RENAME_VARIABLES);
        return result;
    }

    public EqConstraint<NODE> projectExistentially(Collection<Term> termsToProjectAway, EqConstraint<NODE> original, boolean inplace) {
        assert (original.isFrozen());
        assert (original.sanityCheck());
        this.debugStart(BmNames.PROJECTAWAY);
        if (original.isBottom()) {
            this.debugEnd(BmNames.PROJECTAWAY);
            return original;
        }
        if (this.mIsDebugMode) {
            this.mLogger.debug((Object)("project variables " + termsToProjectAway + " from " + original.hashCode()));
        }
        if (inplace) {
            for (Term term : termsToProjectAway) {
                if (!this.getEqNodeAndFunctionFactory().hasNode(term)) continue;
                if (original.isInconsistent()) {
                    this.postProjectHelper(original, termsToProjectAway, original);
                    return original;
                }
                NODE nodeToHavoc = this.getEqNodeAndFunctionFactory().getExistingNode(term);
                this.mWeqCcManager.projectAway(original.getWeqCc(), nodeToHavoc);
            }
            this.postProjectHelper(original, termsToProjectAway, original);
            return original;
        }
        WeqCongruenceClosure<NODE> newWeqCc = original.getWeqCc();
        for (Term term : termsToProjectAway) {
            if (!this.getEqNodeAndFunctionFactory().hasNode(term)) continue;
            if (newWeqCc.isInconsistent(false)) {
                this.postProjectHelper(original, termsToProjectAway, this.getBottomConstraint());
                return this.getBottomConstraint();
            }
            NODE nodeToProjectAway = this.getEqNodeAndFunctionFactory().getExistingNode(term);
            if ((newWeqCc = this.mWeqCcManager.projectAway(newWeqCc, nodeToProjectAway)).isInconsistent(false)) {
                this.postProjectHelper(original, termsToProjectAway, this.getBottomConstraint());
                return this.getBottomConstraint();
            }
            assert (newWeqCc.sanityCheck());
        }
        EqConstraint<NODE> result = this.getEqConstraint(newWeqCc, false);
        this.postProjectHelper(original, termsToProjectAway, result);
        return result;
    }

    private void postProjectHelper(EqConstraint<NODE> original, Collection<Term> termsToProjectAway, EqConstraint<NODE> result) {
        assert (VPDomainHelpers.constraintFreeOfVars(termsToProjectAway, result, this.getMgdScript().getScript())) : "resulting constraint still has at least one of the to-be-projected vars";
        if (this.mIsDebugMode) {
            this.mLogger.debug((Object)("projected variables " + termsToProjectAway + " from " + original.hashCode() + " result: " + result));
        }
        this.debugEnd(BmNames.PROJECTAWAY);
    }

    public AbstractNodeAndFunctionFactory<NODE, Term> getEqNodeAndFunctionFactory() {
        return this.mEqNodeAndFunctionFactory;
    }

    public ManagedScript getMgdScript() {
        return this.mMgdScript;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }

    public WeqCcManager<NODE> getWeqCcManager() {
        return this.mWeqCcManager;
    }

    public ILogger getLogger() {
        return this.mLogger;
    }

    public boolean isDebugMode() {
        return this.mIsDebugMode;
    }

    public Set<IProgramConst> getNonTheoryLiterals() {
        return this.mNonTheoryLiterals;
    }

    public EqDisjunctiveConstraint<NODE> getEmptyDisjunctiveConstraint(boolean modifiable) {
        if (modifiable) {
            return this.getDisjunctiveConstraint(Collections.singleton(this.getEmptyConstraint(true)));
        }
        return this.mEmptyDisjunctiveConstraint;
    }

    public BenchmarkWithCounters getBenchmark() {
        return this.mBenchmark;
    }

    public WeqSettings getWeqSettings() {
        return this.mWeqCcManager.getSettings();
    }

    public EqDisjunctiveConstraint<NODE> closeIfNecessary(EqDisjunctiveConstraint<NODE> resNotClosed) {
        ArrayList<EqConstraint<NODE>> constraintList = new ArrayList<EqConstraint<NODE>>();
        for (EqConstraint<NODE> c : resNotClosed.getConstraints()) {
            constraintList.add(this.closeIfNecessary(c));
        }
        return this.getDisjunctiveConstraint(constraintList);
    }

    private static enum BmNames {
        PROJECTAWAY,
        UNFREEZE,
        ADD_EQUALITY,
        ADD_DISEQUALITY,
        ADD_WEAK_EQUALITY,
        CONJOIN,
        CONJOIN_DISJUNCTIVE,
        DISJOIN,
        DISJOIN_DISJUNCTIVE,
        RENAME_VARIABLES,
        RENAME_VARIABLES_DISJUNCTIVE;


        static String[] getNames() {
            String[] result = new String[BmNames.values().length];
            int i = 0;
            while (i < BmNames.values().length) {
                result[i] = BmNames.values()[i].name();
                ++i;
            }
            return result;
        }
    }
}

