/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.AbstractNodeAndFunctionFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqBottomConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraintFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.VPStatistics;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class EqDisjunctiveConstraint<NODE extends IEqNodeIdentifier<NODE>> {
    private final Set<EqConstraint<NODE>> mConstraints;
    private final EqConstraintFactory<NODE> mFactory;
    private final AbstractNodeAndFunctionFactory<NODE, Term> mNodeAndFunctionFactory;

    public EqDisjunctiveConstraint(Collection<EqConstraint<NODE>> constraintList, EqConstraintFactory<NODE> factory) {
        assert (!constraintList.stream().filter(cons -> cons instanceof EqBottomConstraint).findAny().isPresent()) : "we filter out EqBottomConstraints up front, right? (could also do it here..)";
        this.mConstraints = new HashSet<EqConstraint<NODE>>(constraintList);
        this.mFactory = factory;
        this.mNodeAndFunctionFactory = factory.getEqNodeAndFunctionFactory();
    }

    public boolean isBottom() {
        return this.mConstraints.isEmpty();
    }

    public EqDisjunctiveConstraint<NODE> projectExistentially(Collection<Term> termsToProjectAway) {
        ArrayList newConstraints = new ArrayList();
        for (EqConstraint<NODE> c : this.mConstraints) {
            newConstraints.add(this.mFactory.projectExistentially(termsToProjectAway, c, false));
        }
        return this.mFactory.getDisjunctiveConstraint(newConstraints);
    }

    public Set<EqConstraint<NODE>> getConstraints() {
        return Collections.unmodifiableSet(this.mConstraints);
    }

    public EqConstraint<NODE> flatten() {
        if (this.mConstraints.size() == 0) {
            return this.mFactory.getBottomConstraint();
        }
        if (this.mConstraints.size() == 1) {
            return this.mConstraints.iterator().next();
        }
        return (EqConstraint)this.mConstraints.stream().reduce((c1, c2) -> c1.join(c2)).get();
    }

    public boolean isEmpty() {
        return this.mConstraints.isEmpty();
    }

    public Term getTerm(Script script) {
        List disjuncts = this.mConstraints.stream().map(cons -> cons.getTerm(script)).collect(Collectors.toList());
        return SmtUtils.or((Script)script, disjuncts);
    }

    public boolean areEqual(NODE node1, NODE node2) {
        return this.mConstraints.stream().map(cons -> cons.areEqual(node1, node2, this.mFactory.getWeqSettings().isAddNodesBeforeAnsweringQuery())).reduce((a, b) -> a != false || b != false).get();
    }

    public boolean areEqual(Term node1, Term node2) {
        NODE n1 = this.mNodeAndFunctionFactory.getExistingNode(node1);
        if (n1 == null) {
            return false;
        }
        NODE n2 = this.mNodeAndFunctionFactory.getExistingNode(node2);
        if (n2 == null) {
            return false;
        }
        return this.areEqual(n1, n2);
    }

    public boolean areUnequal(NODE node1, NODE node2) {
        return this.mConstraints.stream().map(cons -> cons.areUnequal(node1, node2, this.mFactory.getWeqSettings().isAddNodesBeforeAnsweringQuery())).reduce((a, b) -> a != false || b != false).get();
    }

    public boolean areUnequal(Term node1, Term node2) {
        NODE n1 = this.mNodeAndFunctionFactory.getExistingNode(node1);
        if (n1 == null) {
            return false;
        }
        NODE n2 = this.mNodeAndFunctionFactory.getExistingNode(node2);
        if (n2 == null) {
            return false;
        }
        return this.areUnequal(n1, n2);
    }

    private EqDisjunctiveConstraint<NODE> reportEquality(NODE node1, NODE node2) {
        ArrayList constraintList = new ArrayList();
        for (EqConstraint<NODE> constraint : this.mConstraints) {
            EqConstraint<NODE> unfrozen = this.mFactory.unfreeze(constraint);
            unfrozen.reportEqualityInPlace(node1, node2);
            if (this.mFactory.getWeqCcManager().getSettings().closeAllEqConstraints()) {
                unfrozen = this.mFactory.closeIfNecessary(unfrozen);
            }
            unfrozen.freezeIfNecessary();
            constraintList.add(unfrozen);
        }
        return this.mFactory.getDisjunctiveConstraint(constraintList);
    }

    public EqDisjunctiveConstraint<NODE> reportEquality(Term node1, Term node2) {
        NODE n1 = this.mNodeAndFunctionFactory.getOrConstructNode(node1);
        NODE n2 = this.mNodeAndFunctionFactory.getOrConstructNode(node2);
        return this.reportEquality(n1, n2);
    }

    private EqDisjunctiveConstraint<NODE> reportDisequality(NODE node1, NODE node2) {
        ArrayList constraintList = new ArrayList();
        for (EqConstraint<NODE> constraint : this.mConstraints) {
            EqConstraint<NODE> unfrozen = this.mFactory.unfreeze(constraint);
            unfrozen.reportDisequalityInPlace(node1, node2);
            if (this.mFactory.getWeqCcManager().getSettings().closeAllEqConstraints()) {
                unfrozen = this.mFactory.closeIfNecessary(unfrozen);
            }
            unfrozen.freezeIfNecessary();
            constraintList.add(unfrozen);
        }
        return this.mFactory.getDisjunctiveConstraint(constraintList);
    }

    public EqDisjunctiveConstraint<NODE> reportDisequality(Term node1, Term node2) {
        NODE n1 = this.mNodeAndFunctionFactory.getOrConstructNode(node1);
        NODE n2 = this.mNodeAndFunctionFactory.getOrConstructNode(node2);
        return this.reportDisequality(n1, n2);
    }

    public String toString() {
        if (this.mConstraints.isEmpty()) {
            return "EmptyDisjunction/False";
        }
        return "\\/ " + this.mConstraints.toString();
    }

    public String toLogString() {
        if (this.mConstraints.isEmpty()) {
            return "EmptyDisjunction/False";
        }
        StringBuilder sb = new StringBuilder();
        this.mConstraints.forEach(c -> {
            StringBuilder stringBuilder2 = sb.append(String.valueOf(c.toLogString()) + "\n");
        });
        return "\\/ " + sb.toString();
    }

    public String getDebugInfo() {
        HashMap<VPStatistics, Integer> statistics = new HashMap<VPStatistics, Integer>();
        VPStatistics[] vPStatisticsArray = VPStatistics.values();
        int n = vPStatisticsArray.length;
        int n2 = 0;
        while (n2 < n) {
            VPStatistics stat = vPStatisticsArray[n2];
            statistics.put(stat, VPStatistics.getInitialValue(stat));
            ++n2;
        }
        StringBuilder sb = new StringBuilder();
        for (EqConstraint<NODE> c : this.mConstraints) {
            VPStatistics[] vPStatisticsArray2 = VPStatistics.values();
            int n3 = vPStatisticsArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                VPStatistics stat = vPStatisticsArray2[n4];
                statistics.put(stat, (Integer)VPStatistics.getAggregator(stat).apply((Integer)statistics.get((Object)stat), c.getStatistics(stat)));
                ++n4;
            }
        }
        sb.append("EqDisjunctiveConstraint statistics:");
        sb.append(statistics);
        return sb.toString();
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.mConstraints == null ? 0 : this.mConstraints.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EqDisjunctiveConstraint other = (EqDisjunctiveConstraint)obj;
        return !(this.mConstraints == null ? other.mConstraints != null : !this.mConstraints.equals(other.mConstraints));
    }

    public Integer getStatistics(VPStatistics stat) {
        switch (stat) {
            case NO_DISJUNCTIONS: 
            case MAX_NO_DISJUNCTIONS: {
                return this.mConstraints.size();
            }
        }
        Integer val = VPStatistics.getInitialValue(stat);
        for (EqConstraint<NODE> c : this.mConstraints) {
            val = (Integer)VPStatistics.getAggregator(stat).apply(val, c.getStatistics(stat));
        }
        return val;
    }

    public EqDisjunctiveConstraint<NODE> closeDisjunctsIfNecessary() {
        if (this.mConstraints.stream().allMatch(c -> c.isClosed())) {
            return this;
        }
        HashSet constraintList = new HashSet();
        for (EqConstraint<NODE> disjunct : this.mConstraints) {
            constraintList.add(this.mFactory.closeIfNecessary(disjunct));
        }
        return this.mFactory.getDisjunctiveConstraint(constraintList);
    }

    public void freezeDisjunctsIfNecessary() {
        for (EqConstraint<NODE> disjunct : this.mConstraints) {
            disjunct.freezeIfNecessary();
        }
    }

    public Set<NODE> getAllLiteralNodes() {
        HashSet<NODE> result = new HashSet<NODE>();
        for (EqConstraint<NODE> c : this.mConstraints) {
            result.addAll(c.getAllLiteralNodes());
        }
        return result;
    }

    public EqConstraintFactory<NODE> getFactory() {
        return this.mFactory;
    }

    public Set<Term> getSetConstraintForExpression(Term exp) {
        NODE node = this.mNodeAndFunctionFactory.getOrConstructNode(exp);
        EqConstraint<NODE> flat = this.flatten();
        Set<NODE> nodes = flat.getSetConstraintForExpression(node);
        if (nodes == null) {
            return null;
        }
        return nodes.stream().map(n -> n.getTerm()).collect(Collectors.toSet());
    }
}

