/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNodeAndFunctionFactory;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Map;

public class EqFunctionApplicationNode
extends EqNode {
    private final EqNode mFunction;
    private final EqNode mArg;

    public EqFunctionApplicationNode(EqNode function, EqNode arg, Term term, EqNodeAndFunctionFactory eqNodeFactory, boolean isUntrackedArray) {
        super(term, eqNodeFactory, isUntrackedArray);
        this.mFunction = function;
        this.mArg = arg;
    }

    public EqNode getAppliedFunction() {
        return this.mFunction;
    }

    @Override
    public EqNode getArgument() {
        return this.mArg;
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    public boolean isFunctionApplication() {
        return true;
    }

    @Override
    public String toString() {
        return String.valueOf(this.mFunction.toString()) + "[" + this.mArg.toString() + "]";
    }

    @Override
    public EqNode replaceAppliedFunction(EqNode replacer) {
        return (EqNode)this.mEqNodeFactory.getOrConstructFuncAppElement(replacer, this.mArg);
    }

    @Override
    public EqNode replaceArgument(EqNode replacer) {
        return (EqNode)this.mEqNodeFactory.getOrConstructFuncAppElement(this.mFunction, replacer);
    }

    public EqNode replaceSubNode(Map<EqNode, EqNode> mapping) {
        EqNode replacer = mapping.get(this);
        if (replacer != null) {
            return replacer;
        }
        return (EqNode)this.mEqNodeFactory.getOrConstructFuncAppElement((EqNode)this.mFunction.replaceSubNode(mapping), (EqNode)this.mArg.replaceSubNode(mapping));
    }
}

