/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.AbstractNodeAndFunctionFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.CongruenceClosureSmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqAtomicBaseNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstantArrayNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqFunctionApplicationNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqMixArrayNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNonAtomicBaseNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class EqNodeAndFunctionFactory
extends AbstractNodeAndFunctionFactory<EqNode, Term> {
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mMgdScript;
    private final Set<Term> mNonTheoryLiteralTerms;
    private final Map<Term, EqNode> mTermToEqNode = new HashMap<Term, EqNode>();
    private final Map<Term, Term> mNormalizationCache = new HashMap<Term, Term>();
    private final List<String> mTrackedArraySubstrings;
    private final Set<String> mMixArrayFunctions;

    public EqNodeAndFunctionFactory(IUltimateServiceProvider services, ManagedScript script, Set<IProgramConst> additionalLiterals, List<String> trackedArraySubstrings, Set<String> mixArrayFunctions) {
        this.mServices = services;
        this.mMgdScript = script;
        this.mNonTheoryLiteralTerms = additionalLiterals.stream().map(pc -> pc.getTerm()).collect(Collectors.toSet());
        this.mTrackedArraySubstrings = trackedArraySubstrings;
        this.mMixArrayFunctions = mixArrayFunctions;
    }

    public ManagedScript getScript() {
        return this.mMgdScript;
    }

    @Override
    public EqNode getOrConstructNode(Term term) {
        if (this.isConstantArray(term)) {
            return this.getOrConstructConstantArray(term);
        }
        if (this.isMixArray(term)) {
            return this.getOrConstructMixArray(term);
        }
        if (SmtUtils.isFunctionApplication((Term)term, (String)"select")) {
            return this.getOrConstructEqFunctionNode((ApplicationTerm)term);
        }
        if (this.isAtomic(term)) {
            return this.getOrConstructEqAtomicBaseNode(term);
        }
        return this.getOrConstructNonAtomicBaseNode(term);
    }

    private EqNode getOrConstructNonAtomicBaseNode(Term term) {
        Term normalizedTerm = this.normalizeTerm(term);
        EqNode result = this.mTermToEqNode.get(normalizedTerm);
        if (result == null) {
            result = (EqNode)this.getBaseElement(normalizedTerm, false);
            this.mTermToEqNode.put(normalizedTerm, result);
        }
        assert (result instanceof EqNonAtomicBaseNode);
        return result;
    }

    private EqNode getOrConstructEqFunctionNode(ApplicationTerm selectTerm) {
        EqNode result = this.mTermToEqNode.get(selectTerm);
        if (result == null) {
            EqNode funcNode = this.getOrConstructNode(selectTerm.getParameters()[0]);
            EqNode argNode = this.getOrConstructNode(selectTerm.getParameters()[1]);
            result = (EqNode)super.getOrConstructFuncAppElement((ICongruenceClosureElement)funcNode, (ICongruenceClosureElement)argNode);
            this.mTermToEqNode.put((Term)selectTerm, result);
        }
        assert (result instanceof EqFunctionApplicationNode);
        return result;
    }

    private EqNode getOrConstructEqAtomicBaseNode(Term term) {
        Term normalizedTerm = this.normalizeTerm(term);
        EqNode result = this.mTermToEqNode.get(normalizedTerm);
        if (result == null) {
            result = (EqNode)this.getBaseElement(normalizedTerm, this.isTermALiteral(normalizedTerm));
            this.mTermToEqNode.put(normalizedTerm, result);
        }
        assert (result instanceof EqAtomicBaseNode);
        return result;
    }

    private Term normalizeTerm(Term term) {
        if (term instanceof TermVariable) {
            return term;
        }
        Term result = this.mNormalizationCache.get(term);
        if (result != null) {
            return result;
        }
        this.mMgdScript.lock((Object)this);
        AffineTerm affineTerm = (AffineTerm)new AffineTermTransformer(this.mMgdScript.getScript()).transform(term);
        this.mMgdScript.unlock((Object)this);
        result = affineTerm.isErrorTerm() ? new CommuhashNormalForm(this.mServices, this.mMgdScript.getScript()).transform(term) : affineTerm.toTerm(this.mMgdScript.getScript());
        this.mNormalizationCache.put(term, result);
        return result;
    }

    @Override
    public boolean hasNode(Term term) {
        return this.mTermToEqNode.get(this.normalizeTerm(term)) != null;
    }

    @Override
    public EqNode getExistingNode(Term term) {
        EqNode result = this.mTermToEqNode.get(this.normalizeTerm(term));
        return result;
    }

    private boolean isTermALiteral(Term term) {
        if (term instanceof TermVariable) {
            return false;
        }
        if (SmtUtils.isTrueLiteral((Term)term) || SmtUtils.isFalseLiteral((Term)term)) {
            return true;
        }
        if (term instanceof ConstantTerm) {
            return true;
        }
        if (this.mNonTheoryLiteralTerms.contains(term)) {
            return true;
        }
        this.mMgdScript.lock((Object)this);
        AffineTerm affineTerm = (AffineTerm)new AffineTermTransformer(this.mMgdScript.getScript()).transform(term);
        this.mMgdScript.unlock((Object)this);
        if (affineTerm.isErrorTerm()) {
            return false;
        }
        return affineTerm.isConstant();
    }

    private boolean isAtomic(Term term) {
        return term instanceof TermVariable || term.getFreeVars().length == 0;
    }

    protected EqNode newBaseElement(Term term, boolean isLiteral) {
        if (this.isAtomic(term)) {
            return new EqAtomicBaseNode(term, isLiteral, this, this.dependsOnUntrackedArray(term));
        }
        assert (!isLiteral);
        assert (term.getFreeVars().length > 0);
        HashSet<EqNode> supportingNodes = new HashSet<EqNode>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable fv = termVariableArray[n2];
            supportingNodes.add(this.getOrConstructNode((Term)fv));
            ++n2;
        }
        return new EqNonAtomicBaseNode(term, supportingNodes, this, this.dependsOnUntrackedArray(term));
    }

    private boolean isConstantArray(Term term) {
        if (!term.getSort().isArraySort()) {
            return false;
        }
        if (!(term instanceof ApplicationTerm)) {
            return false;
        }
        ApplicationTerm at = (ApplicationTerm)term;
        Term def = at.getFunction().getDefinition();
        if (def != null) {
            return this.isConstantArray(def);
        }
        return at.getFunction().getName().equals("const");
    }

    private boolean isMixArray(Term term) {
        if (!term.getSort().isArraySort()) {
            return false;
        }
        if (!(term instanceof ApplicationTerm)) {
            return false;
        }
        ApplicationTerm at = (ApplicationTerm)term;
        Term def = at.getFunction().getDefinition();
        if (def != null) {
            return this.isMixArray(def);
        }
        return this.mMixArrayFunctions.contains(at.getFunction().getName());
    }

    private EqMixArrayNode getOrConstructMixArray(Term term) {
        assert (this.isMixArray(term));
        EqNode result = this.mTermToEqNode.get(term);
        if (result != null) {
            return (EqMixArrayNode)result;
        }
        ApplicationTerm at = (ApplicationTerm)term;
        Term def = at.getFunction().getDefinition();
        if (def != null) {
            throw new AssertionError((Object)"not yet implemented");
        }
        assert (at.getParameters().length == 3);
        assert (at.getParameters()[2].getSort().isArraySort() && new MultiDimensionalSort(at.getParameters()[2].getSort()).getArrayValueSort().getName().equals("Bool"));
        assert (this.mMixArrayFunctions.contains(at.getFunction().getName()));
        EqNode array1 = this.getOrConstructNode(at.getParameters()[0]);
        EqNode array2 = this.getOrConstructNode(at.getParameters()[1]);
        EqMixArrayNode newMixArrayNode = new EqMixArrayNode(term, this, array1, array2);
        this.mTermToEqNode.put(term, newMixArrayNode);
        return newMixArrayNode;
    }

    private EqConstantArrayNode getOrConstructConstantArray(Term term) {
        assert (this.isConstantArray(term));
        EqNode result = this.mTermToEqNode.get(term);
        if (result != null) {
            return (EqConstantArrayNode)result;
        }
        ApplicationTerm at = (ApplicationTerm)term;
        Term def = at.getFunction().getDefinition();
        if (def != null) {
            assert (at.getParameters().length == 1);
            TermVariable var = at.getFunction().getDefinitionVars()[0];
            Term value = at.getParameters()[0];
            Term defSubstituted = Substitution.apply((ManagedScript)this.mMgdScript, Collections.singletonMap(var, value), (Term)def);
            return this.getOrConstructConstantArray(defSubstituted);
        }
        assert (at.getFunction().getName().equals("const"));
        EqNode value = this.getOrConstructNode(at.getParameters()[0]);
        EqConstantArrayNode newConstArrayNode = new EqConstantArrayNode(term, this, value);
        this.mTermToEqNode.put(term, newConstArrayNode);
        return newConstArrayNode;
    }

    private boolean dependsOnUntrackedArray(Term term) {
        if (this.mTrackedArraySubstrings == null) {
            return false;
        }
        if (SmtUtils.isFunctionApplication((Term)term, (String)"select")) {
            return this.dependsOnUntrackedArray(((ApplicationTerm)term).getParameters()[0]);
        }
        if (term.getSort().isArraySort() && (SmtUtils.isConstant((Term)term) || term instanceof TermVariable)) {
            for (String s : this.mTrackedArraySubstrings) {
                if (!term.toString().contains(s)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected EqNode newFuncAppElement(EqNode func, EqNode arg) {
        Term selectTerm = this.buildSelectTerm(func, arg);
        return new EqFunctionApplicationNode(func, arg, selectTerm, this, this.dependsOnUntrackedArray(selectTerm));
    }

    private Term buildSelectTerm(EqNode func, EqNode arg) {
        this.mMgdScript.lock((Object)this);
        Term selectTerm = this.mMgdScript.term((Object)this, "select", new Term[]{func.getTerm(), arg.getTerm()});
        this.mMgdScript.unlock((Object)this);
        return selectTerm;
    }

    boolean isFunction(Term term) {
        return term.getSort().isArraySort();
    }

    public Set<Term> getNonTheoryLiterals() {
        return Collections.unmodifiableSet(this.mNonTheoryLiteralTerms);
    }

    @Override
    public Term getNonTheoryLiteralDisequalities() {
        return SmtUtils.and((Script)this.mMgdScript.getScript(), CongruenceClosureSmtUtils.createDisequalityTermsForNonTheoryLiterals(this.mMgdScript.getScript(), this.getNonTheoryLiterals()));
    }
}

