/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;

class FloydWarshall<VERTEX, EDGELABEL> {
    private final BiPredicate<EDGELABEL, EDGELABEL> mSmallerThan;
    private BiFunction<EDGELABEL, EDGELABEL, EDGELABEL> mPlus;
    private BiFunction<Pair<EDGELABEL, EDGELABEL>, Triple<VERTEX, VERTEX, VERTEX>, EDGELABEL> mOtherPlus;
    private final EDGELABEL mNullLabel;
    private final Map<Doubleton<VERTEX>, EDGELABEL> mDist;
    private final List<VERTEX> mVertices;
    private boolean mPerformedChanges;
    private final BiFunction<EDGELABEL, EDGELABEL, EDGELABEL> mMeet;

    public FloydWarshall(BiPredicate<EDGELABEL, EDGELABEL> smallerThan, BiFunction<EDGELABEL, EDGELABEL, EDGELABEL> plus, BiFunction<EDGELABEL, EDGELABEL, EDGELABEL> meet, EDGELABEL nullLabel, Map<Doubleton<VERTEX>, EDGELABEL> graph, Function<EDGELABEL, EDGELABEL> labelCloner) {
        this(smallerThan, meet, nullLabel, graph, labelCloner);
        this.mPlus = Objects.requireNonNull(plus);
        this.run();
    }

    public FloydWarshall(BiPredicate<EDGELABEL, EDGELABEL> smallerThan, BiFunction<Pair<EDGELABEL, EDGELABEL>, Triple<VERTEX, VERTEX, VERTEX>, EDGELABEL> plus, BiFunction<EDGELABEL, EDGELABEL, EDGELABEL> meet, EDGELABEL nullLabel, Map<Doubleton<VERTEX>, EDGELABEL> graph, Function<EDGELABEL, EDGELABEL> labelCloner, boolean useOtherPlus) {
        this(smallerThan, meet, nullLabel, graph, labelCloner);
        this.mOtherPlus = Objects.requireNonNull(plus);
        this.run();
    }

    private FloydWarshall(BiPredicate<EDGELABEL, EDGELABEL> smallerThan, BiFunction<EDGELABEL, EDGELABEL, EDGELABEL> meet, EDGELABEL nullLabel, Map<Doubleton<VERTEX>, EDGELABEL> graph, Function<EDGELABEL, EDGELABEL> labelCloner) {
        this.mSmallerThan = smallerThan;
        this.mMeet = meet;
        this.mNullLabel = nullLabel;
        this.mPerformedChanges = false;
        this.mDist = new HashMap<Doubleton<VERTEX>, EDGELABEL>();
        HashSet<Object> verticeSet = new HashSet<Object>();
        for (Map.Entry<Doubleton<VERTEX>, EDGELABEL> en : graph.entrySet()) {
            verticeSet.add(en.getKey().getOneElement());
            verticeSet.add(en.getKey().getOtherElement());
            this.mDist.put(en.getKey(), labelCloner.apply(en.getValue()));
        }
        this.mVertices = new ArrayList<VERTEX>(verticeSet);
    }

    public boolean performedChanges() {
        return this.mPerformedChanges;
    }

    private void run() {
        int k = 0;
        while (k < this.mVertices.size()) {
            int i = 0;
            while (i < this.mVertices.size()) {
                if (i != k) {
                    int j = 0;
                    while (j < this.mVertices.size()) {
                        if (j != i && j != k && i <= j) {
                            EDGELABEL ikPlusKj;
                            EDGELABEL distIj = this.getDist(i, j);
                            EDGELABEL distIk = this.getDist(i, k);
                            EDGELABEL distKj = this.getDist(k, j);
                            assert (this.mPlus == null != (this.mOtherPlus == null));
                            EDGELABEL EDGELABEL = ikPlusKj = this.mPlus != null ? this.mPlus.apply(distIk, distKj) : this.mOtherPlus.apply(new Pair(distIk, distKj), new Triple(this.mVertices.get(i), this.mVertices.get(k), this.mVertices.get(j)));
                            if (!this.mSmallerThan.test(distIj, ikPlusKj)) {
                                EDGELABEL ikPlusKjMeetIj = this.mMeet.apply(ikPlusKj, distIj);
                                this.mDist.put(new Doubleton(this.mVertices.get(i), this.mVertices.get(j)), ikPlusKjMeetIj);
                                this.mPerformedChanges = true;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
            ++k;
        }
    }

    private EDGELABEL getDist(int i, int j) {
        EDGELABEL res = this.mDist.get(new Doubleton(this.mVertices.get(i), this.mVertices.get(j)));
        if (res == null) {
            res = this.mNullLabel;
        }
        return res;
    }

    public Map<Doubleton<VERTEX>, EDGELABEL> getResult() {
        return Collections.unmodifiableMap(this.mDist);
    }
}

