/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraintFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqDisjunctiveConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNode;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqNodeAndFunctionFactory;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.LambdaTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.MatchTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BidirectionalMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FormulaToEqDisjunctiveConstraintConverter
extends NonRecursive {
    public static final boolean INPLACE_CONJUNCTIONS = true;
    private final Term mFormula;
    private EqDisjunctiveConstraint<EqNode> mResultConstraint;
    private final EqConstraintFactory<EqNode> mEqConstraintFactory;
    private final EqNodeAndFunctionFactory mEqNodeAndFunctionFactory;
    private final ManagedScript mMgdScript;
    private final IUltimateServiceProvider mServices;
    private final Term mTrueTerm;
    private final Term mFalseTerm;
    private final Deque<EqDisjunctiveConstraint<EqNode>> mResultStack = new ArrayDeque<EqDisjunctiveConstraint<EqNode>>();

    public FormulaToEqDisjunctiveConstraintConverter(IUltimateServiceProvider services, ManagedScript mgdScript, EqConstraintFactory<EqNode> eqConstraintFactory, EqNodeAndFunctionFactory eqNodeAndFunctionFactory, Term formula) {
        this.mFormula = formula;
        this.mEqConstraintFactory = eqConstraintFactory;
        this.mEqNodeAndFunctionFactory = eqNodeAndFunctionFactory;
        this.mMgdScript = mgdScript;
        this.mServices = services;
        this.mMgdScript.lock((Object)this);
        this.mTrueTerm = this.mMgdScript.term((Object)this, "true", new Term[0]);
        this.mFalseTerm = this.mMgdScript.term((Object)this, "false", new Term[0]);
        this.mMgdScript.unlock((Object)this);
        this.computeResult();
    }

    private void computeResult() {
        Term formulaInNnf = new NnfTransformer(this.mMgdScript, this.mServices, NnfTransformer.QuantifierHandling.CRASH).transform(this.mFormula);
        StoreChainSquisher scs = new StoreChainSquisher(this.mMgdScript);
        ArrayList<Term> conjunction = new ArrayList<Term>();
        conjunction.add(scs.transform(formulaInNnf));
        conjunction.addAll(scs.getReplacementEquations());
        Term transFormulaWithSquishedStoreChains = SmtUtils.and((Script)this.mMgdScript.getScript(), conjunction);
        this.run((NonRecursive.Walker)new ConvertTfToEqDisjConsWalker(transFormulaWithSquishedStoreChains));
        assert (this.mResultStack.size() == 1);
        EqDisjunctiveConstraint<EqNode> processedTf = this.mResultStack.pop();
        processedTf.closeDisjunctsIfNecessary();
        processedTf.freezeDisjunctsIfNecessary();
        this.mResultConstraint = processedTf.projectExistentially(scs.getReplacementTermVariables());
    }

    public EqDisjunctiveConstraint<EqNode> getResult() {
        return this.mResultConstraint;
    }

    class ConvertTfToEqDisjConsWalker
    extends NonRecursive.TermWalker {
        public ConvertTfToEqDisjConsWalker(Term term) {
            super(term);
        }

        public void walk(NonRecursive walker, ConstantTerm term) {
            if ("Bool".equals(term.getSort().getName())) {
                assert (false) : "TODO: implement";
            } else assert (false) : "we should have caught this before, right?";
        }

        public void walk(NonRecursive walker, AnnotatedTerm term) {
            walker.enqueueWalker((NonRecursive.Walker)new ConvertTfToEqDisjConsWalker(term.getSubterm()));
        }

        public void walk(NonRecursive walker, ApplicationTerm term) {
            if ("=".equals(term.getFunction().getName())) {
                this.handleXquality(term.getParameters()[0], term.getParameters()[1], true);
            } else if ("distinct".equals(term.getFunction().getName())) {
                this.handleXquality(term.getParameters()[0], term.getParameters()[1], false);
            } else if ("not".equals(term.getFunction().getName()) && SmtUtils.isFunctionApplication((Term)term.getParameters()[0], (String)"=")) {
                ApplicationTerm innerEqualsTerm = (ApplicationTerm)term.getParameters()[0];
                this.handleXquality(innerEqualsTerm.getParameters()[0], innerEqualsTerm.getParameters()[1], false);
            } else if ("not".equals(term.getFunction().getName())) {
                this.handleBooleanTerm(term.getParameters()[0], false);
            } else if ("or".equals(term.getFunction().getName())) {
                walker.enqueueWalker((NonRecursive.Walker)new MakeDisjunctionWalker(term.getParameters().length));
                Term[] termArray = term.getParameters();
                int n = termArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Term param = termArray[n2];
                    walker.enqueueWalker((NonRecursive.Walker)new ConvertTfToEqDisjConsWalker(param));
                    ++n2;
                }
            } else if ("and".equals(term.getFunction().getName())) {
                walker.enqueueWalker((NonRecursive.Walker)new MakeConjunctionWalker(term.getParameters().length));
                Term[] termArray = term.getParameters();
                int n = termArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Term param = termArray[n3];
                    walker.enqueueWalker((NonRecursive.Walker)new ConvertTfToEqDisjConsWalker(param));
                    ++n3;
                }
            } else if ("false".equals(term.getFunction().getName())) {
                FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.push(FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getDisjunctiveConstraint(Collections.emptySet()));
            } else {
                "true".equals(term.getFunction().getName());
                FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.push(FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyDisjunctiveConstraint(true));
            }
        }

        private void handleBooleanTerm(Term term, boolean polarity) {
            assert ("Bool".equals(term.getSort().getName()));
            EqNode tvNode = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(term);
            if (polarity) {
                EqNode trueNode = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(FormulaToEqDisjunctiveConstraintConverter.this.mTrueTerm);
                EqConstraint<EqNode> tvEqualsTrue = FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.addEquality(tvNode, trueNode, FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyConstraint(true), true);
                FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.push(FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getDisjunctiveConstraint(Collections.singleton(tvEqualsTrue)));
            } else {
                EqNode falseNode = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(FormulaToEqDisjunctiveConstraintConverter.this.mFalseTerm);
                EqConstraint<EqNode> tvEqualsFalse = FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.addEquality(tvNode, falseNode, FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyConstraint(true), true);
                FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.push(FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getDisjunctiveConstraint(Collections.singleton(tvEqualsFalse)));
            }
        }

        private void handleXquality(Term arg1, Term arg2, boolean polarity) {
            if (arg1.getSort().isArraySort()) {
                EqConstraint<EqNode> newConstraint;
                EqNode otherSimpleArray;
                EqNode simpleArray;
                ApplicationTerm storeTerm;
                if (!this.isFunctionTracked(arg1) || !this.isFunctionTracked(arg2)) {
                    FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.push(FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyDisjunctiveConstraint(true));
                    return;
                }
                if (SmtUtils.isFunctionApplication((Term)arg1, (String)"store")) {
                    assert (!SmtUtils.isFunctionApplication((Term)arg2, (String)"store"));
                    storeTerm = (ApplicationTerm)arg1;
                    simpleArray = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(arg2);
                    otherSimpleArray = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(storeTerm.getParameters()[0]);
                } else if (SmtUtils.isFunctionApplication((Term)arg2, (String)"store")) {
                    assert (!SmtUtils.isFunctionApplication((Term)arg1, (String)"store"));
                    storeTerm = (ApplicationTerm)arg2;
                    simpleArray = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(arg1);
                    otherSimpleArray = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(storeTerm.getParameters()[0]);
                } else {
                    storeTerm = null;
                    simpleArray = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(arg1);
                    otherSimpleArray = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(arg2);
                }
                if (polarity) {
                    if (storeTerm == null) {
                        newConstraint = FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.addEquality(simpleArray, otherSimpleArray, FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyConstraint(true), true);
                    } else {
                        EqNode storeIndex = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(storeTerm.getParameters()[1]);
                        EqNode storeValue = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(storeTerm.getParameters()[2]);
                        EqConstraint<EqNode> intermediateConstraint = FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.addWeakEquivalence(simpleArray, otherSimpleArray, storeIndex, FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyConstraint(true), true);
                        FormulaToEqDisjunctiveConstraintConverter.this.mMgdScript.lock((Object)this);
                        Term selectTerm = FormulaToEqDisjunctiveConstraintConverter.this.mMgdScript.term((Object)this, "select", new Term[]{simpleArray.getTerm(), storeTerm.getParameters()[1]});
                        FormulaToEqDisjunctiveConstraintConverter.this.mMgdScript.unlock((Object)this);
                        EqNode selectEqNode = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(selectTerm);
                        newConstraint = FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.addEquality(selectEqNode, storeValue, intermediateConstraint, true);
                    }
                } else {
                    newConstraint = storeTerm == null ? FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.addDisequality(simpleArray, otherSimpleArray, FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyConstraint(true), true) : FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyConstraint(true);
                }
                FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.push(FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getDisjunctiveConstraint(Collections.singleton(newConstraint)));
                return;
            }
            if (!this.isElementTracked(arg1) || !this.isElementTracked(arg2)) {
                FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.push(FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyDisjunctiveConstraint(true));
                return;
            }
            EqNode node1 = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(arg1);
            EqNode node2 = FormulaToEqDisjunctiveConstraintConverter.this.mEqNodeAndFunctionFactory.getOrConstructNode(arg2);
            EqConstraint<EqNode> newConstraint = polarity ? FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.addEquality(node1, node2, FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyConstraint(true), true) : FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.addDisequality(node1, node2, FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getEmptyConstraint(true), true);
            FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.push(FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getDisjunctiveConstraint(Collections.singleton(newConstraint)));
        }

        private boolean isElementTracked(Term term) {
            return true;
        }

        private boolean isFunctionTracked(Term term) {
            return true;
        }

        public void walk(NonRecursive walker, LetTerm term) {
            assert (false) : "TODO unlet first (or implement let handling..)";
        }

        public void walk(NonRecursive walker, QuantifiedFormula term) {
            throw new UnsupportedOperationException("quantifiers in Transformulas are currently not supported in the equality domain");
        }

        public void walk(NonRecursive walker, TermVariable term) {
            if ("Bool".equals(term.getSort().getName())) {
                this.handleBooleanTerm((Term)term, true);
                return;
            }
            throw new AssertionError((Object)"we should have caught this before, right?");
        }

        public void walk(NonRecursive walker, MatchTerm term) {
            throw new UnsupportedOperationException("not yet implemented: MatchTerm");
        }

        public void walk(NonRecursive walker, LambdaTerm term) {
            throw new UnsupportedOperationException();
        }
    }

    class MakeConjunctionWalker
    implements NonRecursive.Walker {
        private final int mArity;

        public MakeConjunctionWalker(int arity) {
            this.mArity = arity;
        }

        public void walk(NonRecursive engine) {
            ArrayList conjuncts = new ArrayList();
            int i = 0;
            while (i < this.mArity) {
                conjuncts.add(FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.pop());
                ++i;
            }
            FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.push(FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.conjoinDisjunctiveConstraints(conjuncts));
        }
    }

    class MakeDisjunctionWalker
    implements NonRecursive.Walker {
        private final int mArity;

        public MakeDisjunctionWalker(int arity) {
            this.mArity = arity;
        }

        public void walk(NonRecursive engine) {
            HashSet allConjunctiveConstraints = new HashSet();
            int i = 0;
            while (i < this.mArity) {
                allConjunctiveConstraints.addAll(FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.pop().getConstraints());
                ++i;
            }
            FormulaToEqDisjunctiveConstraintConverter.this.mResultStack.push(FormulaToEqDisjunctiveConstraintConverter.this.mEqConstraintFactory.getDisjunctiveConstraint(allConjunctiveConstraints));
        }
    }

    public static final class StoreChainSquisher
    extends TermTransformer {
        private static final String SQUISHERREPARRAYNAME = "rep";
        private final List<Term> mReplacementEquations;
        private final Map<Term, TermVariable> mReplacedTermToReplacementTv;
        private final Script mScript;
        private final ManagedScript mMgdScript;

        public StoreChainSquisher(ManagedScript mgdScript) {
            this.mScript = mgdScript.getScript();
            this.mMgdScript = mgdScript;
            this.mReplacementEquations = new ArrayList<Term>();
            this.mReplacedTermToReplacementTv = new BidirectionalMap();
        }

        public Collection<Term> getReplacementEquations() {
            ArrayList<Term> result = new ArrayList<Term>();
            for (Map.Entry<Term, TermVariable> en : this.mReplacedTermToReplacementTv.entrySet()) {
                Term replacementEquation = SmtUtils.binaryEquality((Script)this.mScript, (Term)((Term)en.getValue()), (Term)en.getKey());
                result.add(replacementEquation);
            }
            return result;
        }

        public Collection<Term> getReplacementTermVariables() {
            return new ArrayList<TermVariable>(this.mReplacedTermToReplacementTv.values());
        }

        protected void convert(Term term) {
            if (SmtUtils.isFunctionApplication((Term)term, (String)"store")) {
                this.enqueueWalker(new SquishStoreWalker((ApplicationTerm)term));
                this.pushTerms(((ApplicationTerm)term).getParameters());
            } else if (SmtUtils.isFunctionApplication((Term)term, (String)"select")) {
                this.enqueueWalker(new SquishStoreInsideSelectWalker());
                this.pushTerms(((ApplicationTerm)term).getParameters());
            } else if (SmtUtils.isFunctionApplication((Term)term, (String)"=") && SmtUtils.isFunctionApplication((Term)((ApplicationTerm)term).getParameters()[0], (String)"store") && SmtUtils.isFunctionApplication((Term)((ApplicationTerm)term).getParameters()[1], (String)"store")) {
                this.enqueueWalker(new SquishFirstOfTwoArgumentStoresWalker((ApplicationTerm)term));
                assert (((ApplicationTerm)term).getParameters().length == 2);
                this.pushTerms(((ApplicationTerm)term).getParameters());
            } else {
                super.convert(term);
            }
        }

        private TermVariable getReplacementTv(Term term) {
            TermVariable res = this.mReplacedTermToReplacementTv.get(term);
            if (res == null) {
                String name = SmtUtils.sanitizeStringAsSmtIdentifier((String)("rep_" + term.toString()));
                res = this.mMgdScript.constructFreshTermVariable(name, term.getSort());
                this.mReplacedTermToReplacementTv.put(term, res);
            }
            return res;
        }

        Term[] getConvertedArray(Term[] oldArgs) {
            return this.getConverted(oldArgs);
        }

        class SquishFirstOfTwoArgumentStoresWalker
        implements NonRecursive.Walker {
            private final ApplicationTerm mAppTerm;

            public SquishFirstOfTwoArgumentStoresWalker(ApplicationTerm term) {
                this.mAppTerm = term;
                assert (term.getParameters().length == 2);
            }

            public void walk(NonRecursive engine) {
                Term arg2 = StoreChainSquisher.this.getConverted();
                Term arg1 = StoreChainSquisher.this.getConverted();
                assert (SmtUtils.isFunctionApplication((Term)arg1, (String)"store"));
                assert (SmtUtils.isFunctionApplication((Term)arg2, (String)"store"));
                Term innerStoreTerm = arg1;
                TermVariable replacmentTv = StoreChainSquisher.this.getReplacementTv(innerStoreTerm);
                StoreChainSquisher.this.setResult(StoreChainSquisher.this.mScript.term(this.mAppTerm.getFunction().getName(), new Term[]{replacmentTv, arg2}));
            }
        }

        class SquishStoreInsideSelectWalker
        implements NonRecursive.Walker {
            SquishStoreInsideSelectWalker() {
            }

            public void walk(NonRecursive engine) {
                Term arg2 = StoreChainSquisher.this.getConverted();
                Term arg1 = StoreChainSquisher.this.getConverted();
                if (SmtUtils.isFunctionApplication((Term)arg1, (String)"store")) {
                    Term innerStoreTerm = arg1;
                    TermVariable replacmentTv = StoreChainSquisher.this.getReplacementTv(innerStoreTerm);
                    StoreChainSquisher.this.setResult(StoreChainSquisher.this.mScript.term("select", new Term[]{replacmentTv, arg2}));
                } else {
                    StoreChainSquisher.this.setResult(StoreChainSquisher.this.mScript.term("select", new Term[]{arg1, arg2}));
                }
            }
        }

        class SquishStoreWalker
        implements NonRecursive.Walker {
            private static final int NO_STORE_ARGS = 3;
            private final ApplicationTerm mAppTerm;

            public SquishStoreWalker(ApplicationTerm term) {
                this.mAppTerm = term;
            }

            public void walk(NonRecursive engine) {
                StoreChainSquisher transformer = (StoreChainSquisher)engine;
                Term[] oldArgs = this.mAppTerm.getParameters();
                Term[] newArgs = transformer.getConvertedArray(oldArgs);
                assert (newArgs.length == 3);
                Object replacedArray = SmtUtils.isFunctionApplication((Term)newArgs[0], (String)"store") ? StoreChainSquisher.this.getReplacementTv(newArgs[0]) : newArgs[0];
                Object replacedValue = SmtUtils.isFunctionApplication((Term)newArgs[2], (String)"store") ? StoreChainSquisher.this.getReplacementTv(newArgs[2]) : newArgs[2];
                StoreChainSquisher.this.setResult(StoreChainSquisher.this.mScript.term("store", new Term[]{replacedArray, newArgs[1], replacedValue}));
            }

            public String toString() {
                return "StoreTermSquisher: " + StoreChainSquisher.this.mReplacementEquations;
            }
        }
    }
}

