/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IElementRemovalTarget;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IRemovalInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IRestoreNodesBeforeRemove;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.RemoveCcElement;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class RemoveWeqCcElement<NODE extends IEqNodeIdentifier<NODE>>
implements IRemovalInfo<NODE>,
IRestoreNodesBeforeRemove<NODE> {
    private final NODE mElem;
    private final boolean mIntroduceNewNodes;
    private final boolean mMadeChanges;
    private Set<NODE> mElementsToRemove;
    private final Set<NODE> mElementsAlreadyRemoved = new HashSet<NODE>();
    private final Set<NODE> mAddedNodes;
    private boolean mDidRemoval = false;
    private WeqCongruenceClosure<NODE> mWeqCc;

    public RemoveWeqCcElement(WeqCongruenceClosure<NODE> elementContainer, NODE elem, boolean introduceNewNodes) {
        assert (!elem.isFunctionApplication()) : "unexpected..";
        if (elementContainer.isInconsistent(false)) {
            throw new IllegalStateException();
        }
        if (elementContainer.isDebugMode()) {
            elementContainer.getLogger().debug((Object)("RemoveElement " + this.hashCode() + " : removing " + elem + " from " + elementContainer.hashCode()));
        }
        if (!elementContainer.hasElement(elem)) {
            this.mElem = null;
            this.mMadeChanges = false;
            this.mAddedNodes = Collections.emptySet();
            this.mIntroduceNewNodes = false;
            this.mDidRemoval = true;
            return;
        }
        this.mWeqCc = elementContainer;
        this.mElem = elem;
        this.mIntroduceNewNodes = introduceNewNodes;
        this.mMadeChanges = false;
        this.mAddedNodes = !this.mIntroduceNewNodes ? null : new HashSet();
    }

    public Set<NODE> getAddedNodes() {
        assert (this.mDidRemoval);
        return this.mAddedNodes;
    }

    public Collection<NODE> getAlreadyRemovedElements() {
        return this.mElementsAlreadyRemoved;
    }

    public void doRemoval() {
        assert (!this.mDidRemoval);
        Set<NODE> elementsToRemove = this.mWeqCc.collectElementsToRemove(this.mElem);
        this.mElementsToRemove = Collections.unmodifiableSet(elementsToRemove);
        assert (elementsToRemove.stream().allMatch(e -> CongruenceClosure.dependsOnAny((ICongruenceClosureElement)e, Collections.singleton(this.mElem))));
        HashMap<IEqNodeIdentifier, IEqNodeIdentifier> nodeToReplacementNode = new HashMap<IEqNodeIdentifier, IEqNodeIdentifier>();
        for (IEqNodeIdentifier elemToRemove : elementsToRemove) {
            IEqNodeIdentifier otherEqClassMember = this.mWeqCc.getOtherEquivalenceClassMember(elemToRemove, elementsToRemove);
            if (otherEqClassMember == null) continue;
            nodeToReplacementNode.put(elemToRemove, otherEqClassMember);
        }
        assert (DataStructureUtils.intersection(new HashSet(nodeToReplacementNode.values()), elementsToRemove).isEmpty());
        assert (this.nodeAndReplacementAreEquivalent(nodeToReplacementNode, this.mWeqCc));
        assert (!this.mWeqCc.isInconsistent(false));
        boolean becameInconsistentWhenAddingANode = false;
        becameInconsistentWhenAddingANode = RemoveCcElement.addNodesToKeepInformation((IRestoreNodesBeforeRemove)this, elementsToRemove, nodeToReplacementNode);
        this.mWeqCc.reportAllConstraintsFromWeqGraph(false);
        if (becameInconsistentWhenAddingANode) {
            assert (this.mWeqCc.isInconsistent(false));
            this.mDidRemoval = true;
            return;
        }
        assert (this.nodeAndReplacementAreEquivalent(nodeToReplacementNode, this.mWeqCc));
        assert (!this.mWeqCc.isInconsistent(false));
        assert (!this.mWeqCc.isInconsistent(false));
        this.mWeqCc.fatten();
        Set<NODE> nodesAddedInLabels = this.mWeqCc.removeElementAndDependents(this.mElem, elementsToRemove, nodeToReplacementNode);
        this.mWeqCc.thin();
        if (!this.mWeqCc.getManager().getSettings().omitSanitycheckFineGrained1()) assert (this.mWeqCc.getCongruenceClosure().sanityCheck());
        for (IEqNodeIdentifier nail : nodesAddedInLabels) {
            this.mWeqCc.addElementRec(nail);
            if (!this.mWeqCc.isInconsistent(false)) continue;
            if (this.mWeqCc.isDebugMode()) {
                this.mWeqCc.getLogger().debug((Object)("RemoveElement: " + this.mWeqCc.hashCode() + " became inconsistent when adding" + nail));
            }
            this.mDidRemoval = true;
            return;
        }
        assert (this.mWeqCc.sanityCheck());
        this.mWeqCc.extAndTriangleClosure(false);
        if (this.mWeqCc.isDebugMode() && this.mWeqCc.isInconsistent(false)) {
            this.mWeqCc.getLogger().debug((Object)("RemoveElement: " + this.mWeqCc.hashCode() + " became inconsistent during closure operation"));
        }
        this.mDidRemoval = true;
        assert (this.mWeqCc.sanityCheck());
        if (this.mWeqCc.isDebugMode()) {
            this.mWeqCc.getLogger().debug((Object)("RemoveElement " + this.hashCode() + " finished normally"));
        }
    }

    private boolean nodeAndReplacementAreEquivalent(Map<NODE, NODE> nodeToReplacementNode, WeqCongruenceClosure<NODE> elementContainer) {
        for (Map.Entry<NODE, NODE> en : nodeToReplacementNode.entrySet()) {
            if (elementContainer.getEqualityStatus((IEqNodeIdentifier)en.getKey(), (IEqNodeIdentifier)en.getValue()) == EqualityStatus.EQUAL) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public boolean madeChanges() {
        assert (this.mDidRemoval);
        return this.mMadeChanges;
    }

    public Set<NODE> getRemovedElements() {
        return this.mElementsToRemove;
    }

    public String toString() {
        return this.mElementsToRemove.toString();
    }

    public static <NODE extends IEqNodeIdentifier<NODE>> void removeSimpleElement(WeqCongruenceClosure<NODE> cc, NODE elem) {
        RemoveWeqCcElement.removeSimpleElement(cc, elem, true);
    }

    private static <NODE extends IEqNodeIdentifier<NODE>> RemoveWeqCcElement<NODE> removeSimpleElement(WeqCongruenceClosure<NODE> cc, NODE elem, boolean introduceNewNodes) {
        if (elem.isFunctionApplication()) {
            throw new IllegalArgumentException();
        }
        if (cc.isInconsistent(false)) {
            throw new IllegalStateException();
        }
        assert (cc.getElementCurrentlyBeingRemoved() == null);
        RemoveWeqCcElement<NODE> re = new RemoveWeqCcElement<NODE>(cc, elem, introduceNewNodes);
        if (!cc.hasElement(elem)) {
            assert (!re.madeChanges());
            assert (re.getAddedNodes().isEmpty());
            return re;
        }
        cc.setElementCurrentlyBeingRemoved(re);
        re.doRemoval();
        assert (cc.assertSimpleElementIsFullyRemoved(elem));
        if (!cc.getManager().getSettings().omitSanitycheckFineGrained1()) assert (cc.sanityCheck());
        cc.setElementCurrentlyBeingRemoved(null);
        assert (cc.assertSimpleElementIsFullyRemoved(elem));
        assert (cc.sanityCheck());
        return re;
    }

    public static <NODE extends IEqNodeIdentifier<NODE>> Set<NODE> removeSimpleElementDontUseWeqGpaTrackAddedNodes(WeqCongruenceClosure<NODE> lab, NODE elem) {
        RemoveWeqCcElement<NODE> re = RemoveWeqCcElement.removeSimpleElement(lab, elem, true);
        return re.getAddedNodes();
    }

    public boolean isIntroduceNewNodes() {
        return this.mIntroduceNewNodes;
    }

    public NODE getElem() {
        return this.mElem;
    }

    public IElementRemovalTarget<NODE> getElementContainer() {
        return this.mWeqCc;
    }

    public void registerAddedNodes(Set<NODE> nodesToAdd) {
        this.mAddedNodes.addAll(nodesToAdd);
    }
}

