/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.EqConstraint;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalStore;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class VPDomainHelpers {
    public static Map<TermVariable, IProgramVar> computeProgramVarMappingFromTransFormula(TransFormula tf) {
        return VPDomainHelpers.computeProgramVarMappingFromInVarOutVarMappings(tf.getInVars(), tf.getOutVars());
    }

    public static Map<TermVariable, IProgramVar> computeProgramVarMappingFromInVarOutVarMappings(Map<IProgramVar, TermVariable> map1, Map<IProgramVar, TermVariable> map2) {
        HashMap<TermVariable, IProgramVar> result = new HashMap<TermVariable, IProgramVar>();
        for (Map.Entry<IProgramVar, TermVariable> en : map1.entrySet()) {
            result.put(en.getValue(), en.getKey());
        }
        for (Map.Entry<IProgramVar, TermVariable> en : map2.entrySet()) {
            result.put(en.getValue(), en.getKey());
        }
        return result;
    }

    public static IProgramVar getProgramVar(TermVariable newArray, Map<IProgramVar, TermVariable> map) {
        for (Map.Entry<IProgramVar, TermVariable> en : map.entrySet()) {
            if (en.getValue() != newArray) continue;
            return en.getKey();
        }
        return null;
    }

    public static Map<IProgramVar, TermVariable> projectToTerm(Map<IProgramVar, TermVariable> xVars, Term term) {
        HashMap<IProgramVar, TermVariable> result = new HashMap<IProgramVar, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> en : xVars.entrySet()) {
            if (!Arrays.asList(term.getFreeVars()).contains(en.getValue())) continue;
            result.put(en.getKey(), en.getValue());
        }
        return result;
    }

    public static Term getArrayTerm(Term t) {
        if (!(t instanceof ApplicationTerm)) {
            return t;
        }
        ApplicationTerm at = (ApplicationTerm)t;
        if (at.getFunction().getName().equals("select")) {
            MultiDimensionalSelect mds = new MultiDimensionalSelect((Term)at);
            if (mds.getArray() instanceof ApplicationTerm && (((ApplicationTerm)mds.getArray()).getFunction().getName().equals("select") || ((ApplicationTerm)mds.getArray()).getFunction().getName().equals("store"))) {
                return VPDomainHelpers.getArrayTerm(mds.getArray());
            }
            return mds.getArray();
        }
        if (at.getFunction().getName().equals("store")) {
            MultiDimensionalStore mds = MultiDimensionalStore.convert((Term)at);
            if (mds.getArray() instanceof ApplicationTerm && (((ApplicationTerm)mds.getArray()).getFunction().getName().equals("select") || ((ApplicationTerm)mds.getArray()).getFunction().getName().equals("store"))) {
                return VPDomainHelpers.getArrayTerm(mds.getArray());
            }
            return mds.getArray();
        }
        assert (false);
        return null;
    }

    public static Map<IProgramVar, TermVariable> projectToVars(Map<IProgramVar, TermVariable> toBeProjected, Set<IProgramVar> projection) {
        HashMap<IProgramVar, TermVariable> result = new HashMap<IProgramVar, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> en : toBeProjected.entrySet()) {
            if (!projection.contains(en.getKey())) continue;
            result.put(en.getKey(), en.getValue());
        }
        return result;
    }

    public static InOutStatusOfStateId getInOutStatusOfPvoc(IProgramVarOrConst function, TransFormula tf) {
        InOutStatusOfStateId functionInOutStatus = function instanceof IProgramVarOrConst ? VPDomainHelpers.computeInOutStatus((IProgramVar)function, tf) : InOutStatusOfStateId.THROUGH;
        return functionInOutStatus;
    }

    public static InOutStatusOfStateId computeInOutStatus(IProgramVar pv, TransFormula tf) {
        boolean isIn = tf.getInVars().containsKey(pv);
        boolean isOut = tf.getOutVars().containsKey(pv);
        if (isIn && isOut) {
            if (tf.getInVars().get(pv) == tf.getOutVars().get(pv)) {
                return InOutStatusOfStateId.THROUGH;
            }
            return InOutStatusOfStateId.UPDATE;
        }
        if (isIn && !isOut) {
            return InOutStatusOfStateId.IN;
        }
        if (!isIn && isOut) {
            return InOutStatusOfStateId.OUT;
        }
        assert (!isIn && !isOut);
        return InOutStatusOfStateId.NONE;
    }

    public static Map<IProgramVar, TermVariable> projectOut(Map<IProgramVar, TermVariable> inVars, IProgramVarOrConst function) {
        HashMap<IProgramVar, TermVariable> result = new HashMap<IProgramVar, TermVariable>(inVars);
        if (function instanceof IProgramVar) {
            result.remove(function);
        }
        return Collections.unmodifiableMap(result);
    }

    public static <T> Set<List<T>> computeCrossProduct(List<Set<T>> nodesWithSideConditions, IUltimateServiceProvider services) {
        HashSet<List<Object>> result = new HashSet<List<T>>();
        result.add(new ArrayList());
        for (Set<T> nwscs : nodesWithSideConditions) {
            HashSet newResult = new HashSet();
            if (!services.getProgressMonitorService().continueProcessing()) {
                return null;
            }
            for (List list : result) {
                for (T nwsc : nwscs) {
                    ArrayList<T> newIndex = new ArrayList<T>(list);
                    newIndex.add(nwsc);
                    newResult.add(newIndex);
                }
            }
            result = newResult;
        }
        return result;
    }

    public static Map<IProgramVar, TermVariable> projectToTermAndVars(Map<IProgramVar, TermVariable> varMapping, Term projectionTerm, Set<IProgramVar> projectionVars) {
        return VPDomainHelpers.projectToTerm(VPDomainHelpers.projectToVars(varMapping, projectionVars), projectionTerm);
    }

    public static <T> Set<T> intersect(Set<T> s1, Set<T> s2) {
        HashSet<T> result = new HashSet<T>(s1);
        result.retainAll(s2);
        return Collections.unmodifiableSet(result);
    }

    public static <K, V> boolean imageIsNeverNull(Map<K, V> map) {
        for (Map.Entry<K, V> en : map.entrySet()) {
            if (en.getValue() != null) continue;
            return false;
        }
        return true;
    }

    public static <NODE extends IEqNodeIdentifier<NODE>> boolean constraintFreeOfVars(Collection<Term> varsToProjectAway, EqConstraint<NODE> unfrozen, Script script) {
        if (varsToProjectAway.isEmpty()) {
            return true;
        }
        HashSet<Term> mixArrayThirdArgs = new HashSet<Term>();
        for (IEqNodeIdentifier node : unfrozen.getAllNodes()) {
            if (node.isMixFunction()) {
                if (varsToProjectAway.contains(node.getMixFunction1())) {
                    assert (false);
                    return false;
                }
                if (varsToProjectAway.contains(node.getMixFunction2())) {
                    assert (false);
                    return false;
                }
                mixArrayThirdArgs.add(((ApplicationTerm)node.getTerm()).getParameters()[2]);
                continue;
            }
            Set intersection = DataStructureUtils.intersection(new HashSet<TermVariable>(Arrays.asList(node.getTerm().getFreeVars())), new HashSet<Term>(varsToProjectAway));
            if (intersection.isEmpty()) continue;
            assert (false);
            return false;
        }
        if (script != null && Arrays.asList(unfrozen.getTerm(script).getFreeVars()).stream().anyMatch(fv -> varsToProjectAway.contains(fv) && !mixArrayThirdArgs.contains(fv))) {
            assert (false);
            return false;
        }
        return true;
    }

    public static <T> boolean arrayContains(T[] array, T elem) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (t.equals(elem)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <NODE extends IEqNodeIdentifier<NODE>> boolean haveSameType(NODE func1, NODE func2) {
        if (func1.getTerm().getSort() != func2.getTerm().getSort()) {
            assert (false);
            return false;
        }
        return true;
    }

    public static <K, V> void transformRelationInPlace(HashRelation<K, V> relation, Function<K, K> kTransformer, Function<V, V> vTransformer) {
        for (Map.Entry pair : new HashRelation(relation)) {
            relation.removePair(pair.getKey(), pair.getValue());
            relation.addPair(kTransformer.apply(pair.getKey()), vTransformer.apply(pair.getValue()));
        }
    }

    public static enum InOutStatusOfStateId {
        IN,
        OUT,
        THROUGH,
        UPDATE,
        NONE;

    }
}

