/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import java.util.function.BinaryOperator;

public enum VPStatistics {
    MAX_WEQGRAPH_SIZE,
    MAX_SIZEOF_WEQEDGELABEL,
    NO_SUPPORTING_EQUALITIES,
    NO_SUPPORTING_DISEQUALITIES,
    NO_DISJUNCTIONS,
    MAX_NO_DISJUNCTIONS;


    public static BinaryOperator<Integer> getAggregator(VPStatistics vps) {
        switch (vps) {
            case MAX_WEQGRAPH_SIZE: 
            case MAX_SIZEOF_WEQEDGELABEL: 
            case MAX_NO_DISJUNCTIONS: {
                return Math::max;
            }
            case NO_SUPPORTING_EQUALITIES: 
            case NO_SUPPORTING_DISEQUALITIES: 
            case NO_DISJUNCTIONS: {
                return (i1, i2) -> i1 + i2;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static Integer getInitialValue(VPStatistics vps) {
        switch (vps) {
            case MAX_WEQGRAPH_SIZE: 
            case MAX_SIZEOF_WEQEDGELABEL: 
            case MAX_NO_DISJUNCTIONS: {
                return -1;
            }
            case NO_SUPPORTING_EQUALITIES: 
            case NO_SUPPORTING_DISEQUALITIES: 
            case NO_DISJUNCTIONS: {
                return 0;
            }
        }
        throw new UnsupportedOperationException();
    }

    public static Integer getNonApplicableValue(VPStatistics stat) {
        switch (stat) {
            case MAX_WEQGRAPH_SIZE: 
            case MAX_SIZEOF_WEQEDGELABEL: 
            case MAX_NO_DISJUNCTIONS: {
                return -2;
            }
            case NO_SUPPORTING_EQUALITIES: 
            case NO_SUPPORTING_DISEQUALITIES: 
            case NO_DISJUNCTIONS: {
                return -2;
            }
        }
        throw new UnsupportedOperationException();
    }
}

