/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.CongruenceClosureSmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.Diet;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeakEquivalenceGraph;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCcManager;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCongruenceClosure;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IRemovalInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.RemoveCcElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraint;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.PartialOrderCache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

class WeakEquivalenceEdgeLabel<NODE extends IEqNodeIdentifier<NODE>> {
    private static final boolean MEET_IN_PLACE = true;
    private final WeakEquivalenceGraph<NODE> mWeakEquivalenceGraph;
    private final WeqCcManager<NODE> mWeqCcManager;
    private final Set<CongruenceClosure<NODE>> mDisjuncts;
    boolean mIsFrozen;

    WeakEquivalenceEdgeLabel(WeakEquivalenceGraph<NODE> weakEquivalenceGraph, WeakEquivalenceEdgeLabel<NODE> original, boolean omitSanityCheck) {
        this.mWeakEquivalenceGraph = weakEquivalenceGraph;
        this.mWeqCcManager = weakEquivalenceGraph.getWeqCcManager();
        this.mDisjuncts = new HashSet<CongruenceClosure<NODE>>(original.getNumberOfDisjuncts());
        for (CongruenceClosure<NODE> l : original.getDisjuncts()) {
            assert (!l.isInconsistent());
            assert (!l.isTautological() || original.getDisjuncts().size() == 1);
            this.mDisjuncts.add(this.mWeqCcManager.copyCc(l, !this.mWeakEquivalenceGraph.isFrozen()));
        }
        assert (!this.mWeakEquivalenceGraph.isFrozen() || this.mDisjuncts.stream().allMatch(cc -> cc.isFrozen()));
        assert (omitSanityCheck || this.sanityCheck());
    }

    WeakEquivalenceEdgeLabel(WeakEquivalenceGraph<NODE> weakEquivalenceGraph, Set<CongruenceClosure<NODE>> newLabelContents) {
        this(weakEquivalenceGraph, newLabelContents, false);
    }

    WeakEquivalenceEdgeLabel(WeakEquivalenceGraph<NODE> weakEquivalenceGraph, Set<CongruenceClosure<NODE>> newLabelContents, boolean omitSanityChecks) {
        this.mWeakEquivalenceGraph = weakEquivalenceGraph;
        this.mWeqCcManager = weakEquivalenceGraph.getWeqCcManager();
        this.mDisjuncts = this.mWeqCcManager.filterRedundantCcs(newLabelContents);
        if (this.mDisjuncts.size() == 1 && this.mDisjuncts.iterator().next().isInconsistent()) {
            this.mDisjuncts.clear();
        }
        assert (this.mDisjuncts.stream().allMatch(cc -> !this.mWeakEquivalenceGraph.isFrozen() || cc.isFrozen()));
        assert (omitSanityChecks || this.sanityCheck());
    }

    WeakEquivalenceEdgeLabel(WeakEquivalenceGraph<NODE> weakEquivalenceGraph, CongruenceClosure<NODE> emptyDisjunct) {
        this.mWeakEquivalenceGraph = weakEquivalenceGraph;
        this.mWeqCcManager = weakEquivalenceGraph.getWeqCcManager();
        this.mDisjuncts = new HashSet<CongruenceClosure<NODE>>();
        if (weakEquivalenceGraph.isFrozen()) {
            this.mWeqCcManager.freezeIfNecessary(emptyDisjunct);
            this.mDisjuncts.add(emptyDisjunct);
        } else {
            this.mDisjuncts.add(this.mWeqCcManager.getCcManager().unfreezeIfNecessary(emptyDisjunct));
        }
        assert (this.sanityCheck());
    }

    void setExternalRemInfo(IRemovalInfo<NODE> remInfo) {
        for (CongruenceClosure<NODE> lab : this.getDisjuncts()) {
            lab.setExternalRemInfo(remInfo);
        }
    }

    boolean hasExternalRemInfo() {
        for (CongruenceClosure<NODE> l : this.getDisjuncts()) {
            assert (l.assertHasExternalRemInfo());
        }
        return true;
    }

    boolean assertHasOnlyWeqVarConstraints(Set<NODE> weqVarsForThisEdge) {
        for (CongruenceClosure<NODE> l : this.getDisjuncts()) {
            if (l.assertHasOnlyWeqVarConstraints(weqVarsForThisEdge)) continue;
            assert (false);
            return false;
        }
        return true;
    }

    void projectWeqVarNode(NODE firstDimWeqVarNode) {
        for (CongruenceClosure<NODE> lab : this.getDisjuncts()) {
            if (lab instanceof CongruenceClosure) {
                RemoveCcElement.removeSimpleElementDontIntroduceNewNodes(lab, firstDimWeqVarNode);
                continue;
            }
            throw new AssertionError((Object)"implement this?");
        }
        assert (this.sanityCheckDontEnforceProjectToWeqVars(this.mWeakEquivalenceGraph.mWeqCc));
    }

    Set<NODE> projectAwaySimpleElement(NODE elemToRemove) {
        if (this.isTautological()) {
            return Collections.emptySet();
        }
        if (this.isInconsistent()) {
            return Collections.emptySet();
        }
        HashSet nodesToAddToGpa = new HashSet();
        ArrayList<CongruenceClosure<NODE>> newLabelContents = new ArrayList<CongruenceClosure<NODE>>(this.getNumberOfDisjuncts());
        for (CongruenceClosure<NODE> lab : this.getDisjuncts()) {
            assert (lab.sanityCheckOnlyCc(this.mWeakEquivalenceGraph.mWeqCc.getElementCurrentlyBeingRemoved()));
            RemoveCcElement.removeSimpleElementDontIntroduceNewNodes(lab, elemToRemove);
            assert (lab.assertSingleElementIsFullyRemoved(elemToRemove));
            if (lab.isTautological()) {
                this.setToTrue(this.mWeqCcManager.getEmptyCc(false));
                return Collections.emptySet();
            }
            assert (lab.sanityCheckOnlyCc(this.mWeakEquivalenceGraph.mWeqCc.getElementCurrentlyBeingRemoved()));
            assert (lab.assertSingleElementIsFullyRemoved(elemToRemove));
            assert (!lab.isTautological());
            assert (lab.sanityCheckOnlyCc(this.mWeakEquivalenceGraph.mWeqCc.getElementCurrentlyBeingRemoved()));
            newLabelContents.add(lab);
        }
        this.setNewLabelContents(newLabelContents);
        assert (this.getDisjuncts().stream().allMatch(l -> l.assertSingleElementIsFullyRemoved((ICongruenceClosureElement)elemToRemove)));
        assert (this.sanityCheck());
        return nodesToAddToGpa;
    }

    private int getNumberOfDisjuncts() {
        return this.mDisjuncts.size();
    }

    WeakEquivalenceEdgeLabel<NODE> projectToElements(Set<NODE> allWeqNodes, boolean modifiable) {
        assert (this.mWeakEquivalenceGraph.mWeqCc.mDiet == Diet.THIN);
        if (this.isInconsistent()) {
            return this;
        }
        if (allWeqNodes.isEmpty()) {
            return this;
        }
        HashSet<CongruenceClosure<NODE>> newLabelContents = new HashSet<CongruenceClosure<NODE>>();
        for (CongruenceClosure<NODE> item : this.getDisjuncts()) {
            CongruenceClosure<NODE> projected = this.mWeqCcManager.projectToElements(item, allWeqNodes, this.mWeakEquivalenceGraph.mWeqCc.getElementCurrentlyBeingRemoved(), modifiable);
            newLabelContents.add(projected);
        }
        assert (newLabelContents.stream().allMatch(l -> l.sanityCheckOnlyCc()));
        WeakEquivalenceEdgeLabel<NODE> result = new WeakEquivalenceEdgeLabel<NODE>(this.mWeakEquivalenceGraph, newLabelContents);
        assert (result.sanityCheck());
        return result;
    }

    void inOrDecreaseWeqVarIndices(int inOrDecrease, List<NODE> weqVarsForThisEdge) {
        assert (inOrDecrease == 1 || inOrDecrease == -1) : "we don't expect any other cases";
        assert (inOrDecrease != 1 || !this.getAppearingNodes().contains(weqVarsForThisEdge.get(weqVarsForThisEdge.size() - 1))) : "project the highest weqvar before increasing!";
        assert (inOrDecrease != -1 || !this.getAppearingNodes().contains(weqVarsForThisEdge.get(0))) : "project the lowest weqvar before decreasing!";
        if (this.isTautological() || this.isInconsistent()) {
            return;
        }
        HashMap<Term, TermVariable> substitutionMapping = new HashMap<Term, TermVariable>();
        int i = 0;
        while (i < weqVarsForThisEdge.size()) {
            IEqNodeIdentifier nodeI = (IEqNodeIdentifier)weqVarsForThisEdge.get(i);
            int newDim = i + inOrDecrease;
            if (newDim >= 0 && newDim < weqVarsForThisEdge.size()) {
                substitutionMapping.put(nodeI.getTerm(), this.mWeqCcManager.getWeqVariableForDimension(newDim, nodeI.getSort()));
            }
            ++i;
        }
        this.transformElements(e -> e.renameVariables(substitutionMapping));
        assert (this.sanityCheckDontEnforceProjectToWeqVars(this.mWeakEquivalenceGraph.mWeqCc));
    }

    boolean isConstrained(NODE elem) {
        return this.getDisjuncts().stream().anyMatch(l -> l.isConstrained((ICongruenceClosureElement)elem));
    }

    Set<CongruenceClosure<NODE>> getDisjuncts() {
        return Collections.unmodifiableSet(this.mDisjuncts);
    }

    boolean isInconsistent() {
        for (CongruenceClosure<NODE> pa : this.getDisjuncts()) {
            if (!pa.isInconsistent()) {
                return false;
            }
            assert (this.getDisjuncts().size() == 1) : "we are filtering out all but one 'bottoms', right?";
        }
        return true;
    }

    @Deprecated
    WeakEquivalenceEdgeLabel<NODE> reportChangeInGroundPartialArrangement(Predicate<CongruenceClosure<NODE>> reportX) {
        assert (this.sanityCheck());
        HashSet<CongruenceClosure<NODE>> newLabel = new HashSet<CongruenceClosure<NODE>>();
        for (CongruenceClosure<NODE> disjunct : this.getDisjuncts()) {
            assert (this.mWeakEquivalenceGraph.mWeqCc.sanityCheck());
            assert (disjunct.sanityCheckOnlyCc());
            CongruenceClosure<NODE> meetWgpa = this.mWeqCcManager.getSettings().isMeetWithGpaOnReportchange() ? this.mWeqCcManager.meet(disjunct, this.mWeakEquivalenceGraph.mWeqCc.getCongruenceClosure(), this.mWeakEquivalenceGraph.mWeqCc.getElementCurrentlyBeingRemoved(), false) : disjunct;
            if (meetWgpa.isInconsistent()) continue;
            boolean change = reportX.test(meetWgpa);
            if (!change) {
                newLabel.add(disjunct);
                assert (!meetWgpa.isInconsistent());
                continue;
            }
            if (this.mWeqCcManager.getSettings().isMeetWithGpaOnReportchange()) {
                CongruenceClosure<NODE> projected = this.mWeqCcManager.projectToElements(meetWgpa, this.mWeakEquivalenceGraph.getWeqCcManager().getAllWeqNodes(), this.mWeakEquivalenceGraph.mWeqCc.getElementCurrentlyBeingRemoved(), true);
                newLabel.add(projected);
            } else {
                newLabel.add(meetWgpa);
            }
            assert (this.sanityCheck());
        }
        assert (newLabel.stream().allMatch(CongruenceClosure::sanityCheckOnlyCc));
        return new WeakEquivalenceEdgeLabel<NODE>(this.mWeakEquivalenceGraph, newLabel);
    }

    List<Term> toDnf(Script script) {
        ArrayList<Term> result = new ArrayList<Term>();
        Iterator<CongruenceClosure<NODE>> iterator = this.getDisjuncts().iterator();
        while (iterator.hasNext()) {
            CongruenceClosure<NODE> d;
            CongruenceClosure<NODE> cc = d = iterator.next();
            List<Term> cube = CongruenceClosureSmtUtils.congruenceClosureToCube(script, cc, this.mWeqCcManager.getNonTheoryLiteralDisequalitiesIfNecessary());
            Term cubeTerm = SmtUtils.and((Script)script, cube);
            result.add(cubeTerm);
        }
        return result;
    }

    void transformElements(Function<NODE, NODE> transformer) {
        assert (!this.isFrozen());
        assert (this.sanityCheckDontEnforceProjectToWeqVars(this.mWeakEquivalenceGraph.mWeqCc));
        HashSet<CongruenceClosure<NODE>> newLabelContents = new HashSet<CongruenceClosure<NODE>>();
        for (CongruenceClosure<NODE> l : this.getDisjuncts()) {
            if (l.isFrozen()) {
                CongruenceClosure unfrozen = this.mWeqCcManager.getCcManager().unfreeze(l);
                unfrozen.transformElementsAndFunctions(transformer);
                newLabelContents.add(unfrozen);
            } else {
                l.transformElementsAndFunctions(transformer);
                newLabelContents.add(l);
            }
            assert (this.sanityCheckDontEnforceProjectToWeqVars(this.mWeakEquivalenceGraph.mWeqCc));
        }
        this.setNewLabelContents(newLabelContents);
        assert (this.sanityCheckDontEnforceProjectToWeqVars(this.mWeakEquivalenceGraph.mWeqCc));
    }

    Set<NODE> getAppearingNodes() {
        HashSet res = new HashSet();
        this.getDisjuncts().forEach(pa -> {
            boolean bl = res.addAll(pa.getAllElements());
        });
        return res;
    }

    WeakEquivalenceEdgeLabel<NODE> meet(WeakEquivalenceEdgeLabel<NODE> otherLabel, boolean inplace) {
        WeakEquivalenceEdgeLabel<NODE> result;
        assert (this.sanityCheckDontEnforceProjectToWeqVars(this.mWeakEquivalenceGraph.mWeqCc));
        assert (!inplace || !this.isFrozen());
        WeakEquivalenceEdgeLabel<NODE> originalThis = null;
        if (WeqCcManager.areAssertsEnabled() && inplace) {
            originalThis = this.mWeqCcManager.copy(this, true, true);
        } else if (WeqCcManager.areAssertsEnabled() && !inplace) {
            originalThis = this;
        }
        HashSet newLabelContent = new HashSet();
        for (CongruenceClosure<NODE> lc1 : this.getDisjuncts()) {
            for (CongruenceClosure<NODE> lc2 : otherLabel.getDisjuncts()) {
                if (inplace && !lc1.isFrozen()) {
                    this.mWeqCcManager.meet(lc1, lc2, true);
                    newLabelContent.add(lc1);
                    continue;
                }
                CongruenceClosure<NODE> meet = this.mWeqCcManager.meet(lc1, lc2, false);
                newLabelContent.add(meet);
            }
        }
        assert (this.mWeqCcManager.checkMeetWeqLabels(originalThis, otherLabel, new WeakEquivalenceEdgeLabel<NODE>(this.mWeakEquivalenceGraph, newLabelContent, true)));
        if (inplace) {
            Set<CongruenceClosure<NODE>> newLabelContentsFiltered = this.mWeqCcManager.filterRedundantCcs(newLabelContent);
            assert (newLabelContentsFiltered.stream().allMatch(l -> l.sanityCheckOnlyCc()));
            this.setNewLabelContents(newLabelContentsFiltered);
            result = this;
        } else {
            result = new WeakEquivalenceEdgeLabel<NODE>(this.mWeakEquivalenceGraph, newLabelContent);
        }
        if (!inplace) {
            result.freeze();
        }
        assert (result.sanityCheck());
        return result;
    }

    WeakEquivalenceEdgeLabel<NODE> union(WeakEquivalenceEdgeLabel<NODE> other) {
        return this.union(other, null);
    }

    WeakEquivalenceEdgeLabel<NODE> union(WeakEquivalenceEdgeLabel<NODE> other, PartialOrderCache<CongruenceClosure<NODE>> ccPoCache) {
        assert (this.sanityCheck() && other.sanityCheck());
        if (this.isTautological()) {
            return this;
        }
        if (other.isTautological()) {
            return other;
        }
        if (this.isInconsistent()) {
            return other;
        }
        if (other.isInconsistent()) {
            return this;
        }
        ArrayList<CongruenceClosure<NODE>> unionList = new ArrayList<CongruenceClosure<NODE>>(this.getNumberOfDisjuncts() + other.getNumberOfDisjuncts());
        unionList.addAll(this.getDisjuncts());
        unionList.addAll(other.getDisjuncts());
        Set<CongruenceClosure<NODE>> filtered = ccPoCache == null ? this.mWeqCcManager.filterRedundantCcs(new HashSet(unionList)) : this.mWeqCcManager.filterRedundantCcs(new HashSet(unionList), ccPoCache);
        WeakEquivalenceEdgeLabel<NODE> result = new WeakEquivalenceEdgeLabel<NODE>(this.mWeakEquivalenceGraph, filtered);
        assert (this.mWeqCcManager.getSettings().omitSanitycheckFineGrained2() || WeakEquivalenceEdgeLabel.assertUnionIntroducesNoNewNodes(this, other, result)) : "union of two labels may not introduce any new nodes";
        assert (result.sanityCheck());
        return result;
    }

    public static <NODE extends IEqNodeIdentifier<NODE>> boolean assertUnionIntroducesNoNewNodes(WeakEquivalenceEdgeLabel<NODE> first, WeakEquivalenceEdgeLabel<NODE> second, WeakEquivalenceEdgeLabel<NODE> result) {
        Set difference = DataStructureUtils.difference(result.getAppearingNodes(), (Set)DataStructureUtils.union(first.getAppearingNodes(), second.getAppearingNodes()));
        if (!difference.isEmpty()) {
            assert (false);
            return false;
        }
        return true;
    }

    boolean isTautological() {
        for (CongruenceClosure<NODE> l : this.getDisjuncts()) {
            if (!l.isTautological()) continue;
            assert (this.getDisjuncts().size() == 1);
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.getNumberOfDisjuncts() < this.mWeqCcManager.getSettings().getMaxNoEdgelabeldisjunctsForVerboseToString()) {
            return this.toLogString();
        }
        return "weq edge label, size: " + this.mDisjuncts.size();
    }

    public String toLogString() {
        if (this.isInconsistent()) {
            return "False";
        }
        if (this.isTautological()) {
            return "True";
        }
        StringBuilder sb = new StringBuilder();
        this.getDisjuncts().forEach(l -> {
            StringBuilder stringBuilder2 = sb.append(String.valueOf(l.toLogString()) + "\n");
        });
        return sb.toString();
    }

    boolean sanityCheck() {
        return this.sanityCheck(this.mWeakEquivalenceGraph.mWeqCc);
    }

    private boolean sanityCheck(WeqCongruenceClosure<NODE> baseWeqCc) {
        if (this.mWeakEquivalenceGraph.getWeqCcManager() == null) {
            return true;
        }
        if (this.getDisjuncts().stream().anyMatch(l -> l.isTautological()) && this.getDisjuncts().size() > 1) {
            assert (false);
            return false;
        }
        if (this.getDisjuncts().stream().anyMatch(l -> l.isInconsistent())) {
            assert (false);
            return false;
        }
        if (baseWeqCc != null) {
            for (CongruenceClosure<NODE> lab : this.getDisjuncts()) {
                for (IEqNodeIdentifier el : lab.getAllElements()) {
                    if (!CongruenceClosure.dependsOnAny((ICongruenceClosureElement)el, this.mWeakEquivalenceGraph.getWeqCcManager().getAllWeqPrimedNodes())) continue;
                    assert (false);
                    return false;
                }
            }
        }
        return this.sanityCheckDontEnforceProjectToWeqVars(this.mWeakEquivalenceGraph.mWeqCc);
    }

    void meetWithCcGpa() {
        HashSet<CongruenceClosure<NODE>> newLabelContents = new HashSet<CongruenceClosure<NODE>>();
        for (CongruenceClosure<NODE> disjunct : this.getDisjuncts()) {
            assert (disjunct instanceof CongruenceClosure);
            if (disjunct.isTautological()) {
                if (this.getNumberOfDisjuncts() == 1) {
                    return;
                }
                this.setToTrue(this.mWeqCcManager.getCcManager().unfreeze(this.mWeakEquivalenceGraph.mEmptyDisjunct));
                return;
            }
            CongruenceClosure ccfatDisjunct = this.mWeqCcManager.getCcManager().unfreezeIfNecessary(disjunct);
            this.mWeqCcManager.meet(ccfatDisjunct, this.mWeakEquivalenceGraph.mWeqCc.getCongruenceClosure(), this.mWeakEquivalenceGraph.mWeqCc.getElementCurrentlyBeingRemoved(), true);
            if (ccfatDisjunct.isInconsistent()) continue;
            if (ccfatDisjunct.isTautological()) {
                assert (false) : "this should never happen because if the meet is tautological then mLabel.get(i)is, too, right?";
                this.setToTrue(this.mWeqCcManager.getCcManager().unfreeze(this.mWeakEquivalenceGraph.mEmptyDisjunct));
                return;
            }
            newLabelContents.add(ccfatDisjunct);
        }
        assert (newLabelContents.size() <= 1 || !newLabelContents.stream().anyMatch(c -> c.isTautological()));
        this.setNewLabelContents(newLabelContents);
        assert (this.sanityCheckDontEnforceProjectToWeqVars(this.mWeakEquivalenceGraph.mWeqCc));
    }

    private void setNewLabelContents(Collection<CongruenceClosure<NODE>> newLabelContents) {
        assert (newLabelContents.stream().allMatch(cc -> !this.mWeakEquivalenceGraph.isFrozen() || cc.isFrozen()));
        this.mDisjuncts.clear();
        this.mDisjuncts.addAll(newLabelContents);
    }

    private void setToTrue(CongruenceClosure<NODE> emptyDisjunct) {
        assert (this.mWeakEquivalenceGraph.isFrozen() == emptyDisjunct.isFrozen());
        this.mDisjuncts.clear();
        this.mDisjuncts.add(emptyDisjunct);
    }

    boolean sanityCheckDontEnforceProjectToWeqVars(WeqCongruenceClosure<NODE> baseWeqCc) {
        if (baseWeqCc != null) {
            for (CongruenceClosure<NODE> lab : this.getDisjuncts()) {
                if (lab.sanityCheckOnlyCc(baseWeqCc.getElementCurrentlyBeingRemoved())) continue;
                assert (false);
                return false;
            }
        }
        if (this.getDisjuncts().stream().anyMatch(pa -> pa.isTautological()) && this.getNumberOfDisjuncts() != 1) {
            assert (false) : "missing normalization: if there is one 'true' disjunct, we can dropall other disjuncts";
            return false;
        }
        if (this.getDisjuncts().stream().anyMatch(pa -> pa.isInconsistent())) {
            assert (false) : "missing normalization: contains 'false' disjuncts";
            return false;
        }
        return true;
    }

    boolean assertWeqVarSelectsHaveCorrectVarForDimension(int edgeNodeDimension) {
        for (CongruenceClosure<NODE> lab : this.getDisjuncts()) {
            for (IEqNodeIdentifier el : lab.getAllElements()) {
                if (!this.mWeqCcManager.getAllWeqNodes().contains(el) || this.mWeqCcManager.getDimensionOfWeqVar(el) < edgeNodeDimension) continue;
                assert (false);
                return false;
            }
        }
        return true;
    }

    boolean assertElementIsFullyRemoved(NODE elem) {
        for (CongruenceClosure<NODE> lab : this.getDisjuncts()) {
            if (lab.assertSingleElementIsFullyRemoved(elem)) continue;
            assert (false);
            return false;
        }
        return true;
    }

    WeakEquivalenceGraph<NODE> getWeqGraph() {
        return this.mWeakEquivalenceGraph;
    }

    public boolean assertDisjunctsAreUnfrozen() {
        for (CongruenceClosure<NODE> disjunct : this.getDisjuncts()) {
            if (!disjunct.isFrozen()) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public boolean assertDisjunctsAreFrozen() {
        for (CongruenceClosure<NODE> disjunct : this.getDisjuncts()) {
            if (disjunct.isFrozen()) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public void freeze() {
        for (CongruenceClosure<NODE> disjunct : this.getDisjuncts()) {
            this.mWeqCcManager.freezeIfNecessary(disjunct);
        }
        this.mIsFrozen = true;
    }

    public boolean assertIsSlim() {
        assert (this.assertHasOnlyWeqVarConstraints(this.mWeqCcManager.getAllWeqNodes()));
        assert (this.mWeakEquivalenceGraph.mEmptyDisjunct instanceof CongruenceClosure);
        assert (DataStructureUtils.intersection(this.getAppearingNodes(), this.mWeqCcManager.getAllWeqPrimedNodes()).isEmpty());
        return true;
    }

    public WeakEquivalenceEdgeLabel<NODE> thin(WeakEquivalenceGraph<NODE> newWeqGraph) {
        HashSet<CongruenceClosure<NODE>> newLabelContents = new HashSet<CongruenceClosure<NODE>>();
        for (CongruenceClosure<NODE> d : this.getDisjuncts()) {
            CongruenceClosure<NODE> cc = this.mWeqCcManager.copyCc(d, true);
            CongruenceClosure<NODE> unprimedIfWeqFat = cc;
            CongruenceClosure<NODE> thinned = this.mWeqCcManager.projectToElements(unprimedIfWeqFat, this.mWeqCcManager.getAllWeqNodes(), null, true);
            if (thinned.isTautological()) {
                return new WeakEquivalenceEdgeLabel<NODE>(newWeqGraph, this.mWeqCcManager.getEmptyCc(true));
            }
            if (thinned.isInconsistent()) continue;
            newLabelContents.add(thinned);
        }
        return new WeakEquivalenceEdgeLabel<NODE>(newWeqGraph, newLabelContents);
    }

    public void freezeIfNecessary() {
        if (this.mIsFrozen) {
            return;
        }
        for (CongruenceClosure<NODE> disjunct : this.getDisjuncts()) {
            this.mWeqCcManager.freezeIfNecessary(disjunct);
        }
        this.mIsFrozen = true;
    }

    public boolean isFrozen() {
        return this.mIsFrozen;
    }

    public Set<SetConstraint<NODE>> getContainsConstraintForElement(NODE elem) {
        Set resultConstraint = null;
        for (CongruenceClosure<NODE> d : this.mDisjuncts) {
            Set cc = d.getContainsConstraintForElement(elem);
            if (cc == null) {
                return null;
            }
            resultConstraint = resultConstraint == null ? cc : this.mWeqCcManager.getCcManager().getSetConstraintManager().join(this.mWeakEquivalenceGraph.mWeqCc.getCongruenceClosure().getLiteralSetConstraints(), resultConstraint, cc);
        }
        return resultConstraint;
    }
}

