/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.Diet;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.FloydWarshall;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeakEquivalenceEdgeLabel;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCcManager;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCongruenceClosure;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraint;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintManager;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.PartialOrderCache;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class WeakEquivalenceGraph<NODE extends IEqNodeIdentifier<NODE>> {
    private final WeqCcManager<NODE> mWeqCcManager;
    private final Map<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> mWeakEquivalenceEdges;
    private final Queue<ConstraintFromWeqGraph> mConstraintsToReport;
    final WeqCongruenceClosure<NODE> mWeqCc;
    private boolean mIsFrozen;
    final CongruenceClosure<NODE> mEmptyDisjunct;

    public WeakEquivalenceGraph(WeqCongruenceClosure<NODE> pArr, WeqCcManager<NODE> manager, CongruenceClosure<NODE> emptyDisjunct) {
        this.mWeqCc = pArr;
        this.mWeakEquivalenceEdges = new HashMap<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>>();
        this.mConstraintsToReport = new ArrayDeque<ConstraintFromWeqGraph>();
        this.mWeqCcManager = manager;
        this.mEmptyDisjunct = emptyDisjunct;
        assert (this.sanityCheck());
    }

    private WeakEquivalenceGraph(Map<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> weakEquivalenceEdges, Queue<ConstraintFromWeqGraph> constraintsToReport, WeqCcManager<NODE> manager, CongruenceClosure<NODE> emptyDisjunct) {
        this.mWeqCc = null;
        this.mWeakEquivalenceEdges = weakEquivalenceEdges;
        this.mConstraintsToReport = constraintsToReport;
        this.mWeqCcManager = manager;
        this.mEmptyDisjunct = emptyDisjunct;
        assert (this.sanityCheck());
    }

    public WeakEquivalenceGraph(WeqCongruenceClosure<NODE> pArr, WeakEquivalenceGraph<NODE> weakEquivalenceGraph) {
        this.mWeqCc = pArr;
        this.mConstraintsToReport = new ArrayDeque<ConstraintFromWeqGraph>(weakEquivalenceGraph.mConstraintsToReport);
        this.mWeakEquivalenceEdges = new HashMap<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>>();
        this.mWeqCcManager = weakEquivalenceGraph.getWeqCcManager();
        this.mEmptyDisjunct = weakEquivalenceGraph.mEmptyDisjunct;
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> weqEdge : weakEquivalenceGraph.mWeakEquivalenceEdges.entrySet()) {
            Doubleton newSourceAndTarget = new Doubleton((Object)pArr.getRepresentativeElement((IEqNodeIdentifier)weqEdge.getKey().getOneElement()), (Object)pArr.getRepresentativeElement((IEqNodeIdentifier)weqEdge.getKey().getOtherElement()));
            this.putEdgeLabel(newSourceAndTarget, this.mWeqCcManager.copy(weqEdge.getValue(), this, true));
        }
        assert (this.sanityCheck());
    }

    public ConstraintFromWeqGraph pollStoredConstraintAndRemoveRelatedWeqEdge() {
        if (!this.hasConstraintsToReport()) {
            throw new IllegalStateException("check hasArrayEqualities before calling this method");
        }
        ConstraintFromWeqGraph c = this.mConstraintsToReport.poll();
        this.mWeakEquivalenceEdges.remove(c.getRelatedWeqEdge());
        return c;
    }

    @Deprecated
    public boolean reportChangeInGroundPartialArrangement(Predicate<CongruenceClosure<NODE>> action) {
        assert (!this.mIsFrozen);
        boolean madeChanges = false;
        HashMap<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> weqCopy = new HashMap<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>>(this.mWeakEquivalenceEdges);
        for (Map.Entry edge : weqCopy.entrySet()) {
            WeakEquivalenceEdgeLabel<NODE> newLabel = ((WeakEquivalenceEdgeLabel)edge.getValue()).reportChangeInGroundPartialArrangement(action);
            this.updateConstraintsToBePropagated((Doubleton)edge.getKey(), (WeakEquivalenceEdgeLabel)edge.getValue());
            madeChanges = true;
            this.putEdgeLabel((Doubleton)edge.getKey(), newLabel);
            madeChanges |= !this.mWeqCcManager.isEquivalentCc((WeakEquivalenceEdgeLabel)edge.getValue(), newLabel);
        }
        return madeChanges;
    }

    public void replaceVertex(NODE elem, NODE replacement) {
        HashMap<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> edgesCopy = new HashMap<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>>(this.mWeakEquivalenceEdges);
        for (Map.Entry en : edgesCopy.entrySet()) {
            WeakEquivalenceEdgeLabel<NODE> label;
            IEqNodeIdentifier source = (IEqNodeIdentifier)((Doubleton)en.getKey()).getOneElement();
            IEqNodeIdentifier target = (IEqNodeIdentifier)((Doubleton)en.getKey()).getOtherElement();
            if (source.equals(elem)) {
                label = this.mWeakEquivalenceEdges.remove(en.getKey());
                if (replacement == null) continue;
                this.putEdgeLabelDuringRemove(new Doubleton(replacement, (Object)target), label, replacement);
                continue;
            }
            if (!target.equals(elem)) continue;
            label = this.mWeakEquivalenceEdges.remove(en.getKey());
            if (replacement == null) continue;
            this.putEdgeLabelDuringRemove(new Doubleton((Object)source, replacement), label, replacement);
        }
    }

    public WeakEquivalenceGraph<NODE> thinLabels(WeqCongruenceClosure<NODE> baseWeqCc) {
        assert (this.mWeqCc.mDiet != Diet.THIN);
        WeakEquivalenceGraph<IEqNodeIdentifier> result = new WeakEquivalenceGraph<IEqNodeIdentifier>(baseWeqCc, this.mWeqCcManager, this.mWeqCcManager.getEmptyCc(false));
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> en : this.getWeqEdgesEntrySet()) {
            result.reportWeakEquivalence((IEqNodeIdentifier)en.getKey().getOneElement(), (IEqNodeIdentifier)en.getKey().getOtherElement(), en.getValue().thin(result), true);
        }
        return result;
    }

    public Set<NODE> projectAwaySimpleElementInEdgeLabels(NODE elem) {
        assert (!this.mIsFrozen);
        HashSet<NODE> nodesToAdd = new HashSet<NODE>();
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> en : this.getWeqEdgesEntrySet()) {
            assert (!elem.equals(en.getKey().getOneElement()));
            assert (!elem.equals(en.getKey().getOtherElement()));
            nodesToAdd.addAll(en.getValue().projectAwaySimpleElement(elem));
        }
        assert (this.assertElementIsFullyRemoved(elem));
        return nodesToAdd;
    }

    public void transformElementsAndFunctions(Function<NODE, NODE> transformer) {
        HashMap<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> weqEdgesCopy = new HashMap<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>>(this.mWeakEquivalenceEdges);
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> en : weqEdgesCopy.entrySet()) {
            this.mWeakEquivalenceEdges.remove(en.getKey());
            Doubleton newDton = new Doubleton((Object)((IEqNodeIdentifier)transformer.apply((IEqNodeIdentifier)en.getKey().getOneElement())), (Object)((IEqNodeIdentifier)transformer.apply((IEqNodeIdentifier)en.getKey().getOtherElement())));
            if (en.getValue().isFrozen()) {
                WeakEquivalenceEdgeLabel<NODE> unfrozen = this.mWeqCcManager.unfreeze(en.getValue());
                unfrozen.transformElements(transformer);
                this.putEdgeLabel(newDton, unfrozen);
                continue;
            }
            en.getValue().transformElements(transformer);
            this.putEdgeLabel(newDton, en.getValue());
        }
        assert (this.sanityCheck());
    }

    WeakEquivalenceGraph<NODE> join(WeakEquivalenceGraph<NODE> other) {
        assert (this.mWeqCc != null && other.mWeqCc != null) : "we need the base weqCc for the joinof the weq graphs, because strong equalities influence the weak ones..";
        assert (this.isFrozen() && other.isFrozen()) : "frozen <-> fully closed/reduced";
        WeakEquivalenceGraph<NODE> result = new WeakEquivalenceGraph<NODE>(null, this.mWeqCcManager, this.mEmptyDisjunct);
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> thisWeqEdge : this.getWeqEdgesEntrySet()) {
            IEqNodeIdentifier target;
            WeakEquivalenceEdgeLabel<NODE> correspondingWeqEdgeLabelInOther = other.getEdgeLabel(thisWeqEdge.getKey());
            IEqNodeIdentifier source = (IEqNodeIdentifier)thisWeqEdge.getKey().getOneElement();
            if (other.mWeqCc.hasElements(new IEqNodeIdentifier[]{source, target = (IEqNodeIdentifier)thisWeqEdge.getKey().getOtherElement()}) && other.mWeqCc.getEqualityStatus(source, target) == EqualityStatus.EQUAL) {
                WeakEquivalenceEdgeLabel<NODE> newEdgeLabel = this.mWeqCcManager.copy(thisWeqEdge.getValue(), result, true);
                result.putEdgeLabel(thisWeqEdge.getKey(), newEdgeLabel);
                assert (correspondingWeqEdgeLabelInOther == null);
                continue;
            }
            if (correspondingWeqEdgeLabelInOther == null) continue;
            WeakEquivalenceEdgeLabel<NODE> thisNewEdgeLabel = this.mWeqCcManager.copy(thisWeqEdge.getValue(), result, true);
            WeakEquivalenceEdgeLabel<NODE> otherNewEdgeLabel = this.mWeqCcManager.copy(correspondingWeqEdgeLabelInOther, result, true);
            result.putEdgeLabel(thisWeqEdge.getKey(), thisNewEdgeLabel.union(otherNewEdgeLabel));
        }
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> otherWeqEdge : other.getWeqEdgesEntrySet()) {
            IEqNodeIdentifier target;
            IEqNodeIdentifier source = (IEqNodeIdentifier)otherWeqEdge.getKey().getOneElement();
            if (!this.mWeqCc.hasElements(new IEqNodeIdentifier[]{source, target = (IEqNodeIdentifier)otherWeqEdge.getKey().getOtherElement()}) || this.mWeqCc.getEqualityStatus(source, target) != EqualityStatus.EQUAL) continue;
            WeakEquivalenceEdgeLabel<NODE> newEdgeLabel = this.mWeqCcManager.copy(otherWeqEdge.getValue(), result, true);
            result.putEdgeLabel(new Doubleton((Object)source, (Object)target), newEdgeLabel);
        }
        assert (result.sanityCheck());
        return result;
    }

    boolean hasConstraintsToReport() {
        return !this.mConstraintsToReport.isEmpty();
    }

    WeakEquivalenceEdgeLabel<NODE> otherPlus(Pair<WeakEquivalenceEdgeLabel<NODE>, WeakEquivalenceEdgeLabel<NODE>> edges, Triple<NODE, NODE, NODE> nodes) {
        WeakEquivalenceEdgeLabel aToB = (WeakEquivalenceEdgeLabel)edges.getFirst();
        WeakEquivalenceEdgeLabel bToC = (WeakEquivalenceEdgeLabel)edges.getSecond();
        assert (this.mWeqCcManager.getSettings().omitSanitycheckFineGrained1() || aToB.sanityCheck());
        assert (this.mWeqCcManager.getSettings().omitSanitycheckFineGrained1() || bToC.sanityCheck());
        IEqNodeIdentifier a = (IEqNodeIdentifier)nodes.getFirst();
        IEqNodeIdentifier b = (IEqNodeIdentifier)nodes.getSecond();
        IEqNodeIdentifier c = (IEqNodeIdentifier)nodes.getThird();
        if (a.getSort() != b.getSort()) {
            assert (aToB.isTautological());
            return aToB;
        }
        if (b.getSort() != c.getSort()) {
            assert (bToC.isTautological());
            return bToC;
        }
        boolean aToBVanishesOnProjectOfB = this.mayVanishOnProjectOfArray(aToB, b);
        boolean bToCVanishesOnProjectOfB = this.mayVanishOnProjectOfArray(bToC, b);
        if (aToBVanishesOnProjectOfB) {
            IEqNodeIdentifier aOfQ = this.constructAOfQ(new MultiDimensionalSort(a.getSort()), a);
            IEqNodeIdentifier bOfQ = this.constructAOfQ(new MultiDimensionalSort(a.getSort()), b);
            WeakEquivalenceEdgeLabel<IEqNodeIdentifier> aToBNew = this.mWeqCcManager.reportEquality(aToB, aOfQ, bOfQ, false);
            assert (this.mWeqCcManager.getSettings().omitSanitycheckFineGrained1() || aToBNew.sanityCheck());
            return aToBNew.union(bToC, null);
        }
        if (bToCVanishesOnProjectOfB) {
            IEqNodeIdentifier cOfQ = this.constructAOfQ(new MultiDimensionalSort(c.getSort()), c);
            IEqNodeIdentifier bOfQ = this.constructAOfQ(new MultiDimensionalSort(a.getSort()), b);
            WeakEquivalenceEdgeLabel<IEqNodeIdentifier> bToCNew = this.mWeqCcManager.reportEquality(bToC, cOfQ, bOfQ, false);
            assert (this.mWeqCcManager.getSettings().omitSanitycheckFineGrained1() || bToCNew.sanityCheck());
            return aToB.union(bToCNew, null);
        }
        return aToB.union(bToC, null);
    }

    private NODE constructAOfQ(MultiDimensionalSort mds, NODE innerArray) {
        int dimensionality = mds.getDimension();
        int dim = dimensionality - 1;
        while (dim >= 0) {
            NODE qDim = this.mWeqCcManager.getWeqVariableNodeForDimension(dim, (Sort)mds.getIndexSorts().get(dim));
            innerArray = (IEqNodeIdentifier)this.mWeqCcManager.getEqNodeAndFunctionFactory().getOrConstructFuncAppElement((ICongruenceClosureElement)innerArray, (ICongruenceClosureElement)qDim);
            --dim;
        }
        return innerArray;
    }

    private boolean mayVanishOnProjectOfArray(WeakEquivalenceEdgeLabel<NODE> l1, NODE array) {
        if (l1.isTautological() || l1.isInconsistent()) {
            return false;
        }
        return l1.getDisjuncts().stream().anyMatch(d -> this.mayVanishOnProjectOfArray((CongruenceClosure<NODE>)d, array));
    }

    private boolean mayVanishOnProjectOfArray(CongruenceClosure<NODE> d, NODE array) {
        return !this.mWeqCcManager.getAllWeqNodes().stream().anyMatch(q -> d.isConstrainedDirectly((ICongruenceClosureElement)q));
    }

    Map<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> propagateViaTriangleRule() {
        if (this.mWeakEquivalenceEdges.isEmpty()) {
            return Collections.emptyMap();
        }
        assert (this.mWeqCcManager.getSettings().omitSanitycheckFineGrained1() || this.sanityCheck());
        BiPredicate<WeakEquivalenceEdgeLabel, WeakEquivalenceEdgeLabel> smallerThan = (label1, label2) -> this.mWeqCcManager.isStrongerThan(label1, label2, this.mWeqCcManager::isStrongerThan);
        BiFunction<Pair, Triple, WeakEquivalenceEdgeLabel> plus = this::otherPlus;
        BiFunction<WeakEquivalenceEdgeLabel, WeakEquivalenceEdgeLabel, WeakEquivalenceEdgeLabel> meet = (l1, l2) -> this.mWeqCcManager.meetEdgeLabels((WeakEquivalenceEdgeLabel<NODE>)l1, (WeakEquivalenceEdgeLabel<NODE>)l2, false);
        WeakEquivalenceEdgeLabel<NODE> nullLabel = new WeakEquivalenceEdgeLabel<NODE>(this, this.mEmptyDisjunct);
        Map<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> graph = this.mWeakEquivalenceEdges;
        Function<WeakEquivalenceEdgeLabel, WeakEquivalenceEdgeLabel> labelCloner = weqLabel -> this.mWeqCcManager.copy((WeakEquivalenceEdgeLabel<NODE>)weqLabel, true);
        FloydWarshall<NODE, WeakEquivalenceEdgeLabel> fw = new FloydWarshall<NODE, WeakEquivalenceEdgeLabel>(smallerThan, plus, meet, nullLabel, graph, labelCloner, true);
        if (!fw.performedChanges()) {
            return Collections.emptyMap();
        }
        assert (this.mWeqCcManager.getSettings().omitSanitycheckFineGrained1() || fw.getResult().keySet().stream().allMatch(dton -> ((IEqNodeIdentifier)dton.getOneElement()).getSort().equals(((IEqNodeIdentifier)dton.getOtherElement()).getSort())));
        return fw.getResult();
    }

    public boolean isEmpty() {
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> edge : this.getWeqEdgesEntrySet()) {
            if (edge.getValue().isTautological()) continue;
            return false;
        }
        return true;
    }

    boolean isStrongerThan(WeakEquivalenceGraph<NODE> other) {
        assert (this.isFrozen() && other.isFrozen());
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> otherWeqEdgeAndLabel : other.getWeqEdgesEntrySet()) {
            WeakEquivalenceEdgeLabel<NODE> correspondingWeqEdgeInThis = this.getEdgeLabel(otherWeqEdgeAndLabel.getKey());
            if (correspondingWeqEdgeInThis == null) {
                return false;
            }
            if (this.mWeqCcManager.isStrongerThan(correspondingWeqEdgeInThis, otherWeqEdgeAndLabel.getValue())) continue;
            return false;
        }
        return true;
    }

    boolean isFrozen() {
        return this.mIsFrozen;
    }

    public List<Term> getWeakEquivalenceConstraintsAsTerms(Script script) {
        ArrayList<Term> result = new ArrayList<Term>();
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> edge : this.getWeqEdgesEntrySet()) {
            ArrayList<Term> dnfAsCubeList = new ArrayList<Term>();
            dnfAsCubeList.addAll(edge.getValue().toDnf(script));
            IEqNodeIdentifier source = (IEqNodeIdentifier)edge.getKey().getOneElement();
            IEqNodeIdentifier target = (IEqNodeIdentifier)edge.getKey().getOtherElement();
            assert (source.hasSameTypeAs(target));
            Term arrayEquation = this.computeArrayEquation(script, source, target);
            dnfAsCubeList.add(arrayEquation);
            Term edgeFormula = SmtUtils.quantifier((Script)script, (int)1, new HashSet<TermVariable>(this.computeWeqIndicesForArray((IEqNodeIdentifier)edge.getKey().getOneElement())), (Term)SmtUtils.or((Script)script, dnfAsCubeList));
            result.add(edgeFormula);
            assert (this.mWeqCcManager.getSettings().omitSanitycheckFineGrained2() || this.mWeqCcManager.getAllWeqVariables().stream().allMatch(weqvar -> !Arrays.asList(edgeFormula.getFreeVars()).contains(weqvar))) : "free weqvar in formula";
        }
        return result;
    }

    private Term computeArrayEquation(Script script, NODE array1, NODE array2) {
        assert (array1.getTerm().getSort().equals(array2.getTerm().getSort()));
        List indexEntries = this.computeWeqIndicesForArray(array1).stream().map(tv -> tv).collect(Collectors.toList());
        ArrayIndex index = new ArrayIndex(indexEntries);
        Term select1 = array1.getSort().isArraySort() ? SmtUtils.multiDimensionalSelect((Script)script, (Term)array1.getTerm(), (ArrayIndex)index) : array1.getTerm();
        Term select2 = array2.getSort().isArraySort() ? SmtUtils.multiDimensionalSelect((Script)script, (Term)array2.getTerm(), (ArrayIndex)index) : array2.getTerm();
        return SmtUtils.binaryEquality((Script)script, (Term)select1, (Term)select2);
    }

    private List<TermVariable> computeWeqIndicesForArray(NODE array1) {
        MultiDimensionalSort mdSort = new MultiDimensionalSort(array1.getTerm().getSort());
        ArrayList<TermVariable> indexEntries = new ArrayList<TermVariable>();
        int i = 0;
        while (i < mdSort.getDimension()) {
            indexEntries.add(this.mWeqCcManager.getWeqVariableForDimension(i, (Sort)mdSort.getIndexSorts().get(i)));
            ++i;
        }
        return indexEntries;
    }

    public Map<NODE, WeakEquivalenceEdgeLabel<NODE>> getAdjacentWeqEdges(NODE appliedFunction) {
        HashMap<IEqNodeIdentifier, WeakEquivalenceEdgeLabel<NODE>> result = new HashMap<IEqNodeIdentifier, WeakEquivalenceEdgeLabel<NODE>>();
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> en : this.getWeqEdgesEntrySet()) {
            if (((IEqNodeIdentifier)en.getKey().getOneElement()).equals(appliedFunction)) {
                result.put((IEqNodeIdentifier)en.getKey().getOtherElement(), en.getValue());
            }
            if (!((IEqNodeIdentifier)en.getKey().getOtherElement()).equals(appliedFunction)) continue;
            result.put((IEqNodeIdentifier)en.getKey().getOneElement(), en.getValue());
        }
        return result;
    }

    public Map<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> getEdges() {
        return Collections.unmodifiableMap(this.mWeakEquivalenceEdges);
    }

    void putEdgeLabel(Doubleton<NODE> sourceAndTarget, WeakEquivalenceEdgeLabel<NODE> label) {
        assert (!this.isFrozen()) : "attempting to change a frozen weq graph";
        assert (this.mWeqCc == null || this.mWeqCc.isRepresentative((IEqNodeIdentifier)sourceAndTarget.getOneElement()));
        assert (this.mWeqCc == null || this.mWeqCc.isRepresentative((IEqNodeIdentifier)sourceAndTarget.getOtherElement()));
        assert (!this.mIsFrozen || label.assertDisjunctsAreFrozen());
        this.mWeakEquivalenceEdges.put(sourceAndTarget, label);
    }

    private void putEdgeLabelDuringRemove(Doubleton<NODE> sourceAndTarget, WeakEquivalenceEdgeLabel<NODE> label, NODE replacement) {
        this.mWeakEquivalenceEdges.put(sourceAndTarget, label);
    }

    private WeakEquivalenceEdgeLabel<NODE> getEdgeLabel(Doubleton<NODE> sourceAndTarget) {
        return this.mWeakEquivalenceEdges.get(sourceAndTarget);
    }

    private boolean reportWeakEquivalence(Doubleton<NODE> sourceAndTarget, WeakEquivalenceEdgeLabel<NODE> inputLabel, boolean omitSanityChecks) {
        assert (!inputLabel.isTautological()) : "catch this case before?";
        assert (!this.mIsFrozen);
        assert (this.mWeqCc.isRepresentative((IEqNodeIdentifier)sourceAndTarget.getOneElement()) && this.mWeqCc.isRepresentative((IEqNodeIdentifier)sourceAndTarget.getOtherElement()));
        assert (((IEqNodeIdentifier)sourceAndTarget.getOneElement()).getTerm().getSort().equals(((IEqNodeIdentifier)sourceAndTarget.getOtherElement()).getTerm().getSort()));
        assert (!this.mIsFrozen);
        assert (this.mWeqCc.isRepresentative((IEqNodeIdentifier)sourceAndTarget.getOneElement()) && this.mWeqCc.isRepresentative((IEqNodeIdentifier)sourceAndTarget.getOtherElement()));
        assert (!((IEqNodeIdentifier)sourceAndTarget.getOneElement()).equals(sourceAndTarget.getOtherElement()));
        assert (omitSanityChecks || this.sanityCheck());
        WeakEquivalenceEdgeLabel<NODE> oldLabel = this.getEdgeLabel(sourceAndTarget);
        WeakEquivalenceEdgeLabel<IEqNodeIdentifier> inputLabelCopy = this.mWeqCcManager.copy(inputLabel, this, true);
        if (inputLabelCopy.isInconsistent()) {
            this.putEdgeLabel(sourceAndTarget, inputLabelCopy);
            this.addSetConstraintToReport(new ConstraintFromWeqGraph(this, (IEqNodeIdentifier)sourceAndTarget.getOneElement(), (IEqNodeIdentifier)sourceAndTarget.getOtherElement()));
            return oldLabel == null || !oldLabel.isInconsistent();
        }
        if (oldLabel == null || oldLabel.isTautological()) {
            WeakEquivalenceEdgeLabel<IEqNodeIdentifier> newLabel;
            this.updateConstraintsToBePropagated(sourceAndTarget, inputLabelCopy);
            if (this.mWeqCcManager.getSettings().isMeetWithGpaOnReportWeq()) {
                inputLabelCopy.meetWithCcGpa();
                newLabel = inputLabelCopy.projectToElements(new HashSet<IEqNodeIdentifier>(this.mWeqCcManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)sourceAndTarget.getOneElement())), false);
            } else {
                newLabel = this.mWeqCc.getDiet() == Diet.THIN ? inputLabelCopy.projectToElements(new HashSet<IEqNodeIdentifier>(this.mWeqCcManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)sourceAndTarget.getOneElement())), false) : inputLabelCopy;
            }
            this.putEdgeLabel(sourceAndTarget, newLabel);
            assert (omitSanityChecks || this.sanityCheck());
            return true;
        }
        assert (oldLabel.getWeqGraph() == this);
        WeakEquivalenceEdgeLabel<NODE> oldLabelCopy = this.mWeqCcManager.copy(oldLabel, true);
        WeakEquivalenceEdgeLabel<IEqNodeIdentifier> labelToStrengthenWith = inputLabelCopy;
        assert (labelToStrengthenWith.sanityCheck()) : "input label not normalized??";
        if (this.mWeqCcManager.getSettings().isMeetWithGpaOnReportWeq()) {
            labelToStrengthenWith.meetWithCcGpa();
            oldLabelCopy.meetWithCcGpa();
        }
        if (this.mWeqCcManager.isStrongerThan(oldLabelCopy, labelToStrengthenWith)) {
            return false;
        }
        WeakEquivalenceEdgeLabel<IEqNodeIdentifier> strengthenedEdgeLabel = this.mWeqCcManager.meetEdgeLabels(oldLabelCopy, labelToStrengthenWith, false);
        if (this.mWeqCcManager.isStrongerThan(oldLabel, strengthenedEdgeLabel)) {
            return false;
        }
        this.updateConstraintsToBePropagated(sourceAndTarget, strengthenedEdgeLabel);
        if (this.mWeqCc.mDiet == Diet.THIN) {
            strengthenedEdgeLabel = strengthenedEdgeLabel.projectToElements(new HashSet<IEqNodeIdentifier>(this.mWeqCcManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)sourceAndTarget.getOneElement())), false);
        }
        if (this.mWeqCcManager.isStrongerThan(oldLabel, strengthenedEdgeLabel)) {
            return false;
        }
        assert (strengthenedEdgeLabel.sanityCheck());
        this.putEdgeLabel(sourceAndTarget, strengthenedEdgeLabel);
        assert (omitSanityChecks || this.sanityCheck());
        return true;
    }

    private void updateConstraintsToBePropagated(Doubleton<NODE> sourceAndTarget, WeakEquivalenceEdgeLabel<NODE> strengthenedEdgeLabel) {
        if (strengthenedEdgeLabel.isInconsistent()) {
            this.addSetConstraintToReport(new ConstraintFromWeqGraph(this, (IEqNodeIdentifier)sourceAndTarget.getOneElement(), (IEqNodeIdentifier)sourceAndTarget.getOtherElement()));
        }
        if (((IEqNodeIdentifier)sourceAndTarget.getOneElement()).getSort().isArraySort()) {
            return;
        }
        Collection<ConstraintFromWeqGraph> impliedSetConstraints = this.checkEdgeForImpliedSetConstraints(sourceAndTarget, strengthenedEdgeLabel);
        for (ConstraintFromWeqGraph isc : impliedSetConstraints) {
            this.addSetConstraintToReport(isc);
        }
    }

    public boolean reportWeakEquivalence(NODE array1, NODE array2, WeakEquivalenceEdgeLabel<NODE> edgeLabel, boolean omitSanityChecks) {
        assert (!this.mIsFrozen);
        assert (this.mWeqCc.isRepresentative(array1) && this.mWeqCc.isRepresentative(array2));
        if (edgeLabel.isTautological()) {
            return false;
        }
        boolean result = this.reportWeakEquivalence(new Doubleton(array1, array2), edgeLabel, omitSanityChecks);
        assert (omitSanityChecks || this.sanityCheck());
        return result;
    }

    public boolean isConstrained(NODE elem) {
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> edge : this.getWeqEdgesEntrySet()) {
            if (!edge.getValue().isConstrained(elem)) continue;
            return true;
        }
        return false;
    }

    public WeakEquivalenceEdgeLabel<NODE> getEdgeLabel(NODE array1, NODE array2) {
        NODE array2Rep;
        if (array1.getSort() != array2.getSort()) {
            throw new IllegalArgumentException("asking for a weak equivalence between of different sorts make no sense");
        }
        NODE array1Rep = this.mWeqCc.getRepresentativeElement(array1);
        WeakEquivalenceEdgeLabel<NODE> edge = this.getEdgeLabel(new Doubleton(array1Rep, array2Rep = this.mWeqCc.getRepresentativeElement(array2)));
        if (edge == null) {
            return new WeakEquivalenceEdgeLabel<NODE>(this, this.mEmptyDisjunct);
        }
        return edge;
    }

    public WeakEquivalenceEdgeLabel<NODE> projectEdgeLabelToPoint(WeakEquivalenceEdgeLabel<NODE> labelContents, NODE value, List<NODE> weqVarsForOriginalLabel) {
        assert (!this.mIsFrozen);
        assert (this.assertFrozenInsideOut());
        assert (labelContents.getWeqGraph() == this);
        IEqNodeIdentifier firstDimWeqVarNode = (IEqNodeIdentifier)weqVarsForOriginalLabel.get(0);
        List weqVarsForNewLabel = weqVarsForOriginalLabel.size() > 1 ? weqVarsForOriginalLabel.subList(0, weqVarsForOriginalLabel.size() - 2) : Collections.emptyList();
        CongruenceClosure<IEqNodeIdentifier> qEqualsICc = this.mWeqCcManager.getSingleEqualityCc(firstDimWeqVarNode, (IEqNodeIdentifier)value, true, (CongruenceClosure<IEqNodeIdentifier>)this.mEmptyDisjunct);
        WeakEquivalenceEdgeLabel<IEqNodeIdentifier> qEqualsI = this.mWeqCcManager.getSingletonEdgeLabel(this, qEqualsICc);
        WeakEquivalenceEdgeLabel<NODE> copy = this.mWeqCcManager.copy(labelContents, true);
        assert (!copy.isFrozen());
        if (this.mWeqCcManager.getSettings().isMeetWithGpaProjectOrShiftLabel()) {
            copy.meetWithCcGpa();
        }
        WeakEquivalenceEdgeLabel<IEqNodeIdentifier> meet = this.mWeqCcManager.meetEdgeLabels(copy, qEqualsI, true);
        meet.setExternalRemInfo(this.mWeqCc.getElementCurrentlyBeingRemoved());
        meet.projectWeqVarNode(firstDimWeqVarNode);
        meet.inOrDecreaseWeqVarIndices(-1, weqVarsForOriginalLabel);
        assert (!meet.getAppearingNodes().contains(weqVarsForOriginalLabel.get(weqVarsForOriginalLabel.size() - 1))) : "double check the condition if this assertion fails, but as we decreased all weq vars, the last one should not be present in the result, right?..";
        assert (!meet.getDisjuncts().stream().anyMatch(l -> l.isInconsistent())) : "label not well-formed";
        assert (meet.sanityCheckDontEnforceProjectToWeqVars(this.mWeqCc));
        WeakEquivalenceEdgeLabel<IEqNodeIdentifier> result = this.mWeqCc.mDiet == Diet.THIN ? meet.projectToElements(new HashSet(weqVarsForNewLabel), false) : meet;
        assert (this.mWeqCc.mDiet != Diet.THIN || result.assertHasOnlyWeqVarConstraints(new HashSet(weqVarsForNewLabel)));
        assert (result.sanityCheck());
        return result;
    }

    public WeakEquivalenceEdgeLabel<NODE> shiftLabelAndAddException(WeakEquivalenceEdgeLabel<NODE> labelContents, NODE argument, List<NODE> weqVarsForResolventEdge) {
        assert (!weqVarsForResolventEdge.isEmpty()) : "because the array in the resolvent must have a dimension >= 1";
        assert (labelContents.getWeqGraph() == this);
        WeakEquivalenceEdgeLabel<NODE> meet = this.mWeqCcManager.copy(labelContents, true);
        if (this.mWeqCcManager.getSettings().isMeetWithGpaProjectOrShiftLabel()) {
            meet.meetWithCcGpa();
        }
        meet.setExternalRemInfo(this.mWeqCc.getElementCurrentlyBeingRemoved());
        meet.projectWeqVarNode((IEqNodeIdentifier)weqVarsForResolventEdge.get(weqVarsForResolventEdge.size() - 1));
        WeakEquivalenceEdgeLabel<NODE> labelToShiftAndAdd = meet;
        if (this.mWeqCc.mDiet == Diet.THIN) {
            labelToShiftAndAdd = labelToShiftAndAdd.projectToElements(new HashSet<NODE>(weqVarsForResolventEdge), true);
        }
        labelToShiftAndAdd.inOrDecreaseWeqVarIndices(1, weqVarsForResolventEdge);
        IEqNodeIdentifier firstWeqVar = (IEqNodeIdentifier)weqVarsForResolventEdge.get(0);
        assert (labelToShiftAndAdd.isTautological() || labelToShiftAndAdd.isInconsistent() || !labelToShiftAndAdd.getAppearingNodes().contains(firstWeqVar));
        HashSet<CongruenceClosure<NODE>> shiftedLabelContents = new HashSet<CongruenceClosure<NODE>>(labelToShiftAndAdd.getDisjuncts());
        CongruenceClosure<IEqNodeIdentifier> firstWeqVarUnequalArgument = this.mWeqCcManager.getSingleDisequalityCc(firstWeqVar, (IEqNodeIdentifier)argument, true, (CongruenceClosure<IEqNodeIdentifier>)this.mEmptyDisjunct);
        shiftedLabelContents.add(firstWeqVarUnequalArgument);
        assert (shiftedLabelContents.stream().allMatch(l -> l.sanityCheckOnlyCc()));
        WeakEquivalenceEdgeLabel<NODE> normalized = this.mWeqCcManager.filterRedundantICcs(new WeakEquivalenceEdgeLabel<NODE>(this, shiftedLabelContents));
        assert (normalized.getDisjuncts().stream().allMatch(l -> l.sanityCheckOnlyCc()));
        return normalized;
    }

    public void collapseEdgeAtMerge(NODE node1OldRep, NODE node2OldRep) {
        this.mWeakEquivalenceEdges.remove(new Doubleton(node1OldRep, node2OldRep));
    }

    public void updateForNewRep(NODE node1OldRep, NODE node2OldRep, NODE newRep) {
        ConstraintFromWeqGraph current;
        ArrayDeque<ConstraintFromWeqGraph> copy;
        assert (this.mWeqCc.getRepresentativeElement(node1OldRep) == newRep);
        assert (this.mWeqCc.getRepresentativeElement(node2OldRep) == newRep);
        if (node1OldRep == newRep) {
            for (Map.Entry<NODE, WeakEquivalenceEdgeLabel<NODE>> edge : this.getAdjacentWeqEdges(node2OldRep).entrySet()) {
                this.mWeakEquivalenceEdges.remove(new Doubleton(node2OldRep, (Object)((IEqNodeIdentifier)edge.getKey())));
                this.putEdgeLabel(new Doubleton(newRep, (Object)((IEqNodeIdentifier)edge.getKey())), edge.getValue());
            }
        } else {
            for (Map.Entry<NODE, WeakEquivalenceEdgeLabel<NODE>> edge : this.getAdjacentWeqEdges(node1OldRep).entrySet()) {
                this.mWeakEquivalenceEdges.remove(new Doubleton(node1OldRep, (Object)((IEqNodeIdentifier)edge.getKey())));
                this.putEdgeLabel(new Doubleton(newRep, (Object)((IEqNodeIdentifier)edge.getKey())), edge.getValue());
            }
        }
        this.mConstraintsToReport.removeIf(ctr -> ctr.vanishesOnMergeOf(node1OldRep, node2OldRep));
        if (node1OldRep == newRep) {
            copy = new ArrayDeque<ConstraintFromWeqGraph>(this.mConstraintsToReport);
            this.mConstraintsToReport.clear();
            while (!copy.isEmpty()) {
                current = copy.poll();
                this.mConstraintsToReport.add(current.replaceNode(node2OldRep, newRep));
            }
        } else {
            assert (node2OldRep == newRep);
            copy = new ArrayDeque<ConstraintFromWeqGraph>(this.mConstraintsToReport);
            this.mConstraintsToReport.clear();
            while (!copy.isEmpty()) {
                current = copy.poll();
                this.mConstraintsToReport.add(current.replaceNode(node1OldRep, newRep));
            }
        }
    }

    public Integer getNumberOfEdgesStatistic() {
        return this.mWeakEquivalenceEdges.size();
    }

    public Integer getMaxSizeOfEdgeLabelStatistic() {
        Optional<Integer> opt = this.mWeakEquivalenceEdges.values().stream().map(weqlabel -> weqlabel.getDisjuncts().size()).reduce(Math::max);
        if (opt.isPresent()) {
            return opt.get();
        }
        return 0;
    }

    private Set<Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>>> getWeqEdgesEntrySet() {
        return this.mWeakEquivalenceEdges.entrySet();
    }

    public WeakEquivalenceGraph<NODE> ccFattenEdgeLabels() {
        assert (!this.mWeqCc.isInconsistent(false));
        assert (this.mWeqCc.getDiet() == Diet.TRANSITORY_THIN_TO_CCFAT || this.mWeqCc.getDiet() == Diet.TRANSITORY_CCREFATTEN);
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> en : this.getWeqEdgesEntrySet()) {
            en.getValue().meetWithCcGpa();
            this.updateConstraintsToBePropagated(en.getKey(), en.getValue());
        }
        return this;
    }

    private void addSetConstraintToReport(ConstraintFromWeqGraph c) {
        this.mConstraintsToReport.add(c);
    }

    public boolean assertElementIsFullyRemoved(NODE elem) {
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> edge : this.getWeqEdgesEntrySet()) {
            if (((IEqNodeIdentifier)edge.getKey().getOneElement()).equals(elem)) {
                assert (false);
                return false;
            }
            if (((IEqNodeIdentifier)edge.getKey().getOtherElement()).equals(elem)) {
                assert (false);
                return false;
            }
            if (edge.getValue().assertElementIsFullyRemoved(elem)) continue;
            assert (false);
            return false;
        }
        return true;
    }

    public ILogger getLogger() {
        return this.mWeqCc.getLogger();
    }

    public WeqCcManager<NODE> getWeqCcManager() {
        return this.mWeqCcManager;
    }

    public void freeze() {
        assert (!this.hasConstraintsToReport()) : "report array equalities before freezing";
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> edge : this.getWeqEdgesEntrySet()) {
            edge.getValue().freezeIfNecessary();
        }
        this.mIsFrozen = true;
    }

    public String toString() {
        if (this.isEmpty()) {
            return "Empty";
        }
        if (this.mWeakEquivalenceEdges.size() < this.mWeqCcManager.getSettings().getMaxNoWeqEdgesForVerboseToString()) {
            return this.toLogString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("summary:\n");
        for (Map.Entry<String, Integer> entry : this.summarize().entrySet()) {
            sb.append(String.format("%s : %d\n", entry.getKey(), entry.getValue()));
        }
        sb.append("graph shape:\n");
        for (Map.Entry<String, Object> entry : this.getWeqEdgesEntrySet()) {
            sb.append((Object)entry.getKey());
            sb.append("\n");
        }
        return sb.toString();
    }

    public String toLogString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> weq : this.getWeqEdgesEntrySet()) {
            sb.append(weq.getKey());
            sb.append("\n");
            sb.append(weq.getValue().toLogString());
            sb.append("\n");
        }
        return sb.toString();
    }

    Map<String, Integer> summarize() {
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        result.put("#Edges", this.mWeakEquivalenceEdges.size());
        int noEdgeLabelDisjuncts = this.mWeakEquivalenceEdges.values().stream().map(weqEdge -> weqEdge.getDisjuncts().size()).reduce((i1, i2) -> i1 + i2).get();
        result.put("#EdgeLabelDisjuncts", noEdgeLabelDisjuncts);
        result.put("Average#EdgeLabelDisjuncts", noEdgeLabelDisjuncts == 0 ? -1 : this.mWeakEquivalenceEdges.size() / noEdgeLabelDisjuncts);
        return result;
    }

    public boolean assertLabelsAreUnfrozen() {
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> edge : this.getWeqEdgesEntrySet()) {
            if (edge.getValue().isFrozen()) {
                assert (false);
                return false;
            }
            if (edge.getValue().assertDisjunctsAreUnfrozen()) continue;
            assert (false);
            return false;
        }
        return true;
    }

    boolean sanityCheck() {
        assert (this.mWeqCcManager != null);
        if (this.mWeqCc != null && this.mWeqCc.isInconsistent(false)) {
            return true;
        }
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> en : this.getWeqEdgesEntrySet()) {
            if (((IEqNodeIdentifier)en.getKey().getOneElement()).getSort().equals(((IEqNodeIdentifier)en.getKey().getOtherElement()).getSort())) continue;
            assert (false) : "weq graph has edge between arrays of different sorts";
            return false;
        }
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> en : this.getWeqEdgesEntrySet()) {
            if (en.getValue().getWeqGraph() == this) continue;
            assert (false) : "weq graph has edge label with incorrect getWeqGraph()";
            return false;
        }
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> en : this.getWeqEdgesEntrySet()) {
            assert (en.getValue().sanityCheck());
        }
        assert (this.assertFrozenInsideOut());
        assert (this.sanityAllNodesOnWeqLabelsAreKnownToGpa(null));
        return this.sanityCheckWithoutNodesComparison();
    }

    private boolean assertFrozenInsideOut() {
        if (this.mWeqCc != null && this.mWeqCc.isFrozen() && !this.mIsFrozen) {
            assert (false);
            return false;
        }
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> edge : this.getWeqEdgesEntrySet()) {
            if (!this.mIsFrozen || edge.getValue().assertDisjunctsAreFrozen()) continue;
            assert (false);
            return false;
        }
        return true;
    }

    boolean sanityCheckWithoutNodesComparison() {
        IEqNodeIdentifier target;
        IEqNodeIdentifier source;
        assert (this.mWeqCcManager != null) : "factory is needed for the sanity check..";
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
            source = (IEqNodeIdentifier)entry.getKey().getOneElement();
            if (source.hasSameTypeAs(target = (IEqNodeIdentifier)entry.getKey().getOtherElement())) continue;
            assert (false);
            return false;
        }
        if (this.mWeqCc != null) {
            for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
                source = (IEqNodeIdentifier)entry.getKey().getOneElement();
                target = (IEqNodeIdentifier)entry.getKey().getOtherElement();
                if (!this.mWeqCc.hasElement(source)) {
                    assert (false) : "weq edge source is not known to partial arrangement";
                    return false;
                }
                if (!this.mWeqCc.hasElement(target)) {
                    assert (false) : "weq edge target is not known to partial arrangement";
                    return false;
                }
                if (!this.mWeqCc.isRepresentative(source)) {
                    assert (false) : "weq edge source is not a representative";
                    return false;
                }
                if (this.mWeqCc.isRepresentative(target)) continue;
                assert (false) : "weq edge target is not a representative";
                return false;
            }
        }
        for (Doubleton doubleton : this.mWeakEquivalenceEdges.keySet()) {
            if (!((IEqNodeIdentifier)doubleton.getOneElement()).equals(doubleton.getOtherElement())) continue;
            assert (false) : "self loop in weq graph";
            return false;
        }
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
            source = (IEqNodeIdentifier)entry.getKey().getOneElement();
            target = (IEqNodeIdentifier)entry.getKey().getOtherElement();
            if (!entry.getValue().isInconsistent() || this.mConstraintsToReport.stream().anyMatch(ctr -> ctr.isIsArrayEquality() && ctr.isEqualityBetween(source, target))) continue;
            assert (false) : "lost track of an inconsistent weq edge";
            return false;
        }
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> entry : this.getWeqEdgesEntrySet()) {
            int edgedim = new MultiDimensionalSort(((IEqNodeIdentifier)entry.getKey().getOneElement()).getSort()).getDimension();
            if (entry.getValue().assertWeqVarSelectsHaveCorrectVarForDimension(edgedim)) continue;
            assert (false);
            return false;
        }
        return true;
    }

    protected boolean sanityAllNodesOnWeqLabelsAreKnownToGpa(Set<NODE> nodesScheduledForAdding) {
        if (this.mWeqCc != null) {
            for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> edge : this.getWeqEdgesEntrySet()) {
                WeakEquivalenceEdgeLabel<NODE> label = edge.getValue();
                Set nodesOnEdgeLabelWithoutWeqNodes = label.getAppearingNodes().stream().filter(node -> !CongruenceClosure.dependsOnAny((ICongruenceClosureElement)node, this.mWeqCcManager.getAllWeqNodes())).filter(node -> !CongruenceClosure.dependsOnAny((ICongruenceClosureElement)node, this.mWeqCcManager.getAllWeqPrimedNodes())).filter(node -> nodesScheduledForAdding == null || !nodesScheduledForAdding.contains(node)).collect(Collectors.toSet());
                if (this.mWeqCc.getAllElements().containsAll(nodesOnEdgeLabelWithoutWeqNodes)) continue;
                Set difference = DataStructureUtils.difference(nodesOnEdgeLabelWithoutWeqNodes, this.mWeqCc.getAllElements());
                assert (false) : "weq edge contains node(s) that has been removed: " + difference;
                return false;
            }
        }
        return true;
    }

    public void freezeIfNecessary() {
        if (!this.isFrozen()) {
            this.freeze();
        }
    }

    public Set<NODE> getAppearingNodes() {
        HashSet result = new HashSet();
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> en : this.getWeqEdgesEntrySet()) {
            result.add((IEqNodeIdentifier)en.getKey().getOneElement());
            result.add((IEqNodeIdentifier)en.getKey().getOtherElement());
            result.addAll(en.getValue().getAppearingNodes());
        }
        return result;
    }

    public WeqCongruenceClosure<NODE> getBaseWeqCc() {
        return this.mWeqCc;
    }

    public CongruenceClosure<NODE> getEmptyDisjunct() {
        return this.mEmptyDisjunct;
    }

    public Set<NODE> getAppearingNonWeqVarNodes() {
        HashSet<IEqNodeIdentifier> result = new HashSet<IEqNodeIdentifier>();
        for (IEqNodeIdentifier n : this.getAppearingNodes()) {
            if (CongruenceClosure.dependsOnAny((ICongruenceClosureElement)n, this.mWeqCcManager.getAllWeqNodes())) continue;
            result.add(n);
        }
        return result;
    }

    private Collection<ConstraintFromWeqGraph> checkEdgeForImpliedSetConstraints(Doubleton<NODE> sourceAndTarget, WeakEquivalenceEdgeLabel<NODE> edgeLabel) {
        if (!((IEqNodeIdentifier)sourceAndTarget.getOneElement()).isFunctionApplication() && !((IEqNodeIdentifier)sourceAndTarget.getOtherElement()).isFunctionApplication()) {
            return Collections.emptyList();
        }
        if (edgeLabel.isTautological()) {
            return Collections.emptyList();
        }
        ArrayList<ConstraintFromWeqGraph> result = new ArrayList<ConstraintFromWeqGraph>();
        IEqNodeIdentifier src = (IEqNodeIdentifier)sourceAndTarget.getOneElement();
        IEqNodeIdentifier trg = (IEqNodeIdentifier)sourceAndTarget.getOtherElement();
        SetConstraintManager scMan = this.mWeqCcManager.getCcManager().getSetConstraintManager();
        IEqNodeIdentifier oneNode = src;
        IEqNodeIdentifier otherNode = trg;
        this.collectImpliedSetconstraints(scMan, result, edgeLabel, oneNode, otherNode);
        this.collectImpliedSetconstraints(scMan, result, edgeLabel, otherNode, oneNode);
        return result;
    }

    private void collectImpliedSetconstraints(SetConstraintManager<NODE> scMan, Collection<ConstraintFromWeqGraph> result, WeakEquivalenceEdgeLabel<NODE> edgeLabel, NODE oneNode, NODE otherNode) {
        if (!oneNode.isFunctionApplication()) {
            return;
        }
        Set<SetConstraint<NODE>> containsConstraint = edgeLabel.getContainsConstraintForElement(oneNode);
        if (containsConstraint == null || containsConstraint.isEmpty()) {
            result.add(new ConstraintFromWeqGraph(this, oneNode, otherNode, true));
            return;
        }
        for (SetConstraint<NODE> sc : containsConstraint) {
            HashSet<NODE> newLiterals = new HashSet<NODE>(sc.getLiterals());
            HashSet<NODE> newNonLiterals = new HashSet<NODE>(sc.getNonLiterals());
            if (otherNode.isLiteral()) {
                newLiterals.add(otherNode);
            } else {
                newNonLiterals.add(otherNode);
            }
            SetConstraint newSc = scMan.buildSetConstraint(newLiterals, newNonLiterals);
            result.add(new ConstraintFromWeqGraph(this, oneNode, newSc, oneNode, otherNode));
        }
    }

    class CachingWeqEdgeLabelPoComparator {
        private final PartialOrderCache<CongruenceClosure<NODE>> mCcPoCache;

        public CachingWeqEdgeLabelPoComparator() {
            this.mCcPoCache = new PartialOrderCache(WeakEquivalenceGraph.this.mWeqCcManager.getCcComparator());
        }

        boolean isStrongerOrEqual(WeakEquivalenceEdgeLabel<NODE> label1, WeakEquivalenceEdgeLabel<NODE> label2) {
            return WeakEquivalenceGraph.this.mWeqCcManager.isStrongerThan(label1, label2, (arg_0, arg_1) -> this.mCcPoCache.isSmallerOrEqual(arg_0, arg_1));
        }

        WeakEquivalenceEdgeLabel<NODE> union(WeakEquivalenceEdgeLabel<NODE> label1, WeakEquivalenceEdgeLabel<NODE> label2) {
            WeakEquivalenceEdgeLabel result = label1.union(label2, this.mCcPoCache);
            assert (WeakEquivalenceGraph.this.mWeqCcManager.getSettings().omitSanitycheckFineGrained2() || DataStructureUtils.union(label1.getAppearingNodes(), label2.getAppearingNodes()).containsAll(result.getAppearingNodes())) : "union of two labels may not introduce any new nodes";
            return result;
        }
    }

    class ConstraintFromWeqGraph {
        private final boolean mIsArrayEquality;
        private final boolean mIsSetConstraint;
        private final boolean mIsDummyConstraint;
        private final Pair<NODE, SetConstraint<NODE>> mSetConstraint;
        private final Pair<NODE, NODE> mEquality;
        private final Doubleton<NODE> mRelatedEdge;
        final /* synthetic */ WeakEquivalenceGraph this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public ConstraintFromWeqGraph(NODE source, NODE target, boolean isDummy) {
            this.this$0 = (WeakEquivalenceGraph)n;
            assert (isDummy);
            this.mIsArrayEquality = false;
            this.mIsSetConstraint = false;
            this.mIsDummyConstraint = true;
            this.mSetConstraint = null;
            this.mEquality = null;
            this.mRelatedEdge = new Doubleton(source, target);
        }

        ConstraintFromWeqGraph(NODE n, SetConstraint<NODE> sc, NODE source, NODE target) {
            this.this$0 = var1_1;
            this.mIsArrayEquality = false;
            this.mIsSetConstraint = true;
            this.mIsDummyConstraint = false;
            this.mSetConstraint = new Pair(n, sc);
            this.mEquality = null;
            this.mRelatedEdge = new Doubleton(source, target);
        }

        ConstraintFromWeqGraph(NODE one, NODE other) {
            this.this$0 = var1_1;
            this.mIsArrayEquality = true;
            this.mIsSetConstraint = false;
            this.mIsDummyConstraint = false;
            this.mSetConstraint = null;
            this.mEquality = new Pair(one, other);
            this.mRelatedEdge = new Doubleton(one, other);
        }

        public ConstraintFromWeqGraph replaceNode(NODE replacee, NODE replacer) {
            if (this.isIsArrayEquality()) {
                IEqNodeIdentifier n1 = (IEqNodeIdentifier)this.mEquality.getFirst();
                IEqNodeIdentifier n2 = (IEqNodeIdentifier)this.mEquality.getSecond();
                return new ConstraintFromWeqGraph(this.this$0, n1.equals(replacee) ? replacer : n1, n2.equals(replacee) ? replacer : n2);
            }
            if (this.isSetConstraint()) {
                IEqNodeIdentifier n = (IEqNodeIdentifier)this.mSetConstraint.getFirst();
                SetConstraint sc = (SetConstraint)this.mSetConstraint.getSecond();
                SetConstraintManager scMan = this.this$0.mWeqCcManager.getCcManager().getSetConstraintManager();
                IEqNodeIdentifier src = (IEqNodeIdentifier)this.mRelatedEdge.getOneElement();
                IEqNodeIdentifier trg = (IEqNodeIdentifier)this.mRelatedEdge.getOtherElement();
                return new ConstraintFromWeqGraph(this.this$0, n.equals(replacee) ? replacer : n, scMan.transformElements(sc, el -> el.equals(replacee) ? replacer : el), src.equals(replacee) ? replacer : src, trg.equals(replacee) ? replacer : trg);
            }
            if (this.isDummyConstraint()) {
                IEqNodeIdentifier src = (IEqNodeIdentifier)this.mRelatedEdge.getOneElement();
                IEqNodeIdentifier trg = (IEqNodeIdentifier)this.mRelatedEdge.getOtherElement();
                return new ConstraintFromWeqGraph(this.this$0, src.equals(replacee) ? replacer : src, trg.equals(replacee) ? replacer : trg, true);
            }
            throw new AssertionError();
        }

        public Doubleton<NODE> getRelatedWeqEdge() {
            return this.mRelatedEdge;
        }

        public boolean isIsArrayEquality() {
            return this.mIsArrayEquality;
        }

        public boolean isSetConstraint() {
            return this.mIsSetConstraint;
        }

        public boolean isDummyConstraint() {
            return this.mIsDummyConstraint;
        }

        public Pair<NODE, SetConstraint<NODE>> getSetConstraint() {
            return this.mSetConstraint;
        }

        public Pair<NODE, NODE> getEquality() {
            return this.mEquality;
        }

        public boolean isEqualityBetween(NODE n1, NODE n2) {
            if (!this.isIsArrayEquality()) {
                return false;
            }
            if (((IEqNodeIdentifier)this.mEquality.getFirst()).equals(n1) && ((IEqNodeIdentifier)this.mEquality.getSecond()).equals(n2)) {
                return true;
            }
            return ((IEqNodeIdentifier)this.mEquality.getSecond()).equals(n1) && ((IEqNodeIdentifier)this.mEquality.getFirst()).equals(n2);
        }

        public boolean vanishesOnMergeOf(NODE n1, NODE n2) {
            if (((IEqNodeIdentifier)this.mRelatedEdge.getOneElement()).equals(n1) && ((IEqNodeIdentifier)this.mRelatedEdge.getOtherElement()).equals(n2) || ((IEqNodeIdentifier)this.mRelatedEdge.getOneElement()).equals(n2) && ((IEqNodeIdentifier)this.mRelatedEdge.getOtherElement()).equals(n1)) {
                return true;
            }
            if (this.isSetConstraint()) {
                if (((IEqNodeIdentifier)this.mSetConstraint.getFirst()).equals(n1) && ((SetConstraint)this.mSetConstraint.getSecond()).containsElement(n2)) {
                    return true;
                }
                if (((IEqNodeIdentifier)this.mSetConstraint.getFirst()).equals(n2) && ((SetConstraint)this.mSetConstraint.getSecond()).containsElement(n1)) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            if (this.mIsArrayEquality) {
                sb.append("equality: ");
                sb.append(this.mEquality);
            } else if (this.mIsSetConstraint) {
                sb.append("set constraint: ");
                sb.append(this.mSetConstraint.getFirst());
                sb.append(" in ");
                sb.append(this.mSetConstraint.getSecond());
            } else if (this.mIsDummyConstraint) {
                sb.append("DummyConstraint");
            } else {
                throw new AssertionError();
            }
            return sb.toString();
        }
    }
}

