/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.AbstractNodeAndFunctionFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.CongruenceClosureSmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.RemoveWeqCcElement;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeakEquivalenceEdgeLabel;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeakEquivalenceGraph;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCongruenceClosure;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqSettings;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSort;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BidirectionalMap;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CcManager;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IRemovalInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraint;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.PartialOrderCache;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import de.uni_freiburg.informatik.ultimate.util.statistics.BenchmarkWithCounters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;

public class WeqCcManager<NODE extends IEqNodeIdentifier<NODE>> {
    private final IPartialComparator<WeqCongruenceClosure<NODE>> mWeqCcComparator;
    private final CcManager<NODE> mCcManager;
    private final ManagedScript mMgdScript;
    private final ILogger mLogger;
    private final WeqCongruenceClosure<NODE> mTautologicalWeqCc;
    private final WeqCongruenceClosure<NODE> mInconsistentWeqCc;
    private final NestedMap2<Sort, Integer, NODE> mDimensionToWeqVariableNode;
    private final BidirectionalMap<Term, Term> mWeqVarsToWeqPrimedVars;
    private final AbstractNodeAndFunctionFactory<NODE, Term> mNodeAndFunctionFactory;
    private final WeqSettings mSettings;
    private final boolean mBenchmarkMode = false;
    private BenchmarkWithCounters mBenchmark;
    final boolean mDebug;
    final boolean mSkipSolverChecks = true;
    private final Set<NODE> mNonTheoryLiteralNodes;

    public WeqCcManager(ILogger logger, IPartialComparator<WeqCongruenceClosure<NODE>> weqCcComparator, IPartialComparator<CongruenceClosure<NODE>> ccComparator, ManagedScript mgdScript, AbstractNodeAndFunctionFactory<NODE, Term> nodeAndFunctionFactory, WeqSettings settings, boolean debugMode, Set<NODE> nonTheoryLiteralNodes) {
        this.mCcManager = new CcManager(logger, ccComparator);
        this.mMgdScript = mgdScript;
        this.mLogger = logger;
        this.mDebug = debugMode;
        this.mSettings = settings;
        this.mWeqCcComparator = weqCcComparator;
        this.mDimensionToWeqVariableNode = new NestedMap2();
        this.mWeqVarsToWeqPrimedVars = new BidirectionalMap();
        this.mNodeAndFunctionFactory = nodeAndFunctionFactory;
        this.mNonTheoryLiteralNodes = nonTheoryLiteralNodes;
        this.mBenchmark = null;
        this.mTautologicalWeqCc = new WeqCongruenceClosure(this);
        nonTheoryLiteralNodes.forEach(this.mTautologicalWeqCc::addElementRec);
        this.mTautologicalWeqCc.freezeAndClose();
        this.mInconsistentWeqCc = new WeqCongruenceClosure(true);
    }

    public WeqCongruenceClosure<NODE> getEmptyWeqCc(boolean modifiable) {
        if (modifiable) {
            WeqCongruenceClosure result = new WeqCongruenceClosure(this);
            this.mNonTheoryLiteralNodes.forEach(n -> {
                boolean bl = result.addElement(n, false);
            });
            return result;
        }
        return this.mTautologicalWeqCc;
    }

    public WeqCongruenceClosure<NODE> getInconsistentWeqCc(boolean modifiable) {
        if (modifiable) {
            return new WeqCongruenceClosure(true);
        }
        return this.mInconsistentWeqCc;
    }

    public WeqCongruenceClosure<NODE> addNode(NODE node, WeqCongruenceClosure<NODE> origWeqCc, boolean inplace, boolean omitSanityChecks) {
        WeqCongruenceClosure<NODE> result;
        if (origWeqCc.hasElement(node)) {
            return origWeqCc;
        }
        if (inplace) {
            origWeqCc.addElement(node, omitSanityChecks);
            result = origWeqCc;
        } else {
            WeqCongruenceClosure<NODE> unfrozen = this.unfreeze(origWeqCc);
            unfrozen.addElement(node, omitSanityChecks);
            unfrozen.freezeAndClose();
            result = unfrozen;
        }
        assert (omitSanityChecks || origWeqCc.sanityCheck());
        return result;
    }

    public CongruenceClosure<NODE> addNode(NODE node, CongruenceClosure<NODE> congruenceClosure, WeqCongruenceClosure<NODE> newEqualityTarget, boolean inplace, boolean omitSanityChecks) {
        return this.mCcManager.addElement(congruenceClosure, node, newEqualityTarget, inplace, omitSanityChecks);
    }

    WeqCongruenceClosure<NODE> unfreeze(WeqCongruenceClosure<NODE> origWeqCc) {
        this.bmStart(WeqCcBmNames.UNFREEZE);
        assert (origWeqCc.isFrozen());
        WeqCongruenceClosure<NODE> result = this.copyWeqCc(origWeqCc, true);
        assert (!result.isFrozen());
        assert (result.sanityCheck());
        this.bmEnd(WeqCcBmNames.UNFREEZE);
        return result;
    }

    void bmStart(WeqCcBmNames watch) {
    }

    void bmEnd(WeqCcBmNames watch) {
    }

    public WeakEquivalenceEdgeLabel<NODE> filterRedundantICcs(WeakEquivalenceEdgeLabel<NODE> label) {
        WeakEquivalenceEdgeLabel<NODE> result = new WeakEquivalenceEdgeLabel<NODE>(label.getWeqGraph(), this.filterRedundantCcs(label.getDisjuncts()));
        return result;
    }

    public WeakEquivalenceEdgeLabel<NODE> filterRedundantCcs(WeakEquivalenceEdgeLabel<NODE> label) {
        Set filtered = this.mCcManager.filterRedundantCcs(label.getDisjuncts());
        return new WeakEquivalenceEdgeLabel<NODE>(label.getWeqGraph(), filtered);
    }

    private Set<WeqCongruenceClosure<NODE>> filterRedundantWeqCcs(Set<WeqCongruenceClosure<NODE>> ccs) {
        this.bmStart(WeqCcBmNames.FILTERREDUNDANT);
        PartialOrderCache poc = new PartialOrderCache(this.mWeqCcComparator);
        Set result = poc.getMaximalRepresentatives(ccs);
        this.bmEnd(WeqCcBmNames.FILTERREDUNDANT);
        return result;
    }

    public Set<CongruenceClosure<NODE>> filterRedundantCcs(Set<CongruenceClosure<NODE>> ccs) {
        return this.mCcManager.filterRedundantCcs(ccs);
    }

    public Set<CongruenceClosure<NODE>> filterRedundantCcs(Set<CongruenceClosure<NODE>> ccs, PartialOrderCache<CongruenceClosure<NODE>> ccPoCache) {
        return this.mCcManager.filterRedundantCcs(ccs, ccPoCache);
    }

    public IPartialComparator<CongruenceClosure<NODE>> getCcComparator() {
        return this.mCcManager.getCcComparator();
    }

    public WeqCongruenceClosure<NODE> reportEquality(WeqCongruenceClosure<NODE> origWeqCc, NODE node1, NODE node2, boolean inplace) {
        this.bmStart(WeqCcBmNames.REPORTEQUALITY);
        if (inplace) {
            origWeqCc.reportEquality(node1, node2, false);
            this.bmEnd(WeqCcBmNames.REPORTEQUALITY);
            return origWeqCc;
        }
        WeqCongruenceClosure<NODE> unfrozen = this.unfreeze(origWeqCc);
        unfrozen.reportEquality(node1, node2, false);
        unfrozen.freezeAndClose();
        assert (this.checkReportEqualityResult(origWeqCc, node1, node2, unfrozen, this.getNonTheoryLiteralDisequalitiesIfNecessary()));
        this.bmEnd(WeqCcBmNames.REPORTEQUALITY);
        return unfrozen;
    }

    private CongruenceClosure<NODE> reportEquality(CongruenceClosure<NODE> origCc, NODE node1, NODE node2, boolean inplace) {
        CongruenceClosure result = this.mCcManager.reportEquality(node1, node2, origCc, inplace);
        assert (this.checkReportEqualityResult(origCc, node1, node2, result, this.getNonTheoryLiteralDisequalitiesIfNecessary()));
        return result;
    }

    public WeqCongruenceClosure<NODE> reportDisequality(WeqCongruenceClosure<NODE> origWeqCc, NODE node1, NODE node2, boolean inplace) {
        this.bmStart(WeqCcBmNames.REPORTDISEQUALITY);
        if (inplace) {
            origWeqCc.reportDisequality(node1, node2);
            this.bmEnd(WeqCcBmNames.REPORTDISEQUALITY);
            return origWeqCc;
        }
        WeqCongruenceClosure<NODE> unfrozen = this.unfreeze(origWeqCc);
        unfrozen.reportDisequality(node1, node2);
        unfrozen.freezeAndClose();
        assert (this.checkReportDisequalityResult(origWeqCc, node1, node2, unfrozen, this.getNonTheoryLiteralDisequalitiesIfNecessary()));
        this.bmEnd(WeqCcBmNames.REPORTDISEQUALITY);
        return unfrozen;
    }

    public WeqCongruenceClosure<NODE> reportWeakEquivalence(WeqCongruenceClosure<NODE> origWeqCc, NODE array1, NODE array2, NODE storeIndex, boolean inplace) {
        if (this.mSettings.isDeactivateWeakEquivalences() || array1.dependsOnUntrackedArray() || array2.dependsOnUntrackedArray()) {
            assert (origWeqCc.getWeakEquivalenceGraph().getNumberOfEdgesStatistic() == 0);
            return origWeqCc;
        }
        this.bmStart(WeqCcBmNames.REPORTWEQ);
        if (inplace) {
            origWeqCc.reportWeakEquivalence(array1, array2, storeIndex, false);
            this.bmEnd(WeqCcBmNames.REPORTWEQ);
            return origWeqCc;
        }
        WeqCongruenceClosure<NODE> unfrozen = this.unfreeze(origWeqCc);
        unfrozen.reportWeakEquivalence(array1, array2, storeIndex, false);
        unfrozen.freezeAndClose();
        assert (this.checkReportWeakEquivalenceResult(origWeqCc, array1, array2, storeIndex, unfrozen));
        this.bmEnd(WeqCcBmNames.REPORTWEQ);
        return unfrozen;
    }

    public WeqCongruenceClosure<NODE> reportContainsConstraint(NODE elem, Set<NODE> literalSet, WeqCongruenceClosure<NODE> origWeqCc, boolean inplace) {
        this.bmStart(WeqCcBmNames.REPORTCONTAINS);
        if (inplace) {
            origWeqCc.reportContainsConstraint(elem, literalSet);
            this.bmEnd(WeqCcBmNames.REPORTCONTAINS);
            return origWeqCc;
        }
        WeqCongruenceClosure<NODE> unfrozen = this.unfreeze(origWeqCc);
        unfrozen.reportContainsConstraint(elem, literalSet);
        unfrozen.freezeAndClose();
        this.bmEnd(WeqCcBmNames.REPORTCONTAINS);
        return unfrozen;
    }

    public WeqCongruenceClosure<NODE> reportContainsConstraint(NODE elem, Collection<SetConstraint<NODE>> containsConstraint, WeqCongruenceClosure<NODE> origWeqCc, boolean inplace) {
        this.bmStart(WeqCcBmNames.REPORTCONTAINS);
        if (inplace) {
            origWeqCc.reportContainsConstraint(elem, containsConstraint);
            this.bmEnd(WeqCcBmNames.REPORTCONTAINS);
            return origWeqCc;
        }
        WeqCongruenceClosure<NODE> unfrozen = this.unfreeze(origWeqCc);
        unfrozen.reportContainsConstraint(elem, containsConstraint);
        unfrozen.freezeAndClose();
        this.bmEnd(WeqCcBmNames.REPORTCONTAINS);
        return unfrozen;
    }

    public WeqCongruenceClosure<NODE> projectAway(WeqCongruenceClosure<NODE> origWeqCc, NODE node) {
        this.bmStart(WeqCcBmNames.PROJECTAWAY);
        WeqCongruenceClosure<NODE> closed = this.closeIfNecessary(origWeqCc);
        WeqCongruenceClosure<NODE> unfrozen = this.unfreezeIfNecessary(closed);
        assert (unfrozen.isClosed());
        RemoveWeqCcElement.removeSimpleElement(unfrozen, node);
        unfrozen.freezeAndClose();
        assert (this.checkProjectAwayResult(origWeqCc, node, unfrozen, this.getNonTheoryLiteralDisequalitiesIfNecessary()));
        this.bmEnd(WeqCcBmNames.PROJECTAWAY);
        return unfrozen;
    }

    public WeqCongruenceClosure<NODE> closeIfNecessary(WeqCongruenceClosure<NODE> origWeqCc) {
        if (origWeqCc.isClosed()) {
            return origWeqCc;
        }
        if (origWeqCc.isFrozen()) {
            WeqCongruenceClosure<NODE> unfrozen = this.unfreeze(origWeqCc);
            unfrozen.extAndTriangleClosure(false);
            return unfrozen;
        }
        origWeqCc.extAndTriangleClosure(false);
        return origWeqCc;
    }

    public WeqCongruenceClosure<NODE> meet(WeqCongruenceClosure<NODE> weqcc1, WeqCongruenceClosure<NODE> weqcc2, boolean inplace) {
        this.bmStart(WeqCcBmNames.MEET);
        if (inplace) {
            WeqCongruenceClosure<NODE> weqcc1_old = null;
            if (this.mDebug) {
                weqcc1_old = this.copyWeqCc(weqcc1, false);
            }
            weqcc1.meet(weqcc2);
            if (this.mDebug) assert (this.checkMeetResult(weqcc1_old, weqcc2, weqcc1, this.getNonTheoryLiteralDisequalitiesIfNecessary()));
            this.bmEnd(WeqCcBmNames.MEET);
            return weqcc1;
        }
        WeqCongruenceClosure<NODE> unfrozen = this.unfreeze(weqcc1);
        WeqCongruenceClosure<NODE> meetResult = unfrozen.meet(weqcc2);
        WeqCongruenceClosure<NODE> result = this.mSettings.closeAllEqConstraints() || this.mSettings.closeAfterInplaceMeet() ? this.closeIfNecessary(meetResult) : meetResult;
        result.freezeIfNecessary();
        assert (this.checkMeetResult(weqcc1, weqcc2, result, this.getNonTheoryLiteralDisequalitiesIfNecessary()));
        this.bmEnd(WeqCcBmNames.MEET);
        return result;
    }

    public CongruenceClosure<NODE> meet(CongruenceClosure<NODE> cc1, CongruenceClosure<NODE> cc2, boolean inplace) {
        return this.meet(cc1, cc2, null, inplace);
    }

    public CongruenceClosure<NODE> meet(CongruenceClosure<NODE> cc1, CongruenceClosure<NODE> cc2, IRemovalInfo<NODE> elementCurrentlyBeingRemoved, boolean inplace) {
        CongruenceClosure<NODE> cc1_old = null;
        if (this.mDebug && inplace) {
            cc1_old = this.mCcManager.copyNoRemInfo(cc1);
        } else if (this.mDebug && !inplace) {
            cc1_old = cc1;
        }
        CongruenceClosure result = this.mCcManager.meet(cc1, cc2, elementCurrentlyBeingRemoved, inplace);
        if (this.mDebug) assert (this.checkMeetResult(cc1_old, cc2, result, this.getNonTheoryLiteralDisequalitiesIfNecessary()));
        return result;
    }

    public CongruenceClosure<NODE> join(CongruenceClosure<NODE> cc1, CongruenceClosure<NODE> cc2, boolean modifiable) {
        CongruenceClosure result = this.mCcManager.join(cc1, cc2, modifiable);
        assert (this.checkJoinResult(cc1, cc2, result, this.getNonTheoryLiteralDisequalitiesIfNecessary()));
        return result;
    }

    public WeqCongruenceClosure<NODE> join(WeqCongruenceClosure<NODE> weqcc1Raw, WeqCongruenceClosure<NODE> weqcc2Raw, boolean modifiable) {
        this.bmStart(WeqCcBmNames.JOIN);
        WeqCongruenceClosure<NODE> weqcc1 = this.closeIfNecessary(weqcc1Raw);
        weqcc1.freezeIfNecessary();
        WeqCongruenceClosure<NODE> weqcc2 = this.closeIfNecessary(weqcc2Raw);
        weqcc2.freezeIfNecessary();
        if (weqcc1.isInconsistent(false)) {
            this.bmEnd(WeqCcBmNames.JOIN);
            return weqcc2;
        }
        if (weqcc2.isInconsistent(false)) {
            this.bmEnd(WeqCcBmNames.JOIN);
            return weqcc1;
        }
        if (weqcc1.isTautological() || weqcc2.isTautological()) {
            this.bmEnd(WeqCcBmNames.JOIN);
            return this.getEmptyWeqCc(modifiable);
        }
        WeqCongruenceClosure<NODE> result = weqcc1.join(weqcc2);
        assert (result != weqcc1 && result != weqcc2) : "join should construct a new object";
        if (!modifiable) {
            result.freezeAndClose();
        }
        assert (this.checkJoinResult(weqcc1, weqcc2, result, this.getNonTheoryLiteralDisequalitiesIfNecessary()));
        this.bmEnd(WeqCcBmNames.JOIN);
        return result;
    }

    public CongruenceClosure<NODE> renameVariablesCc(CongruenceClosure<NODE> weqCc, Map<Term, Term> substitutionMapping, boolean inplace) {
        return this.mCcManager.transformElements(weqCc, e -> e.renameVariables(substitutionMapping), inplace);
    }

    public WeqCongruenceClosure<NODE> renameVariables(WeqCongruenceClosure<NODE> weqCc, Map<Term, Term> substitutionMapping, boolean inplace) {
        this.bmStart(WeqCcBmNames.RENAMEVARS);
        assert (DataStructureUtils.intersection(new HashSet<Term>(substitutionMapping.values()), new HashSet(weqCc.getCongruenceClosure().getAllElements())).isEmpty());
        if (inplace) {
            assert (!weqCc.isFrozen());
            weqCc.transformElementsAndFunctions(e -> e.renameVariables(substitutionMapping));
            this.bmEnd(WeqCcBmNames.RENAMEVARS);
            return weqCc;
        }
        WeqCongruenceClosure<IEqNodeIdentifier> unfrozen = this.unfreeze(weqCc);
        unfrozen.transformElementsAndFunctions(e -> e.renameVariables(substitutionMapping));
        unfrozen.freezeOmitPropagations();
        this.bmEnd(WeqCcBmNames.RENAMEVARS);
        return unfrozen;
    }

    public boolean isStrongerThan(WeqCongruenceClosure<NODE> weqcc1, WeqCongruenceClosure<NODE> weqcc2) {
        this.bmStart(WeqCcBmNames.ISSTRONGERTHAN);
        if (!weqcc1.isFrozen() && !weqcc2.isFrozen()) {
            this.alignElements(weqcc1, weqcc2, true);
            this.closeIfNecessary(weqcc1);
            this.closeIfNecessary(weqcc2);
            boolean result = weqcc1.isStrongerThan(weqcc2);
            this.bmEnd(WeqCcBmNames.ISSTRONGERTHAN);
            return result;
        }
        WeqCongruenceClosure<NODE> weqcc1Copy = this.copyWeqCc(weqcc1, true);
        WeqCongruenceClosure<NODE> weqcc2Copy = this.copyWeqCc(weqcc2, true);
        this.alignElements(weqcc1Copy, weqcc2Copy, true);
        WeqCongruenceClosure<NODE> weqcc1CopyClosed = this.closeIfNecessary(weqcc1Copy);
        WeqCongruenceClosure<NODE> weqcc2CopyClosed = this.closeIfNecessary(weqcc2Copy);
        int counter = 0;
        while (!weqcc1Copy.getAllElements().equals(weqcc2Copy.getAllElements())) {
            if (++counter > 2) {
                throw new AssertionError((Object)"not expecting to do many iterations here --> check");
            }
            this.alignElements(weqcc1Copy, weqcc2Copy, true);
            weqcc1CopyClosed = this.closeIfNecessary(weqcc1Copy);
            weqcc2CopyClosed = this.closeIfNecessary(weqcc2Copy);
        }
        weqcc1CopyClosed.freezeIfNecessary();
        weqcc2CopyClosed.freezeIfNecessary();
        boolean result = weqcc1Copy.isStrongerThan(weqcc2Copy);
        this.bmEnd(WeqCcBmNames.ISSTRONGERTHAN);
        return result;
    }

    public Pair<WeqCongruenceClosure<NODE>, WeqCongruenceClosure<NODE>> alignElements(WeqCongruenceClosure<NODE> cc1, WeqCongruenceClosure<NODE> cc2, boolean inplace) {
        assert (!inplace || !cc1.isFrozen());
        assert (!inplace || !cc2.isFrozen());
        if (inplace) {
            this.bmStart(WeqCcBmNames.ALIGN_ELEMENTS);
            while (!cc1.getAllElements().containsAll(cc2.getAllElements()) || !cc2.getAllElements().containsAll(cc1.getAllElements())) {
                this.addAllElements(cc1, cc2.getAllElements(), null, true);
                this.addAllElements(cc2, cc1.getAllElements(), null, true);
            }
            this.bmEnd(WeqCcBmNames.ALIGN_ELEMENTS);
            return new Pair(cc1, cc2);
        }
        this.bmStart(WeqCcBmNames.ALIGN_ELEMENTS);
        WeqCongruenceClosure<NODE> cc1Aligned = this.copyWeqCc(cc1, true);
        WeqCongruenceClosure<NODE> cc2Aligned = this.copyWeqCc(cc2, true);
        while (!cc1Aligned.getAllElements().containsAll(cc2Aligned.getAllElements()) || !cc2Aligned.getAllElements().containsAll(cc1Aligned.getAllElements())) {
            this.addAllElements(cc1Aligned, cc2Aligned.getAllElements(), null, true);
            this.addAllElements(cc2Aligned, cc1Aligned.getAllElements(), null, true);
        }
        cc1.freezeIfNecessary();
        cc2.freezeIfNecessary();
        this.bmEnd(WeqCcBmNames.ALIGN_ELEMENTS);
        return new Pair(cc1Aligned, cc2Aligned);
    }

    public CongruenceClosure<NODE> getEmptyCc(boolean modifiable) {
        return this.mCcManager.getEmptyCc(modifiable);
    }

    public WeakEquivalenceEdgeLabel<NODE> getSingletonEdgeLabel(WeakEquivalenceGraph<NODE> weakEquivalenceGraph, CongruenceClosure<NODE> disjunct) {
        return new WeakEquivalenceEdgeLabel<NODE>(weakEquivalenceGraph, Collections.singleton(disjunct));
    }

    public List<NODE> getAllWeqVarsNodeForFunction(NODE func) {
        if (!func.getSort().isArraySort()) {
            return Collections.emptyList();
        }
        MultiDimensionalSort mdSort = new MultiDimensionalSort(func.getSort());
        ArrayList indexSorts = mdSort.getIndexSorts();
        ArrayList<NODE> result = new ArrayList<NODE>(mdSort.getDimension());
        int i = 0;
        while (i < mdSort.getDimension()) {
            result.add(this.getWeqVariableNodeForDimension(i, (Sort)indexSorts.get(i)));
            ++i;
        }
        return result;
    }

    public Map<Term, Term> getWeqPrimedVarsToWeqVars() {
        return this.mWeqVarsToWeqPrimedVars.inverse();
    }

    public Map<Term, Term> getWeqVarsToWeqPrimedVars() {
        return this.mWeqVarsToWeqPrimedVars;
    }

    public Set<NODE> getAllWeqPrimedAndUnprimedNodes() {
        return DataStructureUtils.union(this.getAllWeqNodes(), this.getAllWeqPrimedNodes());
    }

    public Set<NODE> getAllWeqPrimedNodes() {
        HashSet<NODE> result = new HashSet<NODE>();
        for (Triple en : this.mDimensionToWeqVariableNode.entrySet()) {
            result.add(this.mNodeAndFunctionFactory.getExistingNode((Term)this.mWeqVarsToWeqPrimedVars.get((Object)((IEqNodeIdentifier)en.getThird()).getTerm())));
        }
        return result;
    }

    public NODE getWeqVariableNodeForDimension(int dimensionNumber, Sort sort) {
        IEqNodeIdentifier result = (IEqNodeIdentifier)this.mDimensionToWeqVariableNode.get((Object)sort, (Object)dimensionNumber);
        if (result == null) {
            TermVariable weqVar = this.mMgdScript.constructFreshTermVariable("weq" + dimensionNumber, sort);
            TermVariable weqPrimedVar = this.mMgdScript.constructFreshTermVariable("weqPrime" + dimensionNumber, sort);
            this.mWeqVarsToWeqPrimedVars.put((Object)weqVar, (Object)weqPrimedVar);
            result = this.getEqNodeAndFunctionFactory().getOrConstructNode((Term)weqVar);
            this.mDimensionToWeqVariableNode.put((Object)sort, (Object)dimensionNumber, (Object)result);
        }
        return (NODE)result;
    }

    public TermVariable getWeqVariableForDimension(int dimensionNumber, Sort sort) {
        return (TermVariable)this.getWeqVariableNodeForDimension(dimensionNumber, sort).getTerm();
    }

    public Set<TermVariable> getAllWeqVariables() {
        HashSet<TermVariable> result = new HashSet<TermVariable>();
        this.mDimensionToWeqVariableNode.entrySet().forEach(en -> {
            boolean bl = result.add((TermVariable)((IEqNodeIdentifier)en.getThird()).getTerm());
        });
        return result;
    }

    public Set<NODE> getAllWeqNodes() {
        HashSet<IEqNodeIdentifier> result = new HashSet<IEqNodeIdentifier>();
        for (Triple en : this.mDimensionToWeqVariableNode.entrySet()) {
            result.add((IEqNodeIdentifier)en.getThird());
        }
        return result;
    }

    public ILogger getLogger() {
        return this.mLogger;
    }

    public AbstractNodeAndFunctionFactory<NODE, Term> getEqNodeAndFunctionFactory() {
        return this.mNodeAndFunctionFactory;
    }

    private boolean checkReportWeakEquivalenceResult(WeqCongruenceClosure<NODE> origWeqCc, NODE array1, NODE array2, NODE storeIndex, WeqCongruenceClosure<NODE> unfrozen) {
        return true;
    }

    private boolean checkReportEqualityResult(CongruenceClosure<NODE> origCc, NODE node1, NODE node2, CongruenceClosure<NODE> result, Term literalDisequalities) {
        return this.checkReportEqualityResult(CongruenceClosureSmtUtils.congruenceClosureToTerm(this.mMgdScript.getScript(), origCc, literalDisequalities), node1.getTerm(), node2.getTerm(), CongruenceClosureSmtUtils.congruenceClosureToTerm(this.mMgdScript.getScript(), result, literalDisequalities));
    }

    private boolean checkReportEqualityResult(WeqCongruenceClosure<NODE> origCc, NODE node1, NODE node2, WeqCongruenceClosure<NODE> result, Term literalDisequalities) {
        return this.checkReportEqualityResult(WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), origCc, literalDisequalities), node1.getTerm(), node2.getTerm(), WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), result, literalDisequalities));
    }

    private boolean checkReportEqualityResult(Term original, Term node1, Term node2, Term result) {
        this.mMgdScript.lock((Object)this);
        Script script = this.mMgdScript.getScript();
        Term originalAndEquality = SmtUtils.and((Script)script, (Term[])new Term[]{original, this.mMgdScript.term((Object)this, "=", new Term[]{node1, node2})});
        boolean res = this.checkImplicationHolds(script, originalAndEquality, result) && this.checkImplicationHolds(script, result, originalAndEquality);
        this.mMgdScript.unlock((Object)this);
        return res;
    }

    private boolean checkReportDisequalityResult(CongruenceClosure<NODE> origCc, NODE node1, NODE node2, CongruenceClosure<NODE> result, Term literalDisequalities) {
        return this.checkReportDisequalityResult(CongruenceClosureSmtUtils.congruenceClosureToTerm(this.mMgdScript.getScript(), origCc, literalDisequalities), node1.getTerm(), node2.getTerm(), CongruenceClosureSmtUtils.congruenceClosureToTerm(this.mMgdScript.getScript(), result, literalDisequalities));
    }

    private boolean checkReportDisequalityResult(WeqCongruenceClosure<NODE> origCc, NODE node1, NODE node2, WeqCongruenceClosure<NODE> result, Term literalDisequalities) {
        return this.checkReportDisequalityResult(WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), origCc, literalDisequalities), node1.getTerm(), node2.getTerm(), WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), result, literalDisequalities));
    }

    private boolean checkReportDisequalityResult(Term original, Term node1, Term node2, Term result) {
        this.mMgdScript.lock((Object)this);
        Script script = this.mMgdScript.getScript();
        Term originalAndEquality = SmtUtils.and((Script)script, (Term[])new Term[]{original, this.mMgdScript.term((Object)this, "distinct", new Term[]{node1, node2})});
        boolean res = this.checkImplicationHolds(script, originalAndEquality, result) && this.checkImplicationHolds(script, result, originalAndEquality);
        this.mMgdScript.unlock((Object)this);
        return res;
    }

    private boolean checkProjectAwayResult(WeqCongruenceClosure<NODE> original, NODE nodeToProjectAway, WeqCongruenceClosure<NODE> result, Term literalDisequalities) {
        return this.checkProjectAwayResult(WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), original, literalDisequalities), nodeToProjectAway.getTerm(), WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), result, literalDisequalities));
    }

    private boolean checkProjectAwayResult(Term original, Term projectedVar, Term result) {
        this.mMgdScript.lock((Object)this);
        Script script = this.mMgdScript.getScript();
        Term originalProjected = projectedVar instanceof TermVariable ? SmtUtils.quantifier((Script)script, (int)0, Collections.singleton((TermVariable)projectedVar), (Term)original) : original;
        boolean res = this.checkImplicationHolds(script, originalProjected, result);
        this.mMgdScript.unlock((Object)this);
        return res;
    }

    private boolean checkMeetResult(CongruenceClosure<NODE> cc1, CongruenceClosure<NODE> cc2, CongruenceClosure<NODE> result, Term literalDisequalities) {
        return this.checkMeetResult(CongruenceClosureSmtUtils.congruenceClosureToTerm(this.mMgdScript.getScript(), cc1, literalDisequalities), CongruenceClosureSmtUtils.congruenceClosureToTerm(this.mMgdScript.getScript(), cc2, literalDisequalities), CongruenceClosureSmtUtils.congruenceClosureToTerm(this.mMgdScript.getScript(), result, literalDisequalities));
    }

    boolean checkMeetResult(WeqCongruenceClosure<NODE> weqcc1, WeqCongruenceClosure<NODE> weqcc2, WeqCongruenceClosure<NODE> result, Term literalDisequalities) {
        return this.checkMeetResult(WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), weqcc1, literalDisequalities), WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), weqcc2, literalDisequalities), WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), result, literalDisequalities));
    }

    private boolean checkMeetResult(Term cc1, Term cc2, Term resultTerm) {
        this.mMgdScript.lock((Object)this);
        Script script = this.mMgdScript.getScript();
        Term cc1AndCc2Term = SmtUtils.and((Script)script, (Term[])new Term[]{cc1, cc2});
        boolean res = this.checkImplicationHolds(script, cc1AndCc2Term, resultTerm) && this.checkImplicationHolds(script, resultTerm, cc1AndCc2Term);
        this.mMgdScript.unlock((Object)this);
        return res;
    }

    private boolean checkJoinResult(CongruenceClosure<NODE> cc1, CongruenceClosure<NODE> cc2, CongruenceClosure<NODE> result, Term literalDisequalities) {
        return this.checkJoinResult(CongruenceClosureSmtUtils.congruenceClosureToTerm(this.mMgdScript.getScript(), cc1, literalDisequalities), CongruenceClosureSmtUtils.congruenceClosureToTerm(this.mMgdScript.getScript(), cc2, literalDisequalities), CongruenceClosureSmtUtils.congruenceClosureToTerm(this.mMgdScript.getScript(), result, literalDisequalities));
    }

    private boolean checkJoinResult(WeqCongruenceClosure<NODE> weqcc1, WeqCongruenceClosure<NODE> weqcc2, WeqCongruenceClosure<NODE> result, Term literalDisequalities) {
        return this.checkJoinResult(WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), weqcc1, literalDisequalities), WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), weqcc2, literalDisequalities), WeqCcManager.weqCcToTerm(this.mMgdScript.getScript(), result, literalDisequalities));
    }

    private boolean checkJoinResult(Term cc1, Term cc2, Term resultTerm) {
        this.mMgdScript.lock((Object)this);
        this.mMgdScript.echo((Object)this, new QuotedObject("WeqCcManager.checkJoinResult (begin)"));
        Script script = this.mMgdScript.getScript();
        Term cc1OrCc2Term = SmtUtils.or((Script)script, (Term[])new Term[]{cc1, cc2});
        boolean res = this.checkImplicationHolds(script, cc1OrCc2Term, resultTerm);
        this.mMgdScript.echo((Object)this, new QuotedObject("WeqCcManager.checkJoinResult (end)"));
        this.mMgdScript.unlock((Object)this);
        return res;
    }

    private boolean checkImplicationHolds(Script script, Term ante, Term succ) {
        return true;
    }

    private Script.LBool isStrongerThan(Script script, Term ante, Term succ) {
        assert (this.mMgdScript.isLockOwner((Object)this));
        this.mMgdScript.push((Object)this, 1);
        HashSet<TermVariable> freeVars = new HashSet<TermVariable>();
        freeVars.addAll(Arrays.asList(ante.getFreeVars()));
        freeVars.addAll(Arrays.asList(succ.getFreeVars()));
        HashMap<TermVariable, Term> subsMap = new HashMap<TermVariable, Term>();
        for (TermVariable fv : freeVars) {
            this.mMgdScript.declareFun((Object)this, fv.getName(), new Sort[0], fv.getSort());
            Term cons = this.mMgdScript.term((Object)this, fv.getName(), new Term[0]);
            subsMap.put(fv, cons);
        }
        this.mMgdScript.assertTerm((Object)this, Substitution.apply((ManagedScript)this.mMgdScript, subsMap, (Term)ante));
        this.mMgdScript.assertTerm((Object)this, SmtUtils.not((Script)script, (Term)Substitution.apply((ManagedScript)this.mMgdScript, subsMap, (Term)succ)));
        Script.LBool satResult = this.mMgdScript.checkSat((Object)this);
        this.mMgdScript.pop((Object)this, 1);
        return satResult;
    }

    private boolean checkFilterDisjunctionResult(Set<CongruenceClosure<NODE>> input, Set<CongruenceClosure<NODE>> result, Term literalDisequalities) {
        if (!input.stream().anyMatch(d -> d.isInconsistent(false)) && !result.stream().anyMatch(d -> d.isInconsistent(false))) {
            HashSet nodesInput = new HashSet();
            input.stream().forEach(d -> {
                boolean bl = nodesInput.addAll(d.getAllElements());
            });
            HashSet nodesResult = new HashSet();
            result.stream().forEach(d -> {
                boolean bl = nodesResult.addAll(d.getAllElements());
            });
            Set difference = DataStructureUtils.difference(nodesResult, nodesInput);
            if (!difference.isEmpty()) {
                assert (false);
                return false;
            }
        }
        return true;
    }

    private static <NODE extends IEqNodeIdentifier<NODE>> Term disjunctionToTerm(Script script, Set<CongruenceClosure<NODE>> ccs, Term literalDisequalities) {
        if (ccs.isEmpty()) {
            return script.term("false", new Term[0]);
        }
        HashSet<Term> disjunctTerms = new HashSet<Term>();
        for (CongruenceClosure<NODE> cc : ccs) {
            disjunctTerms.add(CongruenceClosureSmtUtils.congruenceClosureToTerm(script, cc, literalDisequalities));
        }
        return SmtUtils.or((Script)script, disjunctTerms);
    }

    public static <NODE extends IEqNodeIdentifier<NODE>> Term weqCcToTerm(Script script, WeqCongruenceClosure<NODE> weqCc, Term literalDisequalities) {
        if (weqCc.isInconsistent(false)) {
            return script.term("false", new Term[0]);
        }
        ArrayList<Term> allConjuncts = new ArrayList<Term>();
        allConjuncts.addAll(CongruenceClosureSmtUtils.congruenceClosureToCube(script, weqCc.getCongruenceClosure(), literalDisequalities));
        List<Term> weakEqConstraints = weqCc.getWeakEquivalenceGraph().getWeakEquivalenceConstraintsAsTerms(script);
        allConjuncts.addAll(weakEqConstraints);
        Term result = SmtUtils.and((Script)script, (Term[])allConjuncts.toArray(new Term[allConjuncts.size()]));
        assert (weqCc.getManager().getSettings().omitSanitycheckFineGrained1() || weqCc.getManager().getAllWeqVariables().stream().allMatch(weqvar -> !Arrays.asList(result.getFreeVars()).contains(weqvar)));
        return result;
    }

    public WeqCongruenceClosure<NODE> getWeqCongruenceClosure(CongruenceClosure<NODE> cc, WeakEquivalenceGraph<NODE> weqGraph, boolean modifiable) {
        CongruenceClosure ccUnfrozen = this.mCcManager.unfreezeIfNecessary(cc);
        this.addAllElementsCc(ccUnfrozen, weqGraph.getAppearingNonWeqVarNodes(), null, true);
        WeqCongruenceClosure result = new WeqCongruenceClosure(ccUnfrozen, weqGraph, this);
        this.mNonTheoryLiteralNodes.forEach(n -> {
            boolean bl = result.addElement(n, false);
        });
        if (!modifiable) {
            result.freezeAndClose();
        }
        return result;
    }

    public CongruenceClosure<NODE> getSingleEqualityCc(NODE node1, NODE node2, boolean modifiable, CongruenceClosure<NODE> dummyDisjunct) {
        return this.mCcManager.getSingleEqualityCc(node1, node2, modifiable);
    }

    public CongruenceClosure<NODE> getSingleDisequalityCc(NODE node1, NODE node2, boolean modifiable, CongruenceClosure<NODE> dummyDisjunct) {
        return this.mCcManager.getSingleDisequalityCc(node1, node2, modifiable);
    }

    public CongruenceClosure<NODE> getSingleEqualityCc(NODE node1, NODE node2, boolean modifiable) {
        return this.mCcManager.getSingleEqualityCc(node1, node2, modifiable);
    }

    public CongruenceClosure<NODE> getSingleDisequalityCc(NODE node1, NODE node2, boolean modifiable) {
        return this.mCcManager.getSingleDisequalityCc(node1, node2, modifiable);
    }

    public CongruenceClosure<NODE> copyCcNoRemInfo(CongruenceClosure<NODE> cc) {
        CongruenceClosure result = this.mCcManager.copyNoRemInfo(cc);
        assert (result.isFrozen() == cc.isFrozen());
        return result;
    }

    public CongruenceClosure<NODE> copyCcNoRemInfoUnfrozen(CongruenceClosure<NODE> cc) {
        return this.mCcManager.copyNoRemInfoUnfrozen(cc);
    }

    public CongruenceClosure<NODE> projectToElements(CongruenceClosure<NODE> cc, Set<NODE> nodesToKeep, IRemovalInfo<NODE> remInfo, boolean modifiable) {
        assert (!cc.isInconsistent(false)) : "catch this outside";
        CongruenceClosure result = this.mCcManager.projectToElements(cc, nodesToKeep, remInfo);
        assert (result.isFrozen()) : "projectToElements always freezes, right?.. (because it cannot work inplace)";
        if (modifiable) {
            result = this.mCcManager.unfreeze(result);
        }
        return result;
    }

    public WeqCongruenceClosure<NODE> addAllElements(WeqCongruenceClosure<NODE> weqcc, Set<NODE> nodesToAdd, IRemovalInfo<NODE> remInfo, boolean inplace) {
        this.bmStart(WeqCcBmNames.ADDALLNODES);
        if (inplace) {
            for (IEqNodeIdentifier e : nodesToAdd) {
                if (weqcc.isInconsistent(false)) {
                    return weqcc;
                }
                this.addNode(e, weqcc, true, false);
            }
            this.bmEnd(WeqCcBmNames.ADDALLNODES);
            return weqcc;
        }
        WeqCongruenceClosure<Object> result = this.unfreeze(weqcc);
        for (IEqNodeIdentifier e : nodesToAdd) {
            if (weqcc.isInconsistent(false)) {
                return weqcc;
            }
            result = this.addNode(e, weqcc, false, false);
        }
        assert (result.isFrozen());
        this.bmEnd(WeqCcBmNames.ADDALLNODES);
        return result;
    }

    public CongruenceClosure<NODE> addAllElementsCc(CongruenceClosure<NODE> cc, Set<NODE> elemsToAdd, IRemovalInfo<NODE> remInfo, boolean inplace) {
        return this.mCcManager.addAllElements(cc, elemsToAdd, remInfo, inplace);
    }

    CongruenceClosure<NODE> computeWeqConstraintForIndex(List<NODE> nodes, boolean modifiable) {
        CongruenceClosure<NODE> result = this.getEmptyCc(true);
        int i = 0;
        while (i < nodes.size()) {
            IEqNodeIdentifier ithNode = (IEqNodeIdentifier)nodes.get(i);
            NODE weqVarNode = this.getWeqVariableNodeForDimension(i, ithNode.getTerm().getSort());
            this.reportEquality(result, weqVarNode, ithNode, true);
            ++i;
        }
        if (!modifiable) {
            result.freezeAndClose();
        }
        return result;
    }

    public WeakEquivalenceEdgeLabel<NODE> getEdgeLabelForIndex(WeakEquivalenceGraph<NODE> weakEquivalenceGraph, NODE storeIndex) {
        return this.getSingletonEdgeLabel(weakEquivalenceGraph, this.computeWeqConstraintForIndex(Collections.singletonList(storeIndex), !weakEquivalenceGraph.isFrozen()));
    }

    public WeakEquivalenceEdgeLabel<NODE> meetEdgeLabels(WeakEquivalenceEdgeLabel<NODE> l1, WeakEquivalenceEdgeLabel<NODE> l2, boolean inplace) {
        this.bmStart(WeqCcBmNames.MEETEDGELABELS);
        WeakEquivalenceEdgeLabel<NODE> result = l1.meet(l2, inplace);
        assert (!inplace || result == l1) : "if inplace is set, we must return the original object";
        assert (inplace || this.isStrongerThanPrecise(result, l1));
        assert (inplace || this.isStrongerThanPrecise(result, l2));
        this.bmEnd(WeqCcBmNames.MEETEDGELABELS);
        return result;
    }

    boolean checkMeetWeqLabels(WeakEquivalenceEdgeLabel<NODE> l1, WeakEquivalenceEdgeLabel<NODE> l2, WeakEquivalenceEdgeLabel<NODE> result) {
        Script script = this.mMgdScript.getScript();
        this.mMgdScript.lock((Object)this);
        List<Term> l1Dnf = l1.toDnf(script);
        Term l1Term = SmtUtils.or((Script)script, l1Dnf);
        List<Term> l2Dnf = l2.toDnf(script);
        Term l2Term = SmtUtils.or((Script)script, l2Dnf);
        List<Term> resultDnf = result.toDnf(script);
        Term resultTerm = SmtUtils.or((Script)script, resultDnf);
        Term l1AndL2 = SmtUtils.and((Script)script, (Term[])new Term[]{l1Term, l2Term});
        boolean oneImpliesTwo = this.checkImplicationHolds(script, l1AndL2, resultTerm);
        assert (oneImpliesTwo);
        boolean twoImpliesOne = this.checkImplicationHolds(script, resultTerm, l1AndL2);
        assert (twoImpliesOne);
        this.mMgdScript.unlock((Object)this);
        return oneImpliesTwo && twoImpliesOne;
    }

    public void freezeIfNecessary(CongruenceClosure<NODE> cc) {
        this.mCcManager.freezeIfNecessary(cc);
    }

    public boolean isStrongerThan(WeakEquivalenceEdgeLabel<NODE> label1, WeakEquivalenceEdgeLabel<NODE> label2) {
        boolean result = this.mSettings.isPreciseWeqLabelComparison() ? this.isStrongerThanPrecise(label1, label2) : this.isStrongerThan(label1, label2, this::isStrongerThan);
        assert (this.checkIsStrongerThanResult(label1, label2, result));
        return result;
    }

    boolean isStrongerThanPrecise(WeakEquivalenceEdgeLabel<NODE> label1, WeakEquivalenceEdgeLabel<NODE> label2) {
        Script script = this.mMgdScript.getScript();
        this.mMgdScript.lock((Object)this);
        Term label1Term = SmtUtils.or((Script)script, label1.toDnf(script));
        label1Term = SmtUtils.and((Script)script, (Term[])new Term[]{label1Term, this.getNonTheoryLiteralDisequalitiesIfNecessary()});
        Term label2Term = SmtUtils.or((Script)script, label2.toDnf(script));
        Script.LBool satResult = this.isStrongerThan(script, label1Term, label2Term);
        assert (satResult != Script.LBool.UNKNOWN) : "TODO: solve this problem.. implement a fallback??";
        boolean implicationHolds = satResult == Script.LBool.UNSAT;
        this.mMgdScript.unlock((Object)this);
        return implicationHolds;
    }

    private boolean checkIsStrongerThanResult(WeakEquivalenceEdgeLabel<NODE> label1, WeakEquivalenceEdgeLabel<NODE> label2, boolean impCheckResult) {
        return true;
    }

    public boolean isStrongerThan(WeakEquivalenceEdgeLabel<NODE> label1, WeakEquivalenceEdgeLabel<NODE> label2, BiPredicate<CongruenceClosure<NODE>, CongruenceClosure<NODE>> lowerOrEqual) {
        this.bmStart(WeqCcBmNames.ISLABELSTRONGERTHAN);
        for (CongruenceClosure<NODE> label1disjunct : label1.getDisjuncts()) {
            boolean existsWeaker = false;
            for (CongruenceClosure<NODE> label2disjunct : label2.getDisjuncts()) {
                if (!lowerOrEqual.test(label1disjunct, label2disjunct)) continue;
                existsWeaker = true;
                break;
            }
            if (existsWeaker) continue;
            this.bmEnd(WeqCcBmNames.ISLABELSTRONGERTHAN);
            return false;
        }
        this.bmEnd(WeqCcBmNames.ISLABELSTRONGERTHAN);
        return true;
    }

    public boolean isStrongerThan(CongruenceClosure<NODE> paThis, CongruenceClosure<NODE> paOther) {
        return this.mCcManager.isStrongerThan(paThis, paOther);
    }

    public boolean isEquivalentCc(WeakEquivalenceEdgeLabel<NODE> label1, WeakEquivalenceEdgeLabel<NODE> label2) {
        return this.isStrongerThan(label1, label2) && this.isStrongerThan(label2, label1);
    }

    public boolean isStrongerThan(WeakEquivalenceGraph<NODE> weakEquivalenceGraph, WeakEquivalenceGraph<NODE> weakEquivalenceGraph2) {
        this.bmStart(WeqCcBmNames.ISWEQGRAPHSTRONGERTHAN);
        assert (weakEquivalenceGraph.getBaseWeqCc().isClosed() && weakEquivalenceGraph2.getBaseWeqCc().isClosed());
        boolean result = weakEquivalenceGraph.isStrongerThan(weakEquivalenceGraph2);
        this.bmEnd(WeqCcBmNames.ISWEQGRAPHSTRONGERTHAN);
        return result;
    }

    private void freezeIfNecessary(WeakEquivalenceGraph<NODE> weakEquivalenceGraph) {
        if (!weakEquivalenceGraph.isFrozen()) {
            weakEquivalenceGraph.freeze();
        }
    }

    public WeakEquivalenceGraph<NODE> join(WeakEquivalenceGraph<NODE> weakEquivalenceGraph, WeakEquivalenceGraph<NODE> weakEquivalenceGraph2, boolean modifiable) {
        this.bmStart(WeqCcBmNames.WEQGRAPHJOIN);
        this.freezeIfNecessary(weakEquivalenceGraph);
        this.freezeIfNecessary(weakEquivalenceGraph2);
        WeakEquivalenceGraph<NODE> result = weakEquivalenceGraph.join(weakEquivalenceGraph2);
        if (!modifiable) {
            result.freeze();
        }
        this.bmEnd(WeqCcBmNames.WEQGRAPHJOIN);
        return result;
    }

    public WeqCongruenceClosure<NODE> copyWeqCc(WeqCongruenceClosure<NODE> original, boolean modifiable) {
        WeqCongruenceClosure<NODE> result = new WeqCongruenceClosure<NODE>(original);
        if (!modifiable) {
            result.freezeAndClose();
        }
        return result;
    }

    public CongruenceClosure<NODE> copyCc(CongruenceClosure<NODE> icc, boolean modifiable) {
        return this.mCcManager.getCopy(icc, modifiable);
    }

    public WeakEquivalenceEdgeLabel<NODE> copy(WeakEquivalenceEdgeLabel<NODE> original, boolean omitSanityCheck, boolean modifiable) {
        return this.copy(original, original.getWeqGraph(), omitSanityCheck, modifiable);
    }

    public WeakEquivalenceEdgeLabel<NODE> copy(WeakEquivalenceEdgeLabel<NODE> original, boolean modifiable) {
        return this.copy(original, original.getWeqGraph(), modifiable);
    }

    public WeqCongruenceClosure<NODE> unfreezeIfNecessary(WeqCongruenceClosure<NODE> weqcc) {
        if (weqcc.isFrozen()) {
            return this.unfreeze(weqcc);
        }
        return weqcc;
    }

    public WeakEquivalenceEdgeLabel<NODE> copy(WeakEquivalenceEdgeLabel<NODE> value, WeakEquivalenceGraph<NODE> weakEquivalenceGraph, boolean modifiable) {
        return this.copy(value, weakEquivalenceGraph, false, modifiable);
    }

    public WeakEquivalenceEdgeLabel<NODE> copy(WeakEquivalenceEdgeLabel<NODE> value, WeakEquivalenceGraph<NODE> weakEquivalenceGraph, boolean omitSanityCheck, boolean modifiable) {
        WeakEquivalenceEdgeLabel<NODE> result = new WeakEquivalenceEdgeLabel<NODE>(weakEquivalenceGraph, value, omitSanityCheck);
        if (!modifiable) {
            result.freeze();
        }
        return result;
    }

    public WeakEquivalenceGraph<NODE> unfreeze(WeakEquivalenceGraph<NODE> weqGraph) {
        return new WeakEquivalenceGraph<NODE>(weqGraph.getBaseWeqCc(), weqGraph);
    }

    public WeakEquivalenceEdgeLabel<NODE> unfreeze(WeakEquivalenceEdgeLabel<NODE> value) {
        return this.copy(value, true);
    }

    public static boolean areAssertsEnabled() {
        boolean assertsEnabled = false;
        if (!$assertionsDisabled) {
            assertsEnabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return assertsEnabled;
    }

    public boolean checkEquivalence(WeqCongruenceClosure<NODE> weqcc1, WeqCongruenceClosure<NODE> weqcc2) {
        return true;
    }

    public Term getNonTheoryLiteralDisequalitiesIfNecessary() {
        return this.mMgdScript.getScript().term("true", new Term[0]);
    }

    public WeqSettings getSettings() {
        return this.mSettings;
    }

    public int getDimensionOfWeqVar(NODE weqVarNode) {
        for (Triple en : this.mDimensionToWeqVariableNode.entrySet()) {
            if (!((IEqNodeIdentifier)en.getThird()).equals(weqVarNode)) continue;
            return (Integer)en.getSecond();
        }
        throw new AssertionError((Object)("weq var unknown: " + weqVarNode));
    }

    public BenchmarkWithCounters getBenchmark() {
        return this.mBenchmark;
    }

    public CcManager<NODE> getCcManager() {
        return this.mCcManager;
    }

    public void replaceElement(WeakEquivalenceEdgeLabel<NODE> aToB, NODE replacer, NODE replacee) {
        Function<IEqNodeIdentifier, IEqNodeIdentifier> transformer = n -> n.equals(replacee) ? replacer : n;
        aToB.transformElements(transformer);
    }

    public WeakEquivalenceEdgeLabel<NODE> reportEquality(WeakEquivalenceEdgeLabel<NODE> label, NODE n1, NODE n2, boolean inplace) {
        if (inplace) {
            for (CongruenceClosure<NODE> d : label.getDisjuncts()) {
                this.reportEquality(d, n1, n2, true);
            }
            return label;
        }
        HashSet newDisjuncts = new HashSet();
        for (CongruenceClosure<NODE> d : label.getDisjuncts()) {
            this.freezeIfNecessary(d);
            CongruenceClosure<NODE> newD = this.reportEquality(d, n1, n2, false);
            if (newD.isInconsistent()) continue;
            newDisjuncts.add(newD);
        }
        return new WeakEquivalenceEdgeLabel<NODE>(label.getWeqGraph(), newDisjuncts);
    }

    public boolean isDebugMode() {
        return this.mDebug;
    }

    static enum WeqCcBmNames {
        FILTERREDUNDANT,
        UNFREEZE,
        COPY,
        MEET,
        JOIN,
        ISSTRONGERTHAN,
        ADDNODE,
        REPORTEQUALITY,
        REPORTDISEQUALITY,
        REPORTWEQ,
        REPORTCONTAINS,
        PROJECTAWAY,
        RENAMEVARS,
        ADDALLNODES,
        MEETEDGELABELS,
        ISLABELSTRONGERTHAN,
        ISWEQGRAPHSTRONGERTHAN,
        WEQGRAPHJOIN,
        FREEZE_AND_CLOSE,
        FREEZEONLY,
        EXT_AND_TRIANGLE_CLOSURE,
        ALIGN_ELEMENTS;


        static String[] getNames() {
            String[] result = new String[WeqCcBmNames.values().length];
            int i = 0;
            while (i < WeqCcBmNames.values().length) {
                result[i] = WeqCcBmNames.values()[i].name();
                ++i;
            }
            return result;
        }
    }
}

