/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.Diet;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.IEqNodeIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.VPStatistics;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeakEquivalenceEdgeLabel;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeakEquivalenceGraph;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.vpdomain.WeqCcManager;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CcAuxData;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.CongruenceClosure;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.ICongruenceClosureElement;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IElementRemovalTarget;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IEqualityReportingTarget;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.IRemovalInfo;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraint;
import de.uni_freiburg.informatik.ultimate.util.datastructures.congruenceclosure.SetConstraintConjunction;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;

public class WeqCongruenceClosure<NODE extends IEqNodeIdentifier<NODE>>
implements IEqualityReportingTarget<NODE>,
IElementRemovalTarget<NODE> {
    private CongruenceClosure<NODE> mCongruenceClosure;
    private WeakEquivalenceGraph<NODE> mWeakEquivalenceGraphThin;
    private WeakEquivalenceGraph<NODE> mWeakEquivalenceGraphCcFat;
    private boolean mIsWeqFatEdgeLabel;
    private boolean mIsFrozen = false;
    private boolean mIsClosed = true;
    private final ILogger mLogger;
    private final WeqCcManager<NODE> mManager;
    Diet mDiet;

    public WeqCongruenceClosure(WeqCcManager<NODE> manager) {
        assert (manager != null);
        this.mLogger = manager.getLogger();
        this.mManager = manager;
        this.mCongruenceClosure = manager.getEmptyCc(true);
        this.mWeakEquivalenceGraphThin = new WeakEquivalenceGraph<NODE>(this, manager, manager.getEmptyCc(false));
        this.mDiet = Diet.THIN;
        assert (this.mManager.getSettings().omitSanitycheckFineGrained2() || this.sanityCheck());
    }

    public WeqCongruenceClosure(boolean isInconsistent) {
        if (!isInconsistent) {
            throw new IllegalArgumentException("use other constructor!");
        }
        this.mCongruenceClosure = null;
        this.mManager = null;
        this.mLogger = null;
        this.mIsFrozen = true;
    }

    public WeqCongruenceClosure(CongruenceClosure<NODE> cc, WeakEquivalenceGraph<NODE> weqGraph, WeqCcManager<NODE> manager) {
        assert (!cc.isFrozen());
        this.mLogger = manager.getLogger();
        this.mCongruenceClosure = manager.copyCcNoRemInfo(cc);
        assert (manager != null);
        if (cc.isInconsistent(false)) {
            throw new IllegalArgumentException("use other constructor!");
        }
        this.mManager = manager;
        this.mWeakEquivalenceGraphThin = new WeakEquivalenceGraph<NODE>(this, weqGraph);
        this.mDiet = Diet.THIN;
        assert (this.mManager.getSettings().omitSanitycheckFineGrained2() || this.sanityCheck());
    }

    public WeqCongruenceClosure(WeqCongruenceClosure<NODE> original) {
        this.mLogger = original.getLogger();
        this.mManager = original.mManager;
        this.mCongruenceClosure = this.mManager.copyCc(original.mCongruenceClosure, true);
        assert (!this.mCongruenceClosure.isFrozen());
        assert (original.mManager != null);
        if (original.mDiet != Diet.TRANSITORY_THIN_TO_CCFAT && original.mDiet != Diet.THIN) {
            throw new AssertionError();
        }
        this.mIsWeqFatEdgeLabel = original.mIsWeqFatEdgeLabel;
        this.mDiet = original.mDiet;
        this.mWeakEquivalenceGraphThin = new WeakEquivalenceGraph<NODE>(this, original.mWeakEquivalenceGraphThin);
        assert (this.mManager.getSettings().omitSanitycheckFineGrained2() || this.sanityCheck());
        assert (!this.mIsFrozen);
    }

    public boolean addElement(NODE elem, boolean omitSanityChecks) {
        assert (!this.isFrozen());
        this.addElementRec(elem);
        if (!this.mManager.getSettings().omitSanitycheckFineGrained1()) assert (omitSanityChecks || this.sanityCheck());
        this.mIsClosed = false;
        this.reportAllConstraintsFromWeqGraph(omitSanityChecks);
        assert (omitSanityChecks || this.sanityCheck());
        return true;
    }

    public boolean isFrozen() {
        assert (this.isInconsistent(false) || this.mIsFrozen == this.mCongruenceClosure.isFrozen());
        return this.mIsFrozen;
    }

    public void freezeOmitPropagations() {
        if (this.mCongruenceClosure != null) {
            this.mManager.getCcManager().freezeIfNecessary(this.mCongruenceClosure);
        }
        if (!this.isInconsistent(false)) {
            this.getWeakEquivalenceGraph().freezeIfNecessary();
        }
        this.mIsFrozen = true;
    }

    public void freezeAndClose() {
        this.mManager.bmStart(WeqCcManager.WeqCcBmNames.FREEZE_AND_CLOSE);
        assert (!this.mIsFrozen);
        this.extAndTriangleClosure(false);
        this.freezeOmitPropagations();
        this.mManager.bmEnd(WeqCcManager.WeqCcBmNames.FREEZE_AND_CLOSE);
    }

    public boolean isInconsistent() {
        return this.isInconsistent(this.mManager.getSettings().closeBeforeIsInconsistentCheck());
    }

    public boolean isInconsistent(boolean close) {
        if (close) {
            this.mManager.closeIfNecessary(this);
        }
        return this.mCongruenceClosure == null || this.mCongruenceClosure.isInconsistent();
    }

    public void reportWeakEquivalence(NODE array1, NODE array2, NODE storeIndex, boolean omitSanityChecks) {
        assert (!this.isFrozen());
        assert (array1.hasSameTypeAs(array2));
        this.mManager.addNode(storeIndex, this, true, true);
        if (!this.mManager.getSettings().omitSanitycheckFineGrained1()) assert (this.sanityCheck());
        this.reportWeakEquivalence(array1, array2, this.mManager.getEdgeLabelForIndex(this.getWeakEquivalenceGraph(), storeIndex), omitSanityChecks);
        assert (this.mManager.getSettings().omitSanitycheckFineGrained2() || this.sanityCheck());
    }

    private void reportWeakEquivalence(NODE array1, NODE array2, WeakEquivalenceEdgeLabel<NODE> edgeLabel, boolean omitSanityChecks) {
        assert (!this.isFrozen());
        if (this.isInconsistent(false)) {
            return;
        }
        this.reportWeakEquivalenceDoOnlyRoweqPropagations(array1, array2, edgeLabel, omitSanityChecks);
        assert (this.mManager.getSettings().omitSanitycheckFineGrained2() || this.sanityCheck());
    }

    boolean executeFloydWarshallAndReportResultToWeqCc(boolean omitSanityChecks) {
        if (this.isInconsistent(false)) {
            return false;
        }
        WeqCongruenceClosure originalCopy = null;
        if (WeqCcManager.areAssertsEnabled() && this.mManager.mDebug) {
            this.mManager.getClass();
        }
        boolean fwmc = false;
        Map<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> fwResult = this.getCcWeakEquivalenceGraph().propagateViaTriangleRule();
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> fwEdge : fwResult.entrySet()) {
            fwmc |= this.reportWeakEquivalenceDoOnlyRoweqPropagations((IEqNodeIdentifier)fwEdge.getKey().getOneElement(), (IEqNodeIdentifier)fwEdge.getKey().getOtherElement(), fwEdge.getValue(), omitSanityChecks);
            if (!this.mManager.getSettings().omitSanitycheckFineGrained1()) assert (omitSanityChecks || this.sanityCheck());
        }
        assert (this.mManager.checkEquivalence(originalCopy, this));
        assert (omitSanityChecks || this.sanityCheck());
        return fwmc;
    }

    private boolean reportWeakEquivalenceDoOnlyRoweqPropagations(NODE array1, NODE array2, WeakEquivalenceEdgeLabel<NODE> edgeLabel, boolean omitSanityChecks) {
        assert (!this.isFrozen());
        assert (!this.mManager.getSettings().isDeactivateWeakEquivalences());
        assert (!array1.dependsOnUntrackedArray());
        assert (!array2.dependsOnUntrackedArray());
        if (this.isInconsistent(false)) {
            return false;
        }
        if (edgeLabel.isTautological()) {
            return false;
        }
        boolean addedNewNode = false;
        addedNewNode |= !this.mCongruenceClosure.hasElement(array1);
        addedNewNode |= !this.mCongruenceClosure.hasElement(array2);
        this.mManager.addNode(array1, this, true, omitSanityChecks);
        this.mManager.addNode(array2, this, true, omitSanityChecks);
        IEqNodeIdentifier array1Rep = (IEqNodeIdentifier)this.mCongruenceClosure.getRepresentativeElement(array1);
        IEqNodeIdentifier array2Rep = (IEqNodeIdentifier)this.mCongruenceClosure.getRepresentativeElement(array2);
        if (array1Rep == array2Rep) {
            return addedNewNode;
        }
        boolean reportedNewWeq = this.getCcWeakEquivalenceGraph().reportWeakEquivalence(array1Rep, array2Rep, edgeLabel, omitSanityChecks);
        if (!reportedNewWeq) {
            return addedNewNode;
        }
        WeakEquivalenceEdgeLabel<IEqNodeIdentifier> strengthenedEdgeLabel = this.getCcWeakEquivalenceGraph().getEdgeLabel(array1Rep, array2Rep);
        if (strengthenedEdgeLabel == null) {
            throw new AssertionError((Object)"TODO : check this case, this does not happen, right? (and the comment above is nonsense..)");
        }
        if (this.isInconsistent(false)) {
            return true;
        }
        array1Rep = (IEqNodeIdentifier)this.mCongruenceClosure.getRepresentativeElement(array1);
        array2Rep = (IEqNodeIdentifier)this.mCongruenceClosure.getRepresentativeElement(array2);
        CongruenceClosure.constantAndMixFunctionTreatmentOnAddEquality((ICongruenceClosureElement)array1Rep, (ICongruenceClosureElement)array2Rep, (Set)this.mCongruenceClosure.getEquivalenceClass(array1), (Set)this.mCongruenceClosure.getEquivalenceClass(array2), (CcAuxData)this.mCongruenceClosure.getAuxData(), n -> {
            WeqCongruenceClosure<IEqNodeIdentifier> weqCongruenceClosure = this.mManager.addNode((IEqNodeIdentifier)n, this, true, true);
        }, (IEqualityReportingTarget)this);
        array1Rep = (IEqNodeIdentifier)this.mCongruenceClosure.getRepresentativeElement(array1);
        array2Rep = (IEqNodeIdentifier)this.mCongruenceClosure.getRepresentativeElement(array2);
        Collection ccps1 = this.mCongruenceClosure.getAuxData().getAfCcPars((ICongruenceClosureElement)array1Rep);
        Collection ccps2 = this.mCongruenceClosure.getAuxData().getAfCcPars((ICongruenceClosureElement)array2Rep);
        for (IEqNodeIdentifier ccp1 : ccps1) {
            if (!this.mCongruenceClosure.hasElements((ICongruenceClosureElement[])new IEqNodeIdentifier[]{ccp1, (IEqNodeIdentifier)ccp1.getArgument(), (IEqNodeIdentifier)ccp1.getAppliedFunction()})) continue;
            for (IEqNodeIdentifier ccp2 : ccps2) {
                if (this.isInconsistent(false)) {
                    return true;
                }
                if (!this.mCongruenceClosure.hasElements((ICongruenceClosureElement[])new IEqNodeIdentifier[]{ccp2, (IEqNodeIdentifier)ccp2.getArgument(), (IEqNodeIdentifier)ccp2.getAppliedFunction()}) || this.mCongruenceClosure.getEqualityStatus((ICongruenceClosureElement)((IEqNodeIdentifier)ccp1.getArgument()), (ICongruenceClosureElement)((IEqNodeIdentifier)ccp2.getArgument())) != EqualityStatus.EQUAL) continue;
                WeakEquivalenceEdgeLabel<IEqNodeIdentifier> projectedLabel = this.getCcWeakEquivalenceGraph().projectEdgeLabelToPoint(strengthenedEdgeLabel, (IEqNodeIdentifier)ccp1.getArgument(), this.mManager.getAllWeqVarsNodeForFunction(array1));
                this.reportWeakEquivalenceDoOnlyRoweqPropagations(ccp1, ccp2, projectedLabel, omitSanityChecks);
            }
        }
        array1Rep = (IEqNodeIdentifier)this.mCongruenceClosure.getRepresentativeElement(array1);
        array2Rep = (IEqNodeIdentifier)this.mCongruenceClosure.getRepresentativeElement(array2);
        Set array1RepCcChildren = this.mCongruenceClosure.getAuxData().getCcChildren((ICongruenceClosureElement)array1Rep).getSetOfPairs();
        Set array2RepCcChildren = this.mCongruenceClosure.getAuxData().getCcChildren((ICongruenceClosureElement)array2Rep).getSetOfPairs();
        for (Map.Entry ccc1 : array1RepCcChildren) {
            if (((IEqNodeIdentifier)ccc1.getKey()).dependsOnUntrackedArray()) continue;
            for (Map.Entry ccc2 : array2RepCcChildren) {
                if (this.isInconsistent(false)) {
                    return true;
                }
                if (((IEqNodeIdentifier)ccc2.getKey()).dependsOnUntrackedArray() || this.mCongruenceClosure.getEqualityStatus((ICongruenceClosureElement)((IEqNodeIdentifier)ccc1.getValue()), (ICongruenceClosureElement)((IEqNodeIdentifier)ccc2.getValue())) != EqualityStatus.EQUAL) continue;
                WeakEquivalenceEdgeLabel<IEqNodeIdentifier> shiftedLabelWithException = this.getCcWeakEquivalenceGraph().shiftLabelAndAddException(strengthenedEdgeLabel, (IEqNodeIdentifier)ccc1.getValue(), this.mManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)ccc1.getKey()));
                this.reportWeakEquivalenceDoOnlyRoweqPropagations((IEqNodeIdentifier)ccc1.getKey(), (IEqNodeIdentifier)ccc2.getKey(), shiftedLabelWithException, omitSanityChecks);
            }
        }
        return true;
    }

    private void constArrayWeqProp(NODE array1, NODE array2, WeakEquivalenceEdgeLabel<NODE> edgeLabel) {
        IEqNodeIdentifier nonConstantArray;
        IEqNodeIdentifier constantArray;
        IEqNodeIdentifier array1Rep = (IEqNodeIdentifier)this.mCongruenceClosure.getRepresentativeElement(array1);
        IEqNodeIdentifier array2Rep = (IEqNodeIdentifier)this.mCongruenceClosure.getRepresentativeElement(array2);
        if (array1Rep.isConstantFunction()) {
            assert (!array2Rep.isConstantFunction()) : "?";
            constantArray = array1Rep;
            nonConstantArray = array2Rep;
        } else if (array2Rep.isConstantFunction()) {
            assert (!array1Rep.isConstantFunction()) : "?";
            constantArray = array2Rep;
            nonConstantArray = array1Rep;
        } else {
            constantArray = null;
            nonConstantArray = null;
        }
        Collection aIs = null;
        Set<SetConstraint<IEqNodeIdentifier>> containsConstraint = null;
        if (nonConstantArray != null && !(aIs = this.mCongruenceClosure.getFuncAppsWithFunc((ICongruenceClosureElement)nonConstantArray)).isEmpty()) {
            IEqNodeIdentifier sampleAi = (IEqNodeIdentifier)aIs.iterator().next();
            IEqNodeIdentifier aQ = (IEqNodeIdentifier)this.mManager.getEqNodeAndFunctionFactory().getFuncAppElement(nonConstantArray, (ICongruenceClosureElement)this.mManager.getWeqVariableNodeForDimension(0, ((IEqNodeIdentifier)sampleAi.getArgument()).getSort()), true);
            containsConstraint = edgeLabel.getContainsConstraintForElement(aQ);
            assert (containsConstraint == null || !this.mManager.getCcManager().getSetConstraintManager().isInconsistent(containsConstraint)) : "uncaught inconsistent case";
        }
        if (constantArray != null && !aIs.isEmpty() && containsConstraint != null) {
            IEqNodeIdentifier constantArrayConstant = (IEqNodeIdentifier)constantArray.getConstantFunctionValue();
            assert (constantArrayConstant.isLiteral());
            for (IEqNodeIdentifier aI : aIs) {
                if (this.mCongruenceClosure.getEquivalenceClass((ICongruenceClosureElement)aI).stream().anyMatch(n -> n.isLiteral())) continue;
                Set newLiteralSet = this.mManager.getCcManager().getSetConstraintManager().join(this.mCongruenceClosure.getLiteralSetConstraints(), containsConstraint, Collections.singleton(this.mManager.getCcManager().getSetConstraintManager().buildSetConstraint(Collections.singleton(constantArrayConstant))));
                this.mCongruenceClosure.reportContainsConstraint((ICongruenceClosureElement)aI, (Collection)newLiteralSet);
            }
        }
    }

    public boolean reportEquality(NODE node1, NODE node2, boolean omitSanityChecks) {
        assert (!this.isFrozen());
        if (!this.mManager.getSettings().omitSanitycheckFineGrained1()) assert (omitSanityChecks || this.sanityCheck());
        boolean madeChanges = this.reportEqualityRec(node1, node2);
        this.mIsClosed = false;
        assert (this.mManager.getSettings().omitSanitycheckFineGrained2() || omitSanityChecks || this.sanityCheck());
        return madeChanges;
    }

    public boolean reportEqualityRec(NODE node1, NODE node2) {
        assert (!this.isFrozen());
        assert (node1.hasSameTypeAs(node2));
        if (this.isInconsistent(false)) {
            throw new IllegalStateException();
        }
        boolean freshElem = false;
        freshElem |= !this.mCongruenceClosure.hasElement(node1);
        freshElem |= !this.mCongruenceClosure.hasElement(node2);
        this.mManager.addNode(node1, this, true, true);
        this.mManager.addNode(node2, this, true, true);
        assert (this.mCongruenceClosure.assertAtMostOneLiteralPerEquivalenceClass());
        if (this.mCongruenceClosure.getEqualityStatus(node1, node2) == EqualityStatus.EQUAL) {
            return freshElem;
        }
        if (this.mCongruenceClosure.getEqualityStatus(node1, node2) == EqualityStatus.NOT_EQUAL) {
            this.mCongruenceClosure.reportEqualityToElementTVER(node1, node2);
            if (!this.mCongruenceClosure.isElementTverInconsistent()) {
                this.mCongruenceClosure.reportDisequalityToElementTver(node1, node2);
            }
            assert (this.mCongruenceClosure.isElementTverInconsistent());
            return true;
        }
        NODE node1OldRep = this.getRepresentativeElement(node1);
        NODE node2OldRep = this.getRepresentativeElement(node2);
        CcAuxData oldAuxData = new CcAuxData(this.mCongruenceClosure, this.mCongruenceClosure.getAuxData(), true);
        this.getWeakEquivalenceGraph().collapseEdgeAtMerge(node1OldRep, node2OldRep);
        Pair propInfo = this.mCongruenceClosure.doMergeAndComputePropagations(node1, node2);
        if (propInfo == null) {
            return true;
        }
        NODE newRep = this.getRepresentativeElement(node1);
        this.getWeakEquivalenceGraph().updateForNewRep(node1OldRep, node2OldRep, newRep);
        if (this.isInconsistent(false)) {
            return true;
        }
        CongruenceClosure.doFwccAndBwccPropagationsFromMerge((Pair)propInfo, (IEqualityReportingTarget)this);
        if (this.isInconsistent(false)) {
            return true;
        }
        if (!(this.mManager.getSettings().isDeactivateWeakEquivalences() || node1.dependsOnUntrackedArray() || node2.dependsOnUntrackedArray())) {
            this.doRoweqPropagationsOnMerge(node1, node2, node1OldRep, node2OldRep, oldAuxData, true);
        }
        if (this.isInconsistent(false)) {
            return true;
        }
        if (this.mManager.getSettings().isAlwaysReportChangeToGpa()) {
            this.reportGpaChangeToWeqGraphAndPropagateArrayEqualities(cc -> cc.reportEqualityRec((ICongruenceClosureElement)node1, (ICongruenceClosureElement)node2));
        }
        return true;
    }

    public NODE getRepresentativeElement(NODE elem) {
        return (NODE)((IEqNodeIdentifier)this.mCongruenceClosure.getRepresentativeElement(elem));
    }

    private void doRoweqPropagationsOnMerge(NODE node1, NODE node2, NODE node1OldRep, NODE node2OldRep, CcAuxData<NODE> oldAuxData, boolean omitSanityChecks) {
        CongruenceClosure<IEqNodeIdentifier> qUnequalI;
        IEqNodeIdentifier firstWeqVar;
        if (this.isInconsistent(false)) {
            return;
        }
        for (Map.Entry ccc1 : oldAuxData.getCcChildren(node1OldRep)) {
            IEqNodeIdentifier ccc1AfReplaced = (IEqNodeIdentifier)ccc1.getKey();
            IEqNodeIdentifier ccc1ArgReplaced = (IEqNodeIdentifier)ccc1.getValue();
            if (ccc1AfReplaced == null || ccc1ArgReplaced == null || ccc1AfReplaced.dependsOnUntrackedArray() || ccc1ArgReplaced.dependsOnUntrackedArray()) continue;
            for (Map.Entry ccc2 : oldAuxData.getCcChildren(node2OldRep)) {
                IEqNodeIdentifier ccc2AfReplaced = (IEqNodeIdentifier)ccc2.getKey();
                IEqNodeIdentifier ccc2ArgReplaced = (IEqNodeIdentifier)ccc2.getValue();
                if (ccc2AfReplaced == null || ccc2ArgReplaced == null) continue;
                assert (this.mCongruenceClosure.hasElements((ICongruenceClosureElement[])new IEqNodeIdentifier[]{ccc1AfReplaced, ccc1ArgReplaced, ccc2AfReplaced, ccc2ArgReplaced}));
                if (this.getEqualityStatus(ccc1ArgReplaced, ccc2ArgReplaced) != EqualityStatus.EQUAL) continue;
                firstWeqVar = this.mManager.getAllWeqVarsNodeForFunction(ccc1AfReplaced).get(0);
                qUnequalI = this.mManager.getSingleDisequalityCc(firstWeqVar, ccc1ArgReplaced, true);
                this.reportWeakEquivalenceDoOnlyRoweqPropagations(ccc1AfReplaced, ccc2AfReplaced, this.mManager.getSingletonEdgeLabel(this.getWeakEquivalenceGraph(), qUnequalI), omitSanityChecks);
            }
        }
        for (IEqNodeIdentifier ccp1 : oldAuxData.getArgCcPars(node1OldRep)) {
            for (IEqNodeIdentifier ccp2 : oldAuxData.getArgCcPars(node2OldRep)) {
                if (!ccp1.getSort().equals(ccp2.getSort())) continue;
                WeakEquivalenceEdgeLabel<IEqNodeIdentifier> aToBLabel = this.getCcWeakEquivalenceGraph().getEdgeLabel((IEqNodeIdentifier)ccp1.getAppliedFunction(), (IEqNodeIdentifier)ccp2.getAppliedFunction());
                WeakEquivalenceEdgeLabel<IEqNodeIdentifier> projectedLabel = this.getCcWeakEquivalenceGraph().projectEdgeLabelToPoint(aToBLabel, (IEqNodeIdentifier)ccp1.getArgument(), this.mManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)ccp1.getAppliedFunction()));
                if (!ccp1.dependsOnUntrackedArray() && !ccp2.dependsOnUntrackedArray()) {
                    this.reportWeakEquivalenceDoOnlyRoweqPropagations(ccp1, ccp2, projectedLabel, omitSanityChecks);
                }
                WeakEquivalenceEdgeLabel<IEqNodeIdentifier> aiToBjLabel = this.getCcWeakEquivalenceGraph().getEdgeLabel(ccp1, ccp2);
                WeakEquivalenceEdgeLabel<IEqNodeIdentifier> shiftedLabelWithException = this.getCcWeakEquivalenceGraph().shiftLabelAndAddException(aiToBjLabel, (IEqNodeIdentifier)node1, this.mManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)ccp1.getAppliedFunction()));
                if (!((IEqNodeIdentifier)ccp1.getAppliedFunction()).dependsOnUntrackedArray() && !((IEqNodeIdentifier)ccp2.getAppliedFunction()).dependsOnUntrackedArray()) {
                    this.reportWeakEquivalenceDoOnlyRoweqPropagations((IEqNodeIdentifier)ccp1.getAppliedFunction(), (IEqNodeIdentifier)ccp2.getAppliedFunction(), shiftedLabelWithException, omitSanityChecks);
                }
                if (this.getEqualityStatus(ccp1, ccp2) != EqualityStatus.EQUAL || ((IEqNodeIdentifier)ccp1.getAppliedFunction()).dependsOnUntrackedArray() || ((IEqNodeIdentifier)ccp2.getAppliedFunction()).dependsOnUntrackedArray()) continue;
                firstWeqVar = this.mManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)ccp1.getAppliedFunction()).get(0);
                assert (this.mManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)ccp1.getAppliedFunction()).equals(this.mManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)ccp2.getAppliedFunction())));
                assert (this.getEqualityStatus((IEqNodeIdentifier)ccp2.getArgument(), (IEqNodeIdentifier)ccp1.getArgument()) == EqualityStatus.EQUAL) : " propagation is only allowed if i = j";
                qUnequalI = this.mManager.getSingleDisequalityCc(firstWeqVar, (IEqNodeIdentifier)ccp1.getArgument(), true);
                this.reportWeakEquivalenceDoOnlyRoweqPropagations((IEqNodeIdentifier)ccp1.getAppliedFunction(), (IEqNodeIdentifier)ccp2.getAppliedFunction(), this.mManager.getSingletonEdgeLabel(this.getWeakEquivalenceGraph(), qUnequalI), omitSanityChecks);
            }
        }
        this.otherRoweqPropOnMerge(node1OldRep, oldAuxData, omitSanityChecks);
        this.otherRoweqPropOnMerge(node2OldRep, oldAuxData, omitSanityChecks);
    }

    public EqualityStatus getEqualityStatus(NODE node1, NODE node2) {
        return this.mCongruenceClosure.getEqualityStatus(node1, node2);
    }

    private boolean otherRoweqPropOnMerge(NODE nodeOldRep, CcAuxData<NODE> oldAuxData, boolean omitSanityChecks) {
        boolean madeChanges = false;
        for (Map.Entry ccc : oldAuxData.getCcChildren(nodeOldRep)) {
            for (Map.Entry<NODE, WeakEquivalenceEdgeLabel<NODE>> edgeAdjacentToNode : this.getCcWeakEquivalenceGraph().getAdjacentWeqEdges(nodeOldRep).entrySet()) {
                IEqNodeIdentifier cfr_ignored_0 = (IEqNodeIdentifier)edgeAdjacentToNode.getKey();
                WeakEquivalenceEdgeLabel<NODE> phi = edgeAdjacentToNode.getValue();
                if (!oldAuxData.getArgCcPars((ICongruenceClosureElement)((IEqNodeIdentifier)ccc.getValue())).contains(edgeAdjacentToNode.getKey())) continue;
                for (Map.Entry aj : oldAuxData.getCcChildren((ICongruenceClosureElement)((IEqNodeIdentifier)edgeAdjacentToNode.getKey()))) {
                    WeakEquivalenceEdgeLabel<IEqNodeIdentifier> shiftedLabelWithException = this.getCcWeakEquivalenceGraph().shiftLabelAndAddException(phi, (IEqNodeIdentifier)ccc.getValue(), this.mManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)ccc.getKey()));
                    madeChanges |= this.reportWeakEquivalenceDoOnlyRoweqPropagations((IEqNodeIdentifier)ccc.getKey(), (IEqNodeIdentifier)aj.getKey(), shiftedLabelWithException, omitSanityChecks);
                }
            }
        }
        return madeChanges;
    }

    boolean reportAllConstraintsFromWeqGraph(boolean omitSanityChecks) {
        if (!this.mManager.getSettings().omitSanitycheckFineGrained1()) assert (omitSanityChecks || this.sanityCheck());
        if (this.isInconsistent(false)) {
            assert (this.sanityCheck());
            return false;
        }
        boolean madeChanges = false;
        while (this.getWeakEquivalenceGraph().hasConstraintsToReport()) {
            WeakEquivalenceGraph.ConstraintFromWeqGraph aeq = this.getWeakEquivalenceGraph().pollStoredConstraintAndRemoveRelatedWeqEdge();
            if (aeq.isIsArrayEquality()) {
                madeChanges |= this.reportEquality((IEqNodeIdentifier)aeq.getEquality().getFirst(), (IEqNodeIdentifier)aeq.getEquality().getSecond(), omitSanityChecks);
            } else if (aeq.isSetConstraint()) {
                madeChanges = true;
                this.reportContainsConstraint((NODE)((IEqNodeIdentifier)aeq.getSetConstraint().getFirst()), (Collection<SetConstraint<NODE>>)Collections.singleton((SetConstraint)aeq.getSetConstraint().getSecond()));
            } else if (!aeq.isDummyConstraint()) {
                throw new AssertionError();
            }
            if (this.isInconsistent(false)) {
                assert (this.sanityCheck());
                assert (madeChanges);
                return true;
            }
            if (!this.mManager.getSettings().omitSanitycheckFineGrained1()) assert (omitSanityChecks || this.sanityCheck());
        }
        assert (omitSanityChecks || this.sanityCheck());
        assert (this.weqGraphFreeOfArrayEqualities());
        return madeChanges;
    }

    public boolean reportDisequality(NODE node1, NODE node2) {
        assert (!this.isFrozen());
        boolean result = this.reportDisequalityRec(node1, node2);
        assert (this.mManager.getSettings().omitSanitycheckFineGrained2() || this.sanityCheck());
        return result;
    }

    public boolean reportDisequalityRec(NODE node1, NODE node2) {
        boolean madeChanges = false;
        if (!(madeChanges |= this.mCongruenceClosure.reportDisequalityRec(node1, node2))) {
            return false;
        }
        if (this.isInconsistent(false)) {
            return true;
        }
        if (this.mManager.getSettings().isAlwaysReportChangeToGpa()) {
            this.reportGpaChangeToWeqGraphAndPropagateArrayEqualities(cc -> cc.reportDisequalityRec((ICongruenceClosureElement)node1, (ICongruenceClosureElement)node2));
            assert (this.weqGraphFreeOfArrayEqualities());
        }
        if (this.isInconsistent(false)) {
            return true;
        }
        return true;
    }

    public void reportContainsConstraint(NODE elem, Set<NODE> literalSet) {
        this.mCongruenceClosure.reportContainsConstraint(elem, literalSet);
        if (this.mManager.getSettings().isAlwaysReportChangeToGpa()) {
            throw new AssertionError((Object)"not implemented");
        }
    }

    public void reportContainsConstraint(NODE elem, Collection<SetConstraint<NODE>> setCc) {
        this.mCongruenceClosure.reportContainsConstraint(elem, setCc);
        if (this.mManager.getSettings().isAlwaysReportChangeToGpa()) {
            throw new AssertionError((Object)"not implemented");
        }
    }

    @Deprecated
    private boolean reportGpaChangeToWeqGraphAndPropagateArrayEqualities(Predicate<CongruenceClosure<NODE>> reporter) {
        assert (this.sanityCheck());
        if (this.isInconsistent(false)) {
            return false;
        }
        boolean madeChanges = false;
        madeChanges |= this.getCcWeakEquivalenceGraph().reportChangeInGroundPartialArrangement(reporter);
        this.reportAllConstraintsFromWeqGraph(false);
        assert (this.sanityCheck());
        return madeChanges;
    }

    public boolean isTautological() {
        if (this.mCongruenceClosure == null) {
            return false;
        }
        return this.mCongruenceClosure.isTautological() && this.getWeakEquivalenceGraph().isEmpty();
    }

    public boolean isStrongerThan(WeqCongruenceClosure<NODE> other) {
        assert (this.isClosed() && other.isClosed()) : "caller ensures this, right?";
        assert (this.getAllElements().equals(other.getAllElements()));
        if (this.isInconsistent()) {
            return true;
        }
        if (other.isTautological()) {
            return true;
        }
        if (this.isTautological()) {
            return false;
        }
        if (other.isInconsistent()) {
            return false;
        }
        if (!this.mManager.isStrongerThan(this.mCongruenceClosure, other.mCongruenceClosure)) {
            return false;
        }
        return this.mManager.isStrongerThan(this.getWeakEquivalenceGraph(), other.getWeakEquivalenceGraph());
    }

    public void fatten() {
        assert (!this.isFrozen());
        if (this.isInconsistent(false)) {
            return;
        }
        switch (this.mDiet) {
            case THIN: 
            case TRANSITORY_THIN_TO_CCFAT: {
                this.mDiet = Diet.TRANSITORY_THIN_TO_CCFAT;
                break;
            }
            case CCFAT: {
                this.mDiet = Diet.TRANSITORY_CCREFATTEN;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.mWeakEquivalenceGraphCcFat = this.getWeakEquivalenceGraph().ccFattenEdgeLabels();
        this.mWeakEquivalenceGraphThin = null;
        this.mDiet = Diet.CCFAT;
        assert (this.mManager.getSettings().omitSanitycheckFineGrained2() || this.sanityCheck());
    }

    public void extAndTriangleClosure(boolean omitSanityChecks) {
        if (this.mIsClosed) {
            return;
        }
        this.mManager.bmStart(WeqCcManager.WeqCcBmNames.EXT_AND_TRIANGLE_CLOSURE);
        WeqCongruenceClosure originalCopy = null;
        if (WeqCcManager.areAssertsEnabled() && this.mManager.mDebug) {
            this.mManager.getClass();
        }
        int loopCtr = 0;
        while (loopCtr++ < 10) {
            if (this.mManager.isDebugMode()) {
                this.mManager.getLogger().debug((Object)("ext and triangle closure, loop iteration #" + loopCtr));
            }
            boolean madeChanges = true;
            while (madeChanges) {
                if (this.isInconsistent(false)) {
                    assert (this.mManager.checkEquivalence(originalCopy, this));
                    this.mIsClosed = true;
                    this.mManager.bmEnd(WeqCcManager.WeqCcBmNames.EXT_AND_TRIANGLE_CLOSURE);
                    return;
                }
                assert (omitSanityChecks || this.sanityCheck());
                this.fatten();
                madeChanges = this.reportAllConstraintsFromWeqGraph(omitSanityChecks);
            }
            this.thin();
            assert (this.sanityCheck());
            this.executeFloydWarshallAndReportResultToWeqCc(omitSanityChecks);
            if (!this.getWeakEquivalenceGraph().hasConstraintsToReport()) {
                assert (this.mManager.checkEquivalence(originalCopy, this));
                this.mIsClosed = true;
                this.mManager.bmEnd(WeqCcManager.WeqCcBmNames.EXT_AND_TRIANGLE_CLOSURE);
                return;
            }
            this.reportAllConstraintsFromWeqGraph(omitSanityChecks);
        }
    }

    public Set<NODE> removeElementAndDependents(NODE elem, Set<NODE> elementsToRemove, Map<NODE, NODE> nodeToReplacementNode) {
        for (IEqNodeIdentifier etr : elementsToRemove) {
            this.getWeakEquivalenceGraph().replaceVertex(etr, (IEqNodeIdentifier)nodeToReplacementNode.get(etr));
        }
        Set<NODE> nodesToAddInGpa = this.getWeakEquivalenceGraph().projectAwaySimpleElementInEdgeLabels(elem);
        assert (nodesToAddInGpa.isEmpty()) : "we don't allow introduction of new nodes at labels if weare not in the meet-with-WeqGpa case";
        this.mCongruenceClosure.removeElements(elementsToRemove, nodeToReplacementNode);
        return nodesToAddInGpa;
    }

    public Set<NODE> getNodesToIntroduceBeforeRemoval(NODE elemToRemove, Set<NODE> elementsToRemove, Map<NODE, NODE> elemToRemoveToReplacement) {
        Set replByFwcc = this.mCongruenceClosure.getNodesToIntroduceBeforeRemoval(elemToRemove, elementsToRemove, elemToRemoveToReplacement);
        if (!replByFwcc.isEmpty()) {
            assert (replByFwcc.size() == 1);
            assert (DataStructureUtils.intersection((Set)this.mCongruenceClosure.getElementCurrentlyBeingRemoved().getRemovedElements(), (Set)replByFwcc).isEmpty());
            return replByFwcc;
        }
        boolean etrIsRemovedBecauseOfAf = elementsToRemove.contains(elemToRemove.getAppliedFunction());
        if (!etrIsRemovedBecauseOfAf) {
            return Collections.emptySet();
        }
        assert (elemToRemove.isFunctionApplication());
        HashSet<IEqNodeIdentifier> result = new HashSet<IEqNodeIdentifier>();
        boolean iToBeRemovedToo = elementsToRemove.contains(elemToRemove.getArgument());
        IEqNodeIdentifier jEqualToI = (IEqNodeIdentifier)this.mCongruenceClosure.getOtherEquivalenceClassMember((ICongruenceClosureElement)((IEqNodeIdentifier)elemToRemove.getArgument()), elementsToRemove);
        if (iToBeRemovedToo && jEqualToI == null) {
            return Collections.emptySet();
        }
        IEqNodeIdentifier j = iToBeRemovedToo ? jEqualToI : (IEqNodeIdentifier)elemToRemove.getArgument();
        for (Map.Entry<IEqNodeIdentifier, WeakEquivalenceEdgeLabel<IEqNodeIdentifier>> edge : this.getCcWeakEquivalenceGraph().getAdjacentWeqEdges((IEqNodeIdentifier)elemToRemove.getAppliedFunction()).entrySet()) {
            IEqNodeIdentifier bi;
            WeakEquivalenceEdgeLabel<IEqNodeIdentifier> projectedLabel;
            assert (!edge.getKey().equals(elemToRemove.getAppliedFunction()));
            if (elementsToRemove.contains(edge.getKey()) || (projectedLabel = this.getCcWeakEquivalenceGraph().projectEdgeLabelToPoint(edge.getValue(), (IEqNodeIdentifier)elemToRemove.getArgument(), this.mManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)elemToRemove.getAppliedFunction()))).isTautological()) continue;
            if (projectedLabel.isInconsistent()) {
                bi = (IEqNodeIdentifier)this.mManager.getEqNodeAndFunctionFactory().getOrConstructFuncAppElement(edge.getKey(), j);
                assert (!this.mCongruenceClosure.getElementCurrentlyBeingRemoved().getRemovedElements().contains(bi));
                elemToRemoveToReplacement.put(elemToRemove, bi);
                if (!this.mCongruenceClosure.hasElement((ICongruenceClosureElement)bi)) {
                    assert (this.assertNodeToAddIsEquivalentToOriginal(bi, elemToRemove));
                    return Collections.singleton(bi);
                }
                return Collections.emptySet();
            }
            if (projectedLabel.isTautological()) continue;
            bi = (IEqNodeIdentifier)this.mManager.getEqNodeAndFunctionFactory().getOrConstructFuncAppElement(edge.getKey(), j);
            if (this.mManager.getSettings().isIntroduceAtMostOneNodeForEachRemovedNode()) {
                assert (!this.mCongruenceClosure.getElementCurrentlyBeingRemoved().getRemovedElements().contains(bi));
                if (!this.hasElement((NODE)bi)) {
                    return Collections.singleton(bi);
                }
                return Collections.emptySet();
            }
            assert (!this.mCongruenceClosure.getElementCurrentlyBeingRemoved().getRemovedElements().contains(bi));
            if (this.hasElement((NODE)bi)) continue;
            result.add(bi);
        }
        return result;
    }

    private boolean assertNodeToAddIsEquivalentToOriginal(NODE nodeToAdd, NODE elemToRemove) {
        WeqCongruenceClosure<NODE> copy = this.mManager.copyWeqCc(this, true);
        this.mManager.addNode(nodeToAdd, copy, true, true);
        if (copy.getEqualityStatus(nodeToAdd, elemToRemove) != EqualityStatus.EQUAL) {
            assert (false);
            return false;
        }
        return true;
    }

    public boolean hasElement(NODE node) {
        return this.mCongruenceClosure.hasElement(node);
    }

    public boolean isConstrained(NODE elem) {
        if (this.mCongruenceClosure.isConstrained(elem)) {
            return true;
        }
        return this.getWeakEquivalenceGraph().isConstrained(elem);
    }

    private void registerNewElement(NODE elem) {
        if (this.isInconsistent(false)) {
            return;
        }
        if (!elem.isFunctionApplication()) {
            return;
        }
        boolean madeChanges = false;
        if (this.mManager.getSettings().isDeactivateWeakEquivalences() || elem.dependsOnUntrackedArray()) {
            return;
        }
        CongruenceClosure.constantFunctionTreatmentOnAddElement(elem, this.getWeakEquivalenceGraph().getAdjacentWeqEdges((IEqNodeIdentifier)elem.getAppliedFunction()).keySet(), (IEqualityReportingTarget)this);
        CongruenceClosure.mixFunctionTreatmentOnAddElement(elem, (e, lits) -> {
            WeqCongruenceClosure<IEqNodeIdentifier> weqCongruenceClosure = this.mManager.reportContainsConstraint((IEqNodeIdentifier)e, (Set<IEqNodeIdentifier>)lits, (WeqCongruenceClosure<IEqNodeIdentifier>)this, true);
        }, e -> {
            WeqCongruenceClosure<IEqNodeIdentifier> weqCongruenceClosure = this.mManager.addNode((IEqNodeIdentifier)e, this, true, true);
        }, this.getWeakEquivalenceGraph().getAdjacentWeqEdges((IEqNodeIdentifier)elem.getAppliedFunction()).keySet());
        for (IEqNodeIdentifier iEqNodeIdentifier : this.mCongruenceClosure.getArgCcPars((ICongruenceClosureElement)this.getRepresentativeElement((IEqNodeIdentifier)elem.getArgument()))) {
            if (!iEqNodeIdentifier.hasSameTypeAs((ICongruenceClosureElement)elem)) continue;
            assert (this.hasElements(new IEqNodeIdentifier[]{iEqNodeIdentifier, (IEqNodeIdentifier)iEqNodeIdentifier.getAppliedFunction(), (IEqNodeIdentifier)iEqNodeIdentifier.getArgument()}));
            if (this.getEqualityStatus((IEqNodeIdentifier)elem.getAppliedFunction(), (IEqNodeIdentifier)iEqNodeIdentifier.getAppliedFunction()) == EqualityStatus.EQUAL) continue;
            WeakEquivalenceEdgeLabel<IEqNodeIdentifier> weqEdgeLabelContents = this.getCcWeakEquivalenceGraph().getEdgeLabel((IEqNodeIdentifier)iEqNodeIdentifier.getAppliedFunction(), (IEqNodeIdentifier)elem.getAppliedFunction());
            WeakEquivalenceEdgeLabel<IEqNodeIdentifier> projectedLabel = this.getCcWeakEquivalenceGraph().projectEdgeLabelToPoint(weqEdgeLabelContents, (IEqNodeIdentifier)iEqNodeIdentifier.getArgument(), this.mManager.getAllWeqVarsNodeForFunction((IEqNodeIdentifier)iEqNodeIdentifier.getAppliedFunction()));
            if (!iEqNodeIdentifier.dependsOnUntrackedArray()) {
                madeChanges |= this.reportWeakEquivalenceDoOnlyRoweqPropagations(elem, iEqNodeIdentifier, projectedLabel, true);
            }
            if (!this.isInconsistent(false)) continue;
            return;
        }
        for (Map.Entry entry : this.getWeakEquivalenceGraph().getAdjacentWeqEdges((IEqNodeIdentifier)elem.getAppliedFunction()).entrySet()) {
            IEqNodeIdentifier weaklyEqualArray = (IEqNodeIdentifier)entry.getKey();
            if (!weaklyEqualArray.isConstantFunction() || !((IEqNodeIdentifier)weaklyEqualArray.getConstantFunctionValue()).isLiteral()) continue;
            IEqNodeIdentifier constantArrayConstant = (IEqNodeIdentifier)weaklyEqualArray.getConstantFunctionValue();
            assert (((IEqNodeIdentifier)weaklyEqualArray.getConstantFunctionValue()).isLiteral());
            IEqNodeIdentifier aQ = (IEqNodeIdentifier)elem.replaceArgument(this.mManager.getWeqVariableNodeForDimension(0, ((IEqNodeIdentifier)elem.getArgument()).getSort()));
            WeakEquivalenceEdgeLabel edgeLabel = (WeakEquivalenceEdgeLabel)entry.getValue();
            Set<SetConstraint<IEqNodeIdentifier>> containsConstraint = edgeLabel.getContainsConstraintForElement(aQ);
            if (containsConstraint == null) continue;
            Set newLiteralSet = this.mManager.getCcManager().getSetConstraintManager().join(this.mCongruenceClosure.getLiteralSetConstraints(), containsConstraint, Collections.singleton(this.mManager.getCcManager().getSetConstraintManager().buildSetConstraint(Collections.singleton(constantArrayConstant))));
            this.mCongruenceClosure.reportContainsConstraint(elem, (Collection)newLiteralSet);
            madeChanges = true;
        }
        this.mIsClosed = false;
    }

    public boolean hasElements(NODE ... elems) {
        return this.mCongruenceClosure.hasElements(elems);
    }

    public void transformElementsAndFunctions(Function<NODE, NODE> elemTransformer) {
        assert (!this.isFrozen());
        if (this.mCongruenceClosure.isFrozen()) {
            CongruenceClosure ccUnfrozen = this.mManager.getCcManager().unfreeze(this.mCongruenceClosure);
            ccUnfrozen.transformElementsAndFunctions(elemTransformer);
            this.updateCongruenceClosure(ccUnfrozen);
        } else {
            this.mCongruenceClosure.transformElementsAndFunctions(elemTransformer);
        }
        if (this.getWeakEquivalenceGraph().isFrozen()) {
            WeakEquivalenceGraph<NODE> weqGraphUnfrozen = this.mManager.unfreeze(this.getWeakEquivalenceGraph());
            weqGraphUnfrozen.transformElementsAndFunctions(elemTransformer);
            this.updateWeqGraph(weqGraphUnfrozen);
        } else {
            this.getWeakEquivalenceGraph().transformElementsAndFunctions(elemTransformer);
        }
        assert (this.sanityCheck());
    }

    private void updateWeqGraph(WeakEquivalenceGraph<NODE> weqGraphUnfrozen) {
        switch (this.mDiet) {
            case THIN: 
            case TRANSITORY_THIN_TO_CCFAT: {
                this.mWeakEquivalenceGraphThin = weqGraphUnfrozen;
                break;
            }
            case CCFAT: 
            case TRANSITORY_CCREFATTEN: {
                this.mWeakEquivalenceGraphCcFat = weqGraphUnfrozen;
            }
        }
    }

    private void updateCongruenceClosure(CongruenceClosure<NODE> ccUnfrozen) {
        assert (!this.isFrozen());
        this.mCongruenceClosure = ccUnfrozen;
    }

    public boolean assertSimpleElementIsFullyRemoved(NODE elem) {
        for (IEqNodeIdentifier e : this.getAllElements()) {
            if (!e.isDependentNonFunctionApplication() || !e.getSupportingNodes().contains(elem)) continue;
            assert (false);
            return false;
        }
        return this.mCongruenceClosure.assertSimpleElementIsFullyRemoved(elem);
    }

    public Set<NODE> getAllElements() {
        return this.mCongruenceClosure.getAllElements();
    }

    public boolean assertSingleElementIsFullyRemoved(NODE elem) {
        if (!this.getWeakEquivalenceGraph().assertElementIsFullyRemoved(elem)) {
            assert (false);
            return false;
        }
        return this.mCongruenceClosure.assertSingleElementIsFullyRemoved(elem);
    }

    WeqCongruenceClosure<NODE> join(WeqCongruenceClosure<NODE> other) {
        assert (this.isClosed() && other.isClosed());
        assert (!(this.isInconsistent(false) || other.isInconsistent(false) || this.isTautological() || other.isTautological())) : "catch this case in WeqCcManager";
        WeqCongruenceClosure<NODE> result = this.mManager.getWeqCongruenceClosure(this.mManager.join(this.mCongruenceClosure, other.mCongruenceClosure, true), this.mManager.join(this.getWeakEquivalenceGraph(), other.getWeakEquivalenceGraph(), true), true);
        return result;
    }

    WeqCongruenceClosure<NODE> meet(WeqCongruenceClosure<NODE> other) {
        assert (!this.getWeakEquivalenceGraph().hasConstraintsToReport());
        WeqCongruenceClosure<NODE> result = this.meetRec(other);
        this.mIsClosed = false;
        result.reportAllConstraintsFromWeqGraph(false);
        assert (result.sanityCheck());
        return result;
    }

    private WeqCongruenceClosure<NODE> meetRec(WeqCongruenceClosure<NODE> other) {
        WeqCongruenceClosure<IEqNodeIdentifier> result = this.meetWeqWithCc(other.mCongruenceClosure);
        this.reportAllConstraintsFromWeqGraph(false);
        assert (this.mManager.getSettings().omitSanitycheckFineGrained1() || result.sanityCheck());
        if (result.isInconsistent(false)) {
            return result;
        }
        assert (result.mCongruenceClosure.assertAtMostOneLiteralPerEquivalenceClass());
        assert (!this.getWeakEquivalenceGraph().hasConstraintsToReport());
        if (!this.mManager.getSettings().omitSanitycheckFineGrained1()) {
            assert (result.sanityCheck());
            assert (other.getWeakEquivalenceGraph().sanityCheck());
            assert (other.sanityCheck());
        }
        if (this.mManager.getSettings().isDeactivateWeakEquivalences()) {
            return result;
        }
        for (Map.Entry<Doubleton<NODE>, WeakEquivalenceEdgeLabel<NODE>> edge : other.getCcWeakEquivalenceGraph().getEdges().entrySet()) {
            result.reportWeakEquivalenceDoOnlyRoweqPropagations((IEqNodeIdentifier)edge.getKey().getOneElement(), (IEqNodeIdentifier)edge.getKey().getOtherElement(), edge.getValue(), true);
            assert (result.sanityCheck());
            if (!result.isInconsistent(false)) continue;
            return result;
        }
        return result;
    }

    public void freezeIfNecessary() {
        if (!this.isFrozen()) {
            this.freezeOmitPropagations();
        }
    }

    private WeqCongruenceClosure<NODE> meetWeqWithCc(CongruenceClosure<NODE> other) {
        assert (!this.isInconsistent(false) && !other.isInconsistent(false));
        WeqCongruenceClosure<Object> thisAligned = this.mManager.addAllElements(this, other.getAllElements(), null, true);
        for (Map.Entry eq : other.getSupportingElementEqualities().entrySet()) {
            if (thisAligned.isInconsistent(false)) {
                return this;
            }
            thisAligned = this.mManager.reportEquality(thisAligned, (IEqNodeIdentifier)eq.getKey(), (IEqNodeIdentifier)eq.getValue(), true);
        }
        for (Map.Entry deq : other.getElementDisequalities()) {
            if (thisAligned.isInconsistent(false)) {
                return this;
            }
            thisAligned = this.mManager.reportDisequality(thisAligned, (IEqNodeIdentifier)deq.getKey(), (IEqNodeIdentifier)deq.getValue(), true);
        }
        for (Map.Entry en : other.getLiteralSetConstraints().getConstraints().entrySet()) {
            if (thisAligned.isInconsistent(false)) {
                return this;
            }
            thisAligned = this.mManager.reportContainsConstraint((Object)((IEqNodeIdentifier)en.getKey()), ((SetConstraintConjunction)en.getValue()).getSetConstraints(), thisAligned, true);
        }
        assert (thisAligned.sanityCheck());
        return thisAligned;
    }

    public boolean sanityCheck() {
        if (this.isInconsistent(false)) {
            return true;
        }
        if (this.mIsFrozen != this.mCongruenceClosure.isFrozen()) {
            assert (false);
            return false;
        }
        boolean res = this.mCongruenceClosure.sanityCheck();
        if (this.getWeakEquivalenceGraph() != null) {
            res &= this.getWeakEquivalenceGraph().sanityCheck();
        }
        if (!this.isInconsistent(false)) {
            for (IEqNodeIdentifier el : this.getAllElements()) {
                if (!CongruenceClosure.dependsOnAny((ICongruenceClosureElement)el, this.mManager.getAllWeqPrimedNodes())) continue;
                assert (false);
                return false;
            }
        }
        return res;
    }

    public String toString() {
        if (this.isTautological()) {
            return "True";
        }
        if (this.isInconsistent(false)) {
            return "False";
        }
        if (this.getAllElements().size() < this.mManager.getSettings().getMaxNoElementsForVerboseToString()) {
            return this.toLogString();
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Partial arrangement:\n");
        sb.append(this.mCongruenceClosure.toString());
        sb.append("\n");
        if (this.getWeakEquivalenceGraph() != null) {
            sb.append("Weak equivalences:\n");
            sb.append(this.getWeakEquivalenceGraph().toString());
        } else {
            sb.append("weak equivalence graph is null\n");
        }
        return sb.toString();
    }

    public String toLogString() {
        if (this.isTautological()) {
            return "True";
        }
        if (this.isInconsistent(false)) {
            return "False";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Partial arrangement:\n");
        sb.append(this.mCongruenceClosure.toLogString());
        sb.append("\n");
        if (this.getWeakEquivalenceGraph() != null && !this.getWeakEquivalenceGraph().isEmpty()) {
            sb.append("Weak equivalences:\n");
            sb.append(this.getWeakEquivalenceGraph().toLogString());
        } else if (this.getWeakEquivalenceGraph() != null && this.getWeakEquivalenceGraph().isEmpty()) {
            sb.append("weak equivalence graph is empty\n");
        } else {
            sb.append("weak equivalence graph is null\n");
        }
        return sb.toString();
    }

    public boolean weqGraphFreeOfArrayEqualities() {
        if (this.getWeakEquivalenceGraph().hasConstraintsToReport()) {
            assert (false);
            return false;
        }
        return true;
    }

    public Integer getStatistics(VPStatistics stat) {
        switch (stat) {
            case MAX_WEQGRAPH_SIZE: {
                return this.getWeakEquivalenceGraph().getNumberOfEdgesStatistic();
            }
            case MAX_SIZEOF_WEQEDGELABEL: {
                return this.getWeakEquivalenceGraph().getMaxSizeOfEdgeLabelStatistic();
            }
            case NO_SUPPORTING_DISEQUALITIES: {
                HashRelation cleanedDeqs = new HashRelation();
                for (Map.Entry deq : this.mCongruenceClosure.getElementDisequalities()) {
                    if (cleanedDeqs.containsPair((Object)((IEqNodeIdentifier)deq.getValue()), (Object)((IEqNodeIdentifier)deq.getKey()))) continue;
                    cleanedDeqs.addPair((Object)((IEqNodeIdentifier)deq.getKey()), (Object)((IEqNodeIdentifier)deq.getValue()));
                }
                return cleanedDeqs.size();
            }
            case NO_SUPPORTING_EQUALITIES: {
                return this.mCongruenceClosure.getSupportingElementEqualities().size();
            }
        }
        return VPStatistics.getNonApplicableValue(stat);
    }

    public Set<NODE> collectElementsToRemove(NODE elem) {
        return this.mCongruenceClosure.collectElementsToRemove(elem);
    }

    public NODE getOtherEquivalenceClassMember(NODE node, Set<NODE> forbiddenSet) {
        return (NODE)((IEqNodeIdentifier)this.mCongruenceClosure.getOtherEquivalenceClassMember(node, forbiddenSet));
    }

    public boolean addElementRec(NODE node) {
        boolean newlyAdded = !this.mCongruenceClosure.hasElement(node);
        this.mManager.addNode(node, this.mCongruenceClosure, this, true, true);
        if (!newlyAdded) {
            return false;
        }
        this.registerNewElement(node);
        return true;
    }

    public IRemovalInfo<NODE> getElementCurrentlyBeingRemoved() {
        return this.mCongruenceClosure.getElementCurrentlyBeingRemoved();
    }

    public boolean isRepresentative(NODE elem) {
        return this.mCongruenceClosure.isRepresentative(elem);
    }

    public CongruenceClosure<NODE> getCongruenceClosure() {
        return this.mCongruenceClosure;
    }

    public void setElementCurrentlyBeingRemoved(IRemovalInfo<NODE> re) {
        this.mCongruenceClosure.setElementCurrentlyBeingRemoved(re);
    }

    public boolean isDebugMode() {
        return this.mLogger != null;
    }

    public ILogger getLogger() {
        return this.mLogger;
    }

    public WeakEquivalenceGraph<NODE> getCcWeakEquivalenceGraph() {
        assert (this.assertDietSanity());
        switch (this.mDiet) {
            case THIN: 
            case TRANSITORY_THIN_TO_CCFAT: {
                return this.mWeakEquivalenceGraphThin;
            }
            case CCFAT: 
            case TRANSITORY_CCREFATTEN: {
                return this.mWeakEquivalenceGraphCcFat;
            }
        }
        throw new AssertionError();
    }

    public WeakEquivalenceGraph<NODE> getWeakEquivalenceGraph() {
        assert (this.assertDietSanity());
        switch (this.mDiet) {
            case THIN: 
            case TRANSITORY_THIN_TO_CCFAT: {
                return this.mWeakEquivalenceGraphThin;
            }
            case CCFAT: 
            case TRANSITORY_CCREFATTEN: {
                return this.mWeakEquivalenceGraphCcFat;
            }
        }
        throw new AssertionError();
    }

    private boolean assertDietSanity() {
        switch (this.mDiet) {
            case THIN: 
            case TRANSITORY_THIN_TO_CCFAT: {
                if (this.mWeakEquivalenceGraphThin == null) {
                    assert (false);
                    return false;
                }
                if (this.mWeakEquivalenceGraphCcFat == null) break;
                assert (false);
                return false;
            }
            case CCFAT: 
            case TRANSITORY_CCREFATTEN: {
                if (this.mWeakEquivalenceGraphThin != null) {
                    assert (false);
                    return false;
                }
                if (this.mWeakEquivalenceGraphCcFat != null) break;
                assert (false);
                return false;
            }
        }
        return true;
    }

    public boolean sanityCheckOnlyCc() {
        return this.mCongruenceClosure.sanityCheck();
    }

    public boolean sanityCheckOnlyCc(IRemovalInfo<NODE> remInfo) {
        return this.mCongruenceClosure.sanityCheck(remInfo);
    }

    public void thin() {
        assert (!this.mIsFrozen);
        assert (this.mDiet != Diet.THIN);
        assert (this.assertDietSanity());
        if (this.mWeakEquivalenceGraphCcFat == null) {
            throw new AssertionError();
        }
        this.mWeakEquivalenceGraphThin = this.mWeakEquivalenceGraphCcFat.thinLabels(this);
        this.mWeakEquivalenceGraphCcFat = null;
        this.mDiet = Diet.THIN;
    }

    public Diet getDiet() {
        return this.mDiet;
    }

    public void setDiet(Diet newDiet) {
        this.mDiet = newDiet;
    }

    public void setIsEdgeLabelDisjunct() {
        this.mIsWeqFatEdgeLabel = true;
    }

    public WeqCcManager<NODE> getManager() {
        return this.mManager;
    }

    public Set<NODE> getAllLiterals() {
        return this.mCongruenceClosure.getAllLiterals();
    }

    public Set<SetConstraint<NODE>> getContainsConstraintForElement(NODE elem) {
        return this.mCongruenceClosure.getContainsConstraintForElement(elem);
    }

    public boolean isWeqFatEdgeLabel() {
        return this.mIsWeqFatEdgeLabel;
    }

    public boolean isClosed() {
        return this.mIsClosed;
    }

    public boolean isConstrainedDirectly(NODE elem) {
        throw new UnsupportedOperationException("we are not using weq fattening anymore, right? (otherwise: implement similarly as in CongruenceClosure..)");
    }
}

