/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ConstDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StringLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieArrayType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SMT;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.BoogieDeclarations;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.IBoogieSymbolTableVariableProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.ITerm2ExpressionSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.TypeSortTranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.DefaultIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.LocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.DeclarableFunctionSymbol;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.ISmtDeclarable;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public class Boogie2SmtSymbolTable
implements IIcfgSymbolTable,
IBoogieSymbolTableVariableProvider,
ITerm2ExpressionSymbolTable {
    public static final String ID_BUILTIN = "builtin";
    public static final String ID_SMTDEFINED = "smtdefined";
    private static final String ID_INDICES = "indices";
    private static final String ID_CONST_ARRAY = "const_array";
    private static final String ID_STRUCTPOS = "structpos";
    private final BoogieDeclarations mBoogieDeclarations;
    private final ManagedScript mScript;
    private final TypeSortTranslator mTypeSortTranslator;
    private final Map<String, ProgramNonOldVar> mGlobals = new HashMap<String, ProgramNonOldVar>();
    private final Map<String, ProgramOldVar> mOldGlobals = new HashMap<String, ProgramOldVar>();
    private final Map<String, Map<String, IProgramVar>> mSpecificationInParam = new HashMap<String, Map<String, IProgramVar>>();
    private final Map<String, Map<String, IProgramVar>> mSpecificationOutParam = new HashMap<String, Map<String, IProgramVar>>();
    private final Map<String, Map<String, IProgramVar>> mImplementationInParam = new HashMap<String, Map<String, IProgramVar>>();
    private final Map<String, Map<String, IProgramVar>> mImplementationOutParam = new HashMap<String, Map<String, IProgramVar>>();
    private final Map<String, List<ILocalProgramVar>> mProc2InParams = new HashMap<String, List<ILocalProgramVar>>();
    private final Map<String, List<ILocalProgramVar>> mProc2OutParams = new HashMap<String, List<ILocalProgramVar>>();
    private final Map<String, Map<String, LocalProgramVar>> mImplementationLocals = new HashMap<String, Map<String, LocalProgramVar>>();
    private final Map<String, ProgramConst> mConstants = new HashMap<String, ProgramConst>();
    private final Map<TermVariable, IProgramVar> mSmtVar2ProgramVar = new HashMap<TermVariable, IProgramVar>();
    private final Map<IProgramVar, DeclarationInformation> mProgramVar2DeclarationInformation = new HashMap<IProgramVar, DeclarationInformation>();
    private final Map<IProgramVar, BoogieASTNode> mProgramVar2AstNode = new HashMap<IProgramVar, BoogieASTNode>();
    private final Map<ApplicationTerm, ProgramConst> mSmtConst2ProgramConst = new HashMap<ApplicationTerm, ProgramConst>();
    private final Map<String, String> mBoogieFunction2SmtFunction = new HashMap<String, String>();
    private final Map<String, String> mSmtFunction2BoogieFunction = new HashMap<String, String>();
    private final Map<String, Map<String, Expression[]>> mBoogieFunction2Attributes = new HashMap<String, Map<String, Expression[]>>();
    private final DefaultIcfgSymbolTable mIcfgSymbolTable = new DefaultIcfgSymbolTable();

    public Boogie2SmtSymbolTable(BoogieDeclarations boogieDeclarations, ManagedScript script, TypeSortTranslator typeSortTranslator) {
        this.mScript = script;
        this.mTypeSortTranslator = typeSortTranslator;
        this.mBoogieDeclarations = boogieDeclarations;
        this.mScript.lock((Object)this);
        this.mScript.echo((Object)this, new QuotedObject("Start declaration of constants"));
        for (ConstDeclaration constDeclaration : this.mBoogieDeclarations.getConstDeclarations()) {
            this.declareConstants(constDeclaration);
        }
        this.mScript.echo((Object)this, new QuotedObject("Finished declaration of constants"));
        this.mScript.echo((Object)this, new QuotedObject("Start declaration of functions"));
        for (FunctionDeclaration functionDeclaration : this.mBoogieDeclarations.getFunctionDeclarations()) {
            this.declareFunction(functionDeclaration);
        }
        this.mScript.echo((Object)this, new QuotedObject("Finished declaration of functions"));
        this.mScript.echo((Object)this, new QuotedObject("Start declaration of global variables"));
        for (VariableDeclaration variableDeclaration : this.mBoogieDeclarations.getGlobalVarDeclarations()) {
            this.declareGlobalVariables(variableDeclaration);
        }
        this.mScript.echo((Object)this, new QuotedObject("Finished declaration global variables"));
        this.mScript.echo((Object)this, new QuotedObject("Start declaration of local variables"));
        for (String string : this.mBoogieDeclarations.getProcSpecification().keySet()) {
            Procedure procSpec = this.mBoogieDeclarations.getProcSpecification().get(string);
            Procedure procImpl = this.mBoogieDeclarations.getProcImplementation().get(string);
            if (procImpl == null) {
                this.declareSpec(procSpec);
                continue;
            }
            this.declareSpecImpl(procSpec, procImpl);
        }
        this.mScript.echo((Object)this, new QuotedObject("Finished declaration local variables"));
        this.mScript.unlock((Object)this);
    }

    private static <T extends IProgramVar> void putNew(String procId, String varId, T pv, Map<String, Map<String, T>> map) {
        Map<String, T> varId2ProgramVar = map.get(procId);
        if (varId2ProgramVar == null) {
            varId2ProgramVar = new HashMap<String, T>();
            map.put(procId, varId2ProgramVar);
        }
        IProgramVar previousValue = (IProgramVar)varId2ProgramVar.put(varId, pv);
        assert (previousValue == null) : "variable already contained";
    }

    private static <VALUE> void putNew(String varId, VALUE value, Map<String, VALUE> map) {
        VALUE previousValue = map.put(varId, value);
        assert (previousValue == null) : "variable already contained";
    }

    private static <T extends IProgramVar> T get(String varId, String procId, Map<String, Map<String, T>> map) {
        Map<String, T> varId2ProgramVar = map.get(procId);
        if (varId2ProgramVar == null) {
            return null;
        }
        return (T)((IProgramVar)varId2ProgramVar.get(varId));
    }

    public static boolean isSpecification(Procedure spec) {
        return spec.getSpecification() != null;
    }

    public static boolean isImplementation(Procedure impl) {
        return impl.getBody() != null;
    }

    @Override
    public IProgramVar getBoogieVar(String varId, DeclarationInformation declarationInformation, boolean inOldContext) {
        DeclarationInformation.StorageClass storageClass = declarationInformation.getStorageClass();
        String procedure = declarationInformation.getProcedure();
        switch (storageClass) {
            case GLOBAL: {
                if (inOldContext) {
                    return this.mOldGlobals.get(varId);
                }
                return this.mGlobals.get(varId);
            }
            case PROC_FUNC_INPARAM: 
            case IMPLEMENTATION_INPARAM: {
                return Boogie2SmtSymbolTable.get(varId, procedure, this.mImplementationInParam);
            }
            case PROC_FUNC_OUTPARAM: 
            case IMPLEMENTATION_OUTPARAM: {
                return Boogie2SmtSymbolTable.get(varId, procedure, this.mImplementationOutParam);
            }
            case LOCAL: {
                return Boogie2SmtSymbolTable.get(varId, procedure, this.mImplementationLocals);
            }
        }
        throw new AssertionError((Object)("inappropriate decl info " + declarationInformation));
    }

    @Override
    public IProgramVar getBoogieVar(String varId, String procedure, boolean isInParam) {
        if (isInParam) {
            return Boogie2SmtSymbolTable.get(varId, procedure, this.mImplementationInParam);
        }
        return Boogie2SmtSymbolTable.get(varId, procedure, this.mImplementationOutParam);
    }

    @Override
    public IProgramVar getProgramVar(TermVariable tv) {
        return this.mIcfgSymbolTable.getProgramVar(tv);
    }

    @Override
    public DeclarationInformation getDeclarationInformation(IProgramVar pv) {
        return this.mProgramVar2DeclarationInformation.get(pv);
    }

    public BoogieASTNode getAstNode(IProgramVar pv) {
        return this.mProgramVar2AstNode.get(pv);
    }

    private void declareConstants(ConstDeclaration constdecl) {
        String attributeDefinedIdentifier;
        VarList varlist = constdecl.getVarList();
        Map<String, Expression[]> attributes = Boogie2SmtSymbolTable.extractAttributes((Declaration)constdecl);
        if (attributes != null && (attributeDefinedIdentifier = Boogie2SmtSymbolTable.checkForAttributeDefinedIdentifier(attributes, ID_BUILTIN)) != null) {
            if (varlist.getIdentifiers().length > 1) {
                throw new IllegalArgumentException("if builtin identifier is used we support only one constant per const declaration");
            }
            String constId = varlist.getIdentifiers()[0];
            String[] indices = Boogie2SmtSymbolTable.checkForIndices(attributes);
            ApplicationTerm constant = (ApplicationTerm)this.mScript.term((Object)this, attributeDefinedIdentifier, indices, null, new Term[0]);
            ProgramConst programConst = new ProgramConst(constId, constant, true);
            ProgramConst previousValue = this.mConstants.put(constId, programConst);
            assert (previousValue == null) : "constant already contained";
            this.mSmtConst2ProgramConst.put(constant, programConst);
            this.mIcfgSymbolTable.add(programConst);
            return;
        }
        Sort[] paramTypes = new Sort[]{};
        IBoogieType iType = varlist.getType().getBoogieType();
        Sort sort = this.mTypeSortTranslator.getSort(iType, (BoogieASTNode)varlist);
        String[] stringArray = varlist.getIdentifiers();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String constId = stringArray[n2];
            this.mScript.declareFun((Object)this, constId, paramTypes, sort);
            ApplicationTerm constant = (ApplicationTerm)this.mScript.term((Object)this, constId, new Term[0]);
            ProgramConst programConst = new ProgramConst(constId, constant, false);
            ProgramConst previousValue = this.mConstants.put(constId, programConst);
            assert (previousValue == null) : "constant already contained";
            this.mSmtConst2ProgramConst.put(constant, programConst);
            this.mIcfgSymbolTable.add(programConst);
            ++n2;
        }
    }

    @Override
    public ProgramConst getBoogieConst(String constId) {
        return this.mConstants.get(constId);
    }

    @Override
    public ProgramConst getProgramConst(ApplicationTerm smtConstant) {
        return (ProgramConst)this.mIcfgSymbolTable.getProgramConst(smtConstant);
    }

    public Map<String, Expression[]> getAttributes(String boogieFunctionId) {
        return Collections.unmodifiableMap(this.mBoogieFunction2Attributes.get(boogieFunctionId));
    }

    private void declareFunction(FunctionDeclaration funcdecl) {
        String smtID;
        int ids;
        Map<String, Expression[]> attributes = Boogie2SmtSymbolTable.extractAttributes((Declaration)funcdecl);
        String id = funcdecl.getIdentifier();
        this.mBoogieFunction2Attributes.put(id, attributes);
        boolean attributeConstArray = Boogie2SmtSymbolTable.checkForAttributeWithoutValue(attributes, ID_CONST_ARRAY);
        String attributeDefinedIdentifier = Boogie2SmtSymbolTable.checkForAttributeDefinedIdentifier(attributes, ID_BUILTIN);
        String smtDefinedBody = Boogie2SmtSymbolTable.checkForAttributeDefinedIdentifier(attributes, ID_SMTDEFINED);
        int numParams = 0;
        VarList[] varListArray = funcdecl.getInParams();
        int n = varListArray.length;
        int n2 = 0;
        while (n2 < n) {
            VarList vl = varListArray[n2];
            ids = vl.getIdentifiers().length;
            numParams += ids == 0 ? 1 : ids;
            ++n2;
        }
        Sort[] paramSorts = new Sort[numParams];
        String[] paramIds = new String[numParams];
        int paramNr = 0;
        VarList[] varListArray2 = funcdecl.getInParams();
        int n3 = varListArray2.length;
        ids = 0;
        while (ids < n3) {
            VarList vl = varListArray2[ids];
            int ids2 = vl.getIdentifiers().length;
            if (ids2 == 0) {
                ids2 = 1;
            }
            IBoogieType paramType = vl.getType().getBoogieType();
            Sort paramSort = this.mTypeSortTranslator.getSort(paramType, (BoogieASTNode)funcdecl);
            int i = 0;
            while (i < ids2) {
                paramSorts[paramNr] = paramSort;
                paramIds[paramNr] = i < vl.getIdentifiers().length ? vl.getIdentifiers()[i] : null;
                ++paramNr;
                ++i;
            }
            ++ids;
        }
        IBoogieType resultType = funcdecl.getOutParam().getType().getBoogieType();
        Sort resultSort = this.mTypeSortTranslator.getSort(resultType, (BoogieASTNode)funcdecl);
        if (attributeConstArray) {
            int paramPos;
            smtID = Boogie2SMT.quoteId(id);
            String structPos = Boogie2SmtSymbolTable.checkForAttributeDefinedIdentifier(attributes, ID_STRUCTPOS);
            int n4 = paramPos = structPos == null ? 0 : Integer.parseInt(structPos);
            if (structPos == null && paramIds.length > 1) {
                throw new ISmtDeclarable.IllegalSmtDeclarableUsageException("Internal problem with expanding const-array function: " + id);
            }
            if (!(resultType instanceof BoogieArrayType) || ((BoogieArrayType)resultType).getValueType() != funcdecl.getInParams()[paramPos].getType().getBoogieType()) {
                throw new ISmtDeclarable.IllegalSmtDeclarableUsageException("Type mismatch in const-array function: " + id);
            }
            TermVariable[] paramTVs = new TermVariable[paramIds.length];
            int i = 0;
            while (i < paramTVs.length) {
                paramTVs[i] = this.mScript.getScript().variable(paramIds[i], paramSorts[i]);
                ++i;
            }
            ArrayDeque<Sort> sortHierarchy = new ArrayDeque<Sort>();
            Sort sort = resultSort;
            while (sort != paramSorts[paramPos]) {
                sortHierarchy.addLast(sort);
                assert (sort.getName().equals("Array"));
                sort = sort.getArguments()[1];
            }
            assert (sortHierarchy.size() >= 1);
            TermVariable smtBody = paramTVs[paramPos];
            while (!sortHierarchy.isEmpty()) {
                Sort arraySort = (Sort)sortHierarchy.removeLast();
                smtBody = this.mScript.getScript().term("const", null, arraySort, new Term[]{smtBody});
            }
            DeclarableFunctionSymbol smtFunctionDefinition = DeclarableFunctionSymbol.createFromScriptDefineFun((String)smtID, (TermVariable[])paramTVs, (Sort)resultSort, (Term)smtBody);
            smtFunctionDefinition.defineOrDeclare(this.mScript.getScript());
        } else if (attributeDefinedIdentifier == null) {
            smtID = Boogie2SMT.quoteId(id);
            DeclarableFunctionSymbol smtFunctionDefinition = DeclarableFunctionSymbol.createFromString((Script)this.mScript.getScript(), (String)smtID, (String)smtDefinedBody, (String[])paramIds, (Sort[])paramSorts, (Sort)resultSort);
            smtFunctionDefinition.defineOrDeclare(this.mScript.getScript());
        } else {
            smtID = attributeDefinedIdentifier;
            if (smtDefinedBody != null) {
                throw new ISmtDeclarable.IllegalSmtDeclarableUsageException(String.valueOf(id) + " has " + ID_SMTDEFINED + " and " + ID_BUILTIN + " attributes");
            }
        }
        this.mBoogieFunction2SmtFunction.put(id, smtID);
        this.mSmtFunction2BoogieFunction.put(smtID, id);
    }

    public static boolean checkForAttributeWithoutValue(Map<String, Expression[]> attributes, String n) {
        Expression[] values = attributes.get(n);
        if (values == null) {
            return false;
        }
        if (values.length == 0) {
            return true;
        }
        throw new IllegalArgumentException("Attribute has an argument: " + n);
    }

    public static String checkForAttributeDefinedIdentifier(Map<String, Expression[]> attributes, String n) {
        Expression[] values = attributes.get(n);
        if (values == null) {
            return null;
        }
        if (values.length == 1 && values[0] instanceof StringLiteral) {
            StringLiteral sl = (StringLiteral)values[0];
            return sl.getValue();
        }
        throw new IllegalArgumentException("Attribute has more than one argument or argument is not String: " + n);
    }

    public static String[] checkForIndices(Map<String, Expression[]> attributes) {
        Expression[] values = attributes.get(ID_INDICES);
        if (values == null) {
            return null;
        }
        String[] result = new String[values.length];
        int i = 0;
        while (i < values.length) {
            if (!(values[i] instanceof IntegerLiteral)) {
                throw new IllegalArgumentException("no single value attribute");
            }
            result[i] = ((IntegerLiteral)values[i]).getValue();
            ++i;
        }
        return result;
    }

    public static Map<String, Expression[]> extractAttributes(Declaration decl) {
        HashMap<String, Expression[]> result = new HashMap<String, Expression[]>();
        Attribute[] attributeArray = decl.getAttributes();
        int n = attributeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attr = attributeArray[n2];
            if (attr instanceof NamedAttribute) {
                NamedAttribute nattr = (NamedAttribute)attr;
                result.put(nattr.getName(), ((NamedAttribute)attr).getValues());
            }
            ++n2;
        }
        return result;
    }

    @Override
    public Map<String, String> getSmtFunction2BoogieFunction() {
        return Collections.unmodifiableMap(this.mSmtFunction2BoogieFunction);
    }

    public Map<String, String> getBoogieFunction2SmtFunction() {
        return Collections.unmodifiableMap(this.mBoogieFunction2SmtFunction);
    }

    private void declareGlobalVariables(VariableDeclaration vardecl) {
        VarList[] varListArray = vardecl.getVariables();
        int n = varListArray.length;
        int n2 = 0;
        while (n2 < n) {
            VarList vl = varListArray[n2];
            String[] stringArray = vl.getIdentifiers();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String id = stringArray[n4];
                IBoogieType type = vl.getType().getBoogieType();
                ProgramNonOldVar global = this.constructGlobalBoogieVar(id, type, vl);
                Boogie2SmtSymbolTable.putNew(id, global, this.mGlobals);
                ProgramOldVar oldGlobal = global.getOldVar();
                Boogie2SmtSymbolTable.putNew(id, oldGlobal, this.mOldGlobals);
                ++n4;
            }
            ++n2;
        }
    }

    @Override
    public Set<IProgramNonOldVar> getGlobals() {
        return this.mIcfgSymbolTable.getGlobals();
    }

    public Map<String, IProgramNonOldVar> getGlobalsMap() {
        return Collections.unmodifiableMap(this.mGlobals);
    }

    public Map<String, IProgramVar> getOldVars() {
        return Collections.unmodifiableMap(this.mOldGlobals);
    }

    @Override
    public Set<ILocalProgramVar> getLocals(String proc) {
        return this.mIcfgSymbolTable.getLocals(proc);
    }

    @Override
    public Set<IProgramConst> getConstants() {
        return this.mIcfgSymbolTable.getConstants();
    }

    public Map<String, ProgramConst> getConstsMap() {
        return Collections.unmodifiableMap(this.mConstants);
    }

    private void declareSpecImpl(Procedure spec, Procedure impl) {
        DeclarationInformation declInfoOutParam;
        DeclarationInformation declInfoInParam;
        String procId = spec.getIdentifier();
        assert (procId.equals(impl.getIdentifier()));
        if (spec == impl) {
            declInfoInParam = new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, procId);
            declInfoOutParam = new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM, procId);
        } else {
            assert (Boogie2SmtSymbolTable.isSpecAndImpl(spec, impl));
            declInfoInParam = new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_INPARAM, procId);
            declInfoOutParam = new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM, procId);
        }
        this.declareParams(procId, spec.getInParams(), impl.getInParams(), this.mSpecificationInParam, this.mImplementationInParam, declInfoInParam, this.mProc2InParams);
        this.declareParams(procId, spec.getOutParams(), impl.getOutParams(), this.mSpecificationOutParam, this.mImplementationOutParam, declInfoOutParam, this.mProc2OutParams);
        this.declareLocals(impl);
    }

    private static boolean isSpecAndImpl(Procedure spec, Procedure impl) {
        return Boogie2SmtSymbolTable.isSpecification(spec) && !Boogie2SmtSymbolTable.isImplementation(spec) && Boogie2SmtSymbolTable.isImplementation(impl) && !Boogie2SmtSymbolTable.isSpecification(impl);
    }

    private void declareSpec(Procedure spec) {
        assert (Boogie2SmtSymbolTable.isSpecification(spec)) : "no specification";
        assert (!Boogie2SmtSymbolTable.isImplementation(spec)) : "is implementation";
        String procId = spec.getIdentifier();
        this.declareParams(procId, spec.getInParams(), this.mSpecificationInParam, new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, procId), this.mProc2InParams);
        this.declareParams(procId, spec.getOutParams(), this.mSpecificationOutParam, new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_OUTPARAM, procId), this.mProc2OutParams);
    }

    private void declareParams(String procId, VarList[] specVl, VarList[] implVl, Map<String, Map<String, IProgramVar>> specMap, Map<String, Map<String, IProgramVar>> implMap, DeclarationInformation declarationInformation, Map<String, List<ILocalProgramVar>> proc2params) {
        if (specVl.length != implVl.length) {
            throw new IllegalArgumentException("specification and implementation have different param length");
        }
        ArrayList<LocalProgramVar> params = new ArrayList<LocalProgramVar>();
        List previous = proc2params.put(procId, Collections.unmodifiableList(params));
        if (previous != null) {
            throw new AssertionError((Object)("params for procedure " + procId + " already added"));
        }
        int i = 0;
        while (i < specVl.length) {
            String[] implIds;
            IBoogieType implType;
            IBoogieType specType = specVl[i].getType().getBoogieType();
            if (!specType.equals(implType = implVl[i].getType().getBoogieType())) {
                throw new IllegalArgumentException("specification and implementation have different types");
            }
            String[] specIds = specVl[i].getIdentifiers();
            if (specIds.length != (implIds = implVl[i].getIdentifiers()).length) {
                throw new IllegalArgumentException("specification and implementation have different param length");
            }
            int j = 0;
            while (j < specIds.length) {
                LocalProgramVar pv = this.constructLocalProgramVar(implIds[j], procId, implType, implVl[i], declarationInformation);
                Boogie2SmtSymbolTable.putNew(procId, implIds[j], pv, implMap);
                Boogie2SmtSymbolTable.putNew(procId, specIds[j], pv, specMap);
                params.add(pv);
                ++j;
            }
            ++i;
        }
    }

    private void declareParams(String procId, VarList[] vl, Map<String, Map<String, IProgramVar>> specMap, DeclarationInformation declarationInformation, Map<String, List<ILocalProgramVar>> proc2params) {
        ArrayList<LocalProgramVar> params = new ArrayList<LocalProgramVar>();
        List previous = proc2params.put(procId, Collections.unmodifiableList(params));
        if (previous != null) {
            throw new AssertionError((Object)("params for procedure " + procId + " already added"));
        }
        int i = 0;
        while (i < vl.length) {
            IBoogieType type = vl[i].getType().getBoogieType();
            String[] ids = vl[i].getIdentifiers();
            int j = 0;
            while (j < ids.length) {
                LocalProgramVar pv = this.constructLocalProgramVar(ids[j], procId, type, vl[i], declarationInformation);
                Boogie2SmtSymbolTable.putNew(procId, ids[j], pv, specMap);
                params.add(pv);
                ++j;
            }
            ++i;
        }
    }

    public void declareLocals(Procedure proc) {
        if (proc.getBody() != null) {
            DeclarationInformation declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.LOCAL, proc.getIdentifier());
            VariableDeclaration[] variableDeclarationArray = proc.getBody().getLocalVars();
            int n = variableDeclarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                VariableDeclaration vdecl = variableDeclarationArray[n2];
                VarList[] varListArray = vdecl.getVariables();
                int n3 = varListArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    VarList vl = varListArray[n4];
                    String[] stringArray = vl.getIdentifiers();
                    int n5 = stringArray.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        String id = stringArray[n6];
                        IBoogieType type = vl.getType().getBoogieType();
                        LocalProgramVar pv = this.constructLocalProgramVar(id, proc.getIdentifier(), type, vl, declarationInformation);
                        Boogie2SmtSymbolTable.putNew(proc.getIdentifier(), id, pv, this.mImplementationLocals);
                        ++n6;
                    }
                    ++n4;
                }
                ++n2;
            }
        }
    }

    public LocalProgramVar constructLocalProgramVar(String identifier, String procedure, IBoogieType iType, VarList varList, DeclarationInformation declarationInformation) {
        Sort sort = this.mTypeSortTranslator.getSort(iType, (BoogieASTNode)varList);
        String name = ProgramVarUtils.buildBoogieVarName(identifier, procedure, false, false);
        TermVariable termVariable = this.mScript.variable(name, sort);
        ApplicationTerm defaultConstant = ProgramVarUtils.constructDefaultConstant(this.mScript, this, sort, name);
        ApplicationTerm primedConstant = ProgramVarUtils.constructPrimedConstant(this.mScript, this, sort, name);
        LocalProgramVar pv = new LocalProgramVar(identifier, procedure, termVariable, defaultConstant, primedConstant);
        this.mSmtVar2ProgramVar.put(termVariable, pv);
        this.mProgramVar2DeclarationInformation.put(pv, declarationInformation);
        this.mProgramVar2AstNode.put(pv, (BoogieASTNode)varList);
        this.mIcfgSymbolTable.add(pv);
        return pv;
    }

    private ProgramNonOldVar constructGlobalBoogieVar(String identifier, IBoogieType iType, VarList varlist) {
        Sort sort = this.mTypeSortTranslator.getSort(iType, (BoogieASTNode)varlist);
        DeclarationInformation declarationInformation = new DeclarationInformation(DeclarationInformation.StorageClass.GLOBAL, null);
        ProgramNonOldVar nonOldVar = ProgramVarUtils.constructGlobalProgramVarPair(identifier, sort, this.mScript, this);
        this.mSmtVar2ProgramVar.put(nonOldVar.getTermVariable(), nonOldVar);
        this.mProgramVar2DeclarationInformation.put(nonOldVar, declarationInformation);
        this.mProgramVar2AstNode.put(nonOldVar, (BoogieASTNode)varlist);
        ProgramOldVar oldVar = nonOldVar.getOldVar();
        this.mSmtVar2ProgramVar.put(oldVar.getTermVariable(), oldVar);
        this.mProgramVar2DeclarationInformation.put(oldVar, declarationInformation);
        this.mProgramVar2AstNode.put(oldVar, (BoogieASTNode)varlist);
        this.mIcfgSymbolTable.add(nonOldVar);
        return nonOldVar;
    }

    public HashRelation<String, IProgramNonOldVar> constructProc2ModifiableGlobalsMapping() {
        HashRelation result = new HashRelation();
        for (Map.Entry<String, Set<String>> proc2vars : this.mBoogieDeclarations.getModifiedVars().entrySet()) {
            for (String var : proc2vars.getValue()) {
                IProgramNonOldVar pv = this.getGlobalsMap().get(var);
                result.addPair((Object)proc2vars.getKey(), (Object)pv);
            }
        }
        HashSet<String> procedures = new HashSet<String>();
        for (String procId : this.mSpecificationInParam.keySet()) {
            procedures.add(procId);
        }
        for (String procId : this.mImplementationInParam.keySet()) {
            procedures.add(procId);
        }
        return result;
    }

    @Override
    public ILocation getLocation(IProgramVar pv) {
        BoogieASTNode astNode = this.getAstNode(pv);
        assert (astNode != null) : "There is no AstNode for the IProgramVar " + pv;
        ILocation loc = astNode.getLocation();
        return loc;
    }

    public Map<String, List<ILocalProgramVar>> getProc2InParams() {
        return Collections.unmodifiableMap(this.mProc2InParams);
    }

    public Map<String, List<ILocalProgramVar>> getProc2OutParams() {
        return Collections.unmodifiableMap(this.mProc2OutParams);
    }

    @Override
    public Set<ApplicationTerm> computeAllDefaultConstants() {
        LinkedHashSet<ApplicationTerm> rtr = new LinkedHashSet<ApplicationTerm>();
        Function<IProgramVar, ApplicationTerm> fun = IProgramVar::getDefaultConstant;
        Boogie2SmtSymbolTable.getAll(this.mSpecificationInParam, fun).forEachOrdered(rtr::add);
        Boogie2SmtSymbolTable.getAll(this.mSpecificationOutParam, fun).forEachOrdered(rtr::add);
        Boogie2SmtSymbolTable.getAll(this.mImplementationInParam, fun).forEachOrdered(rtr::add);
        Boogie2SmtSymbolTable.getAll(this.mImplementationOutParam, fun).forEachOrdered(rtr::add);
        this.mImplementationLocals.entrySet().stream().flatMap(a -> ((Map)a.getValue()).entrySet().stream()).map(a -> (ApplicationTerm)fun.apply((IProgramVar)a.getValue())).forEachOrdered(rtr::add);
        this.mProc2InParams.entrySet().stream().flatMap(a -> ((List)a.getValue()).stream()).map(fun::apply).forEachOrdered(rtr::add);
        this.mProc2OutParams.entrySet().stream().flatMap(a -> ((List)a.getValue()).stream()).map(fun::apply).forEachOrdered(rtr::add);
        this.mGlobals.entrySet().stream().map(a -> (ApplicationTerm)fun.apply((IProgramVar)a.getValue())).forEachOrdered(rtr::add);
        this.mOldGlobals.entrySet().stream().map(a -> (ApplicationTerm)fun.apply((IProgramVar)a.getValue())).forEachOrdered(rtr::add);
        return rtr;
    }

    private static <V, T, K1, K2> Stream<T> getAll(Map<K1, Map<K2, V>> map, Function<V, T> fun) {
        return map.entrySet().stream().flatMap(a -> ((Map)a.getValue()).entrySet().stream()).map(a -> fun.apply(a.getValue()));
    }
}

