/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Axiom;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ConstDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.EnsuresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LoopInvariantSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ModifiesSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RequiresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.TypeDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.RenameProcedureSpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class BoogieDeclarations {
    private final ILogger mLogger;
    private final List<Axiom> mAxioms = new ArrayList<Axiom>();
    private final List<TypeDeclaration> mTypeDeclarations = new ArrayList<TypeDeclaration>();
    private final List<ConstDeclaration> mConstDeclarations = new ArrayList<ConstDeclaration>();
    private final List<FunctionDeclaration> mFunctionDeclarations = new ArrayList<FunctionDeclaration>();
    private final List<VariableDeclaration> mGlobalVarDeclarations = new ArrayList<VariableDeclaration>();
    private final Map<String, Procedure> mProcSpecification = new HashMap<String, Procedure>();
    private final Map<String, Procedure> mProcImplementation = new HashMap<String, Procedure>();
    private final Map<String, List<RequiresSpecification>> mRequires = new HashMap<String, List<RequiresSpecification>>();
    private final Map<String, List<RequiresSpecification>> mRequiresNonFree = new HashMap<String, List<RequiresSpecification>>();
    private final Map<String, List<EnsuresSpecification>> mEnsures = new HashMap<String, List<EnsuresSpecification>>();
    private final Map<String, List<EnsuresSpecification>> mEnsuresNonFree = new HashMap<String, List<EnsuresSpecification>>();
    private final Map<String, Set<String>> mModifiedVars = new HashMap<String, Set<String>>();

    public BoogieDeclarations(Collection<Declaration> decls, ILogger logger) {
        this.mLogger = logger;
        for (Declaration decl : decls) {
            if (decl instanceof Axiom) {
                this.mAxioms.add((Axiom)decl);
                continue;
            }
            if (decl instanceof TypeDeclaration) {
                this.mTypeDeclarations.add((TypeDeclaration)decl);
                continue;
            }
            if (decl instanceof ConstDeclaration) {
                this.mConstDeclarations.add((ConstDeclaration)decl);
                continue;
            }
            if (decl instanceof FunctionDeclaration) {
                this.mFunctionDeclarations.add((FunctionDeclaration)decl);
                continue;
            }
            if (decl instanceof VariableDeclaration) {
                this.mGlobalVarDeclarations.add((VariableDeclaration)decl);
                continue;
            }
            if (decl instanceof Procedure) {
                Procedure proc = (Procedure)decl;
                if (proc.getSpecification() != null && proc.getBody() != null) {
                    this.mLogger.info((Object)String.format("Specification and implementation of procedure %s given in one single declaration", proc.getIdentifier()));
                }
                if (proc.getSpecification() != null) {
                    this.mLogger.info((Object)("Found specification of procedure " + proc.getIdentifier()));
                    if (this.mProcSpecification.containsKey(proc.getIdentifier())) {
                        throw new UnsupportedOperationException("Procedure" + proc.getIdentifier() + "declarated twice");
                    }
                    this.mProcSpecification.put(proc.getIdentifier(), proc);
                }
                if (proc.getBody() == null) continue;
                this.mLogger.info((Object)("Found implementation of procedure " + proc.getIdentifier()));
                if (this.mProcImplementation.containsKey(proc.getIdentifier())) {
                    throw new UnsupportedOperationException("File contains two implementations of procedure" + proc.getIdentifier());
                }
                this.mProcImplementation.put(proc.getIdentifier(), proc);
                continue;
            }
            throw new AssertionError((Object)("Unknown Declaration" + decl));
        }
        for (Procedure proc : this.mProcSpecification.values()) {
            this.extractContract(proc.getIdentifier());
        }
    }

    public BoogieDeclarations(Declaration[] decls, ILogger logger) {
        this(Arrays.asList(decls), logger);
    }

    public BoogieDeclarations(Unit unit, ILogger logger) {
        this(unit.getDeclarations(), logger);
    }

    private void extractContract(String procId) {
        Specification[] specifications;
        Procedure procImpl;
        Procedure procSpec = this.mProcSpecification.get(procId);
        if (procSpec != (procImpl = this.mProcImplementation.get(procId)) && procImpl != null) {
            RenameProcedureSpec renamer = new RenameProcedureSpec();
            specifications = renamer.renameSpecs(procSpec, procImpl);
        } else {
            specifications = procSpec.getSpecification();
        }
        ArrayList<EnsuresSpecification> ensures = new ArrayList<EnsuresSpecification>();
        ArrayList<EnsuresSpecification> ensuresNonFree = new ArrayList<EnsuresSpecification>();
        ArrayList<RequiresSpecification> requires = new ArrayList<RequiresSpecification>();
        ArrayList<RequiresSpecification> requiresNonFree = new ArrayList<RequiresSpecification>();
        HashSet<String> modifiedVars = new HashSet<String>();
        Specification[] specificationArray = specifications;
        int n = specifications.length;
        int n2 = 0;
        while (n2 < n) {
            Specification spec = specificationArray[n2];
            if (spec instanceof EnsuresSpecification) {
                EnsuresSpecification ensSpec = (EnsuresSpecification)spec;
                ensures.add(ensSpec);
                if (!ensSpec.isFree()) {
                    ensuresNonFree.add(ensSpec);
                }
            } else if (spec instanceof RequiresSpecification) {
                RequiresSpecification recSpec = (RequiresSpecification)spec;
                requires.add(recSpec);
                if (!recSpec.isFree()) {
                    requiresNonFree.add(recSpec);
                }
            } else {
                if (spec instanceof LoopInvariantSpecification) {
                    this.mLogger.debug((Object)("Found LoopInvariantSpecification" + spec + "but this plugin does not use loop invariants."));
                    throw new IllegalArgumentException("LoopInvariantSpecification may not occur in procedure constract");
                }
                if (spec instanceof ModifiesSpecification) {
                    ModifiesSpecification modSpec = (ModifiesSpecification)spec;
                    VariableLHS[] variableLHSArray = modSpec.getIdentifiers();
                    int n3 = variableLHSArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        VariableLHS var = variableLHSArray[n4];
                        String ident = var.getIdentifier();
                        modifiedVars.add(ident);
                        ++n4;
                    }
                } else {
                    throw new UnsupportedOperationException("Unknown type of specification)");
                }
            }
            this.mEnsures.put(procId, ensures);
            this.mEnsuresNonFree.put(procId, ensuresNonFree);
            this.mRequires.put(procId, requires);
            this.mRequiresNonFree.put(procId, requiresNonFree);
            ++n2;
        }
        this.mModifiedVars.put(procId, modifiedVars);
    }

    public List<Axiom> getAxioms() {
        return this.mAxioms;
    }

    public List<TypeDeclaration> getTypeDeclarations() {
        return this.mTypeDeclarations;
    }

    public List<ConstDeclaration> getConstDeclarations() {
        return this.mConstDeclarations;
    }

    public List<FunctionDeclaration> getFunctionDeclarations() {
        return this.mFunctionDeclarations;
    }

    public List<VariableDeclaration> getGlobalVarDeclarations() {
        return this.mGlobalVarDeclarations;
    }

    public Map<String, Procedure> getProcSpecification() {
        return this.mProcSpecification;
    }

    public Map<String, Procedure> getProcImplementation() {
        return this.mProcImplementation;
    }

    public Map<String, List<RequiresSpecification>> getRequires() {
        return this.mRequires;
    }

    public Map<String, List<RequiresSpecification>> getRequiresNonFree() {
        return this.mRequiresNonFree;
    }

    public Map<String, List<EnsuresSpecification>> getEnsures() {
        return this.mEnsures;
    }

    public Map<String, List<EnsuresSpecification>> getEnsuresNonFree() {
        return this.mEnsuresNonFree;
    }

    public Map<String, Set<String>> getModifiedVars() {
        return this.mModifiedVars;
    }
}

