/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitvecLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SmtSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.IOperationTranslator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigInteger;

public class DefaultOperationTranslator
implements IOperationTranslator {
    protected final Boogie2SmtSymbolTable mBoogie2SmtSymbolTable;
    protected final Script mScript;

    public DefaultOperationTranslator(Boogie2SmtSymbolTable symbolTable, Script script) {
        this.mBoogie2SmtSymbolTable = symbolTable;
        this.mScript = script;
    }

    @Override
    public String opTranslation(BinaryExpression.Operator op, IBoogieType type1, IBoogieType type2) {
        if (op == BinaryExpression.Operator.COMPEQ) {
            return "=";
        }
        if (op == BinaryExpression.Operator.COMPGEQ) {
            return ">=";
        }
        if (op == BinaryExpression.Operator.COMPGT) {
            return ">";
        }
        if (op == BinaryExpression.Operator.COMPLEQ) {
            return "<=";
        }
        if (op == BinaryExpression.Operator.COMPLT) {
            return "<";
        }
        if (op == BinaryExpression.Operator.COMPNEQ) {
            throw new UnsupportedOperationException();
        }
        if (op == BinaryExpression.Operator.LOGICAND) {
            return "and";
        }
        if (op == BinaryExpression.Operator.LOGICOR) {
            return "or";
        }
        if (op == BinaryExpression.Operator.LOGICIMPLIES) {
            return "=>";
        }
        if (op == BinaryExpression.Operator.LOGICIFF) {
            return "=";
        }
        if (op == BinaryExpression.Operator.ARITHDIV) {
            IBoogieType type;
            IBoogieType iBoogieType = type = type1 == null ? type2 : type1;
            if (type instanceof BoogiePrimitiveType) {
                BoogiePrimitiveType primType = (BoogiePrimitiveType)type;
                if (primType.getTypeCode() == -2) {
                    return "div";
                }
                if (primType.getTypeCode() == -3) {
                    return "/";
                }
                throw new AssertionError((Object)("ARITHDIV of this type not allowed: " + type));
            }
            throw new AssertionError((Object)("ARITHDIV of this type not allowed: " + type));
        }
        if (op == BinaryExpression.Operator.ARITHMINUS) {
            return "-";
        }
        if (op == BinaryExpression.Operator.ARITHMOD) {
            return "mod";
        }
        if (op == BinaryExpression.Operator.ARITHMUL) {
            return "*";
        }
        if (op == BinaryExpression.Operator.ARITHPLUS) {
            return "+";
        }
        if (op == BinaryExpression.Operator.BITVECCONCAT) {
            return "concat";
        }
        throw new AssertionError((Object)("Unsupported binary expression " + op));
    }

    @Override
    public String opTranslation(UnaryExpression.Operator op, IBoogieType type) {
        if (op == UnaryExpression.Operator.LOGICNEG) {
            return "not";
        }
        if (op == UnaryExpression.Operator.ARITHNEGATIVE) {
            return "-";
        }
        throw new AssertionError((Object)("Unsupported unary expression " + op));
    }

    @Override
    public String funcApplication(String funcIdentifier, IBoogieType[] argumentTypes) {
        return this.mBoogie2SmtSymbolTable.getBoogieFunction2SmtFunction().get(funcIdentifier);
    }

    @Override
    public Term booleanTranslation(BooleanLiteral exp) {
        return exp.getValue() ? this.mScript.term("true", new Term[0]) : this.mScript.term("false", new Term[0]);
    }

    @Override
    public Term bitvecTranslation(BitvecLiteral exp) {
        String[] indices = new String[]{String.valueOf(exp.getLength())};
        return this.mScript.term("bv" + exp.getValue(), indices, null, new Term[0]);
    }

    @Override
    public Term integerTranslation(IntegerLiteral exp) {
        BigInteger bigInt = new BigInteger(exp.getValue());
        Rational rat = SmtUtils.toRational((BigInteger)bigInt);
        return rat.toTerm(SmtSortUtils.getIntSort((Script)this.mScript));
    }

    @Override
    public Term realTranslation(RealLiteral exp) {
        Rational rat = SmtUtils.toRational((String)exp.getValue());
        return rat.toTerm(SmtSortUtils.getRealSort((Script)this.mScript));
    }
}

