/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.BitvectorFactory;
import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayStoreExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitVectorAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitvecLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfThenElseExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.QuantifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Trigger;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SMT;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SmtSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.IOperationTranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.TypeSortTranslator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.BitvectorConstant;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class Expression2Term {
    private final Script mScript;
    private final TypeSortTranslator mTypeSortTranslator;
    private final IOperationTranslator mOperationTranslator;
    private final Boogie2SmtSymbolTable mBoogie2SmtSymbolTable;
    private final ManagedScript mVariableManager;
    private final boolean mOverapproximateFunctions = false;
    private final ScopedHashMap<String, TermVariable> mQuantifiedVariables = new ScopedHashMap();
    private IIdentifierTranslator[] mSmtIdentifierProviders;
    private Map<String, ILocation> mOverapproximations = null;
    private Collection<TermVariable> mAuxVars = null;
    private int mOldContextScopeDepth = 0;
    private final IUltimateServiceProvider mServices;
    private static final String OVERAPPROXIMATION = "overapproximation";

    public Expression2Term(IUltimateServiceProvider services, Script script, TypeSortTranslator typeSortTranslator, Boogie2SmtSymbolTable boogie2SmtSymbolTable, IOperationTranslator operationTranslator, ManagedScript variableManager) {
        this.mServices = services;
        this.mScript = script;
        this.mTypeSortTranslator = typeSortTranslator;
        this.mBoogie2SmtSymbolTable = boogie2SmtSymbolTable;
        this.mOperationTranslator = operationTranslator;
        this.mVariableManager = variableManager;
    }

    public SingleTermResult translateToTerm(IIdentifierTranslator[] identifierTranslators, Expression expression) {
        assert (this.mSmtIdentifierProviders == null) : String.valueOf(this.getClass().getSimpleName()) + " in use";
        assert (this.mQuantifiedVariables.isEmpty()) : String.valueOf(this.getClass().getSimpleName()) + " in use";
        assert (this.mOverapproximations == null) : String.valueOf(this.getClass().getSimpleName()) + " in use";
        assert (this.mAuxVars == null) : String.valueOf(this.getClass().getSimpleName()) + " in use";
        this.mSmtIdentifierProviders = identifierTranslators;
        this.mAuxVars = new ArrayList<TermVariable>();
        this.mOverapproximations = new HashMap<String, ILocation>();
        Term term = this.translate(expression);
        SingleTermResult result = new SingleTermResult(this.mOverapproximations, this.mAuxVars, term);
        this.mSmtIdentifierProviders = null;
        this.mAuxVars = null;
        this.mOverapproximations = null;
        return result;
    }

    public MultiTermResult translateToTerms(IIdentifierTranslator[] identifierTranslators, Expression[] expressions) {
        assert (this.mSmtIdentifierProviders == null) : String.valueOf(this.getClass().getSimpleName()) + " in use";
        assert (this.mQuantifiedVariables.isEmpty()) : String.valueOf(this.getClass().getSimpleName()) + " in use";
        assert (this.mOverapproximations == null) : String.valueOf(this.getClass().getSimpleName()) + " in use";
        assert (this.mAuxVars == null) : String.valueOf(this.getClass().getSimpleName()) + " in use";
        this.mSmtIdentifierProviders = identifierTranslators;
        this.mAuxVars = new ArrayList<TermVariable>();
        this.mOverapproximations = new HashMap<String, ILocation>();
        Term[] terms = new Term[expressions.length];
        int i = 0;
        while (i < expressions.length) {
            terms[i] = this.translate(expressions[i]);
            ++i;
        }
        MultiTermResult result = new MultiTermResult(this.mOverapproximations, this.mAuxVars, terms);
        this.mSmtIdentifierProviders = null;
        this.mAuxVars = null;
        this.mOverapproximations = null;
        return result;
    }

    private Term getSmtIdentifier(String id, DeclarationInformation declInfo, boolean isOldContext, BoogieASTNode boogieASTNode) {
        if (this.mQuantifiedVariables.containsKey((Object)id)) {
            return (Term)this.mQuantifiedVariables.get((Object)id);
        }
        IIdentifierTranslator[] iIdentifierTranslatorArray = this.mSmtIdentifierProviders;
        int n = this.mSmtIdentifierProviders.length;
        int n2 = 0;
        while (n2 < n) {
            IIdentifierTranslator it = iIdentifierTranslatorArray[n2];
            Term term = it.getSmtIdentifier(id, declInfo, isOldContext, boogieASTNode);
            if (term != null) {
                return term;
            }
            ++n2;
        }
        throw new AssertionError((Object)("found no translation for id " + id));
    }

    private boolean isOldContext() {
        return this.mOldContextScopeDepth > 0;
    }

    private Term translate(Expression exp) {
        if (exp instanceof ArrayAccessExpression) {
            ArrayAccessExpression arrexp = (ArrayAccessExpression)exp;
            Expression[] indices = arrexp.getIndices();
            Term result = this.translate(arrexp.getArray());
            int i = 0;
            while (i < indices.length) {
                Term indexiTerm = this.translate(indices[i]);
                result = SmtUtils.select((Script)this.mScript, (Term)result, (Term)indexiTerm);
                ++i;
            }
            return result;
        }
        if (exp instanceof ArrayStoreExpression) {
            ArrayStoreExpression arrexp = (ArrayStoreExpression)exp;
            Expression[] indices = arrexp.getIndices();
            assert (indices.length > 0);
            Term[] arrayBeforeIndex = new Term[indices.length];
            Term[] indexTerm = new Term[indices.length];
            arrayBeforeIndex[0] = this.translate(arrexp.getArray());
            int i = 0;
            while (i < indices.length - 1) {
                indexTerm[i] = this.translate(indices[i]);
                arrayBeforeIndex[i + 1] = SmtUtils.select((Script)this.mScript, (Term)arrayBeforeIndex[i], (Term)indexTerm[i]);
                ++i;
            }
            indexTerm[indices.length - 1] = this.translate(indices[indices.length - 1]);
            Term result = this.translate(arrexp.getValue());
            int i2 = indices.length - 1;
            while (i2 >= 0) {
                result = SmtUtils.store((Script)this.mScript, (Term)arrayBeforeIndex[i2], (Term)indexTerm[i2], (Term)result);
                --i2;
            }
            assert (result != null);
            assert (this.resultContainsNoNull(result));
            return result;
        }
        if (exp instanceof BinaryExpression) {
            BinaryExpression binexp = (BinaryExpression)exp;
            BinaryExpression.Operator op = binexp.getOperator();
            if (op == BinaryExpression.Operator.COMPNEQ) {
                String equalityFuncname = this.mOperationTranslator.opTranslation(BinaryExpression.Operator.COMPEQ, binexp.getLeft().getType(), binexp.getRight().getType());
                String negationFuncname = this.mOperationTranslator.opTranslation(UnaryExpression.Operator.LOGICNEG, (IBoogieType)BoogieType.TYPE_BOOL);
                return SmtUtils.termWithLocalSimplification((Script)this.mScript, (String)negationFuncname, null, null, (Term[])new Term[]{SmtUtils.termWithLocalSimplification((Script)this.mScript, (String)equalityFuncname, null, null, (Term[])new Term[]{this.translate(binexp.getLeft()), this.translate(binexp.getRight())})});
            }
            String funcname = this.mOperationTranslator.opTranslation(op, binexp.getLeft().getType(), binexp.getRight().getType());
            return SmtUtils.termWithLocalSimplification((Script)this.mScript, (String)funcname, null, null, (Term[])new Term[]{this.translate(binexp.getLeft()), this.translate(binexp.getRight())});
        }
        if (exp instanceof UnaryExpression) {
            UnaryExpression unexp = (UnaryExpression)exp;
            UnaryExpression.Operator op = unexp.getOperator();
            if (op == UnaryExpression.Operator.OLD) {
                ++this.mOldContextScopeDepth;
                Term term = this.translate(unexp.getExpr());
                --this.mOldContextScopeDepth;
                return term;
            }
            String funcname = this.mOperationTranslator.opTranslation(op, unexp.getExpr().getType());
            return SmtUtils.termWithLocalSimplification((Script)this.mScript, (String)funcname, null, null, (Term[])new Term[]{this.translate(unexp.getExpr())});
        }
        if (exp instanceof RealLiteral) {
            Term result = this.mOperationTranslator.realTranslation((RealLiteral)exp);
            assert (result != null);
            return result;
        }
        if (exp instanceof BitvecLiteral) {
            Term result = this.mOperationTranslator.bitvecTranslation((BitvecLiteral)exp);
            assert (result != null);
            return result;
        }
        if (exp instanceof BitVectorAccessExpression) {
            BigInteger[] indices = new BigInteger[]{BigInteger.valueOf(((BitVectorAccessExpression)exp).getEnd() - 1), BigInteger.valueOf(((BitVectorAccessExpression)exp).getStart())};
            Term result = this.mScript.term("extract", SmtUtils.toStringArray((BigInteger[])indices), null, new Term[]{this.translate(((BitVectorAccessExpression)exp).getBitvec())});
            assert (result != null);
            return result;
        }
        if (exp instanceof BooleanLiteral) {
            Term result = this.mOperationTranslator.booleanTranslation((BooleanLiteral)exp);
            assert (result != null);
            return result;
        }
        if (exp instanceof FunctionApplication) {
            return this.translateFunctionApplication((FunctionApplication)exp);
        }
        if (exp instanceof IdentifierExpression) {
            IdentifierExpression var = (IdentifierExpression)exp;
            assert (var.getDeclarationInformation() != null) : " no declaration information";
            Term result = this.getSmtIdentifier(var.getIdentifier(), var.getDeclarationInformation(), this.isOldContext(), (BoogieASTNode)exp);
            assert (result != null);
            return result;
        }
        if (exp instanceof IntegerLiteral) {
            Term result = this.mOperationTranslator.integerTranslation((IntegerLiteral)exp);
            assert (result != null);
            return result;
        }
        if (exp instanceof IfThenElseExpression) {
            IfThenElseExpression ite = (IfThenElseExpression)exp;
            Term cond = this.translate(ite.getCondition());
            Term thenPart = this.translate(ite.getThenPart());
            Term elsePart = this.translate(ite.getElsePart());
            Term result = SmtUtils.ite((Script)this.mScript, (Term)cond, (Term)thenPart, (Term)elsePart);
            assert (result != null);
            return result;
        }
        if (exp instanceof QuantifierExpression) {
            QuantifierExpression quant = (QuantifierExpression)exp;
            String[] typeParams = quant.getTypeParams();
            VarList[] variables = quant.getParameters();
            int numvars = typeParams.length;
            int i = 0;
            while (i < variables.length) {
                numvars += variables[i].getIdentifiers().length;
                ++i;
            }
            TermVariable[] vars = new TermVariable[numvars];
            int offset = 0;
            this.mQuantifiedVariables.beginScope();
            int i3 = 0;
            while (i3 < variables.length) {
                IBoogieType type = variables[i3].getType().getBoogieType();
                Sort sort = this.mTypeSortTranslator.getSort(type, (BoogieASTNode)exp);
                int j = 0;
                while (j < variables[i3].getIdentifiers().length) {
                    String identifier = variables[i3].getIdentifiers()[j];
                    String smtVarName = "q" + Boogie2SMT.quoteId(variables[i3].getIdentifiers()[j]);
                    vars[offset] = this.mScript.variable(smtVarName, sort);
                    this.mQuantifiedVariables.put((Object)identifier, (Object)vars[offset]);
                    ++offset;
                    ++j;
                }
                ++i3;
            }
            Term form = this.translate(quant.getSubformula());
            Attribute[] attrs = quant.getAttributes();
            int numTrigs = 0;
            Attribute[] attributeArray = attrs;
            int smtVarName = attrs.length;
            int identifier = 0;
            while (identifier < smtVarName) {
                Attribute a = attributeArray[identifier];
                if (a instanceof Trigger) {
                    ++numTrigs;
                }
                ++identifier;
            }
            Term[][] triggers = new Term[numTrigs][];
            offset = 0;
            Attribute[] attributeArray2 = attrs;
            int n = attrs.length;
            smtVarName = 0;
            while (smtVarName < n) {
                Attribute a = attributeArray2[smtVarName];
                if (a instanceof Trigger) {
                    Expression[] trigs = ((Trigger)a).getTriggers();
                    Term[] smttrigs = new Term[trigs.length];
                    int i4 = 0;
                    while (i4 < trigs.length) {
                        Term trig;
                        smttrigs[i4] = trig = this.translate(trigs[i4]);
                        ++i4;
                    }
                    triggers[offset++] = smttrigs;
                }
                ++smtVarName;
            }
            this.mQuantifiedVariables.endScope();
            Term result = null;
            try {
                result = quant.isUniversal() ? this.mScript.quantifier(1, vars, form, (Term[][])triggers) : this.mScript.quantifier(0, vars, form, (Term[][])triggers);
            }
            catch (SMTLIBException e) {
                if (e.getMessage().equals("Cannot create quantifier in quantifier-free logic")) {
                    Boogie2SMT.reportUnsupportedSyntax((BoogieASTNode)exp, "Setting does not support quantifiers", this.mServices);
                    throw e;
                }
                throw new AssertionError();
            }
            assert (this.resultContainsNoNull(result));
            return result;
        }
        throw new AssertionError((Object)("Unsupported expression " + exp));
    }

    private Term translateFunctionApplication(FunctionApplication func) {
        TermVariable result;
        Map<String, Expression[]> attributes = this.mBoogie2SmtSymbolTable.getAttributes(func.getIdentifier());
        String overapproximation = Boogie2SmtSymbolTable.checkForAttributeDefinedIdentifier(attributes, OVERAPPROXIMATION);
        if (overapproximation != null) {
            Sort resultSort = this.mTypeSortTranslator.getSort(func.getType(), (BoogieASTNode)func);
            TermVariable auxVar = this.mVariableManager.constructFreshTermVariable(func.getIdentifier(), resultSort);
            this.mAuxVars.add(auxVar);
            this.mOverapproximations.put(overapproximation, func.getLocation());
            result = auxVar;
        } else {
            IBoogieType[] argumentTypes = new IBoogieType[func.getArguments().length];
            int i = 0;
            while (i < func.getArguments().length) {
                argumentTypes[i] = func.getArguments()[i].getType();
                ++i;
            }
            Sort[] params = new Sort[func.getArguments().length];
            int i2 = 0;
            while (i2 < func.getArguments().length) {
                params[i2] = this.mTypeSortTranslator.getSort(func.getArguments()[i2].getType(), (BoogieASTNode)func);
                ++i2;
            }
            Term[] parameters = new Term[func.getArguments().length];
            int i3 = 0;
            while (i3 < func.getArguments().length) {
                parameters[i3] = this.translate(func.getArguments()[i3]);
                ++i3;
            }
            String funcSymb = this.mOperationTranslator.funcApplication(func.getIdentifier(), argumentTypes);
            if (funcSymb == null) {
                throw new IllegalArgumentException("unknown function" + func.getIdentifier());
            }
            String[] indices = Boogie2SmtSymbolTable.checkForIndices(attributes);
            BitvectorConstant.BvOp sbo = BitvectorFactory.getSupportedBitvectorOperation((String)funcSymb);
            result = sbo == null ? this.mScript.term(funcSymb, indices, null, parameters) : SmtUtils.termWithLocalSimplification((Script)this.mScript, (String)funcSymb, (String[])indices, null, (Term[])parameters);
        }
        return result;
    }

    private boolean resultContainsNoNull(Term result) {
        return result.toString() != null;
    }

    @FunctionalInterface
    public static interface IIdentifierTranslator {
        public Term getSmtIdentifier(String var1, DeclarationInformation var2, boolean var3, BoogieASTNode var4);
    }

    public static class MultiTermResult
    extends TranslationResult {
        private final Term[] mTerms;

        public MultiTermResult(Map<String, ILocation> overapproximations, Collection<TermVariable> auxiliaryVars, Term[] terms) {
            super(overapproximations, auxiliaryVars);
            this.mTerms = terms;
        }

        public Term[] getTerms() {
            return this.mTerms;
        }
    }

    public static class SingleTermResult
    extends TranslationResult {
        private final Term mTerm;

        public SingleTermResult(Map<String, ILocation> overapproximations, Collection<TermVariable> auxiliaryVars, Term term) {
            super(overapproximations, auxiliaryVars);
            this.mTerm = term;
        }

        public Term getTerm() {
            return this.mTerm;
        }
    }

    static abstract class TranslationResult {
        private final Map<String, ILocation> mOverappoximations;
        private final Collection<TermVariable> mAuxiliaryVars;

        public TranslationResult(Map<String, ILocation> overapproximations, Collection<TermVariable> auxiliaryVars) {
            assert (auxiliaryVars != null);
            this.mOverappoximations = overapproximations;
            this.mAuxiliaryVars = auxiliaryVars;
        }

        public Map<String, ILocation> getOverappoximations() {
            return this.mOverappoximations;
        }

        public Collection<TermVariable> getAuxiliaryVars() {
            return this.mAuxiliaryVars;
        }
    }
}

