/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ArrayStoreExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BinaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitVectorAccessExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BitvecLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BooleanLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.FunctionApplication;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IdentifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IfThenElseExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.IntegerLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.PrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.QuantifierExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RealLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.StringLiteral;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Trigger;
import de.uni_freiburg.informatik.ultimate.boogie.ast.UnaryExpression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SmtSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.TypeSortTranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.LocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.BitvectorUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class MappedTerm2Expression
implements Serializable {
    private static final long serialVersionUID = -3407883192314998843L;
    private final Script mScript;
    private final ScopedHashMap<TermVariable, VarList> mQuantifiedVariables;
    private int mFreshIdentiferCounter;
    private final TypeSortTranslator mTypeSortTranslator;
    private final Boogie2SmtSymbolTable mBoogie2SmtSymbolTable;
    private final Set<IdentifierExpression> mFreeVariables;

    public MappedTerm2Expression(TypeSortTranslator tsTranslation, Boogie2SmtSymbolTable boogie2SmtSymbolTable, ManagedScript maScript) {
        this.mTypeSortTranslator = tsTranslation;
        this.mBoogie2SmtSymbolTable = boogie2SmtSymbolTable;
        this.mScript = maScript.getScript();
        this.mFreeVariables = new HashSet<IdentifierExpression>();
        this.mFreshIdentiferCounter = 0;
        this.mQuantifiedVariables = new ScopedHashMap();
    }

    private String getFreshIdenfier() {
        ++this.mFreshIdentiferCounter;
        return "freshIdentifier" + this.mFreshIdentiferCounter;
    }

    public Expression translate(Term term, Set<TermVariable> variableNameRetainment, Map<TermVariable, String> alternateOldNames) {
        Expression result;
        if (term instanceof AnnotatedTerm) {
            result = MappedTerm2Expression.translate((AnnotatedTerm)term, variableNameRetainment, alternateOldNames);
        } else {
            if (term instanceof ApplicationTerm) {
                return this.translate((ApplicationTerm)term, variableNameRetainment, alternateOldNames);
            }
            if (term instanceof ConstantTerm) {
                result = this.translate((ConstantTerm)term, variableNameRetainment, alternateOldNames);
            } else if (term instanceof LetTerm) {
                result = MappedTerm2Expression.translate((LetTerm)term, variableNameRetainment, alternateOldNames);
            } else if (term instanceof QuantifiedFormula) {
                result = this.translate((QuantifiedFormula)term, variableNameRetainment, alternateOldNames);
            } else if (term instanceof TermVariable) {
                result = this.translate((TermVariable)term, variableNameRetainment, alternateOldNames);
            } else {
                throw new UnsupportedOperationException("unknown kind of Term");
            }
        }
        assert (result != null);
        return result;
    }

    private static Expression translate(AnnotatedTerm term, Set<TermVariable> variableMapRetainment, Map<TermVariable, String> alternateOldNames) {
        throw new UnsupportedOperationException("annotations not supported yet" + term);
    }

    private Expression translate(ApplicationTerm term, Set<TermVariable> variableRewriteMap, Map<TermVariable, String> alternateOldNames) {
        FunctionSymbol symb = term.getFunction();
        if (symb.isIntern() && "select".equals(symb.getName())) {
            return this.translateSelect(term, variableRewriteMap, alternateOldNames);
        }
        if (symb.isIntern() && "store".equals(symb.getName())) {
            return this.translateStore(term, variableRewriteMap, alternateOldNames);
        }
        if (BitvectorUtils.isBitvectorConstant((FunctionSymbol)symb)) {
            return this.translateBitvectorConstant(term);
        }
        Term[] termParams = term.getParameters();
        Expression[] params = new Expression[termParams.length];
        int i = 0;
        while (i < termParams.length) {
            params[i] = this.translate(termParams[i], variableRewriteMap, alternateOldNames);
            ++i;
        }
        IBoogieType type = this.mTypeSortTranslator.getType(symb.getReturnSort());
        if (symb.getParameterSorts().length == 0) {
            if (SmtUtils.isTrueLiteral((Term)term)) {
                IBoogieType booleanType = this.mTypeSortTranslator.getType(SmtSortUtils.getBoolSort((Script)this.mScript));
                return new BooleanLiteral(null, booleanType, true);
            }
            if (SmtUtils.isFalseLiteral((Term)term)) {
                IBoogieType booleanType = this.mTypeSortTranslator.getType(SmtSortUtils.getBoolSort((Script)this.mScript));
                return new BooleanLiteral(null, booleanType, false);
            }
            ProgramConst boogieConst = this.mBoogie2SmtSymbolTable.getProgramConst(term);
            if (boogieConst != null) {
                return new IdentifierExpression(null, this.mTypeSortTranslator.getType(term.getSort()), boogieConst.getIdentifier(), new DeclarationInformation(DeclarationInformation.StorageClass.GLOBAL, null));
            }
            if (this.mBoogie2SmtSymbolTable.getSmtFunction2BoogieFunction().containsKey(symb.getName())) {
                return this.translateWithSymbolTable(symb, type, termParams, variableRewriteMap, alternateOldNames);
            }
            throw new IllegalArgumentException();
        }
        if ("ite".equals(symb.getName())) {
            return new IfThenElseExpression(null, type, params[0], params[1], params[2]);
        }
        if (symb.isIntern()) {
            if (symb.getParameterSorts().length > 0 && (SmtSortUtils.isBitvecSort((Sort)symb.getParameterSorts()[0]) || SmtSortUtils.isFloatingpointSort((Sort)symb.getReturnSort())) && !"=".equals(symb.getName()) && !"distinct".equals(symb.getName())) {
                if ("extract".equals(symb.getName())) {
                    return this.translateBitvectorAccess(type, term, variableRewriteMap, alternateOldNames);
                }
                if (this.mBoogie2SmtSymbolTable.getSmtFunction2BoogieFunction().containsKey(symb.getName())) {
                    return this.translateWithSymbolTable(symb, type, termParams, variableRewriteMap, alternateOldNames);
                }
                throw new UnsupportedOperationException("translation of " + symb + " not yet implemented, please contact Matthias");
            }
            if (symb.getParameterSorts().length == 1) {
                if ("not".equals(symb.getName())) {
                    Expression param = this.translate(term.getParameters()[0], variableRewriteMap, alternateOldNames);
                    return new UnaryExpression(null, type, UnaryExpression.Operator.LOGICNEG, param);
                }
                if ("-".equals(symb.getName())) {
                    Expression param = this.translate(term.getParameters()[0], variableRewriteMap, alternateOldNames);
                    return new UnaryExpression(null, type, UnaryExpression.Operator.ARITHNEGATIVE, param);
                }
                throw new IllegalArgumentException("unknown symbol " + symb);
            }
            if ("xor".equals(symb.getName())) {
                return MappedTerm2Expression.xor(params);
            }
            if ("mod".equals(symb.getName())) {
                return MappedTerm2Expression.mod(params);
            }
            BinaryExpression.Operator op = MappedTerm2Expression.getBinaryOperator(symb);
            if (symb.isLeftAssoc()) {
                return MappedTerm2Expression.leftAssoc(op, type, params);
            }
            if (symb.isRightAssoc()) {
                return MappedTerm2Expression.rightAssoc(op, type, params);
            }
            if (symb.isChainable()) {
                return MappedTerm2Expression.chainable(op, type, params);
            }
            if (symb.isPairwise()) {
                return MappedTerm2Expression.pairwise(op, type, params);
            }
            throw new UnsupportedOperationException("don't know symbol which is neither leftAssoc, rightAssoc, chainable, or pairwise.");
        }
        if (this.mBoogie2SmtSymbolTable.getSmtFunction2BoogieFunction().containsKey(symb.getName())) {
            return this.translateWithSymbolTable(symb, type, termParams, variableRewriteMap, alternateOldNames);
        }
        throw new UnsupportedOperationException("translation of " + symb + " not yet implemented, please contact Matthias");
    }

    private Expression translateBitvectorAccess(IBoogieType type, ApplicationTerm term, Set<TermVariable> variableNameRetainment, Map<TermVariable, String> alternateOldNames) {
        assert ("extract".equals(term.getFunction().getName())) : "no extract";
        assert (term.getParameters().length == 1);
        assert (term.getFunction().getIndices().length == 2);
        Expression bitvector = this.translate(term.getParameters()[0], variableNameRetainment, alternateOldNames);
        int start = Integer.valueOf(term.getFunction().getIndices()[1]);
        int end = Integer.valueOf(term.getFunction().getIndices()[0]);
        return new BitVectorAccessExpression(null, type, bitvector, end, start);
    }

    private Expression translateWithSymbolTable(FunctionSymbol symb, IBoogieType type, Term[] termParams, Set<TermVariable> variableNameRetainment, Map<TermVariable, String> alternateOldNames) {
        String identifier = this.mBoogie2SmtSymbolTable.getSmtFunction2BoogieFunction().get(symb.getName());
        Expression[] arguments = new Expression[termParams.length];
        int i = 0;
        while (i < termParams.length) {
            arguments[i] = this.translate(termParams[i], variableNameRetainment, alternateOldNames);
            ++i;
        }
        return new FunctionApplication(null, type, identifier, arguments);
    }

    private Expression translateBitvectorConstant(ApplicationTerm term) {
        assert (term.getSort().getIndices().length == 1);
        String name = term.getFunction().getName();
        assert (name.startsWith("bv"));
        String decimalValue = name.substring(2, name.length());
        IBoogieType type = this.mTypeSortTranslator.getType(term.getSort());
        String length = term.getSort().getIndices()[0];
        return new BitvecLiteral(null, type, decimalValue, Integer.valueOf(length).intValue());
    }

    private static Expression mod(Expression[] params) {
        if (params.length != 2) {
            throw new AssertionError((Object)"mod has two parameters");
        }
        return new BinaryExpression(null, (IBoogieType)BoogieType.TYPE_INT, BinaryExpression.Operator.ARITHMOD, params[0], params[1]);
    }

    private ArrayStoreExpression translateStore(ApplicationTerm term, Set<TermVariable> variableNameRetainment, Map<TermVariable, String> alternateOldNames) {
        Expression array = this.translate(term.getParameters()[0], variableNameRetainment, alternateOldNames);
        Expression index = this.translate(term.getParameters()[1], variableNameRetainment, alternateOldNames);
        Expression[] indices = new Expression[]{index};
        Expression value = this.translate(term.getParameters()[2], variableNameRetainment, alternateOldNames);
        IBoogieType type = this.mTypeSortTranslator.getType(term.getSort());
        return new ArrayStoreExpression(null, type, array, indices, value);
    }

    private ArrayAccessExpression translateSelect(ApplicationTerm term, Set<TermVariable> variableRewriteMap, Map<TermVariable, String> alternateOldNames) {
        Expression array = this.translate(term.getParameters()[0], variableRewriteMap, alternateOldNames);
        Expression index = this.translate(term.getParameters()[1], variableRewriteMap, alternateOldNames);
        Expression[] indices = new Expression[]{index};
        IBoogieType type = this.mTypeSortTranslator.getType(term.getSort());
        return new ArrayAccessExpression(null, type, array, indices);
    }

    private ArrayAccessExpression translateArray(ApplicationTerm term, Set<TermVariable> variableNameRetainment, Map<TermVariable, String> alternateOldNames) {
        Expression index;
        ArrayList<Expression> reverseIndices = new ArrayList<Expression>();
        ApplicationTerm localTerm = term;
        while ("select".equals(localTerm.getFunction().getName()) && localTerm.getParameters()[0] instanceof ApplicationTerm) {
            assert (localTerm.getParameters().length == 2);
            index = this.translate(localTerm.getParameters()[1], variableNameRetainment, alternateOldNames);
            reverseIndices.add(index);
            localTerm = (ApplicationTerm)localTerm.getParameters()[0];
        }
        assert (localTerm.getParameters().length == 2);
        index = this.translate(localTerm.getParameters()[1], variableNameRetainment, alternateOldNames);
        reverseIndices.add(index);
        Expression array = this.translate(localTerm.getParameters()[0], variableNameRetainment, alternateOldNames);
        Expression[] indices = new Expression[reverseIndices.size()];
        int i = 0;
        while (i < indices.length) {
            indices[i] = (Expression)reverseIndices.get(indices.length - 1 - i);
            ++i;
        }
        IBoogieType type = this.mTypeSortTranslator.getType(localTerm.getSort());
        return new ArrayAccessExpression(null, type, array, indices);
    }

    private Expression translate(ConstantTerm term, Set<TermVariable> variableNameRetainment, Map<TermVariable, String> alternateOldNames) {
        Object value = term.getValue();
        IBoogieType type = this.mTypeSortTranslator.getType(term.getSort());
        if (SmtSortUtils.isBitvecSort((Sort)term.getSort())) {
            BigInteger decimalValue;
            String[] indices = term.getSort().getIndices();
            if (indices.length != 1) {
                throw new AssertionError((Object)"BitVec has exactly one index");
            }
            if (value.toString().startsWith("#x")) {
                decimalValue = new BigInteger(value.toString().substring(2), 16);
            } else if (value.toString().startsWith("#b")) {
                decimalValue = new BigInteger(value.toString().substring(2), 2);
            } else {
                throw new UnsupportedOperationException("only hexadecimal values and boolean values supported yet");
            }
            int length = Integer.valueOf(indices[0]);
            return new BitvecLiteral(null, type, String.valueOf(decimalValue), length);
        }
        if (value instanceof String) {
            return new StringLiteral(null, type, value.toString());
        }
        if (value instanceof BigInteger) {
            return new IntegerLiteral(null, type, value.toString());
        }
        if (value instanceof BigDecimal) {
            return new RealLiteral(null, type, value.toString());
        }
        if (value instanceof Rational) {
            if (SmtSortUtils.isIntSort((Sort)term.getSort())) {
                return new IntegerLiteral(null, type, value.toString());
            }
            if (SmtSortUtils.isRealSort((Sort)term.getSort())) {
                return new RealLiteral(null, type, value.toString());
            }
            throw new UnsupportedOperationException("unknown Sort");
        }
        throw new UnsupportedOperationException("unknown kind of Term");
    }

    private static Expression translate(LetTerm term, Set<TermVariable> variableNameRetainment, Map<TermVariable, String> alternateOldNames) {
        throw new IllegalArgumentException("unlet Term first");
    }

    private Expression translate(QuantifiedFormula term, Set<TermVariable> variableNameRetainment, Map<TermVariable, String> alternateOldNames) {
        Attribute[] attributes;
        this.mQuantifiedVariables.beginScope();
        VarList[] parameters = new VarList[term.getVariables().length];
        int offset = 0;
        TermVariable[] termVariableArray = term.getVariables();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            VarList varList;
            TermVariable tv = termVariableArray[n2];
            IBoogieType boogieType = this.mTypeSortTranslator.getType(tv.getSort());
            String[] identifiers = new String[]{tv.getName()};
            PrimitiveType astType = new PrimitiveType(null, boogieType, boogieType.toString());
            parameters[offset] = varList = new VarList(null, identifiers, (ASTType)astType);
            this.mQuantifiedVariables.put((Object)tv, (Object)varList);
            ++offset;
            ++n2;
        }
        IBoogieType type = this.mTypeSortTranslator.getType(term.getSort());
        assert (term.getQuantifier() == 1 || term.getQuantifier() == 0);
        boolean isUniversal = term.getQuantifier() == 1;
        String[] typeParams = new String[]{};
        Term subTerm = term.getSubformula();
        if (subTerm instanceof AnnotatedTerm) {
            assert (":pattern".equals(((AnnotatedTerm)subTerm).getAnnotations()[0].getKey()));
            Annotation[] annotations = ((AnnotatedTerm)subTerm).getAnnotations();
            assert (annotations.length == 1) : "expecting only one annotation at a time";
            Annotation annotation = annotations[0];
            Object value = annotation.getValue();
            assert (value instanceof Term[]) : "expecting Term[]" + value;
            subTerm = ((AnnotatedTerm)subTerm).getSubterm();
            Term[] pattern = (Term[])value;
            if (pattern.length == 0) {
                attributes = new Attribute[]{};
            } else {
                Expression[] triggers = new Expression[pattern.length];
                int i = 0;
                while (i < pattern.length) {
                    triggers[i] = this.translate(pattern[i], variableNameRetainment, alternateOldNames);
                    ++i;
                }
                Trigger trigger = new Trigger(null, triggers);
                attributes = new Attribute[]{trigger};
            }
        } else {
            attributes = new Attribute[]{};
        }
        Expression subformula = this.translate(subTerm, variableNameRetainment, alternateOldNames);
        QuantifierExpression result = new QuantifierExpression(null, type, isUniversal, typeParams, parameters, attributes, subformula);
        this.mQuantifiedVariables.endScope();
        return result;
    }

    private Expression translate(TermVariable term, Set<TermVariable> variableNameRetainment, Map<TermVariable, String> alternateOldNames) {
        IdentifierExpression result;
        IBoogieType type = this.mTypeSortTranslator.getType(term.getSort());
        if (alternateOldNames.containsKey(term)) {
            result = new IdentifierExpression(null, type, alternateOldNames.get(term), new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION, null));
        } else if (variableNameRetainment.contains(term)) {
            result = new IdentifierExpression(null, type, term.getName(), new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION, null));
        } else if (this.mQuantifiedVariables.containsKey((Object)term)) {
            VarList varList = (VarList)this.mQuantifiedVariables.get((Object)term);
            assert (varList.getIdentifiers().length == 1);
            String id = varList.getIdentifiers()[0];
            result = new IdentifierExpression(null, type, this.translateIdentifier(id), new DeclarationInformation(DeclarationInformation.StorageClass.QUANTIFIED, null));
        } else if (this.mBoogie2SmtSymbolTable.getProgramVar(term) == null) {
            result = new IdentifierExpression(null, type, this.getFreshIdenfier(), new DeclarationInformation(DeclarationInformation.StorageClass.QUANTIFIED, null));
            this.mFreeVariables.add(result);
        } else {
            IProgramVar pv = this.mBoogie2SmtSymbolTable.getProgramVar(term);
            BoogieASTNode astNode = this.mBoogie2SmtSymbolTable.getAstNode(pv);
            assert (astNode != null) : "There is no AstNode for the IProgramVar " + pv;
            ILocation loc = astNode.getLocation();
            DeclarationInformation declInfo = this.mBoogie2SmtSymbolTable.getDeclarationInformation(pv);
            if (pv instanceof LocalProgramVar) {
                result = new IdentifierExpression(loc, type, this.translateIdentifier(((LocalProgramVar)pv).getIdentifier()), declInfo);
            } else if (pv instanceof ProgramNonOldVar) {
                result = new IdentifierExpression(loc, type, this.translateIdentifier(((ProgramNonOldVar)pv).getIdentifier()), declInfo);
            } else if (pv instanceof ProgramOldVar) {
                assert (pv.isGlobal());
                IdentifierExpression nonOldExpression = new IdentifierExpression(loc, type, this.translateIdentifier(((ProgramOldVar)pv).getIdentifierOfNonOldVar()), declInfo);
                result = new UnaryExpression(loc, type, UnaryExpression.Operator.OLD, (Expression)nonOldExpression);
            } else if (pv instanceof ProgramConst) {
                result = new IdentifierExpression(loc, type, this.translateIdentifier(((ProgramConst)((Object)pv)).getIdentifier()), declInfo);
            } else {
                throw new AssertionError((Object)("unsupported kind of variable " + pv.getClass().getSimpleName()));
            }
        }
        return result;
    }

    private String translateIdentifier(String id) {
        return id.replace(" ", "_").replace("(", "_").replace(")", "_").replace("+", "PLUS").replace("-", "MINUS").replace("*", "MUL");
    }

    private static BinaryExpression.Operator getBinaryOperator(FunctionSymbol symb) {
        if ("and".equals(symb.getName())) {
            return BinaryExpression.Operator.LOGICAND;
        }
        if ("or".equals(symb.getName())) {
            return BinaryExpression.Operator.LOGICOR;
        }
        if ("=>".equals(symb.getName())) {
            return BinaryExpression.Operator.LOGICIMPLIES;
        }
        if ("=".equals(symb.getName()) && "bool".equals(symb.getParameterSort(0).getName())) {
            return BinaryExpression.Operator.LOGICIFF;
        }
        if ("=".equals(symb.getName())) {
            return BinaryExpression.Operator.COMPEQ;
        }
        if ("distinct".equals(symb.getName())) {
            return BinaryExpression.Operator.COMPNEQ;
        }
        if ("<=".equals(symb.getName())) {
            return BinaryExpression.Operator.COMPLEQ;
        }
        if (">=".equals(symb.getName())) {
            return BinaryExpression.Operator.COMPGEQ;
        }
        if ("<".equals(symb.getName())) {
            return BinaryExpression.Operator.COMPLT;
        }
        if (">".equals(symb.getName())) {
            return BinaryExpression.Operator.COMPGT;
        }
        if ("+".equals(symb.getName())) {
            return BinaryExpression.Operator.ARITHPLUS;
        }
        if ("-".equals(symb.getName())) {
            return BinaryExpression.Operator.ARITHMINUS;
        }
        if ("*".equals(symb.getName())) {
            return BinaryExpression.Operator.ARITHMUL;
        }
        if ("/".equals(symb.getName())) {
            return BinaryExpression.Operator.ARITHDIV;
        }
        if ("div".equals(symb.getName())) {
            return BinaryExpression.Operator.ARITHDIV;
        }
        if ("mod".equals(symb.getName())) {
            return BinaryExpression.Operator.ARITHMOD;
        }
        if ("ite".equals(symb.getName())) {
            throw new UnsupportedOperationException("not yet implemented");
        }
        if ("abs".equals(symb.getName())) {
            throw new UnsupportedOperationException("not yet implemented");
        }
        throw new IllegalArgumentException("unknown symbol " + symb);
    }

    private static Expression leftAssoc(BinaryExpression.Operator op, IBoogieType type, Expression[] params) {
        Expression result = params[0];
        int i = 0;
        while (i < params.length - 1) {
            result = new BinaryExpression(null, type, op, result, params[i + 1]);
            ++i;
        }
        return result;
    }

    private static Expression rightAssoc(BinaryExpression.Operator op, IBoogieType type, Expression[] params) {
        Expression result = params[params.length - 1];
        int i = params.length - 1;
        while (i > 0) {
            result = new BinaryExpression(null, type, op, params[i - 1], result);
            --i;
        }
        return result;
    }

    private static Expression chainable(BinaryExpression.Operator op, IBoogieType type, Expression[] params) {
        assert (type == BoogieType.TYPE_BOOL);
        BinaryExpression result = new BinaryExpression(null, type, op, params[0], params[1]);
        int i = 1;
        while (i < params.length - 1) {
            BinaryExpression chain = new BinaryExpression(null, type, op, params[i], params[i + 1]);
            result = new BinaryExpression(null, (IBoogieType)BoogieType.TYPE_BOOL, BinaryExpression.Operator.LOGICAND, (Expression)result, (Expression)chain);
            ++i;
        }
        return result;
    }

    private static Expression pairwise(BinaryExpression.Operator op, IBoogieType type, Expression[] params) {
        assert (type == BoogieType.TYPE_BOOL);
        BinaryExpression result = new BinaryExpression(null, type, op, params[0], params[1]);
        int i = 0;
        while (i < params.length - 1) {
            int j = i + 1;
            while (j < params.length - 1) {
                if (i != 0 || j != 1) {
                    BinaryExpression neq = new BinaryExpression(null, type, op, params[j], params[j + 1]);
                    result = new BinaryExpression(null, (IBoogieType)BoogieType.TYPE_BOOL, BinaryExpression.Operator.LOGICAND, (Expression)result, (Expression)neq);
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    private static Expression xor(Expression[] params) {
        BoogiePrimitiveType type = BoogieType.TYPE_BOOL;
        BinaryExpression.Operator iff = BinaryExpression.Operator.LOGICIFF;
        UnaryExpression.Operator neg = UnaryExpression.Operator.LOGICNEG;
        Expression result = params[0];
        int i = 0;
        while (i < params.length - 1) {
            result = new BinaryExpression(null, (IBoogieType)type, iff, params[i + 1], result);
            result = new UnaryExpression(null, (IBoogieType)type, neg, result);
            ++i;
        }
        return result;
    }
}

