/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.DeclarationInformation;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssertStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssignmentStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.EnsuresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ForkStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.HavocStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.JoinStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ModifiesSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.RequiresSpecification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Specification;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SMT;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SmtSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.BoogieDeclarations;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Expression2Term;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PrenexNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierSequence;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfDer;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Statements2TransFormula {
    private static final boolean COMPUTE_ASSERTS = false;
    private static final String MSG_COMPUTE_ASSERTS_NOT_AVAILABLE = "computation of asserts not available";
    private final boolean mSimplePartialSkolemization;
    private final Script mScript;
    private final ManagedScript mMgdScript;
    private final BoogieDeclarations mBoogieDeclarations;
    private final Boogie2SMT mBoogie2SMT;
    private final Boogie2SmtSymbolTable mBoogie2SmtSymbolTable;
    private final Expression2Term mExpression2Term;
    private String mCurrentProcedure;
    private TransFormulaBuilder mTransFormulaBuilder;
    private Set<TermVariable> mAuxVars;
    private Term mAssumes;
    private Term mAsserts;
    private Boogie2SMT.ConstOnlyIdentifierTranslator mConstOnlyIdentifierTranslator;
    private final IUltimateServiceProvider mServices;
    private Map<String, ILocation> mOverapproximations = null;

    public Statements2TransFormula(Boogie2SMT boogie2smt, IUltimateServiceProvider services, Expression2Term expression2Term, boolean simplePartialSkolemization) {
        this.mServices = services;
        this.mSimplePartialSkolemization = simplePartialSkolemization;
        this.mBoogie2SMT = boogie2smt;
        this.mScript = boogie2smt.getScript();
        this.mMgdScript = boogie2smt.getManagedScript();
        this.mExpression2Term = expression2Term;
        this.mBoogie2SmtSymbolTable = this.mBoogie2SMT.getBoogie2SmtSymbolTable();
        this.mBoogieDeclarations = this.mBoogie2SMT.getBoogieDeclarations();
    }

    private void initialize(String procId) {
        assert (this.mCurrentProcedure == null);
        assert (this.mTransFormulaBuilder == null);
        assert (this.mAuxVars == null);
        assert (this.mAssumes == null);
        assert (this.mConstOnlyIdentifierTranslator == null);
        this.mOverapproximations = new HashMap<String, ILocation>();
        this.mCurrentProcedure = procId;
        this.mTransFormulaBuilder = new TransFormulaBuilder(null, null, false, null, true, null, false);
        this.mAuxVars = new HashSet<TermVariable>();
        this.mAssumes = this.mScript.term("true", new Term[0]);
        this.mConstOnlyIdentifierTranslator = this.mBoogie2SMT.createConstOnlyIdentifierTranslator();
    }

    private TranslationResult getTransFormula(boolean feasibilityKnown, SmtUtils.SimplificationTechnique simplicationTechnique) {
        UnmodifiableTransFormula tf = null;
        try {
            tf = this.constructTransFormula(feasibilityKnown, simplicationTechnique);
            this.mCurrentProcedure = null;
            this.mTransFormulaBuilder = null;
            this.mAuxVars = null;
            this.mAssumes = null;
            this.mConstOnlyIdentifierTranslator = null;
        }
        catch (ToolchainCanceledException tce) {
            tce.addRunningTaskInfo(new RunningTaskInfo(this.getClass(), "constructing TransFormula"));
            throw tce;
        }
        return new TranslationResult(tf, this.mOverapproximations);
    }

    private UnmodifiableTransFormula constructTransFormula(boolean feasibilityKnown, SmtUtils.SimplificationTechnique simplicationTechnique) {
        Term formula = this.mSimplePartialSkolemization ? this.skolemize(this.mAssumes, this.mAuxVars) : this.mAssumes;
        formula = this.mBoogie2SMT.getSmtFunctionsAndAxioms().inline(formula);
        UnmodifiableTransFormula.Infeasibility infeasibility = null;
        if (simplicationTechnique != SmtUtils.SimplificationTechnique.NONE) {
            formula = SmtUtils.simplify((ManagedScript)this.mMgdScript, (Term)formula, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)simplicationTechnique);
        }
        if (feasibilityKnown) {
            infeasibility = UnmodifiableTransFormula.Infeasibility.UNPROVEABLE;
        }
        if (infeasibility == null) {
            Term falseTerm = this.mScript.term("false", new Term[0]);
            if (formula == falseTerm) {
                infeasibility = UnmodifiableTransFormula.Infeasibility.INFEASIBLE;
            } else if (simplicationTechnique.decidesFeasibility()) {
                infeasibility = UnmodifiableTransFormula.Infeasibility.UNPROVEABLE;
            } else {
                Script.LBool isSat = Util.checkSat((Script)this.mScript, (Term)formula);
                if (isSat == Script.LBool.UNSAT) {
                    formula = falseTerm;
                    infeasibility = UnmodifiableTransFormula.Infeasibility.INFEASIBLE;
                } else {
                    infeasibility = UnmodifiableTransFormula.Infeasibility.UNPROVEABLE;
                }
            }
        }
        TransFormulaUtils.addConstantsIfInFormula(this.mTransFormulaBuilder, formula, this.mConstOnlyIdentifierTranslator.getNonTheoryConsts());
        this.mTransFormulaBuilder.setFormula(formula);
        this.mTransFormulaBuilder.setInfeasibility(infeasibility);
        this.mTransFormulaBuilder.addAuxVarsButRenameToFreshCopies(this.mAuxVars, this.mMgdScript);
        return this.mTransFormulaBuilder.finishConstruction(this.mMgdScript);
    }

    private IProgramVar getModifiableBoogieVar(String id, DeclarationInformation declInfo) {
        IProgramVar result;
        DeclarationInformation.StorageClass storageClass = declInfo.getStorageClass();
        switch (storageClass) {
            case GLOBAL: 
            case PROC_FUNC_OUTPARAM: 
            case IMPLEMENTATION_OUTPARAM: 
            case LOCAL: {
                result = this.mBoogie2SmtSymbolTable.getBoogieVar(id, declInfo, false);
                break;
            }
            case PROC_FUNC_INPARAM: 
            case IMPLEMENTATION_INPARAM: {
                throw new AssertionError((Object)"not modifiable");
            }
            default: {
                throw new AssertionError((Object)"no appropriate variable ");
            }
        }
        return result;
    }

    private Expression2Term.IIdentifierTranslator[] getIdentifierTranslatorsIntraprocedural() {
        return new Expression2Term.IIdentifierTranslator[]{new LocalVarTranslatorWithInOutVarManagement(), new GlobalVarTranslatorWithInOutVarManagement(this.mCurrentProcedure, false), this.mConstOnlyIdentifierTranslator};
    }

    private void addAssignment(AssignmentStatement assign) {
        LeftHandSide[] lhs = assign.getLhs();
        Expression[] rhs = assign.getRhs();
        HashMap<TermVariable, Expression> addedEqualities = new HashMap<TermVariable, Expression>();
        int i = 0;
        while (i < lhs.length) {
            VariableLHS vlhs = (VariableLHS)lhs[i];
            assert (vlhs.getDeclarationInformation() != null) : " no declaration information";
            String name = vlhs.getIdentifier();
            DeclarationInformation declInfo = vlhs.getDeclarationInformation();
            IProgramVar boogieVar = this.getModifiableBoogieVar(name, declInfo);
            assert (boogieVar != null);
            this.getOrConstuctCurrentRepresentative(boogieVar);
            if (this.mTransFormulaBuilder.containsInVar(boogieVar)) {
                TermVariable tv = this.mTransFormulaBuilder.getInVar(boogieVar);
                addedEqualities.put(tv, rhs[i]);
                this.removeInVar(boogieVar);
            }
            ++i;
        }
        Expression2Term.IIdentifierTranslator[] its = this.getIdentifierTranslatorsIntraprocedural();
        for (TermVariable tv : addedEqualities.keySet()) {
            Expression2Term.SingleTermResult tlres = this.mExpression2Term.translateToTerm(its, (Expression)addedEqualities.get(tv));
            this.mAuxVars.addAll(tlres.getAuxiliaryVars());
            this.mOverapproximations.putAll(tlres.getOverappoximations());
            Term rhsTerm = tlres.getTerm();
            Term eq = SmtUtils.binaryEquality((Script)this.mScript, (Term)tv, (Term)rhsTerm);
            this.mAssumes = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{eq, this.mAssumes});
        }
        this.eliminateAuxVarsViaDer();
    }

    private void addHavoc(HavocStatement havoc) {
        VariableLHS[] variableLHSArray = havoc.getIdentifiers();
        int n = variableLHSArray.length;
        int n2 = 0;
        while (n2 < n) {
            VariableLHS lhs = variableLHSArray[n2];
            assert (lhs.getDeclarationInformation() != null) : " no declaration information";
            String name = lhs.getIdentifier();
            DeclarationInformation declInfo = lhs.getDeclarationInformation();
            IProgramVar boogieVar = this.getModifiableBoogieVar(name, declInfo);
            assert (boogieVar != null);
            this.getOrConstuctCurrentRepresentative(boogieVar);
            if (this.mTransFormulaBuilder.containsInVar(boogieVar)) {
                this.removeInVar(boogieVar);
            }
            ++n2;
        }
    }

    private void addAssume(AssumeStatement assume) {
        Expression2Term.IIdentifierTranslator[] its = this.getIdentifierTranslatorsIntraprocedural();
        Expression2Term.SingleTermResult tlres = this.mExpression2Term.translateToTerm(its, assume.getFormula());
        this.mAuxVars.addAll(tlres.getAuxiliaryVars());
        this.mOverapproximations.putAll(tlres.getOverappoximations());
        Term f = tlres.getTerm();
        this.mAssumes = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{f, this.mAssumes});
        this.eliminateAuxVarsViaDer();
    }

    private void addAssert(AssertStatement assertstmt) {
        throw new AssertionError((Object)MSG_COMPUTE_ASSERTS_NOT_AVAILABLE);
    }

    private static boolean assertTermContainsNoNull(Term result) {
        return result.toString() instanceof Object;
    }

    private void addSummary(CallStatement call) {
        String[] id;
        VariableLHS[] callLhsDeclInfo2;
        Procedure procedure = this.mBoogieDeclarations.getProcSpecification().get(call.getMethodName());
        HashMap<String, Term> substitution = new HashMap<String, Term>();
        Expression[] arguments = call.getArguments();
        VariableLHS[] callLhs = call.getLhs();
        int offset = 0;
        ArrayList<IProgramVar> callLhsBvs = new ArrayList<IProgramVar>();
        VarList[] varListArray = procedure.getOutParams();
        int n = varListArray.length;
        int n2 = 0;
        while (n2 < n) {
            VarList outParamVl = varListArray[n2];
            String[] stringArray = outParamVl.getIdentifiers();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String outParamId = stringArray[n4];
                String callLhsId = callLhs[offset].getIdentifier();
                callLhsDeclInfo2 = callLhs[offset].getDeclarationInformation();
                IProgramVar callLhsBv = this.getModifiableBoogieVar(callLhsId, (DeclarationInformation)callLhsDeclInfo2);
                assert (callLhsBv != null);
                TermVariable callLhsTv = this.getOrConstuctCurrentRepresentative(callLhsBv);
                substitution.put(outParamId, (Term)callLhsTv);
                callLhsBvs.add(callLhsBv);
                ++offset;
                ++n4;
            }
            ++n2;
        }
        for (IProgramVar bv : callLhsBvs) {
            this.removeInVar(bv);
        }
        HashMap<IProgramVar, Term> requiresSubstitution = new HashMap<IProgramVar, Term>();
        HashMap<IProgramVar, Term> ensuresSubstitution = new HashMap<IProgramVar, Term>();
        Specification[] specificationArray = procedure.getSpecification();
        int outParamId = specificationArray.length;
        int n5 = 0;
        while (n5 < outParamId) {
            Specification spec = specificationArray[n5];
            if (spec instanceof ModifiesSpecification) {
                callLhsDeclInfo2 = ((ModifiesSpecification)spec).getIdentifiers();
                int n6 = callLhsDeclInfo2.length;
                int n7 = 0;
                while (n7 < n6) {
                    VariableLHS var22 = callLhsDeclInfo2[n7];
                    id = var22.getIdentifier();
                    IProgramVar boogieVar = this.mBoogie2SmtSymbolTable.getBoogieVar((String)id, var22.getDeclarationInformation(), false);
                    IProgramVar boogieOldVar = this.mBoogie2SmtSymbolTable.getBoogieVar((String)id, var22.getDeclarationInformation(), true);
                    assert (boogieVar != null);
                    assert (boogieOldVar != null);
                    TermVariable tvAfter = this.getOrConstuctCurrentRepresentative(boogieVar);
                    this.removeInVar(boogieVar);
                    TermVariable tvBefore = this.mBoogie2SMT.getManagedScript().constructFreshTermVariable(boogieVar.getGloballyUniqueId(), boogieVar.getTermVariable().getSort());
                    this.mTransFormulaBuilder.addInVar(boogieVar, tvBefore);
                    ensuresSubstitution.put(boogieVar, (Term)tvAfter);
                    ensuresSubstitution.put(boogieOldVar, (Term)tvBefore);
                    requiresSubstitution.put(boogieVar, (Term)tvBefore);
                    requiresSubstitution.put(boogieOldVar, (Term)tvBefore);
                    ++n7;
                }
            }
            ++n5;
        }
        Expression2Term.IIdentifierTranslator[] its = this.getIdentifierTranslatorsIntraprocedural();
        Expression2Term.MultiTermResult tlres22 = this.mExpression2Term.translateToTerms(its, arguments);
        this.mAuxVars.addAll(tlres22.getAuxiliaryVars());
        this.mOverapproximations.putAll(tlres22.getOverappoximations());
        Term[] argumentTerms = tlres22.getTerms();
        offset = 0;
        VarList[] var22 = procedure.getInParams();
        int n8 = var22.length;
        int tlres22 = 0;
        while (tlres22 < n8) {
            VarList vl = var22[tlres22];
            id = vl.getIdentifiers();
            int callLhsDeclInfo2 = id.length;
            int n9 = 0;
            while (n9 < callLhsDeclInfo2) {
                String id2 = id[n9];
                substitution.put(id2, argumentTerms[offset]);
                ++offset;
                ++n9;
            }
            ++tlres22;
        }
        String calledProcedure = call.getMethodName();
        Expression2Term.IIdentifierTranslator[] ensIts = new Expression2Term.IIdentifierTranslator[]{new SubstitutionTranslatorId(substitution), new SubstitutionTranslatorBoogieVar(ensuresSubstitution), new GlobalVarTranslatorWithInOutVarManagement(calledProcedure, false), this.mConstOnlyIdentifierTranslator};
        Specification[] specificationArray2 = procedure.getSpecification();
        int n10 = specificationArray2.length;
        int var22 = 0;
        while (var22 < n10) {
            Specification spec = specificationArray2[var22];
            if (spec instanceof EnsuresSpecification) {
                Expression post = ((EnsuresSpecification)spec).getFormula();
                Expression2Term.SingleTermResult tlres = this.mExpression2Term.translateToTerm(ensIts, post);
                this.mAuxVars.addAll(tlres.getAuxiliaryVars());
                this.mOverapproximations.putAll(tlres.getOverappoximations());
                Term f = tlres.getTerm();
                this.mAssumes = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{f, this.mAssumes});
            }
            ++var22;
        }
        Expression2Term.IIdentifierTranslator[] reqIts = new Expression2Term.IIdentifierTranslator[]{new SubstitutionTranslatorId(substitution), new SubstitutionTranslatorBoogieVar(requiresSubstitution), new GlobalVarTranslatorWithInOutVarManagement(calledProcedure, false), this.mConstOnlyIdentifierTranslator};
        Specification[] specificationArray3 = procedure.getSpecification();
        int n11 = specificationArray3.length;
        n10 = 0;
        while (n10 < n11) {
            Specification spec = specificationArray3[n10];
            if (spec instanceof RequiresSpecification) {
                Expression pre = ((RequiresSpecification)spec).getFormula();
                Expression2Term.SingleTermResult tlres = this.mExpression2Term.translateToTerm(reqIts, pre);
                this.mAuxVars.addAll(tlres.getAuxiliaryVars());
                this.mOverapproximations.putAll(tlres.getOverappoximations());
                Term f = tlres.getTerm();
                this.mAssumes = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{f, this.mAssumes});
            }
            ++n10;
        }
        this.eliminateAuxVarsViaDer();
    }

    private void addForkCurrentThread(ForkStatement fork) {
    }

    private void addJoinCurrentThread(JoinStatement join) {
    }

    private void removeInVar(IProgramVar boogieVar) {
        TermVariable tv = this.mTransFormulaBuilder.removeInVar(boogieVar);
        if (this.mTransFormulaBuilder.getOutVar(boogieVar) != tv) {
            this.mAuxVars.add(tv);
        }
    }

    private TermVariable getOrConstuctCurrentRepresentative(IProgramVar bv) {
        TermVariable tv = this.mTransFormulaBuilder.getInVar(bv);
        if (tv == null) {
            tv = this.createInVar(bv);
            if (!this.mTransFormulaBuilder.containsOutVar(bv)) {
                this.mTransFormulaBuilder.addOutVar(bv, tv);
            }
        }
        return tv;
    }

    private TermVariable createInVar(IProgramVar bv) {
        TermVariable tv = bv.isOldvar() ? bv.getTermVariable() : this.mBoogie2SMT.getManagedScript().constructFreshTermVariable(bv.getGloballyUniqueId(), bv.getTermVariable().getSort());
        this.mTransFormulaBuilder.addInVar(bv, tv);
        return tv;
    }

    private void eliminateAuxVarsViaDer() {
        if (this.mAuxVars.isEmpty()) {
            return;
        }
        XnfDer xnfDer = new XnfDer(this.mMgdScript, this.mServices);
        this.mAssumes = SmtUtils.and((Script)this.mScript, (Term[])xnfDer.tryToEliminate(0, SmtUtils.getConjuncts((Term)this.mAssumes), this.mAuxVars));
    }

    private Term skolemize(Term input, Set<TermVariable> auxVars) {
        Term result;
        Term nnf = new NnfTransformer(this.mMgdScript, this.mServices, NnfTransformer.QuantifierHandling.KEEP).transform(input);
        Term pnf = new PrenexNormalForm(this.mMgdScript).transform(nnf);
        QuantifierSequence qs = new QuantifierSequence(this.mMgdScript, pnf);
        List qvs = qs.getQuantifierBlocks();
        if (qvs.isEmpty() || ((QuantifierSequence.QuantifiedVariables)qvs.get(0)).getQuantifier() == 1) {
            result = pnf;
        } else {
            if (qvs.size() > 1) {
                throw new UnsupportedOperationException("support for alternating quantifiers not yet implemented");
            }
            HashMap<TermVariable, TermVariable> substitutionMapping = new HashMap<TermVariable, TermVariable>();
            for (TermVariable tv : ((QuantifierSequence.QuantifiedVariables)qvs.get(0)).getVariables()) {
                TermVariable newTv = this.mMgdScript.constructFreshTermVariable("skolemized_" + tv.getName(), tv.getSort());
                substitutionMapping.put(tv, newTv);
                auxVars.add(newTv);
            }
            result = Substitution.apply((ManagedScript)this.mMgdScript, substitutionMapping, (Term)qs.getInnerTerm());
        }
        return result;
    }

    public TranslationResult statementSequence(SmtUtils.SimplificationTechnique simplicationTechnique, String procId, List<Statement> statements) {
        this.initialize(procId);
        int i = statements.size() - 1;
        while (i >= 0) {
            Statement st = statements.get(i);
            if (st instanceof AssumeStatement) {
                this.addAssume((AssumeStatement)st);
            } else if (st instanceof AssignmentStatement) {
                this.addAssignment((AssignmentStatement)st);
            } else if (st instanceof HavocStatement) {
                this.addHavoc((HavocStatement)st);
            } else if (st instanceof CallStatement) {
                this.addSummary((CallStatement)st);
            } else if (st instanceof ForkStatement) {
                this.addForkCurrentThread((ForkStatement)st);
            } else if (st instanceof JoinStatement) {
                this.addJoinCurrentThread((JoinStatement)st);
            } else {
                throw new IllegalArgumentException("Intenal Edge only contains Assume, Assignment or Havoc Statement");
            }
            --i;
        }
        return this.getTransFormula(false, simplicationTechnique);
    }

    public TranslationResult inParamAssignment(CallStatement st, SmtUtils.SimplificationTechnique simplicationTechnique) {
        return this.inParamAssignment(st.getMethodName(), st.getArguments(), simplicationTechnique);
    }

    @Deprecated
    public TranslationResult inParamAssignment(ForkStatement st, SmtUtils.SimplificationTechnique simplicationTechnique) {
        return this.inParamAssignment(st.getProcedureName(), st.getArguments(), simplicationTechnique);
    }

    private TranslationResult inParamAssignment(String callee, Expression[] arguments, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.initialize(callee);
        Procedure calleeImpl = this.mBoogieDeclarations.getProcImplementation().get(callee);
        Expression2Term.IIdentifierTranslator[] its = this.getIdentifierTranslatorsIntraprocedural();
        Expression2Term.MultiTermResult tlres = this.mExpression2Term.translateToTerms(its, arguments);
        this.mAuxVars.addAll(tlres.getAuxiliaryVars());
        this.mOverapproximations.putAll(tlres.getOverappoximations());
        Term[] argTerms = tlres.getTerms();
        this.mTransFormulaBuilder.removeOutVarsOfLocalContext();
        DeclarationInformation declInfo = new DeclarationInformation(DeclarationInformation.StorageClass.PROC_FUNC_INPARAM, callee);
        Term[] assignments = new Term[arguments.length];
        int offset = 0;
        VarList[] varListArray = calleeImpl.getInParams();
        int n = varListArray.length;
        int n2 = 0;
        while (n2 < n) {
            VarList varList = varListArray[n2];
            String[] stringArray = varList.getIdentifiers();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String var = stringArray[n4];
                IProgramVar boogieVar = this.mBoogie2SMT.getBoogie2SmtSymbolTable().getBoogieVar(var, declInfo, false);
                assert (boogieVar != null);
                TermVariable tv = this.constructTermVariableWithSuffix(boogieVar, "InParam");
                this.mTransFormulaBuilder.addOutVar(boogieVar, tv);
                assignments[offset] = SmtUtils.binaryEquality((Script)this.mScript, (Term)tv, (Term)argTerms[offset]);
                ++offset;
                ++n4;
            }
            ++n2;
        }
        assert (arguments.length == offset);
        this.mAssumes = SmtUtils.and((Script)this.mScript, (Term[])assignments);
        this.eliminateAuxVarsViaDer();
        return this.getTransFormula(true, SmtUtils.SimplificationTechnique.NONE);
    }

    @Deprecated
    public TranslationResult forkThreadIdAssignment(IProgramVar[] threadTemplateIdVar, String forkingProcedureId, Expression[] forkThreadIdExpressions, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.initialize(forkingProcedureId);
        Expression2Term.IIdentifierTranslator[] its = this.getIdentifierTranslatorsIntraprocedural();
        Expression2Term.MultiTermResult tlres = this.mExpression2Term.translateToTerms(its, forkThreadIdExpressions);
        this.mAuxVars.addAll(tlres.getAuxiliaryVars());
        this.mOverapproximations.putAll(tlres.getOverappoximations());
        Term[] argTerms = tlres.getTerms();
        this.mTransFormulaBuilder.clearOutVars();
        int offset = 0;
        Term[] assignments = new Term[argTerms.length];
        Term[] termArray = argTerms;
        int n = argTerms.length;
        int n2 = 0;
        while (n2 < n) {
            Term argTerm = termArray[n2];
            TermVariable tv = this.constructTermVariableWithSuffix(threadTemplateIdVar[offset], "ThreadTemplateId");
            this.mTransFormulaBuilder.addOutVar(threadTemplateIdVar[offset], tv);
            assignments[offset] = SmtUtils.binaryEquality((Script)this.mScript, (Term)tv, (Term)argTerm);
            ++offset;
            ++n2;
        }
        this.mAssumes = SmtUtils.and((Script)this.mScript, (Term[])assignments);
        this.eliminateAuxVarsViaDer();
        return this.getTransFormula(true, SmtUtils.SimplificationTechnique.NONE);
    }

    @Deprecated
    public TranslationResult joinThreadIdAssumption(IProgramVar[] forkIdAuxVar, String joiningThreadProcedureId, Expression[] joinedThreadIdExpressions, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.initialize(joiningThreadProcedureId);
        Expression2Term.IIdentifierTranslator[] its = this.getIdentifierTranslatorsIntraprocedural();
        Expression2Term.MultiTermResult tlres = this.mExpression2Term.translateToTerms(its, joinedThreadIdExpressions);
        this.mAuxVars.addAll(tlres.getAuxiliaryVars());
        this.mOverapproximations.putAll(tlres.getOverappoximations());
        Term[] argTerms = tlres.getTerms();
        int offset = 0;
        Term[] assignments = new Term[argTerms.length];
        Term[] termArray = argTerms;
        int n = argTerms.length;
        int n2 = 0;
        while (n2 < n) {
            Term argTerm = termArray[n2];
            TermVariable tv = this.createInVar(forkIdAuxVar[offset]);
            this.mTransFormulaBuilder.addOutVar(forkIdAuxVar[offset], tv);
            assignments[offset] = SmtUtils.binaryEquality((Script)this.mScript, (Term)tv, (Term)argTerm);
            ++offset;
            ++n2;
        }
        this.mAssumes = SmtUtils.and((Script)this.mScript, (Term[])assignments);
        this.eliminateAuxVarsViaDer();
        return this.getTransFormula(true, SmtUtils.SimplificationTechnique.NONE);
    }

    public TranslationResult resultAssignment(CallStatement st, String caller, SmtUtils.SimplificationTechnique simplicationTechnique) {
        this.initialize(caller);
        String callee = st.getMethodName();
        Procedure impl = this.mBoogieDeclarations.getProcImplementation().get(callee);
        int offset = 0;
        DeclarationInformation declInfo = new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM, callee);
        Term[] assignments = new Term[st.getLhs().length];
        VarList[] varListArray = impl.getOutParams();
        int n = varListArray.length;
        int n2 = 0;
        while (n2 < n) {
            VarList ourParamVarList = varListArray[n2];
            String[] stringArray = ourParamVarList.getIdentifiers();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String outParamId = stringArray[n4];
                IProgramVar outParamBv = this.mBoogie2SmtSymbolTable.getBoogieVar(outParamId, declInfo, false);
                TermVariable outParamTv = this.constructTermVariableWithSuffix(outParamBv, "OutParam");
                this.mTransFormulaBuilder.addInVar(outParamBv, outParamTv);
                String callLhsId = st.getLhs()[offset].getIdentifier();
                DeclarationInformation callLhsDeclInfo = st.getLhs()[offset].getDeclarationInformation();
                IProgramVar callLhsBv = this.mBoogie2SmtSymbolTable.getBoogieVar(callLhsId, callLhsDeclInfo, false);
                TermVariable callLhsTv = this.mBoogie2SMT.getManagedScript().constructFreshTermVariable(callLhsBv.getGloballyUniqueId(), callLhsBv.getTermVariable().getSort());
                this.mTransFormulaBuilder.addOutVar(callLhsBv, callLhsTv);
                assignments[offset] = SmtUtils.binaryEquality((Script)this.mScript, (Term)callLhsTv, (Term)outParamTv);
                ++offset;
                ++n4;
            }
            ++n2;
        }
        assert (st.getLhs().length == offset);
        this.mAssumes = SmtUtils.and((Script)this.mScript, (Term[])assignments);
        this.eliminateAuxVarsViaDer();
        return this.getTransFormula(true, SmtUtils.SimplificationTechnique.NONE);
    }

    @Deprecated
    public TranslationResult resultAssignment(JoinStatement st, String caller, String callee, SmtUtils.SimplificationTechnique simplificationTechnique) {
        this.initialize(caller);
        Procedure impl = this.mBoogieDeclarations.getProcImplementation().get(callee);
        int offset = 0;
        DeclarationInformation declInfo = new DeclarationInformation(DeclarationInformation.StorageClass.IMPLEMENTATION_OUTPARAM, callee);
        Term[] assignments = new Term[st.getLhs().length];
        VarList[] varListArray = impl.getOutParams();
        int n = varListArray.length;
        int n2 = 0;
        while (n2 < n) {
            VarList ourParamVarList = varListArray[n2];
            String[] stringArray = ourParamVarList.getIdentifiers();
            int n3 = stringArray.length;
            int n4 = 0;
            while (n4 < n3) {
                String outParamId = stringArray[n4];
                IProgramVar outParamBv = this.mBoogie2SmtSymbolTable.getBoogieVar(outParamId, declInfo, false);
                TermVariable outParamTv = this.constructTermVariableWithSuffix(outParamBv, "OutParam");
                this.mTransFormulaBuilder.addInVar(outParamBv, outParamTv);
                String callLhsId = st.getLhs()[offset].getIdentifier();
                DeclarationInformation callLhsDeclInfo = st.getLhs()[offset].getDeclarationInformation();
                IProgramVar callLhsBv = this.mBoogie2SmtSymbolTable.getBoogieVar(callLhsId, callLhsDeclInfo, false);
                TermVariable callLhsTv = this.mBoogie2SMT.getManagedScript().constructFreshTermVariable(callLhsBv.getGloballyUniqueId(), callLhsBv.getTermVariable().getSort());
                this.mTransFormulaBuilder.addOutVar(callLhsBv, callLhsTv);
                assignments[offset] = SmtUtils.binaryEquality((Script)this.mScript, (Term)callLhsTv, (Term)outParamTv);
                ++offset;
                ++n4;
            }
            ++n2;
        }
        assert (st.getLhs().length == offset);
        this.mAssumes = SmtUtils.and((Script)this.mScript, (Term[])assignments);
        this.eliminateAuxVarsViaDer();
        return this.getTransFormula(true, SmtUtils.SimplificationTechnique.NONE);
    }

    public TermVariable constructTermVariableWithSuffix(IProgramVar bv, String suffix) {
        String name = String.valueOf(bv.getGloballyUniqueId()) + SmtUtils.removeSmtQuoteCharacters((String)suffix);
        Sort sort = bv.getTermVariable().getSort();
        TermVariable result = this.mBoogie2SMT.getManagedScript().constructFreshTermVariable(name, sort);
        return result;
    }

    public class GlobalVarTranslatorWithInOutVarManagement
    extends IdentifierTranslatorWithInOutVarManagement {
        private final String mInnerCurrentProcedure;
        private final boolean mAllNonOld;
        private final Set<String> mModifiableByCurrentProcedure;

        public GlobalVarTranslatorWithInOutVarManagement(String currentProcedure, boolean allNonOld) {
            this.mInnerCurrentProcedure = currentProcedure;
            this.mAllNonOld = allNonOld;
            this.mModifiableByCurrentProcedure = Statements2TransFormula.this.mBoogieDeclarations.getModifiedVars().get(this.mInnerCurrentProcedure);
        }

        @Override
        protected IProgramVar getBoogieVar(String id, DeclarationInformation declInfo, boolean isOldContext, BoogieASTNode boogieASTNode) {
            DeclarationInformation.StorageClass storageClass = declInfo.getStorageClass();
            switch (storageClass) {
                case PROC_FUNC_INPARAM: 
                case PROC_FUNC_OUTPARAM: 
                case IMPLEMENTATION_INPARAM: 
                case IMPLEMENTATION_OUTPARAM: 
                case LOCAL: {
                    return null;
                }
                case GLOBAL: {
                    IProgramVar bv = isOldContext ? (this.mAllNonOld || !this.modifiableByCurrentProcedure(id) ? Statements2TransFormula.this.mBoogie2SmtSymbolTable.getBoogieVar(id, declInfo, false) : Statements2TransFormula.this.mBoogie2SmtSymbolTable.getBoogieVar(id, declInfo, true)) : Statements2TransFormula.this.mBoogie2SmtSymbolTable.getBoogieVar(id, declInfo, false);
                    return bv;
                }
            }
            throw new AssertionError();
        }

        private boolean modifiableByCurrentProcedure(String id) {
            return this.mModifiableByCurrentProcedure.contains(id);
        }
    }

    public abstract class IdentifierTranslatorWithInOutVarManagement
    implements Expression2Term.IIdentifierTranslator {
        @Override
        public Term getSmtIdentifier(String id, DeclarationInformation declInfo, boolean isOldContext, BoogieASTNode boogieASTNode) {
            IProgramVar bv = this.getBoogieVar(id, declInfo, isOldContext, boogieASTNode);
            if (bv == null) {
                return null;
            }
            TermVariable tv = Statements2TransFormula.this.getOrConstuctCurrentRepresentative(bv);
            return tv;
        }

        protected abstract IProgramVar getBoogieVar(String var1, DeclarationInformation var2, boolean var3, BoogieASTNode var4);
    }

    public class LocalVarTranslatorWithInOutVarManagement
    extends IdentifierTranslatorWithInOutVarManagement {
        @Override
        protected IProgramVar getBoogieVar(String id, DeclarationInformation declInfo, boolean isOldContext, BoogieASTNode boogieASTNode) {
            DeclarationInformation.StorageClass storageClass = declInfo.getStorageClass();
            switch (storageClass) {
                case PROC_FUNC_INPARAM: 
                case PROC_FUNC_OUTPARAM: 
                case IMPLEMENTATION_INPARAM: 
                case IMPLEMENTATION_OUTPARAM: 
                case LOCAL: {
                    return Statements2TransFormula.this.mBoogie2SmtSymbolTable.getBoogieVar(id, declInfo, isOldContext);
                }
                case GLOBAL: {
                    return null;
                }
            }
            throw new AssertionError();
        }
    }

    public class SubstitutionTranslatorBoogieVar
    implements Expression2Term.IIdentifierTranslator {
        private final Map<IProgramVar, Term> mSubstitution;

        public SubstitutionTranslatorBoogieVar(Map<IProgramVar, Term> substitution) {
            this.mSubstitution = substitution;
        }

        @Override
        public Term getSmtIdentifier(String id, DeclarationInformation declInfo, boolean isOldContext, BoogieASTNode boogieASTNode) {
            IProgramVar bv = Statements2TransFormula.this.mBoogie2SmtSymbolTable.getBoogieVar(id, declInfo, isOldContext);
            if (bv == null) {
                return null;
            }
            return this.mSubstitution.get(bv);
        }
    }

    private class SubstitutionTranslatorId
    implements Expression2Term.IIdentifierTranslator {
        private final Map<String, Term> mSubstitution;

        public SubstitutionTranslatorId(Map<String, Term> substitution) {
            this.mSubstitution = substitution;
        }

        @Override
        public Term getSmtIdentifier(String id, DeclarationInformation declInfo, boolean isOldContext, BoogieASTNode boogieASTNode) {
            return this.mSubstitution.get(id);
        }
    }

    public static final class TranslationResult {
        private final UnmodifiableTransFormula mTransFormula;
        private final Map<String, ILocation> mOverapproximations;

        public TranslationResult(UnmodifiableTransFormula transFormula, Map<String, ILocation> overapproximations) {
            this.mTransFormula = transFormula;
            this.mOverapproximations = overapproximations;
        }

        public UnmodifiableTransFormula getTransFormula() {
            return this.mTransFormula;
        }

        public Map<String, ILocation> getOverapproximations() {
            return this.mOverapproximations;
        }
    }
}

