/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.TypeDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieArrayType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieConstructedType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogiePrimitiveType;
import de.uni_freiburg.informatik.ultimate.boogie.type.BoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.models.IBoogieType;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SMT;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Boogie2SmtSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;

public class TypeSortTranslator {
    protected final Script mScript;
    private final Map<IBoogieType, Sort> mType2Sort = new HashMap<IBoogieType, Sort>();
    private final Map<Sort, IBoogieType> mSort2Type = new HashMap<Sort, IBoogieType>();
    private final Map<String, Map<String, Expression[]>> mType2Attributes = new HashMap<String, Map<String, Expression[]>>();
    private final IUltimateServiceProvider mServices;

    public TypeSortTranslator(Collection<TypeDeclaration> declarations, Script script, IUltimateServiceProvider services) {
        this.mServices = services;
        this.mScript = script;
        Sort boolSort = SmtSortUtils.getBoolSort((Script)this.mScript);
        BoogiePrimitiveType boolType = BoogieType.TYPE_BOOL;
        this.cacheSort((IBoogieType)boolType, boolSort);
        for (TypeDeclaration typeDecl : declarations) {
            this.declareType(typeDecl);
        }
    }

    public TypeSortTranslator(HashRelation<Sort, IBoogieType> sortToType, Script script, IUltimateServiceProvider services) {
        this.mServices = services;
        this.mScript = script;
        for (Map.Entry en : sortToType.getSetOfPairs()) {
            this.cacheSort((IBoogieType)en.getValue(), (Sort)en.getKey());
        }
    }

    public TypeSortTranslator(Script script, IUltimateServiceProvider services) {
        this(Collections.emptySet(), script, services);
        Sort intSort = SmtSortUtils.getIntSort((Script)this.mScript);
        BoogiePrimitiveType boolType = BoogieType.TYPE_INT;
        this.cacheSort((IBoogieType)boolType, intSort);
    }

    public IBoogieType getType(Sort sort) {
        IBoogieType type = this.mSort2Type.get(sort);
        if (type == null) {
            if (sort.isArraySort()) {
                assert (SmtSortUtils.isArraySort((Sort)sort));
                Sort indexSort = sort.getArguments()[0];
                Sort valueSort = sort.getArguments()[1];
                BoogieType[] indexTypes = new BoogieType[]{(BoogieType)this.getType(indexSort)};
                BoogieType valueType = (BoogieType)this.getType(valueSort);
                type = BoogieType.createArrayType((int)0, (BoogieType[])indexTypes, (BoogieType)valueType);
            } else {
                if (SmtSortUtils.isBitvecSort((Sort)sort)) {
                    String bvsize = sort.getIndices()[0];
                    type = BoogieType.createBitvectorType((int)Integer.valueOf(bvsize));
                    return type;
                }
                throw new IllegalArgumentException("Unknown sort " + sort);
            }
        }
        return type;
    }

    public Sort getSort(IBoogieType type, BoogieASTNode astNode) {
        if (type instanceof BoogieType) {
            type = ((BoogieType)type).getUnderlyingType();
        }
        if (this.mType2Sort.containsKey(type)) {
            return this.mType2Sort.get(type);
        }
        return this.constructSort(type, astNode);
    }

    private void declareType(TypeDeclaration typeDecl) {
        String[] typeParams = typeDecl.getTypeParams();
        if (typeParams.length != 0) {
            throw new IllegalArgumentException("Only types without parameters supported");
        }
        String id = typeDecl.getIdentifier();
        Map<String, Expression[]> attributes = Boogie2SmtSymbolTable.extractAttributes((Declaration)typeDecl);
        if (attributes != null) {
            this.mType2Attributes.put(id, attributes);
            String attributeDefinedIdentifier = Boogie2SmtSymbolTable.checkForAttributeDefinedIdentifier(attributes, "builtin");
            if (attributeDefinedIdentifier != null) {
                return;
            }
        }
        if (typeDecl.getSynonym() == null) {
            this.mScript.declareSort(id, 0);
        } else {
            Sort synonymSort = this.getSort(typeDecl.getSynonym().getBoogieType(), (BoogieASTNode)typeDecl);
            this.mScript.defineSort(id, new Sort[0], synonymSort);
        }
    }

    protected Sort constructSort(IBoogieType boogieType, BoogieASTNode astNode) {
        try {
            Sort result = this.constructSort(boogieType, this.mType2Attributes::get);
            return result;
        }
        catch (SMTLIBException e) {
            if ("Sort Array not declared".equals(e.getMessage())) {
                Boogie2SMT.reportUnsupportedSyntax(astNode, "Solver does not support arrays", this.mServices);
                throw e;
            }
            throw new AssertionError((Object)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Sort constructSort(IBoogieType boogieType, Function<String, Map<String, Expression[]>> funAttributeCache) {
        Sort result;
        if (boogieType instanceof BoogiePrimitiveType) {
            if (boogieType.equals(BoogieType.TYPE_BOOL)) {
                result = SmtSortUtils.getBoolSort((Script)this.mScript);
            } else if (boogieType.equals(BoogieType.TYPE_INT)) {
                result = SmtSortUtils.getIntSort((Script)this.mScript);
            } else if (boogieType.equals(BoogieType.TYPE_REAL)) {
                result = SmtSortUtils.getRealSort((Script)this.mScript);
            } else {
                if (boogieType.equals(BoogieType.TYPE_ERROR)) {
                    throw new IllegalArgumentException("BoogieAST contains type errors.");
                }
                if (((BoogiePrimitiveType)boogieType).getTypeCode() <= 0) throw new IllegalArgumentException("Unsupported PrimitiveType " + boogieType);
                int bitvectorSize = ((BoogiePrimitiveType)boogieType).getTypeCode();
                result = SmtSortUtils.getBitvectorSort((Script)this.mScript, (int)bitvectorSize);
            }
        } else if (boogieType instanceof BoogieArrayType) {
            BoogieArrayType arrayType = (BoogieArrayType)boogieType;
            Sort rangeSort = this.constructSort((IBoogieType)arrayType.getValueType(), funAttributeCache);
            int i = arrayType.getIndexCount() - 1;
            while (i >= 1) {
                Sort sorti = this.constructSort((IBoogieType)arrayType.getIndexType(i), funAttributeCache);
                rangeSort = SmtSortUtils.getArraySort((Script)this.mScript, (Sort)sorti, (Sort)rangeSort);
                --i;
            }
            Sort domainSort = this.constructSort((IBoogieType)arrayType.getIndexType(0), funAttributeCache);
            result = SmtSortUtils.getArraySort((Script)this.mScript, (Sort)domainSort, (Sort)rangeSort);
        } else {
            if (!(boogieType instanceof BoogieConstructedType)) throw new IllegalArgumentException("Unsupported type " + boogieType);
            BoogieConstructedType constructedType = (BoogieConstructedType)boogieType;
            String name = constructedType.getConstr().getName();
            Map<String, Expression[]> attributes = funAttributeCache.apply(name);
            if (attributes == null) {
                result = SmtSortUtils.getNamedSort((Script)this.mScript, (String)name);
            } else {
                String attributeDefinedIdentifier = Boogie2SmtSymbolTable.checkForAttributeDefinedIdentifier(attributes, "builtin");
                if (attributeDefinedIdentifier == null) {
                    result = SmtSortUtils.getNamedSort((Script)this.mScript, (String)name);
                } else {
                    String[] indices = Boogie2SmtSymbolTable.checkForIndices(attributes);
                    result = SmtSortUtils.getBuiltinSort((Script)this.mScript, (String)attributeDefinedIdentifier, (String[])indices);
                }
            }
        }
        this.cacheSort(boogieType, result);
        return result;
    }

    private void cacheSort(IBoogieType boogieType, Sort result) {
        this.mType2Sort.put(boogieType, result);
        this.mSort2Type.put(result, boogieType);
    }
}

