/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg;

import de.uni_freiburg.informatik.ultimate.core.lib.models.BasePayloadContainer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class BasicIcfg<LOC extends IcfgLocation>
extends BasePayloadContainer
implements IIcfg<LOC> {
    private static final long serialVersionUID = 1L;
    private final Map<String, Map<DebugIdentifier, LOC>> mProgramPoints;
    private final Map<String, LOC> mEntryNodes;
    private final Map<String, LOC> mExitNodes;
    private final Map<String, Set<LOC>> mErrorNodes;
    private final Set<LOC> mLoopLocations;
    private CfgSmtToolkit mCfgSmtToolkit;
    private final Set<LOC> mInitialNodes;
    private final String mIdentifier;
    private final Class<LOC> mLocationClass;

    public BasicIcfg(String identifier, CfgSmtToolkit cfgSmtToolkit, Class<LOC> locClazz) {
        this.mLocationClass = Objects.requireNonNull(locClazz);
        this.mIdentifier = Objects.requireNonNull(identifier);
        this.mCfgSmtToolkit = Objects.requireNonNull(cfgSmtToolkit);
        this.mInitialNodes = new LinkedHashSet<LOC>();
        this.mLoopLocations = new LinkedHashSet<LOC>();
        this.mProgramPoints = new LinkedHashMap<String, Map<DebugIdentifier, LOC>>();
        this.mEntryNodes = new LinkedHashMap<String, LOC>();
        this.mExitNodes = new LinkedHashMap<String, LOC>();
        this.mErrorNodes = new LinkedHashMap<String, Set<LOC>>();
        for (String proc : this.mCfgSmtToolkit.getProcedures()) {
            this.mProgramPoints.put(proc, new LinkedHashMap());
            this.mErrorNodes.put(proc, new LinkedHashSet());
        }
    }

    public void addProcedure(String proc) {
        this.mProgramPoints.put(proc, new LinkedHashMap());
        this.mErrorNodes.put(proc, new LinkedHashSet());
    }

    public void addLocation(LOC loc, boolean isInitial, boolean isError, boolean isProcEntry, boolean isProcExit, boolean isLoopLocation) {
        if (loc == null) {
            throw new IllegalArgumentException("Cannot add null location");
        }
        assert (this.getLocationClass().isAssignableFrom(loc.getClass())) : "Incompatible location types. Should be subclass of " + this.getLocationClass() + " but is " + loc.getClass();
        String proc = BasicIcfg.getProcedure(loc);
        Map<DebugIdentifier, LOC> name2Loc = this.mProgramPoints.get(proc);
        assert (name2Loc != null) : "Unknown procedure";
        IcfgLocation old = (IcfgLocation)name2Loc.put(((IcfgLocation)loc).getDebugIdentifier(), loc);
        if (((IcfgLocation)loc).equals(old)) {
            return;
        }
        assert (old == null) : "Duplicate debug identifier for loc " + loc;
        if (isInitial) {
            this.mInitialNodes.add(loc);
        }
        if (isError) {
            Set<LOC> procErrors = this.mErrorNodes.get(proc);
            assert (procErrors != null) : "Unknown procedure";
            procErrors.add(loc);
        }
        if (isProcEntry) {
            IcfgLocation oldEntry = (IcfgLocation)this.mEntryNodes.put(proc, loc);
            assert (oldEntry == null || ((IcfgLocation)loc).equals(oldEntry)) : "Do not overwrite the procedure entry node by mistake! Remove the old one first";
        }
        if (isProcExit) {
            IcfgLocation oldExit = (IcfgLocation)this.mExitNodes.put(proc, loc);
            assert (oldExit == null || ((IcfgLocation)loc).equals(oldExit)) : "Do not overwrite the procedure exit node by mistake! Remove the old one first";
        }
        if (isLoopLocation) {
            this.mLoopLocations.add(loc);
        }
    }

    public void addOrdinaryLocation(LOC loc) {
        this.addLocation(loc, false, false, false, false, false);
    }

    public boolean removeLocation(IcfgLocation loc) {
        IcfgLocation exitLoc;
        if (loc == null) {
            return false;
        }
        String proc = BasicIcfg.getProcedure(loc);
        Map<DebugIdentifier, LOC> name2loc = this.mProgramPoints.get(proc);
        if (name2loc == null) {
            return false;
        }
        IcfgLocation removedLoc = (IcfgLocation)name2loc.remove(loc.getDebugIdentifier());
        if (!loc.equals(removedLoc)) {
            assert (removedLoc == null) : "Multiple nodes with identical debug identifier!";
            return false;
        }
        IcfgLocation entryLoc = (IcfgLocation)this.mEntryNodes.get(proc);
        if (loc.equals(entryLoc)) {
            this.mEntryNodes.remove(proc);
        }
        if (loc.equals(exitLoc = (IcfgLocation)this.mExitNodes.get(proc))) {
            this.mExitNodes.remove(proc);
        }
        Set<LOC> errorLocs = this.mErrorNodes.get(proc);
        errorLocs.remove(loc);
        this.mLoopLocations.remove(loc);
        this.mInitialNodes.remove(loc);
        return true;
    }

    private static String getProcedure(IcfgLocation loc) {
        String proc = loc.getProcedure();
        assert (proc != null) : "Location " + loc + " does not have a procedure";
        return proc;
    }

    @Override
    public Map<String, Map<DebugIdentifier, LOC>> getProgramPoints() {
        return Collections.unmodifiableMap(this.mProgramPoints);
    }

    @Override
    public Map<String, LOC> getProcedureEntryNodes() {
        return Collections.unmodifiableMap(this.mEntryNodes);
    }

    @Override
    public Map<String, LOC> getProcedureExitNodes() {
        return Collections.unmodifiableMap(this.mExitNodes);
    }

    @Override
    public Map<String, Set<LOC>> getProcedureErrorNodes() {
        return Collections.unmodifiableMap(this.mErrorNodes);
    }

    @Override
    public Set<LOC> getLoopLocations() {
        return Collections.unmodifiableSet(this.mLoopLocations);
    }

    @Override
    public CfgSmtToolkit getCfgSmtToolkit() {
        return this.mCfgSmtToolkit;
    }

    public void setCfgSmtToolkit(CfgSmtToolkit cfgSmtToolkit) {
        this.mCfgSmtToolkit = cfgSmtToolkit;
    }

    @Override
    public Set<LOC> getInitialNodes() {
        return Collections.unmodifiableSet(this.mInitialNodes);
    }

    public Set<IcfgEdge> getInitialOutgoingEdges() {
        return this.getInitialNodes().stream().flatMap(a -> a.getOutgoingEdges().stream()).collect(Collectors.toSet());
    }

    @Override
    public String getIdentifier() {
        return this.mIdentifier;
    }

    @Override
    public Class<LOC> getLocationClass() {
        return this.mLocationClass;
    }

    public String toString() {
        return this.graphStructureToString();
    }
}

