/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class DefaultIcfgSymbolTable
implements IIcfgSymbolTable {
    protected final Map<TermVariable, IProgramVar> mTermVariable2ProgramVar = new HashMap<TermVariable, IProgramVar>();
    protected final Map<ApplicationTerm, IProgramConst> mAppTerm2ProgramConst = new HashMap<ApplicationTerm, IProgramConst>();
    protected final Set<IProgramNonOldVar> mGlobals = new HashSet<IProgramNonOldVar>();
    protected final Set<IProgramConst> mConstants = new HashSet<IProgramConst>();
    protected final HashRelation<String, ILocalProgramVar> mLocals = new HashRelation();
    protected boolean mConstructionFinished = false;

    public DefaultIcfgSymbolTable() {
    }

    public DefaultIcfgSymbolTable(IIcfgSymbolTable symbolTable, Set<String> procs) {
        for (IProgramConst constant : symbolTable.getConstants()) {
            this.add(constant);
        }
        for (IProgramNonOldVar nonold : symbolTable.getGlobals()) {
            this.add(nonold);
        }
        for (String proc : procs) {
            for (ILocalProgramVar local : symbolTable.getLocals(proc)) {
                this.add(local);
            }
        }
        assert (this.checkGlobals());
    }

    @Override
    public IProgramVar getProgramVar(TermVariable tv) {
        return this.mTermVariable2ProgramVar.get(tv);
    }

    @Override
    public IProgramConst getProgramConst(ApplicationTerm smtConstant) {
        return this.mAppTerm2ProgramConst.get(smtConstant);
    }

    @Override
    public Set<IProgramNonOldVar> getGlobals() {
        return Collections.unmodifiableSet(this.mGlobals);
    }

    @Override
    public Set<IProgramConst> getConstants() {
        return Collections.unmodifiableSet(this.mConstants);
    }

    @Override
    public Set<ILocalProgramVar> getLocals(String proc) {
        Set locals = this.mLocals.getImage((Object)proc);
        if (locals == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.mLocals.getImage((Object)proc));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void add(IProgramVarOrConst varOrConst) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, unable to add new variables or constants.");
        }
        if (varOrConst instanceof IProgramConst) {
            IProgramConst pc = (IProgramConst)varOrConst;
            this.mConstants.add(pc);
            this.mAppTerm2ProgramConst.put(pc.getDefaultConstant(), pc);
            return;
        } else {
            if (!(varOrConst instanceof IProgramVar)) throw new AssertionError((Object)"unknown kind of variable");
            IProgramVar var = (IProgramVar)varOrConst;
            this.mTermVariable2ProgramVar.put(var.getTermVariable(), var);
            if (var instanceof IProgramOldVar || var.isOldvar()) {
                throw new IllegalArgumentException("cannot add oldvar, add nonoldvar instead: " + var);
            }
            if (var instanceof ILocalProgramVar) {
                this.mLocals.addPair((Object)var.getProcedure(), (Object)((ILocalProgramVar)var));
                return;
            } else {
                if (!(var instanceof IProgramNonOldVar)) throw new AssertionError((Object)"unknown kind of variable");
                IProgramNonOldVar nonOldVar = (IProgramNonOldVar)var;
                this.mGlobals.add(nonOldVar);
                IProgramOldVar oldVar = nonOldVar.getOldVar();
                this.mTermVariable2ProgramVar.put(oldVar.getTermVariable(), oldVar);
                assert (Objects.equals(oldVar.getNonOldVar(), var)) : "getNonOldVar() and getOldVar() should match, but do not! Oldvar: " + oldVar + " Var: " + var;
                return;
            }
        }
    }

    public void finishConstruction() {
        this.mConstructionFinished = true;
        assert (this.checkGlobals());
    }

    private boolean checkGlobals() {
        if (this.mTermVariable2ProgramVar.entrySet().stream().anyMatch(a -> a.getValue() == null)) {
            throw new AssertionError((Object)"Null entry in TermVar2ProgramVar");
        }
        Set programVars = this.mTermVariable2ProgramVar.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
        Set oldVars = programVars.stream().filter(IProgramVar::isOldvar).collect(Collectors.toSet());
        Optional<IProgramOldVar> any = oldVars.stream().map(a -> (IProgramOldVar)a).filter(a -> !programVars.contains(a.getNonOldVar())).findAny();
        if (any.isPresent()) {
            throw new AssertionError((Object)("old var with no corresponding var: " + any.get()));
        }
        return true;
    }

    @Override
    public Set<ApplicationTerm> computeAllDefaultConstants() {
        LinkedHashSet<ApplicationTerm> rtr = new LinkedHashSet<ApplicationTerm>();
        this.mGlobals.stream().map(a -> a.getDefaultConstant()).forEachOrdered(rtr::add);
        this.mLocals.getSetOfPairs().stream().map(a -> ((ILocalProgramVar)a.getValue()).getDefaultConstant()).forEachOrdered(rtr::add);
        return rtr;
    }
}

