/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.ITranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.ModelCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ConcurrencyInformation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ProcedureMultiplier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ThreadInstance;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ThreadInstanceAdder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IcfgDuplicator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class IcfgPetrifier {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final BasicIcfg<IcfgLocation> mPetrifiedIcfg;
    private final BlockEncodingBacktranslator mBacktranslator;

    public IcfgPetrifier(IUltimateServiceProvider services, IIcfg<?> icfg, int numberOfThreadInstances, boolean addSelfLoops) {
        this.mServices = services;
        this.mLogger = services.getLoggingService().getLogger(ModelCheckerUtils.PLUGIN_ID);
        BlockEncodingBacktranslator backtranslator = new BlockEncodingBacktranslator(IcfgEdge.class, Term.class, this.mLogger);
        IcfgDuplicator duplicator = new IcfgDuplicator(this.mLogger, this.mServices, icfg.getCfgSmtToolkit().getManagedScript(), backtranslator);
        this.mPetrifiedIcfg = duplicator.copy(icfg);
        Map<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>> old2newEdgeMapping = duplicator.getOld2NewEdgeMapping();
        ConcurrencyInformation concurrency = icfg.getCfgSmtToolkit().getConcurrencyInformation();
        List<IIcfgForkTransitionThreadCurrent<IcfgLocation>> forks = concurrency.getThreadInstanceMap().keySet().stream().map(x -> (IIcfgForkTransitionThreadCurrent)old2newEdgeMapping.get(x)).collect(Collectors.toList());
        List<IIcfgJoinTransitionThreadCurrent<IcfgLocation>> joins = concurrency.getJoinTransitions().stream().map(x -> (IIcfgJoinTransitionThreadCurrent)old2newEdgeMapping.get(x)).collect(Collectors.toList());
        ThreadInstanceAdder adder = new ThreadInstanceAdder(this.mServices, addSelfLoops);
        Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>> threadInstanceMap = ThreadInstanceAdder.constructThreadInstances(this.mPetrifiedIcfg, forks, numberOfThreadInstances);
        HashMap<IIcfgForkTransitionThreadCurrent<IcfgLocation>, IcfgLocation> inUseErrorNodeMap = new HashMap<IIcfgForkTransitionThreadCurrent<IcfgLocation>, IcfgLocation>();
        CfgSmtToolkit cfgSmtToolkit = adder.constructNewToolkit(this.mPetrifiedIcfg.getCfgSmtToolkit(), threadInstanceMap, inUseErrorNodeMap, joins);
        this.mPetrifiedIcfg.setCfgSmtToolkit(cfgSmtToolkit);
        List<ThreadInstance> instances = IcfgPetrifier.getAllInstances(threadInstanceMap);
        ProcedureMultiplier.duplicateProcedures(this.mServices, this.mPetrifiedIcfg, instances, backtranslator, threadInstanceMap, forks, joins);
        IcfgPetrifier.fillErrorNodeMap(threadInstanceMap.keySet(), inUseErrorNodeMap);
        inUseErrorNodeMap.values().forEach(x -> this.mPetrifiedIcfg.addLocation((IcfgLocation)x, false, true, false, false, false));
        adder.connectThreadInstances(this.mPetrifiedIcfg, forks, joins, threadInstanceMap, inUseErrorNodeMap, backtranslator);
        Set<Term> idVars = instances.stream().flatMap(x -> Arrays.stream(x.getIdVars())).map(IProgramVarOrConst::getTerm).collect(Collectors.toSet());
        backtranslator.setVariableBlacklist(idVars);
        this.mBacktranslator = backtranslator;
    }

    private static void fillErrorNodeMap(Set<IIcfgForkTransitionThreadCurrent<IcfgLocation>> forkTransitions, Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, IcfgLocation> inUseErrorNodeMap) {
        int errorNodeId = 0;
        for (IIcfgForkTransitionThreadCurrent<IcfgLocation> fork : forkTransitions) {
            IcfgLocation errNode = ThreadInstanceAdder.constructErrorLocation(errorNodeId, fork);
            inUseErrorNodeMap.put(fork, errNode);
            ++errorNodeId;
        }
    }

    public IIcfg<IcfgLocation> getPetrifiedIcfg() {
        return this.mPetrifiedIcfg;
    }

    public ITranslator<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>, Term, Term, IcfgLocation, IcfgLocation> getBacktranslator() {
        return this.mBacktranslator;
    }

    public static List<ThreadInstance> getAllInstances(Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>> threadInstanceMap) {
        return threadInstanceMap.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }
}

