/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg;

import de.uni_freiburg.informatik.ultimate.core.lib.results.NoBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.core.lib.translation.ProgramExecutionFormatter;
import de.uni_freiburg.informatik.ultimate.core.model.results.IRelevanceInformation;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadOther;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadOther;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgForkThreadOtherTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class IcfgProgramExecution<L extends IAction>
implements IProgramExecution<L, Term> {
    private final List<AtomicTraceElement<L>> mTrace;
    private final Map<Integer, IProgramExecution.ProgramState<Term>> mPartialProgramStateMapping;
    private final Map<TermVariable, Boolean>[] mBranchEncoders;
    private final boolean mIsConcurrent;
    private final Class<L> mTransitionClazz;

    public IcfgProgramExecution(List<AtomicTraceElement<L>> trace, Map<Integer, IProgramExecution.ProgramState<Term>> partialProgramStateMapping, Map<TermVariable, Boolean>[] branchEncoders, boolean isConcurrent, Class<L> transitionClazz) {
        assert (partialProgramStateMapping != null);
        assert (branchEncoders != null);
        assert (trace != null);
        assert (partialProgramStateMapping.size() - 1 <= trace.size());
        this.mIsConcurrent = isConcurrent;
        this.mTrace = trace;
        this.mPartialProgramStateMapping = partialProgramStateMapping;
        this.mBranchEncoders = branchEncoders;
        this.mTransitionClazz = transitionClazz;
    }

    public static <L extends IAction> IcfgProgramExecution<L> create(Class<L> transitionClazz) {
        return IcfgProgramExecution.create(Collections.emptyList(), Collections.emptyMap(), new ArrayList().toArray(new Map[0]), null, transitionClazz);
    }

    public static <L extends IAction> IcfgProgramExecution<L> create(List<L> trace, Map<Integer, IProgramExecution.ProgramState<Term>> partialProgramStateMapping, Map<TermVariable, Boolean>[] branchEncoders) {
        return IcfgProgramExecution.create(trace, partialProgramStateMapping, branchEncoders, null, IcfgProgramExecution.getClassFromTrace(trace));
    }

    public static <L extends IAction> IcfgProgramExecution<L> create(List<L> trace, Map<Integer, IProgramExecution.ProgramState<Term>> partialProgramStateMapping, Map<TermVariable, Boolean>[] branchEncoders, Class<L> clazz) {
        return IcfgProgramExecution.create(trace, partialProgramStateMapping, branchEncoders, null, clazz);
    }

    private static <L extends IAction> Class<L> getClassFromTrace(List<L> trace) {
        return ((IAction)trace.stream().findFirst().orElseThrow(() -> new UnsupportedOperationException("Empty trace is not supported"))).getClass();
    }

    public static <L extends IAction> Class<L> getClassFromAtomicTraceElements(List<AtomicTraceElement<L>> trace) {
        return ((IAction)((AtomicTraceElement)trace.stream().findFirst().orElseThrow(() -> new UnsupportedOperationException("Empty trace is not supported"))).getTraceElement()).getClass();
    }

    public static <L extends IAction> IcfgProgramExecution<L> create(List<L> trace, Map<Integer, IProgramExecution.ProgramState<Term>> partialProgramStateMapping) {
        return IcfgProgramExecution.create(trace, partialProgramStateMapping, new ArrayList().toArray(new Map[0]), null, IcfgProgramExecution.getClassFromTrace(trace));
    }

    public static <L extends IAction> IcfgProgramExecution<L> create(List<L> trace, Map<Integer, IProgramExecution.ProgramState<Term>> partialProgramStateMapping, Class<L> clazz) {
        return IcfgProgramExecution.create(trace, partialProgramStateMapping, new ArrayList().toArray(new Map[0]), null, clazz);
    }

    public static <L extends IAction> IcfgProgramExecution<L> create(List<L> trace, Map<Integer, IProgramExecution.ProgramState<Term>> partialProgramStateMapping, Map<TermVariable, Boolean>[] branchEncoders, List<IRelevanceInformation> relevanceInformation) {
        return IcfgProgramExecution.create(trace, partialProgramStateMapping, branchEncoders, relevanceInformation, IcfgProgramExecution.getClassFromTrace(trace));
    }

    public static <L extends IAction> IcfgProgramExecution<L> create(List<L> trace, Map<Integer, IProgramExecution.ProgramState<Term>> partialProgramStateMapping, Map<TermVariable, Boolean>[] branchEncoders, List<IRelevanceInformation> relevanceInformation, Class<L> transitionClazz) {
        int[] threadIds;
        Map<String, Integer> threadIdMap;
        boolean isConcurrent = IcfgProgramExecution.isConcurrent(trace);
        if (isConcurrent) {
            threadIdMap = IcfgProgramExecution.createThreadIds(trace);
            threadIds = IcfgProgramExecution.createThreadIdsFromMap(trace, threadIdMap);
        } else {
            threadIdMap = null;
            threadIds = null;
        }
        return new IcfgProgramExecution<L>(IcfgProgramExecution.createATESequence(trace, relevanceInformation, threadIdMap, threadIds), partialProgramStateMapping, branchEncoders, threadIds != null, transitionClazz);
    }

    private static int[] createThreadIdsFromMap(List<? extends IAction> trace, Map<String, Integer> threadIdMap) {
        int[] rtr = new int[trace.size()];
        int i = 0;
        for (IAction iAction : trace) {
            Integer id = threadIdMap.get(iAction.getPrecedingProcedure());
            rtr[i] = id;
            ++i;
        }
        return rtr;
    }

    private static boolean isConcurrent(List<? extends IAction> trace) {
        return trace.stream().anyMatch(a -> a instanceof IIcfgForkTransitionThreadOther || a instanceof IIcfgJoinTransitionThreadOther || a instanceof IIcfgForkTransitionThreadCurrent || a instanceof IIcfgJoinTransitionThreadCurrent);
    }

    private static final Map<String, Integer> createThreadIds(List<? extends IAction> trace) {
        int nextThreadId = 0;
        HashMap<String, Integer> threadIdMap = new HashMap<String, Integer>();
        if (trace.isEmpty()) {
            throw new UnsupportedOperationException("trace has length 0");
        }
        String initialProcedure = trace.get(0).getPrecedingProcedure();
        threadIdMap.put(initialProcedure, nextThreadId);
        ++nextThreadId;
        for (IAction iAction : trace) {
            String forkedProcedure;
            Integer id = (Integer)threadIdMap.get(iAction.getPrecedingProcedure());
            if (id == null) {
                throw new AssertionError((Object)("No thread ID for procedure " + iAction.getPrecedingProcedure()));
            }
            if (!(iAction instanceof IcfgForkThreadOtherTransition) || threadIdMap.containsKey(forkedProcedure = iAction.getSucceedingProcedure())) continue;
            threadIdMap.put(forkedProcedure, nextThreadId);
            ++nextThreadId;
        }
        return threadIdMap;
    }

    private static <LETTER extends IAction> List<AtomicTraceElement<LETTER>> createATESequence(List<LETTER> trace, List<IRelevanceInformation> relevanceInformation, Map<String, Integer> threadIdMap, int[] threadIds) {
        assert (trace != null);
        assert (relevanceInformation == null || trace.size() == relevanceInformation.size()) : "incompatible sizes";
        assert (threadIds == null || threadIds.length == trace.size());
        ArrayList<AtomicTraceElement<LETTER>> translatedAtes = new ArrayList<AtomicTraceElement<LETTER>>();
        int i = 0;
        while (i < trace.size()) {
            Integer forkedProcedureId;
            IIcfgTransition teTrans;
            IAction te = (IAction)trace.get(i);
            AtomicTraceElement.AtomicTraceElementBuilder ateBuilder = new AtomicTraceElement.AtomicTraceElementBuilder();
            ateBuilder.setStepAndElement((Object)te);
            ateBuilder.setProcedures(te.getPrecedingProcedure(), te.getSucceedingProcedure());
            if (threadIdMap != null) {
                ateBuilder.setThreadId(threadIds[i]);
            }
            if (relevanceInformation != null) {
                ateBuilder.setRelevanceInformation(relevanceInformation.get(i));
            }
            if (te instanceof IIcfgForkTransitionThreadOther) {
                teTrans = (IIcfgTransition)te;
                if (threadIdMap != null) {
                    forkedProcedureId = threadIdMap.get(((IcfgLocation)teTrans.getTarget()).getProcedure());
                    assert (forkedProcedureId != null);
                    ateBuilder.setForkedThreadId(forkedProcedureId.intValue());
                }
                ateBuilder.setStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.FORK});
                assert (threadIdMap != null);
            } else if (te instanceof IIcfgForkTransitionThreadCurrent) {
                teTrans = (IIcfgTransition)te;
                if (threadIdMap != null) {
                    forkedProcedureId = threadIdMap.get(((IcfgLocation)teTrans.getTarget()).getProcedure());
                    assert (forkedProcedureId != null);
                    ateBuilder.setForkedThreadId(forkedProcedureId.intValue());
                }
                ateBuilder.setStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.FORK});
                assert (threadIdMap != null);
            } else if (te instanceof IIcfgJoinTransitionThreadOther) {
                ateBuilder.setStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.JOIN});
                assert (threadIdMap != null);
            } else if (te instanceof IIcfgJoinTransitionThreadCurrent) {
                ateBuilder.setStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.JOIN});
                assert (threadIdMap != null);
            } else if (te instanceof IIcfgCallTransition) {
                ateBuilder.setStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.PROC_CALL});
            } else if (te instanceof IIcfgReturnTransition) {
                ateBuilder.setStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.PROC_RETURN});
            }
            translatedAtes.add(ateBuilder.build());
            ++i;
        }
        return translatedAtes;
    }

    public Map<TermVariable, Boolean>[] getBranchEncoders() {
        return this.mBranchEncoders;
    }

    public int getLength() {
        return this.mTrace.size();
    }

    public AtomicTraceElement<L> getTraceElement(int i) {
        return this.mTrace.get(i);
    }

    public IProgramExecution.ProgramState<Term> getProgramState(int i) {
        if (i < 0 || i >= this.mTrace.size()) {
            throw new IllegalArgumentException("out of range");
        }
        return this.mPartialProgramStateMapping.get(i);
    }

    public IProgramExecution.ProgramState<Term> getInitialProgramState() {
        return this.mPartialProgramStateMapping.get(-1);
    }

    public String toString() {
        ProgramExecutionFormatter pef = new ProgramExecutionFormatter(new IcfgBacktranslationValueProvider());
        return pef.formatProgramExecution((IProgramExecution)this);
    }

    public Class<Term> getExpressionClass() {
        return Term.class;
    }

    public Class<? extends L> getTraceElementClass() {
        return this.mTransitionClazz;
    }

    public IcfgProgramExecution<L> addRelevanceInformation(List<IRelevanceInformation> relevanceInformation) {
        ArrayList<AtomicTraceElement<L>> newAtes = new ArrayList<AtomicTraceElement<L>>();
        Iterator<AtomicTraceElement<L>> iter = this.mTrace.iterator();
        Iterator<IRelevanceInformation> relIter = relevanceInformation.iterator();
        boolean isConcurrent = false;
        while (iter.hasNext()) {
            AtomicTraceElement ate = AtomicTraceElement.AtomicTraceElementBuilder.from(iter.next()).setRelevanceInformation(relIter.next()).build();
            isConcurrent = isConcurrent || ate.hasThreadId();
            newAtes.add(ate);
        }
        return new IcfgProgramExecution<L>(newAtes, this.mPartialProgramStateMapping, this.mBranchEncoders, isConcurrent, this.mTransitionClazz);
    }

    public IBacktranslationValueProvider<L, Term> getBacktranslationValueProvider() {
        return new NoBacktranslationValueProvider();
    }

    public boolean isConcurrent() {
        return this.mIsConcurrent;
    }
}

