/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.LoopEntryAnnotation;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ThreadInstance;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadOther;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadOther;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocationIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.util.DfsBookkeeping;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class IcfgUtils {
    private IcfgUtils() {
    }

    public static <LOC extends IcfgLocation> Set<LOC> getPotentialCycleProgramPoints(IIcfg<LOC> icfg) {
        return new IcfgLocationIterator<LOC>(icfg).asStream().filter(a -> a.getOutgoingEdges().stream().anyMatch(b -> {
            LoopEntryAnnotation loa = LoopEntryAnnotation.getAnnotation((IElement)b);
            return loa != null && loa.getLoopEntryType() == LoopEntryAnnotation.LoopEntryType.GOTO;
        })).collect(Collectors.toSet());
    }

    public static <LOC extends IcfgLocation> Set<LOC> getCallerAndCalleePoints(IIcfg<LOC> icfg) {
        return new IcfgEdgeIterator(icfg).asStream().filter(e -> e instanceof IIcfgCallTransition).flatMap(e -> Stream.of((IcfgLocation)e.getSource(), (IcfgLocation)e.getTarget())).collect(Collectors.toSet());
    }

    public static boolean isConcurrent(IIcfg<?> icfg) {
        return !icfg.getCfgSmtToolkit().getConcurrencyInformation().getThreadInstanceMap().isEmpty();
    }

    public static <LOC extends IcfgLocation> List<IcfgEdge> extractStartEdges(IIcfg<LOC> icfg) {
        return icfg.getInitialNodes().stream().flatMap(a -> a.getOutgoingEdges().stream()).collect(Collectors.toList());
    }

    public static <T extends IIcfgTransition<?>> UnmodifiableTransFormula getTransformula(T transition) {
        if (transition instanceof IInternalAction) {
            return ((IInternalAction)((Object)transition)).getTransformula();
        }
        if (transition instanceof ICallAction) {
            return ((ICallAction)((Object)transition)).getLocalVarsAssignment();
        }
        if (transition instanceof IReturnAction) {
            return ((IReturnAction)((Object)transition)).getAssignmentOfReturn();
        }
        throw new UnsupportedOperationException("Dont know how to extract transformula from transition " + transition);
    }

    public static <LOC extends IcfgLocation> Set<LOC> getErrorLocations(IIcfg<LOC> icfg) {
        LinkedHashSet errorLocs = new LinkedHashSet();
        for (Map.Entry<String, Set<LOC>> entry : icfg.getProcedureErrorNodes().entrySet()) {
            errorLocs.addAll(entry.getValue());
        }
        return errorLocs;
    }

    public static <LOC extends IcfgLocation> boolean isErrorLocation(IIcfg<LOC> icfg, IcfgLocation loc) {
        if (icfg == null) {
            throw new IllegalArgumentException();
        }
        if (loc == null) {
            return false;
        }
        String proc = loc.getProcedure();
        Map<String, Set<LOC>> errorNodes = icfg.getProcedureErrorNodes();
        if (errorNodes == null || errorNodes.isEmpty()) {
            return false;
        }
        Set<LOC> procErrorNodes = errorNodes.get(proc);
        if (procErrorNodes == null || procErrorNodes.isEmpty()) {
            return false;
        }
        return procErrorNodes.contains(loc);
    }

    public static <LOC extends IcfgLocation> int getNumberOfLocations(IIcfg<LOC> icfg) {
        int result = 0;
        for (Map.Entry<String, Map<DebugIdentifier, LOC>> entry : icfg.getProgramPoints().entrySet()) {
            result += entry.getValue().size();
        }
        return result;
    }

    public static Set<IProgramVar> collectAllProgramVars(CfgSmtToolkit csToolkit) {
        HashSet<IProgramVar> result = new HashSet<IProgramVar>();
        for (IProgramNonOldVar nonold : csToolkit.getSymbolTable().getGlobals()) {
            result.add(nonold);
            IProgramOldVar oldVar = nonold.getOldVar();
            result.add(oldVar);
        }
        for (String proc : csToolkit.getProcedures()) {
            result.addAll(csToolkit.getSymbolTable().getLocals(proc));
        }
        return result;
    }

    public static <LOC extends IcfgLocation> int computeIcfgHashCode(IIcfg<LOC> icfg) {
        IcfgLocationIterator<LOC> locIt = new IcfgLocationIterator<LOC>(icfg);
        int result = 0;
        while (locIt.hasNext()) {
            Object loc = locIt.next();
            result += ((IcfgLocation)loc).hashCode();
            for (IcfgEdge edge : loc.getOutgoingEdges()) {
                result += edge.hashCode();
            }
        }
        return result;
    }

    public static <LOC extends IcfgLocation> boolean hasUnreachableProgramPoints(IIcfg<LOC> icfg) {
        for (Map.Entry<String, Map<DebugIdentifier, LOC>> entry : icfg.getProgramPoints().entrySet()) {
            for (Map.Entry<DebugIdentifier, LOC> innerEntry : entry.getValue().entrySet()) {
                IcfgLocation loc = (IcfgLocation)innerEntry.getValue();
                if (!loc.getIncomingEdges().isEmpty() || IcfgUtils.isEntry(loc, icfg) || IcfgUtils.isExit(loc, icfg)) continue;
                return true;
            }
        }
        return false;
    }

    public static <LOC extends IcfgLocation> boolean isEntry(LOC loc, IIcfg<LOC> icfg) {
        return ((IcfgLocation)icfg.getProcedureEntryNodes().get(loc.getProcedure())).equals(loc);
    }

    public static <LOC extends IcfgLocation> boolean isExit(LOC loc, IIcfg<LOC> icfg) {
        return ((IcfgLocation)icfg.getProcedureExitNodes().get(loc.getProcedure())).equals(loc);
    }

    public static <LOC extends IcfgLocation> boolean isEnabled(Set<LOC> locs, IcfgEdge edge) {
        if (edge instanceof IIcfgForkTransitionThreadCurrent || edge instanceof IIcfgJoinTransitionThreadCurrent) {
            return false;
        }
        if (edge instanceof IIcfgForkTransitionThreadOther) {
            Set threads = locs.stream().map(IcfgLocation::getProcedure).collect(Collectors.toSet());
            String forkedThread = edge.getSucceedingProcedure();
            return locs.contains(edge.getSource()) && !threads.contains(forkedThread);
        }
        if (edge instanceof IIcfgJoinTransitionThreadOther) {
            IIcfgJoinTransitionThreadOther joinOther = (IIcfgJoinTransitionThreadOther)((Object)edge);
            IIcfgJoinTransitionThreadCurrent joinCurrent = joinOther.getCorrespondingIIcfgJoinTransitionCurrentThread();
            return locs.contains(joinOther.getSource()) && locs.contains(joinCurrent.getSource());
        }
        return locs.contains(edge.getSource());
    }

    public static boolean canReachCached(IcfgLocation sourceLoc, Predicate<IcfgEdge> isTarget, Predicate<IcfgEdge> prune, Function<IcfgLocation, Script.LBool> getCachedResult, BiConsumer<IcfgLocation, Boolean> setCachedResult) {
        IcfgLocation currentLoc;
        Script.LBool cachedCanReach = getCachedResult.apply(sourceLoc);
        if (cachedCanReach != Script.LBool.UNKNOWN) {
            return cachedCanReach == Script.LBool.SAT;
        }
        DfsBookkeeping dfs = new DfsBookkeeping();
        LinkedList<IcfgLocation> worklist = new LinkedList<IcfgLocation>();
        worklist.add(sourceLoc);
        Script.LBool canReach = Script.LBool.UNSAT;
        while (!worklist.isEmpty() && canReach != Script.LBool.SAT) {
            currentLoc = (IcfgLocation)worklist.getLast();
            Script.LBool knownCanReach = getCachedResult.apply(currentLoc);
            if (knownCanReach != Script.LBool.UNKNOWN) {
                canReach = knownCanReach == Script.LBool.SAT || canReach != Script.LBool.UNKNOWN ? knownCanReach : canReach;
                worklist.removeLast();
                dfs.push((Object)currentLoc);
                dfs.backtrack();
                continue;
            }
            if (dfs.isVisited((Object)currentLoc)) {
                assert (canReach != Script.LBool.SAT) : "After reachability confirmed, should be fast-backtracking";
                worklist.removeLast();
                if (dfs.peek() != currentLoc) continue;
                boolean completeBacktrack = dfs.backtrack();
                Script.LBool lBool = canReach = completeBacktrack ? Script.LBool.UNSAT : Script.LBool.UNKNOWN;
                if (canReach == Script.LBool.UNKNOWN) continue;
                assert (canReach == Script.LBool.UNSAT);
                setCachedResult.accept(currentLoc, false);
                continue;
            }
            dfs.push((Object)currentLoc);
            List outgoing = currentLoc.getOutgoingEdges();
            ArrayList<IcfgLocation> successors = new ArrayList<IcfgLocation>(outgoing.size());
            for (IcfgEdge edge : outgoing) {
                IcfgLocation succ = (IcfgLocation)edge.getTarget();
                if (isTarget.test(edge)) {
                    canReach = Script.LBool.SAT;
                    break;
                }
                if (prune.test(edge)) continue;
                if (!dfs.isVisited((Object)succ)) {
                    successors.add(succ);
                    continue;
                }
                int stackIndex = dfs.stackIndexOf((Object)succ);
                if (stackIndex != -1) {
                    assert (getCachedResult.apply(succ) == Script.LBool.UNKNOWN) : "Loop heads on stack must have UNKNOWN status";
                    canReach = Script.LBool.UNKNOWN;
                    dfs.updateLoopHead((Object)currentLoc, new Pair((Object)stackIndex, (Object)succ));
                    continue;
                }
                Script.LBool succCanReach = getCachedResult.apply(succ);
                assert (succCanReach != Script.LBool.SAT) : "Backtracked node must not have SAT status";
                canReach = succCanReach == Script.LBool.UNKNOWN ? Script.LBool.UNKNOWN : canReach;
                dfs.backPropagateLoopHead((Object)currentLoc, (Object)succ);
            }
            if (canReach == Script.LBool.SAT) continue;
            successors.stream().forEach(worklist::add);
        }
        while (!dfs.isStackEmpty()) {
            assert (canReach == Script.LBool.SAT) : "Fast-backtracking must only happen in case of reachability";
            currentLoc = (IcfgLocation)dfs.peek();
            dfs.backtrack();
            setCachedResult.accept(currentLoc, true);
        }
        Script.LBool cachedReachability = getCachedResult.apply(sourceLoc);
        assert (cachedReachability != Script.LBool.UNKNOWN) : "reachability should be clearly determined";
        assert (cachedReachability == canReach) : "contradictory reachability: " + cachedReachability + " != " + canReach;
        return canReach == Script.LBool.SAT;
    }

    public static <LOC extends IcfgLocation> Set<String> getAllThreadInstances(IIcfg<LOC> icfg) {
        Stream<String> threadInstances = icfg.getCfgSmtToolkit().getConcurrencyInformation().getThreadInstanceMap().values().stream().flatMap(Collection::stream).map(ThreadInstance::getThreadInstanceName);
        String mainThread = ((IcfgLocation)DataStructureUtils.getOneAndOnly(icfg.getInitialNodes(), (String)"initial node")).getProcedure();
        return Stream.concat(Stream.of(mainThread), threadInstances).collect(Collectors.toSet());
    }

    public static Set<IIcfgForkTransitionThreadCurrent<IcfgLocation>> getForksInLoop(IIcfg<?> icfg) {
        HashSet<IIcfgForkTransitionThreadCurrent<IcfgLocation>> result = new HashSet<IIcfgForkTransitionThreadCurrent<IcfgLocation>>();
        Map<String, ?> entryLocs = icfg.getProcedureEntryNodes();
        block0: for (IIcfgForkTransitionThreadCurrent<IcfgLocation> fork : icfg.getCfgSmtToolkit().getConcurrencyInformation().getThreadInstanceMap().keySet()) {
            ArrayDeque<Object> queue = new ArrayDeque<Object>();
            HashSet<IcfgLocation> visited = new HashSet<IcfgLocation>();
            queue.add(fork.getTarget());
            queue.add((IcfgLocation)entryLocs.get(fork.getNameOfForkedProcedure()));
            while (!queue.isEmpty()) {
                IcfgLocation loc = (IcfgLocation)queue.pop();
                if (!visited.add(loc)) continue;
                if (loc.equals(fork.getSource())) {
                    result.add(fork);
                    continue block0;
                }
                for (IcfgEdge edge : loc.getOutgoingEdges()) {
                    queue.add((IcfgLocation)edge.getTarget());
                    if (!(edge instanceof IIcfgForkTransitionThreadCurrent)) continue;
                    IIcfgForkTransitionThreadCurrent fork2 = (IIcfgForkTransitionThreadCurrent)((Object)edge);
                    queue.add((IcfgLocation)entryLocs.get(fork2.getNameOfForkedProcedure()));
                }
            }
        }
        return result;
    }
}

