/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collections;
import java.util.Set;

public class ModifiableGlobalsTable {
    private final HashRelation<String, IProgramNonOldVar> mProc2Globals = new HashRelation();

    public ModifiableGlobalsTable(HashRelation<String, IProgramNonOldVar> proc2globals) {
        this.mProc2Globals.addAll(proc2globals);
    }

    public Set<IProgramNonOldVar> getModifiedBoogieVars(String proc) {
        return Collections.unmodifiableSet(this.mProc2Globals.getImage((Object)proc));
    }

    public boolean isModifiable(IProgramOldVar bv, String proc) {
        IProgramNonOldVar bnov = bv.getNonOldVar();
        return this.mProc2Globals.containsPair((Object)proc, (Object)bnov);
    }

    public boolean isModifiable(IProgramNonOldVar bnov, String proc) {
        return this.mProc2Globals.containsPair((Object)proc, (Object)bnov);
    }

    public boolean containsNonModifiableOldVars(IPredicate pred, String proc) {
        for (IProgramVar bv : pred.getVars()) {
            boolean modifiable;
            if (!(bv instanceof IProgramOldVar) || (modifiable = this.isModifiable((IProgramOldVar)bv, proc))) continue;
            return true;
        }
        return false;
    }

    public static Term constructConstantOldVarEquality(IProgramNonOldVar bv, boolean primed, Script script) {
        IProgramOldVar oldVar = bv.getOldVar();
        ApplicationTerm nonOldConstant = primed ? bv.getPrimedConstant() : bv.getDefaultConstant();
        ApplicationTerm oldConstant = primed ? oldVar.getPrimedConstant() : oldVar.getDefaultConstant();
        return SmtUtils.binaryEquality((Script)script, (Term)oldConstant, (Term)nonOldConstant);
    }

    public HashRelation<String, IProgramNonOldVar> getProcToGlobals() {
        return new HashRelation(this.mProc2Globals);
    }
}

