/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class OldVarsAssignmentCache {
    protected final ManagedScript mMgdScript;
    private final ModifiableGlobalsTable mModifiableGlobalsTable;
    private final Map<String, UnmodifiableTransFormula> mProc2OldVarsAssignment;
    private final Map<String, UnmodifiableTransFormula> mProc2GlobalVarsAssignment;

    public OldVarsAssignmentCache(ManagedScript mgdScript, ModifiableGlobalsTable modifiableGlobalsTable) {
        this.mMgdScript = mgdScript;
        this.mModifiableGlobalsTable = modifiableGlobalsTable;
        this.mProc2OldVarsAssignment = new HashMap<String, UnmodifiableTransFormula>();
        this.mProc2GlobalVarsAssignment = new HashMap<String, UnmodifiableTransFormula>();
    }

    public UnmodifiableTransFormula getOldVarsAssignment(String proc) {
        UnmodifiableTransFormula oldVarsAssignment = this.mProc2OldVarsAssignment.get(proc);
        if (oldVarsAssignment == null) {
            oldVarsAssignment = this.constructOldVarsAssignment(proc);
            this.mProc2OldVarsAssignment.put(proc, oldVarsAssignment);
        }
        return this.mProc2OldVarsAssignment.get(proc);
    }

    public UnmodifiableTransFormula getGlobalVarsAssignment(String proc) {
        UnmodifiableTransFormula globalVarsAssignment = this.mProc2GlobalVarsAssignment.get(proc);
        if (globalVarsAssignment == null) {
            globalVarsAssignment = this.constructGlobalVarsAssignment(proc);
            this.mProc2GlobalVarsAssignment.put(proc, globalVarsAssignment);
        }
        return this.mProc2GlobalVarsAssignment.get(proc);
    }

    private UnmodifiableTransFormula constructOldVarsAssignment(String proc) {
        Set<IProgramNonOldVar> vars = this.mModifiableGlobalsTable.getModifiedBoogieVars(proc);
        if (vars == null) {
            vars = Collections.emptySet();
        }
        TransFormulaBuilder tfb = new TransFormulaBuilder(null, null, true, null, true, null, true);
        Term glob2oldFormula = this.mMgdScript.getScript().term("true", new Term[0]);
        for (IProgramNonOldVar modifiableGlobal : vars) {
            IProgramOldVar oldVarOfModifiable = modifiableGlobal.getOldVar();
            Sort sort = modifiableGlobal.getDefaultConstant().getSort();
            String nameIn = modifiableGlobal + "_In";
            TermVariable tvIn = this.mMgdScript.getScript().variable(nameIn, sort);
            String nameOut = "old(" + modifiableGlobal + ")" + "_Out";
            TermVariable tvOut = this.mMgdScript.getScript().variable(nameOut, sort);
            tfb.addInVar(modifiableGlobal, tvIn);
            tfb.addOutVar(modifiableGlobal, tvIn);
            tfb.addOutVar(oldVarOfModifiable, tvOut);
            Term assignment = SmtUtils.binaryEquality((Script)this.mMgdScript.getScript(), (Term)tvOut, (Term)tvIn);
            glob2oldFormula = SmtUtils.and((Script)this.mMgdScript.getScript(), (Term[])new Term[]{glob2oldFormula, assignment});
        }
        tfb.setFormula(glob2oldFormula);
        tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.UNPROVEABLE);
        return tfb.finishConstruction(this.mMgdScript);
    }

    private UnmodifiableTransFormula constructGlobalVarsAssignment(String proc) {
        Set<IProgramNonOldVar> vars = this.mModifiableGlobalsTable.getModifiedBoogieVars(proc);
        if (vars == null) {
            vars = Collections.emptySet();
        }
        TransFormulaBuilder tfb = new TransFormulaBuilder(null, null, true, null, true, null, true);
        Term old2globFormula = this.mMgdScript.getScript().term("true", new Term[0]);
        for (IProgramNonOldVar modifiableGlobal : vars) {
            IProgramOldVar oldVarOfModifiable = modifiableGlobal.getOldVar();
            Sort sort = modifiableGlobal.getDefaultConstant().getSort();
            String nameIn = "old(" + modifiableGlobal + ")" + "_In";
            TermVariable tvIn = this.mMgdScript.getScript().variable(nameIn, sort);
            String nameOut = modifiableGlobal + "_Out";
            TermVariable tvOut = this.mMgdScript.getScript().variable(nameOut, sort);
            tfb.addInVar(oldVarOfModifiable, tvIn);
            tfb.addOutVar(oldVarOfModifiable, tvIn);
            tfb.addOutVar(modifiableGlobal, tvOut);
            Term assignment = SmtUtils.binaryEquality((Script)this.mMgdScript.getScript(), (Term)tvOut, (Term)tvIn);
            old2globFormula = SmtUtils.and((Script)this.mMgdScript.getScript(), (Term[])new Term[]{old2globFormula, assignment});
        }
        tfb.setFormula(old2globFormula);
        tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.UNPROVEABLE);
        return tfb.finishConstruction(this.mMgdScript);
    }
}

