/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.boogie.Expression2Term;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.DefaultIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.SmtFunctionsAndAxioms;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ThreadInstance;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IForkActionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IJoinActionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgForkThreadCurrentTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgJoinThreadCurrentTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class ProcedureMultiplier {
    public static void duplicateProcedures(IUltimateServiceProvider services, BasicIcfg<IcfgLocation> icfg, List<ThreadInstance> instances, BlockEncodingBacktranslator backtranslator, Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>> threadInstanceMap, List<IIcfgForkTransitionThreadCurrent<IcfgLocation>> forkCurrentThreads, List<IIcfgJoinTransitionThreadCurrent<IcfgLocation>> joinCurrentThreads) {
        Class<ProcedureMultiplier> lockOwner = ProcedureMultiplier.class;
        HashRelation<String, String> copyDirectives = ProcedureMultiplier.generateCopyDirectives(instances);
        CfgSmtToolkit cfgSmtToolkit = icfg.getCfgSmtToolkit();
        IcfgEdgeFactory icfgEdgeFactory = cfgSmtToolkit.getIcfgEdgeFactory();
        HashMap<String, List<ILocalProgramVar>> inParams = new HashMap<String, List<ILocalProgramVar>>(cfgSmtToolkit.getInParams());
        HashMap<String, List<ILocalProgramVar>> outParams = new HashMap<String, List<ILocalProgramVar>>(cfgSmtToolkit.getOutParams());
        HashSet<String> procedures = new HashSet<String>(cfgSmtToolkit.getProcedures());
        SmtFunctionsAndAxioms smtSymbols = cfgSmtToolkit.getSmtFunctionsAndAxioms();
        DefaultIcfgSymbolTable symbolTable = new DefaultIcfgSymbolTable(cfgSmtToolkit.getSymbolTable(), procedures);
        ManagedScript managedScript = cfgSmtToolkit.getManagedScript();
        HashRelation proc2globals = new HashRelation(cfgSmtToolkit.getModifiableGlobalsTable().getProcToGlobals());
        HashMap<String, HashMap<ILocalProgramVar, ILocalProgramVar>> oldVar2newVar = new HashMap<String, HashMap<ILocalProgramVar, ILocalProgramVar>>();
        HashMap<Term, Term> variableBacktranslationMapping = new HashMap<Term, Term>();
        managedScript.lock(lockOwner);
        for (String proc : copyDirectives.getDomain()) {
            assert (cfgSmtToolkit.getProcedures().contains(proc)) : "procedure " + proc + " missing";
            for (String copyIdentifier : copyDirectives.getImage((Object)proc)) {
                icfg.addProcedure(copyIdentifier);
                HashMap<ILocalProgramVar, ILocalProgramVar> procOldVar2NewVar = new HashMap<ILocalProgramVar, ILocalProgramVar>();
                procedures.add(copyIdentifier);
                ArrayList<Iterator<ILocalProgramVar>> inParamsOfCopy = new ArrayList<Iterator<ILocalProgramVar>>();
                for (ILocalProgramVar inParam : (List)inParams.get(proc)) {
                    Iterator<ILocalProgramVar> inParamCopy = ProcedureMultiplier.constructVariableCopy(inParam, copyIdentifier, managedScript, procOldVar2NewVar, variableBacktranslationMapping, symbolTable, lockOwner);
                    inParamsOfCopy.add(inParamCopy);
                }
                inParams.put(copyIdentifier, inParamsOfCopy);
                ArrayList<ILocalProgramVar> outParamsOfCopy = new ArrayList<ILocalProgramVar>();
                for (ILocalProgramVar outParam : (List)outParams.get(proc)) {
                    ILocalProgramVar outParamCopy = ProcedureMultiplier.constructVariableCopy(outParam, copyIdentifier, managedScript, procOldVar2NewVar, variableBacktranslationMapping, symbolTable, lockOwner);
                    outParamsOfCopy.add(outParamCopy);
                }
                outParams.put(copyIdentifier, outParamsOfCopy);
                for (ILocalProgramVar localVar : cfgSmtToolkit.getSymbolTable().getLocals(proc)) {
                    if (procOldVar2NewVar.containsKey(localVar)) continue;
                    ProcedureMultiplier.constructVariableCopy(localVar, copyIdentifier, managedScript, procOldVar2NewVar, variableBacktranslationMapping, symbolTable, lockOwner);
                }
                oldVar2newVar.put(copyIdentifier, procOldVar2NewVar);
                proc2globals.getImage((Object)proc).forEach(g -> {
                    boolean bl = proc2globals.addPair((Object)copyIdentifier, g);
                });
            }
        }
        backtranslator.setTermTranslator(x -> Substitution.apply((ManagedScript)managedScript, (Map)variableBacktranslationMapping, (Term)x));
        managedScript.unlock(lockOwner);
        CfgSmtToolkit newCfgSmtToolkit = new CfgSmtToolkit(new ModifiableGlobalsTable((HashRelation<String, IProgramNonOldVar>)proc2globals), managedScript, symbolTable, procedures, inParams, outParams, icfgEdgeFactory, cfgSmtToolkit.getConcurrencyInformation(), smtSymbols);
        icfg.setCfgSmtToolkit(newCfgSmtToolkit);
        for (String proc : copyDirectives.getDomain()) {
            IcfgLocation procEntry = icfg.getProcedureEntryNodes().get(proc);
            List edges = new IcfgEdgeIterator(procEntry.getOutgoingEdges()).asStream().collect(Collectors.toList());
            for (String copyIdentifier : copyDirectives.getImage((Object)proc)) {
                HashMap<IcfgLocation, IcfgLocation> old2NewLoc = new HashMap<IcfgLocation, IcfgLocation>();
                for (IcfgEdge edge : edges) {
                    IcfgLocation source = ProcedureMultiplier.getOrConstructLocationCopy((IcfgLocation)edge.getSource(), old2NewLoc, icfg, copyIdentifier, backtranslator);
                    IcfgLocation target = ProcedureMultiplier.getOrConstructLocationCopy((IcfgLocation)edge.getTarget(), old2NewLoc, icfg, copyIdentifier, backtranslator);
                    IcfgEdge newEdge = ProcedureMultiplier.constructEdgeCopy(edge, source, target, (Map)oldVar2newVar.get(copyIdentifier), icfgEdgeFactory, managedScript, threadInstanceMap, forkCurrentThreads, joinCurrentThreads);
                    backtranslator.mapEdges((IIcfgTransition<IcfgLocation>)newEdge, edge);
                    ModelUtils.copyAnnotations((IElement)edge, (IElement)newEdge);
                    source.addOutgoing((IModifiableMultigraphEdge)newEdge);
                    target.addIncoming((IModifiableMultigraphEdge)newEdge);
                }
            }
        }
    }

    private static IcfgEdge constructEdgeCopy(IcfgEdge edge, IcfgLocation source, IcfgLocation target, Map<ILocalProgramVar, ILocalProgramVar> varReplacement, IcfgEdgeFactory icfgEdgeFactory, ManagedScript managedScript, Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>> threadInstanceMap, List<IIcfgForkTransitionThreadCurrent<IcfgLocation>> forkCurrentThreads, List<IIcfgJoinTransitionThreadCurrent<IcfgLocation>> joinCurrentThreads) {
        UnmodifiableTransFormula transFormula = TransFormulaBuilder.constructCopy(managedScript, edge.getTransformula(), varReplacement);
        if (edge instanceof IcfgInternalTransition) {
            UnmodifiableTransFormula transFormulaWithBE = TransFormulaBuilder.constructCopy(managedScript, ((IcfgInternalTransition)edge).getTransitionFormulaWithBranchEncoders(), varReplacement);
            return icfgEdgeFactory.createInternalTransition(source, target, null, transFormula, transFormulaWithBE);
        }
        if (edge instanceof IcfgForkThreadCurrentTransition) {
            IcfgForkThreadCurrentTransition oldForkEdge = (IcfgForkThreadCurrentTransition)edge;
            IForkActionThreadCurrent.ForkSmtArguments newForkSmtArguments = ProcedureMultiplier.copyForkSmtArguments(oldForkEdge.getForkSmtArguments(), varReplacement, managedScript);
            IcfgForkThreadCurrentTransition newForkEdge = icfgEdgeFactory.createForkThreadCurrentTransition(source, target, null, transFormula, newForkSmtArguments, oldForkEdge.getNameOfForkedProcedure());
            forkCurrentThreads.add(newForkEdge);
            List<ThreadInstance> threadInstances = threadInstanceMap.get(oldForkEdge);
            assert (threadInstances != null);
            threadInstanceMap.put(newForkEdge, threadInstances);
            return newForkEdge;
        }
        if (edge instanceof IcfgJoinThreadCurrentTransition) {
            IJoinActionThreadCurrent.JoinSmtArguments newForkSmtArguments = ProcedureMultiplier.copyJoinSmtArguments(((IcfgJoinThreadCurrentTransition)edge).getJoinSmtArguments(), varReplacement, managedScript);
            IcfgJoinThreadCurrentTransition newJoinEdge = icfgEdgeFactory.createJoinThreadCurrentTransition(source, target, null, transFormula, newForkSmtArguments);
            joinCurrentThreads.add(newJoinEdge);
            return newJoinEdge;
        }
        if (edge instanceof IcfgCallTransition) {
            throw new UnsupportedOperationException(String.format("%s does not support %s. Calls and returns should habe been removed by inlining. (Did the inlining fail because this program is recursive.)", ProcedureMultiplier.class.getSimpleName(), edge.getClass().getSimpleName()));
        }
        throw new UnsupportedOperationException(String.valueOf(ProcedureMultiplier.class.getSimpleName()) + " does not support " + edge.getClass().getSimpleName());
    }

    private static IcfgLocation getOrConstructLocationCopy(IcfgLocation originalLocation, Map<IcfgLocation, IcfgLocation> old2newLoc, BasicIcfg<IcfgLocation> icfg, String newProc, BlockEncodingBacktranslator backtranslator) {
        return old2newLoc.computeIfAbsent(originalLocation, x -> ProcedureMultiplier.constructLocationCopy(x, icfg, newProc, backtranslator));
    }

    private static IcfgLocation constructLocationCopy(IcfgLocation originalLocation, BasicIcfg<IcfgLocation> icfg, String newProc, BlockEncodingBacktranslator backtranslator) {
        String proc = originalLocation.getProcedure();
        IcfgLocation newLoc = new IcfgLocation(originalLocation.getDebugIdentifier(), newProc);
        ModelUtils.copyAnnotations((IElement)originalLocation, (IElement)newLoc);
        backtranslator.mapLocations(newLoc, originalLocation);
        boolean isInitial = icfg.getInitialNodes().contains(originalLocation);
        boolean isError = icfg.getProcedureErrorNodes().get(proc).contains(originalLocation);
        boolean isProcEntry = icfg.getProcedureEntryNodes().get(proc).equals(originalLocation);
        boolean isProcExit = icfg.getProcedureExitNodes().get(proc).equals(originalLocation);
        boolean isLoopLocation = icfg.getLoopLocations().contains(originalLocation);
        icfg.addLocation(newLoc, isInitial, isError, isProcEntry, isProcExit, isLoopLocation);
        return newLoc;
    }

    private static ILocalProgramVar constructVariableCopy(ILocalProgramVar localVar, String procedureCopy, ManagedScript managedScript, Map<ILocalProgramVar, ILocalProgramVar> procOldVar2NewVar, Map<Term, Term> variableBacktranslationMapping, DefaultIcfgSymbolTable symbolTable, Object lockOwner) {
        ILocalProgramVar localVarCopy = ProgramVarUtils.constructLocalProgramVar(localVar.getIdentifier(), procedureCopy, localVar.getSort(), managedScript, lockOwner);
        procOldVar2NewVar.put(localVar, localVarCopy);
        variableBacktranslationMapping.put((Term)localVarCopy.getTermVariable(), (Term)localVar.getTermVariable());
        symbolTable.add(localVarCopy);
        return localVarCopy;
    }

    private static IForkActionThreadCurrent.ForkSmtArguments copyForkSmtArguments(IForkActionThreadCurrent.ForkSmtArguments forkSmtArguments, Map<ILocalProgramVar, ILocalProgramVar> map, ManagedScript managedScript) {
        Map<Term, Term> defaultVariableMapping = ProcedureMultiplier.constructDefaultVariableMapping(map);
        Expression2Term.MultiTermResult newThreadIdArguments = ProcedureMultiplier.copyMultiTermResult(forkSmtArguments.getThreadIdArguments(), defaultVariableMapping, managedScript);
        Expression2Term.MultiTermResult newProcedureArguments = ProcedureMultiplier.copyMultiTermResult(forkSmtArguments.getProcedureArguments(), defaultVariableMapping, managedScript);
        return new IForkActionThreadCurrent.ForkSmtArguments(newThreadIdArguments, newProcedureArguments);
    }

    private static IJoinActionThreadCurrent.JoinSmtArguments copyJoinSmtArguments(IJoinActionThreadCurrent.JoinSmtArguments joinSmtArguments, Map<ILocalProgramVar, ILocalProgramVar> map, ManagedScript managedScript) {
        Map<Term, Term> defaultVariableMapping = ProcedureMultiplier.constructDefaultVariableMapping(map);
        Expression2Term.MultiTermResult newThreadIdArguments = ProcedureMultiplier.copyMultiTermResult(joinSmtArguments.getThreadIdArguments(), defaultVariableMapping, managedScript);
        List<IProgramVar> newAssignmentLhs = joinSmtArguments.getAssignmentLhs().stream().map(x -> x.isGlobal() ? x : (IProgramVar)map.get(x)).collect(Collectors.toList());
        return new IJoinActionThreadCurrent.JoinSmtArguments(newThreadIdArguments, newAssignmentLhs);
    }

    private static Expression2Term.MultiTermResult copyMultiTermResult(Expression2Term.MultiTermResult oldProcedureArguments, Map<Term, Term> defaultVariableMadefaultVariableMappingpping2, ManagedScript managedScript) {
        UnaryOperator subst = x -> Substitution.apply((ManagedScript)managedScript, (Map)defaultVariableMadefaultVariableMappingpping2, (Term)x);
        Term[] terms = (Term[])Arrays.stream(oldProcedureArguments.getTerms()).map(subst).toArray(Term[]::new);
        Collection auxiliaryVars = oldProcedureArguments.getAuxiliaryVars();
        Map overapproximations = oldProcedureArguments.getOverappoximations();
        Expression2Term.MultiTermResult copy = new Expression2Term.MultiTermResult(overapproximations, auxiliaryVars, terms);
        return copy;
    }

    private static Map<Term, Term> constructDefaultVariableMapping(Map<ILocalProgramVar, ILocalProgramVar> map) {
        return map.entrySet().stream().collect(Collectors.toMap(x -> ((ILocalProgramVar)x.getKey()).getTermVariable(), x -> ((ILocalProgramVar)x.getValue()).getTermVariable()));
    }

    private static HashRelation<String, String> generateCopyDirectives(Collection<ThreadInstance> threadInstances) {
        HashRelation result = new HashRelation();
        for (ThreadInstance ti : threadInstances) {
            result.addPair((Object)ti.getThreadTemplateName(), (Object)ti.getThreadInstanceName());
        }
        return result;
    }
}

