/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.DeclarableFunctionSymbol;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.HistoryRecordingScript;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.ISmtDeclarable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.NonDeclaringTermTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class SmtFunctionsAndAxioms {
    public static final int HARDCODED_SERIALNUMBER_FOR_AXIOMS = 0;
    private final HistoryRecordingScript mScript;
    private final ManagedScript mMgdScript;
    private final IPredicate mAxioms;

    public SmtFunctionsAndAxioms(ManagedScript mgdScript) {
        this(mgdScript.getScript().term("true", new Term[0]), new String[0], mgdScript);
    }

    public SmtFunctionsAndAxioms(Term axioms, String[] defininingProcedures, ManagedScript mgdScript) {
        this(new BasicPredicate(0, defininingProcedures, axioms, Collections.emptySet(), axioms), mgdScript);
    }

    public SmtFunctionsAndAxioms(IPredicate axioms, ManagedScript mgdScript) {
        this.mAxioms = Objects.requireNonNull(axioms);
        this.mMgdScript = mgdScript;
        this.mScript = Objects.requireNonNull(HistoryRecordingScript.extractHistoryRecordingScript((Script)Objects.requireNonNull(mgdScript.getScript())));
        assert (axioms.getClosedFormula() == axioms.getFormula()) : "Axioms are not closed";
        assert (axioms.getFormula().getFreeVars().length == 0) : "Axioms are not closed";
        assert (axioms.getProcedures() != null);
    }

    public SmtFunctionsAndAxioms addAxiom(Term additionalAxioms) {
        Term newAxioms = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{this.mAxioms.getClosedFormula(), additionalAxioms});
        Script.LBool quickCheckAxioms = this.mScript.assertTerm(additionalAxioms);
        assert (quickCheckAxioms != Script.LBool.UNSAT) : "Axioms are inconsistent";
        BasicPredicate newAxiomsPred = new BasicPredicate(0, new String[0], additionalAxioms, Collections.emptySet(), newAxioms);
        return new SmtFunctionsAndAxioms(newAxiomsPred, this.mMgdScript);
    }

    public void transferAllSymbols(Script script) {
        HistoryRecordingScript.transferHistoryFromRecord((Script)this.mScript, (Script)script);
        NonDeclaringTermTransferrer tt = new NonDeclaringTermTransferrer(script);
        Term transferredAxiom = tt.transform(this.mAxioms.getClosedFormula());
        if (!SmtUtils.isTrueLiteral((Term)transferredAxiom)) {
            Script.LBool quickCheckAxioms = script.assertTerm(transferredAxiom);
            assert (quickCheckAxioms != Script.LBool.UNSAT) : "Axioms are inconsistent";
        }
    }

    public Term inline(Term term) {
        return new SmtFunctionInliner().inline(this.mMgdScript, term);
    }

    public IPredicate getAxioms() {
        return this.mAxioms;
    }

    public Map<String, DeclarableFunctionSymbol> getDefinedFunctions() {
        return this.mScript.getSymbolTable().entrySet().stream().filter(a -> a.getValue() instanceof DeclarableFunctionSymbol).map(a -> (DeclarableFunctionSymbol)a.getValue()).filter(a -> a.getDefinition() != null).collect(Collectors.toMap(DeclarableFunctionSymbol::getName, a -> a));
    }

    private static class SmtFunctionInliner
    extends TermTransformer {
        private ManagedScript mMgdScript;
        private HistoryRecordingScript mScript;

        private SmtFunctionInliner() {
        }

        public Term inline(ManagedScript mgdScript, Term term) {
            this.mMgdScript = mgdScript;
            this.mScript = HistoryRecordingScript.extractHistoryRecordingScript((Script)mgdScript.getScript());
            if (this.mScript == null) {
                throw new IllegalArgumentException(mgdScript.getScript().getClass() + " does not contain a " + HistoryRecordingScript.class);
            }
            return this.transform(term);
        }

        public void convertApplicationTerm(ApplicationTerm appTerm, Term[] newArgs) {
            String funName = appTerm.getFunction().getName();
            ISmtDeclarable decl = (ISmtDeclarable)this.mScript.getSymbolTable().get(funName);
            if (decl == null) {
                this.setResult(SmtUtils.convertApplicationTerm((ApplicationTerm)appTerm, (Term[])newArgs, (Script)this.mScript));
                return;
            }
            assert (decl instanceof DeclarableFunctionSymbol);
            DeclarableFunctionSymbol funDecl = (DeclarableFunctionSymbol)decl;
            Term body = funDecl.getDefinition();
            if (body == null) {
                this.setResult(SmtUtils.convertApplicationTerm((ApplicationTerm)appTerm, (Term[])newArgs, (Script)this.mScript));
                return;
            }
            if (appTerm.getParameters().length == 0) {
                this.setResult(body);
                return;
            }
            Term[] paramVars = funDecl.getParamVars();
            assert (newArgs.length == paramVars.length);
            HashMap<Term, Term> substitutionMapping = new HashMap<Term, Term>();
            int i = 0;
            while (i < paramVars.length) {
                Term paramVar = paramVars[i];
                if (paramVar != null) {
                    substitutionMapping.put(paramVar, newArgs[i]);
                }
                ++i;
            }
            this.setResult(Substitution.apply((ManagedScript)this.mMgdScript, substitutionMapping, (Term)body));
        }
    }
}

