/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.Payload;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.ModelCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ConcurrencyInformation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.DefaultIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgPetrifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ThreadInstance;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IForkActionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IJoinActionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgForkThreadOtherTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgJoinThreadOtherTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.ProcedureErrorDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.ProcedureErrorWithCheckDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ThreadInstanceAdder {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final boolean mAddSelfLoops;

    public ThreadInstanceAdder(IUltimateServiceProvider services, boolean addSelfLoops) {
        this.mServices = services;
        this.mLogger = services.getLoggingService().getLogger(ModelCheckerUtils.PLUGIN_ID);
        this.mAddSelfLoops = addSelfLoops;
    }

    public IIcfg<IcfgLocation> connectThreadInstances(IIcfg<IcfgLocation> icfg, List<IIcfgForkTransitionThreadCurrent<IcfgLocation>> forkCurrentThreads, List<IIcfgJoinTransitionThreadCurrent<IcfgLocation>> joinCurrentThreads, Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>> threadInstanceMap, Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, IcfgLocation> inUseErrorNodeMap, BlockEncodingBacktranslator backtranslator) {
        for (IIcfgForkTransitionThreadCurrent<IcfgLocation> fct : forkCurrentThreads) {
            Object callerNode = fct.getSource();
            IcfgLocation errorNode = inUseErrorNodeMap.get(fct);
            IcfgEdgeFactory ef = icfg.getCfgSmtToolkit().getIcfgEdgeFactory();
            UnmodifiableTransFormula errorTransformula = TransFormulaBuilder.getTrivialTransFormula(icfg.getCfgSmtToolkit().getManagedScript());
            IcfgInternalTransition errorTransition = ef.createInternalTransition((IcfgLocation)callerNode, errorNode, (IPayload)new Payload(), errorTransformula);
            if (this.mAddSelfLoops) {
                IcfgInternalTransition errorLoop = ef.createInternalTransition(errorNode, errorNode, (IPayload)new Payload(), errorTransformula);
                errorNode.addIncoming((IModifiableMultigraphEdge)errorLoop);
                errorNode.addOutgoing((IModifiableMultigraphEdge)errorLoop);
            }
            ThreadInstanceAdder.integrateForkEdge(fct, backtranslator, callerNode, errorNode, errorTransition);
            for (ThreadInstance ti : threadInstanceMap.get(fct)) {
                this.addForkOtherThreadTransition(fct, ti.getIdVars(), icfg, ti.getThreadInstanceName(), backtranslator);
            }
        }
        int joinOtherThreadTransitions = 0;
        for (IIcfgJoinTransitionThreadCurrent<IcfgLocation> jot : joinCurrentThreads) {
            for (ThreadInstance ti : IcfgPetrifier.getAllInstances(threadInstanceMap)) {
                boolean threadIdCompatible = ThreadInstanceAdder.isThreadIdCompatible(ti.getIdVars(), jot.getJoinSmtArguments().getThreadIdArguments().getTerms());
                boolean returnValueCompatible = ThreadInstanceAdder.isReturnValueCompatible(jot.getJoinSmtArguments().getAssignmentLhs(), icfg.getCfgSmtToolkit().getOutParams().get(ti.getThreadInstanceName()));
                if (!threadIdCompatible || !returnValueCompatible) continue;
                this.addJoinOtherThreadTransition(jot, ti.getThreadInstanceName(), ti.getIdVars(), icfg, backtranslator);
                ++joinOtherThreadTransitions;
            }
        }
        this.mLogger.info((Object)("Constructed " + joinOtherThreadTransitions + " joinOtherThreadTransitions."));
        return icfg;
    }

    private static boolean isReturnValueCompatible(List<IProgramVar> assignmentLhs, List<ILocalProgramVar> outParams) {
        if (assignmentLhs.isEmpty()) {
            return true;
        }
        if (assignmentLhs.size() != outParams.size()) {
            return false;
        }
        int i = 0;
        while (i < assignmentLhs.size()) {
            if (!assignmentLhs.get(i).getTerm().getSort().equals(outParams.get(i).getTerm().getSort())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static boolean isThreadIdCompatible(IProgramNonOldVar[] idVars, Term[] terms) {
        if (idVars.length != terms.length) {
            return false;
        }
        int i = 0;
        while (i < idVars.length) {
            if (!idVars[i].getTerm().getSort().equals(terms[i].getSort())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void addForkOtherThreadTransition(IIcfgForkTransitionThreadCurrent<IcfgLocation> fct, IProgramNonOldVar[] threadIdVars, IIcfg<? extends IcfgLocation> icfg, String threadInstanceName, BlockEncodingBacktranslator backtranslator) {
        assert (icfg.getProcedureEntryNodes().containsKey(threadInstanceName)) : "Thread instance " + threadInstanceName + " missing.";
        Object callerNode = fct.getSource();
        IcfgLocation calleeEntryLoc = icfg.getProcedureEntryNodes().get(threadInstanceName);
        CfgSmtToolkit cfgSmtToolkit = icfg.getCfgSmtToolkit();
        UnmodifiableTransFormula forkTransformula = this.constructForkTransFormula(fct.getForkSmtArguments(), Arrays.asList(threadIdVars), threadInstanceName, cfgSmtToolkit);
        IcfgForkThreadOtherTransition forkThreadOther = cfgSmtToolkit.getIcfgEdgeFactory().createForkThreadOtherTransition((IcfgLocation)callerNode, calleeEntryLoc, null, forkTransformula, fct);
        ThreadInstanceAdder.integrateForkEdge(fct, backtranslator, callerNode, calleeEntryLoc, forkThreadOther);
        HashMap overapproximations = new HashMap();
        if (!overapproximations.isEmpty()) {
            new Overapprox(overapproximations).annotate(fct);
        }
    }

    private UnmodifiableTransFormula constructForkTransFormula(IForkActionThreadCurrent.ForkSmtArguments fsa, List<IProgramVar> threadIdVars, String threadInstanceName, CfgSmtToolkit cfgSmtToolkit) {
        ManagedScript managedScript = cfgSmtToolkit.getManagedScript();
        UnmodifiableTransFormula parameterAssignment = fsa.constructInVarsAssignment(cfgSmtToolkit.getSymbolTable(), managedScript, cfgSmtToolkit.getInParams().get(threadInstanceName));
        UnmodifiableTransFormula threadIdAssignment = fsa.constructThreadIdAssignment(cfgSmtToolkit.getSymbolTable(), managedScript, threadIdVars);
        Set<IProgramVar> localVarsWithoutInParams = cfgSmtToolkit.getSymbolTable().getLocals(threadInstanceName).stream().filter(x -> !cfgSmtToolkit.getInParams().get(threadInstanceName).contains(x)).collect(Collectors.toSet());
        UnmodifiableTransFormula havocOfLocalVars = TransFormulaUtils.constructHavoc(localVarsWithoutInParams, managedScript);
        List<UnmodifiableTransFormula> conjuncts = List.of(parameterAssignment, threadIdAssignment, havocOfLocalVars);
        return this.constructSequentialComposition(managedScript, conjuncts);
    }

    private UnmodifiableTransFormula constructSequentialComposition(ManagedScript managedScript, List<UnmodifiableTransFormula> transformulas) {
        return TransFormulaUtils.sequentialComposition(this.mLogger, this.mServices, managedScript, false, false, false, SmtUtils.XnfConversionTechnique.BOTTOM_UP_WITH_LOCAL_SIMPLIFICATION, SmtUtils.SimplificationTechnique.NONE, transformulas);
    }

    private static void integrateForkEdge(IIcfgForkTransitionThreadCurrent<IcfgLocation> originProvider, BlockEncodingBacktranslator backtranslator, IcfgLocation source, IcfgLocation target, IcfgEdge newEdge) {
        source.addOutgoing((IModifiableMultigraphEdge)newEdge);
        target.addIncoming((IModifiableMultigraphEdge)newEdge);
        IIcfgTransition<IcfgLocation> originalEdge = ThreadInstanceAdder.getOriginalEdge(originProvider, backtranslator);
        backtranslator.mapEdges((IIcfgTransition<IcfgLocation>)newEdge, originalEdge);
        backtranslator.addAteTransformer(newEdge, builder -> {
            builder.addStepInfo(new AtomicTraceElement.StepInfo[]{AtomicTraceElement.StepInfo.FORK});
            if (builder.getForkedThreadId() == null) {
                builder.setForkedThreadId(-1);
            }
        });
    }

    private static IIcfgTransition<IcfgLocation> getOriginalEdge(IIcfgTransition<IcfgLocation> newEdge, BlockEncodingBacktranslator backtranslator) {
        List transRes = backtranslator.translateTrace(Collections.singletonList(newEdge));
        if (transRes.size() != 1) {
            throw new IllegalStateException();
        }
        return (IIcfgTransition)transRes.get(0);
    }

    private void addJoinOtherThreadTransition(IIcfgJoinTransitionThreadCurrent<IcfgLocation> jot, String threadInstanceName, IProgramNonOldVar[] threadIdVars, IIcfg<? extends IcfgLocation> icfg, BlockEncodingBacktranslator backtranslator) {
        IcfgLocation exitNode = icfg.getProcedureExitNodes().get(threadInstanceName);
        Object callerNode = jot.getTarget();
        CfgSmtToolkit cfgSmtToolkit = icfg.getCfgSmtToolkit();
        UnmodifiableTransFormula joinTransformula = this.constructJoinTransformula(jot.getJoinSmtArguments(), Arrays.asList(threadIdVars), threadInstanceName, cfgSmtToolkit);
        IcfgJoinThreadOtherTransition joinThreadOther = cfgSmtToolkit.getIcfgEdgeFactory().createJoinThreadOtherTransition(exitNode, (IcfgLocation)callerNode, null, joinTransformula, jot);
        exitNode.addOutgoing((IModifiableMultigraphEdge)joinThreadOther);
        callerNode.addIncoming((IModifiableMultigraphEdge)joinThreadOther);
        IIcfgTransition<IcfgLocation> originalEdge = ThreadInstanceAdder.getOriginalEdge(jot, backtranslator);
        backtranslator.mapEdges((IIcfgTransition<IcfgLocation>)joinThreadOther, originalEdge);
        HashMap overapproximations = new HashMap();
        if (!overapproximations.isEmpty()) {
            new Overapprox(overapproximations).annotate(jot);
        }
    }

    private UnmodifiableTransFormula constructJoinTransformula(IJoinActionThreadCurrent.JoinSmtArguments jsa, List<IProgramVar> threadIdVars, String threadInstanceName, CfgSmtToolkit cfgSmtToolkit) {
        ManagedScript managedScript = cfgSmtToolkit.getManagedScript();
        UnmodifiableTransFormula threadIdAssumption = jsa.constructThreadIdAssumption(cfgSmtToolkit.getSymbolTable(), managedScript, threadIdVars);
        UnmodifiableTransFormula resultAssignment = jsa.getAssignmentLhs().isEmpty() ? TransFormulaBuilder.getTrivialTransFormula(managedScript) : jsa.constructResultAssignment(managedScript, cfgSmtToolkit.getOutParams().get(threadInstanceName));
        List<UnmodifiableTransFormula> conjuncts = List.of(resultAssignment, threadIdAssumption);
        return this.constructSequentialComposition(managedScript, conjuncts);
    }

    public static Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>> constructThreadInstances(IIcfg<? extends IcfgLocation> icfg, List<IIcfgForkTransitionThreadCurrent<IcfgLocation>> forkCurrentThreads, int numberOfThreadInstances) {
        HashMap<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>> result = new HashMap<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>>();
        ManagedScript mgdScript = icfg.getCfgSmtToolkit().getManagedScript();
        int i = 0;
        for (IIcfgForkTransitionThreadCurrent<IcfgLocation> fork : forkCurrentThreads) {
            ArrayList<ThreadInstance> threadInstances = new ArrayList<ThreadInstance>();
            int j = 1;
            while (j <= numberOfThreadInstances) {
                String procedureName = fork.getNameOfForkedProcedure();
                String threadInstanceId = ThreadInstanceAdder.generateThreadInstanceId(i, procedureName, j, numberOfThreadInstances);
                ThreadInstance ti = ThreadInstanceAdder.constructThreadInstance(mgdScript, fork, procedureName, threadInstanceId);
                threadInstances.add(ti);
                ++j;
            }
            result.put(fork, threadInstances);
            ++i;
        }
        return result;
    }

    static IcfgLocation constructErrorLocation(int i, IIcfgForkTransitionThreadCurrent<IcfgLocation> fork) {
        Check check = new Check(Check.Spec.SUFFICIENT_THREAD_INSTANCES);
        ProcedureErrorWithCheckDebugIdentifier debugIdentifier = new ProcedureErrorWithCheckDebugIdentifier(fork.getPrecedingProcedure(), i, ProcedureErrorDebugIdentifier.ProcedureErrorType.INUSE_VIOLATION, check);
        IcfgLocation errorLocation = new IcfgLocation(debugIdentifier, fork.getPrecedingProcedure());
        ModelUtils.copyAnnotations(fork, (IElement)errorLocation);
        check.annotate((IElement)errorLocation);
        return errorLocation;
    }

    private static ThreadInstance constructThreadInstance(ManagedScript mgdScript, IIcfgForkTransitionThreadCurrent<IcfgLocation> fork, String procedureName, String threadInstanceId) {
        IProgramNonOldVar[] threadIdVars = ThreadInstanceAdder.constructThreadIdVariable(threadInstanceId, mgdScript, fork.getForkSmtArguments().getThreadIdArguments().getTerms());
        return new ThreadInstance(threadInstanceId, procedureName, threadIdVars);
    }

    private static String generateThreadInstanceId(int forkNumber, String procedureName, int threadInstanceNumber, int threadInstanceMax) {
        return String.valueOf(procedureName) + "Thread" + threadInstanceNumber + "of" + threadInstanceMax + "ForFork" + forkNumber;
    }

    private static ProgramNonOldVar[] constructThreadIdVariable(String threadInstanceId, ManagedScript mgdScript, Term[] threadIdArguments) {
        ProgramNonOldVar[] threadIdVars = new ProgramNonOldVar[threadIdArguments.length];
        int i = 0;
        Term[] termArray = threadIdArguments;
        int n = threadIdArguments.length;
        int n2 = 0;
        while (n2 < n) {
            Term forkId = termArray[n2];
            threadIdVars[i] = ThreadInstanceAdder.constructThreadAuxiliaryVariable(String.valueOf(threadInstanceId) + "_thidvar" + i, forkId.getSort(), mgdScript);
            ++i;
            ++n2;
        }
        return threadIdVars;
    }

    private static ProgramNonOldVar constructThreadAuxiliaryVariable(String id, Sort sort, ManagedScript mgdScript) {
        mgdScript.lock((Object)id);
        ProgramNonOldVar var = ProgramVarUtils.constructGlobalProgramVarPair(id, sort, mgdScript, id);
        mgdScript.unlock((Object)id);
        return var;
    }

    CfgSmtToolkit constructNewToolkit(CfgSmtToolkit cfgSmtToolkit, Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, List<ThreadInstance>> threadInstanceMap, Map<IIcfgForkTransitionThreadCurrent<IcfgLocation>, IcfgLocation> inUseErrorNodeMap, Collection<IIcfgJoinTransitionThreadCurrent<IcfgLocation>> joinTransitions) {
        DefaultIcfgSymbolTable newSymbolTable = new DefaultIcfgSymbolTable(cfgSmtToolkit.getSymbolTable(), cfgSmtToolkit.getProcedures());
        HashRelation proc2Globals = new HashRelation(cfgSmtToolkit.getModifiableGlobalsTable().getProcToGlobals());
        for (ThreadInstance ti : IcfgPetrifier.getAllInstances(threadInstanceMap)) {
            IProgramNonOldVar[] iProgramNonOldVarArray = ti.getIdVars();
            int n = iProgramNonOldVarArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProgramNonOldVar idVar = iProgramNonOldVarArray[n2];
                ThreadInstanceAdder.addVar(idVar, newSymbolTable, (HashRelation<String, IProgramNonOldVar>)proc2Globals, cfgSmtToolkit.getProcedures());
                ++n2;
            }
        }
        newSymbolTable.finishConstruction();
        ConcurrencyInformation concurrencyInformation = new ConcurrencyInformation(threadInstanceMap, inUseErrorNodeMap, joinTransitions);
        return new CfgSmtToolkit(new ModifiableGlobalsTable((HashRelation<String, IProgramNonOldVar>)proc2Globals), cfgSmtToolkit.getManagedScript(), newSymbolTable, cfgSmtToolkit.getProcedures(), cfgSmtToolkit.getInParams(), cfgSmtToolkit.getOutParams(), cfgSmtToolkit.getIcfgEdgeFactory(), concurrencyInformation, cfgSmtToolkit.getSmtFunctionsAndAxioms());
    }

    private static void addVar(IProgramNonOldVar var, DefaultIcfgSymbolTable newSymbolTable, HashRelation<String, IProgramNonOldVar> proc2Globals, Set<String> allProcedures) {
        newSymbolTable.add(var);
        for (String proc : allProcedures) {
            proc2Globals.addPair((Object)proc, (Object)var);
        }
    }
}

