/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure;

import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;

public abstract class AbstractIcfgTransition
extends IcfgEdge {
    private static final long serialVersionUID = 2115527505602304364L;
    private final int mId;

    public AbstractIcfgTransition(IcfgLocation source, IcfgLocation target, IPayload payload, int id) {
        super(source, target, payload);
        this.mId = id;
    }

    @Override
    public String getPrecedingProcedure() {
        return ((IcfgLocation)super.getSource()).getProcedure();
    }

    @Override
    public String getSucceedingProcedure() {
        return ((IcfgLocation)super.getTarget()).getProcedure();
    }

    public String toString() {
        return this.toDebugString(null);
    }

    public int hashCode() {
        return this.mId;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractIcfgTransition other = (AbstractIcfgTransition)obj;
        return this.mId == other.mId;
    }

    protected String toDebugString(String suffix) {
        StringBuilder sb = new StringBuilder();
        sb.append("[").append(this.mId).append("] ");
        sb.append(this.getSource());
        sb.append("-->");
        sb.append(this.getTarget());
        if (suffix != null) {
            sb.append(": ");
            sb.append(suffix);
        }
        return sb.toString();
    }
}

