/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.AbstractBasicAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.BasicCallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.BasicForkActionCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.BasicInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.BasicJoinActionCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.BasicReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IForkActionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IJoinActionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import java.util.Collections;

public final class ActionUtils {
    private ActionUtils() {
    }

    public static IAction constructCopy(ManagedScript script, IAction action) {
        AbstractBasicAction rtr;
        if (action == null) {
            return null;
        }
        if (action instanceof IInternalAction) {
            UnmodifiableTransFormula oldTf = action.getTransformula();
            UnmodifiableTransFormula newTf = TransFormulaBuilder.constructCopy(script, oldTf, Collections.emptySet(), Collections.emptySet(), Collections.emptyMap());
            rtr = new BasicInternalAction(action.getPrecedingProcedure(), action.getSucceedingProcedure(), newTf);
        } else if (action instanceof ICallAction) {
            UnmodifiableTransFormula oldTf = ((ICallAction)action).getLocalVarsAssignment();
            UnmodifiableTransFormula newTf = TransFormulaBuilder.constructCopy(script, oldTf, Collections.emptySet(), Collections.emptySet(), Collections.emptyMap());
            rtr = new BasicCallAction(action.getPrecedingProcedure(), action.getSucceedingProcedure(), newTf);
        } else if (action instanceof IReturnAction) {
            IReturnAction rAction = (IReturnAction)action;
            UnmodifiableTransFormula oldAORTf = rAction.getAssignmentOfReturn();
            UnmodifiableTransFormula oldLVACTf = rAction.getLocalVarsAssignmentOfCall();
            UnmodifiableTransFormula newAORTf = TransFormulaBuilder.constructCopy(script, oldAORTf, Collections.emptySet(), Collections.emptySet(), Collections.emptyMap());
            UnmodifiableTransFormula newLVACTf = TransFormulaBuilder.constructCopy(script, oldLVACTf, Collections.emptySet(), Collections.emptySet(), Collections.emptyMap());
            rtr = new BasicReturnAction(action.getPrecedingProcedure(), action.getSucceedingProcedure(), newAORTf, newLVACTf);
        } else if (action instanceof IForkActionThreadCurrent) {
            IForkActionThreadCurrent fAction = (IForkActionThreadCurrent)action;
            fAction.getTransformula();
            rtr = new BasicForkActionCurrent(action.getPrecedingProcedure(), action.getSucceedingProcedure(), fAction.getTransformula(), fAction.getForkSmtArguments(), fAction.getNameOfForkedProcedure());
        } else if (action instanceof IJoinActionThreadCurrent) {
            IJoinActionThreadCurrent fAction = (IJoinActionThreadCurrent)action;
            rtr = new BasicJoinActionCurrent(action.getPrecedingProcedure(), action.getSucceedingProcedure(), fAction.getTransformula(), fAction.getJoinSmtArguments());
        } else {
            throw new UnsupportedOperationException("(Yet) unknown IAction subtype: " + action.getClass());
        }
        return rtr;
    }
}

