/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure;

import de.uni_freiburg.informatik.ultimate.core.lib.models.VisualizationNode;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IVisualizable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgGraphProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.DebugIdentifier;
import de.uni_freiburg.informatik.ultimate.util.TgfBuilder;
import java.util.Map;
import java.util.Set;

public interface IIcfg<LOC extends IcfgLocation>
extends IElement,
IVisualizable<VisualizationNode> {
    public Map<String, Map<DebugIdentifier, LOC>> getProgramPoints();

    public Map<String, LOC> getProcedureEntryNodes();

    public Map<String, LOC> getProcedureExitNodes();

    public Map<String, Set<LOC>> getProcedureErrorNodes();

    public Set<LOC> getLoopLocations();

    public CfgSmtToolkit getCfgSmtToolkit();

    public Set<LOC> getInitialNodes();

    public String getIdentifier();

    default public VisualizationNode getVisualizationGraph() {
        return IcfgGraphProvider.getVisualizationGraph(this);
    }

    public Class<LOC> getLocationClass();

    default public String graphStructureToString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Map<DebugIdentifier, LOC>> entry : this.getProgramPoints().entrySet()) {
            for (Map.Entry<DebugIdentifier, LOC> innerEntry : entry.getValue().entrySet()) {
                IcfgLocation loc = (IcfgLocation)innerEntry.getValue();
                for (IcfgEdge edge : loc.getOutgoingEdges()) {
                    sb.append("ProgramPoint: ");
                    sb.append(loc.toString());
                    sb.append(" --->  Edge: ");
                    sb.append(edge.getClass().getSimpleName());
                    sb.append(" ");
                    sb.append(edge.toString());
                    sb.append(" --->  ProgramPoint: ");
                    sb.append(((IcfgLocation)edge.getTarget()).toString());
                    sb.append(System.lineSeparator());
                }
            }
        }
        return sb.toString();
    }

    default public String graphStructureToTgf() {
        TgfBuilder tgfBuilder = new TgfBuilder();
        for (Map.Entry<String, Map<DebugIdentifier, LOC>> entry : this.getProgramPoints().entrySet()) {
            for (Map.Entry<DebugIdentifier, LOC> innerEntry : entry.getValue().entrySet()) {
                IcfgLocation sourceNode = (IcfgLocation)innerEntry.getValue();
                tgfBuilder.addDisconnectedNode((Object)sourceNode);
                for (IcfgEdge edge : sourceNode.getOutgoingEdges()) {
                    tgfBuilder.addEdge((Object)sourceNode, (Object)edge, (Object)((IcfgLocation)edge.getTarget()));
                }
            }
        }
        return tgfBuilder.toString();
    }
}

