/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.ModelCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IActionWithBranchEncoders;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgSummaryTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgForkThreadCurrentTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgForkThreadOtherTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgJoinThreadCurrentTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgJoinThreadOtherTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class IcfgEdgeBuilder {
    private final SmtUtils.XnfConversionTechnique mXnfConversionTechnique;
    private final SmtUtils.SimplificationTechnique mSimplificationTechnique;
    private final ManagedScript mManagedScript;
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final CfgSmtToolkit mCfgSmtToolkit;
    private final IcfgEdgeFactory mEdgeFactory;

    public IcfgEdgeBuilder(CfgSmtToolkit toolkit, IUltimateServiceProvider services, SmtUtils.SimplificationTechnique simplificationTechnique, SmtUtils.XnfConversionTechnique xnfConversionTechnique) {
        this.mServices = services;
        this.mLogger = services.getLoggingService().getLogger(ModelCheckerUtils.PLUGIN_ID);
        this.mSimplificationTechnique = simplificationTechnique;
        this.mXnfConversionTechnique = xnfConversionTechnique;
        this.mManagedScript = toolkit.getManagedScript();
        this.mCfgSmtToolkit = toolkit;
        this.mEdgeFactory = toolkit.getIcfgEdgeFactory();
    }

    public IcfgEdge constructSequentialComposition(IcfgLocation source, IcfgLocation target, List<IcfgEdge> edges) {
        return this.constructSequentialComposition(source, target, edges, false, false, true);
    }

    public IcfgEdge constructSequentialComposition(IcfgLocation source, IcfgLocation target, IcfgEdge first, IcfgEdge second) {
        List<IcfgEdge> codeblocks = Arrays.asList(first, second);
        return this.constructSequentialComposition(source, target, codeblocks, false, false, true);
    }

    public IcfgEdge constructSimplifiedSequentialComposition(IcfgLocation source, IcfgLocation target, IcfgEdge block) {
        return this.constructSequentialComposition(source, target, Collections.singletonList(block), true, true, true);
    }

    public IcfgEdge constructSequentialComposition(IcfgLocation source, IcfgLocation target, List<IcfgEdge> transitions, boolean simplify, boolean elimQuants, boolean connect) {
        assert (IcfgEdgeBuilder.onlyInternal(transitions)) : "You cannot have calls or returns in normal sequential compositions";
        List<UnmodifiableTransFormula> transFormulas = transitions.stream().map(IcfgUtils::getTransformula).collect(Collectors.toList());
        UnmodifiableTransFormula tf = TransFormulaUtils.sequentialComposition(this.mLogger, this.mServices, this.mManagedScript, simplify, elimQuants, false, this.mXnfConversionTechnique, this.mSimplificationTechnique, transFormulas);
        List<UnmodifiableTransFormula> transFormulasWithBE = transitions.stream().map(IcfgEdgeBuilder::getTransformulaWithBE).collect(Collectors.toList());
        UnmodifiableTransFormula tfWithBE = TransFormulaUtils.sequentialComposition(this.mLogger, this.mServices, this.mManagedScript, simplify, elimQuants, false, this.mXnfConversionTechnique, this.mSimplificationTechnique, transFormulasWithBE);
        IcfgInternalTransition rtr = this.mEdgeFactory.createInternalTransition(source, target, null, tf, tfWithBE);
        ModelUtils.mergeAnnotations(transitions, (IElement)rtr);
        if (connect) {
            source.addOutgoing((IModifiableMultigraphEdge)rtr);
            target.addIncoming((IModifiableMultigraphEdge)rtr);
        }
        return rtr;
    }

    private static UnmodifiableTransFormula getTransformulaWithBE(IcfgEdge edge) {
        if (edge instanceof IActionWithBranchEncoders) {
            return ((IActionWithBranchEncoders)((Object)edge)).getTransitionFormulaWithBranchEncoders();
        }
        return edge.getTransformula();
    }

    public IcfgEdge constructInterproceduralSequentialComposition(IcfgLocation source, IcfgLocation target, IIcfgCallTransition<?> callTrans, IIcfgTransition<?> intermediateTrans, IIcfgReturnTransition<?, ?> returnTrans) {
        return this.constructInterproceduralSequentialComposition(source, target, callTrans, intermediateTrans, returnTrans, false, false);
    }

    private IcfgEdge constructInterproceduralSequentialComposition(IcfgLocation source, IcfgLocation target, IIcfgCallTransition<?> callTrans, IIcfgTransition<?> intermediateTrans, IIcfgReturnTransition<?, ?> returnTrans, boolean simplify, boolean elimQuants) {
        UnmodifiableTransFormula tfWithBE;
        String calledProc = callTrans.getSucceedingProcedure();
        UnmodifiableTransFormula callTf = callTrans.getLocalVarsAssignment();
        UnmodifiableTransFormula oldVarsAssignment = this.mCfgSmtToolkit.getOldVarsAssignmentCache().getOldVarsAssignment(calledProc);
        UnmodifiableTransFormula globalVarsAssignment = this.mCfgSmtToolkit.getOldVarsAssignmentCache().getGlobalVarsAssignment(calledProc);
        UnmodifiableTransFormula procedureTf = intermediateTrans.getTransformula();
        UnmodifiableTransFormula returnTf = returnTrans.getAssignmentOfReturn();
        IIcfgSymbolTable symbolTable = this.mCfgSmtToolkit.getSymbolTable();
        Set<IProgramNonOldVar> modifiableGlobalsOfCallee = this.mCfgSmtToolkit.getModifiableGlobalsTable().getModifiedBoogieVars(calledProc);
        UnmodifiableTransFormula tf = TransFormulaUtils.sequentialCompositionWithCallAndReturn(this.mManagedScript, simplify, elimQuants, false, callTf, oldVarsAssignment, globalVarsAssignment, procedureTf, returnTf, this.mLogger, this.mServices, this.mXnfConversionTechnique, this.mSimplificationTechnique, symbolTable, modifiableGlobalsOfCallee);
        if (intermediateTrans instanceof IActionWithBranchEncoders) {
            UnmodifiableTransFormula procedureTfWithBE = ((IActionWithBranchEncoders)((Object)intermediateTrans)).getTransitionFormulaWithBranchEncoders();
            tfWithBE = TransFormulaUtils.sequentialCompositionWithCallAndReturn(this.mManagedScript, simplify, elimQuants, false, callTf, oldVarsAssignment, globalVarsAssignment, procedureTfWithBE, returnTf, this.mLogger, this.mServices, this.mXnfConversionTechnique, this.mSimplificationTechnique, symbolTable, modifiableGlobalsOfCallee);
        } else {
            tfWithBE = tf;
        }
        IcfgInternalTransition rtr = this.mEdgeFactory.createInternalTransition(source, target, null, tf, tfWithBE);
        source.addOutgoing((IModifiableMultigraphEdge)rtr);
        target.addIncoming((IModifiableMultigraphEdge)rtr);
        ModelUtils.mergeAnnotations((IElement)rtr, (IElement[])new IElement[]{callTrans, intermediateTrans, returnTrans});
        return rtr;
    }

    public IcfgInternalTransition constructParallelComposition(IcfgLocation source, IcfgLocation target, Map<TermVariable, IcfgEdge> branchEncodersAndTransitions) {
        assert (!branchEncodersAndTransitions.isEmpty()) : "Cannot compose 0 transitions";
        Collection<IcfgEdge> transitions = branchEncodersAndTransitions.values();
        assert (IcfgEdgeBuilder.onlyInternal(transitions)) : "You cannot have calls or returns in parallel compositions";
        List<UnmodifiableTransFormula> transFormulas = transitions.stream().map(IcfgUtils::getTransformula).collect(Collectors.toList());
        UnmodifiableTransFormula[] tfArray = transFormulas.toArray(new UnmodifiableTransFormula[transFormulas.size()]);
        UnmodifiableTransFormula parallelTf = TransFormulaUtils.parallelComposition(this.mLogger, this.mServices, this.mManagedScript, null, false, this.mXnfConversionTechnique, true, tfArray);
        List<UnmodifiableTransFormula> transFormulasWithBE = transitions.stream().map(IcfgEdgeBuilder::getTransformulaWithBE).collect(Collectors.toList());
        UnmodifiableTransFormula[] tfWithBEArray = transFormulasWithBE.toArray(new UnmodifiableTransFormula[transFormulasWithBE.size()]);
        TermVariable[] branchIndicatorArray = branchEncodersAndTransitions.keySet().toArray(new TermVariable[branchEncodersAndTransitions.size()]);
        UnmodifiableTransFormula parallelWithBranchIndicators = TransFormulaUtils.parallelComposition(this.mLogger, this.mServices, this.mManagedScript, branchIndicatorArray, false, this.mXnfConversionTechnique, true, tfWithBEArray);
        IcfgInternalTransition rtr = this.mEdgeFactory.createInternalTransition(source, target, null, parallelTf, parallelWithBranchIndicators);
        ModelUtils.mergeAnnotations(transitions, (IElement)rtr);
        return rtr;
    }

    public Map<TermVariable, IcfgEdge> constructBranchIndicatorToEdgeMapping(List<IcfgEdge> transitions) {
        LinkedHashMap<TermVariable, IcfgEdge> result = new LinkedHashMap<TermVariable, IcfgEdge>();
        this.mManagedScript.lock(result);
        int i = 0;
        while (i < transitions.size()) {
            String varname = "BraInd" + i + "of" + transitions.size();
            Sort boolSort = SmtSortUtils.getBoolSort((Script)this.mManagedScript.getScript());
            TermVariable tv = this.mManagedScript.constructFreshTermVariable(varname, boolSort);
            result.put(tv, transitions.get(i));
            ++i;
        }
        this.mManagedScript.unlock(result);
        return result;
    }

    private static boolean onlyInternal(Collection<IcfgEdge> transitions) {
        return transitions.stream().allMatch(IcfgEdgeBuilder::onlyInternal);
    }

    private static boolean onlyInternal(IcfgEdge transition) {
        return transition instanceof IIcfgInternalTransition && !(transition instanceof IIcfgSummaryTransition);
    }

    public IcfgEdge constructAndConnectInternalTransition(IcfgEdge oldTransition, IcfgLocation source, IcfgLocation target, Term term) {
        assert (IcfgEdgeBuilder.onlyInternal(oldTransition)) : "You cannot have calls or returns in normal sequential compositions";
        UnmodifiableTransFormula oldTf = IcfgUtils.getTransformula(oldTransition);
        HashSet<TermVariable> freeVars = new HashSet<TermVariable>(Arrays.asList(term.getFreeVars()));
        HashSet<TermVariable> oldFreeVars = new HashSet<TermVariable>(Arrays.asList(oldTf.getFormula().getFreeVars()));
        Map<IProgramVar, TermVariable> newInVars = IcfgEdgeBuilder.filterValues(oldTf.getInVars(), freeVars::contains);
        Map<IProgramVar, TermVariable> newOutVars = IcfgEdgeBuilder.filterValues(oldTf.getOutVars(), freeVars::contains);
        HashSet<TermVariable> newAuxVars = new HashSet<TermVariable>(oldTf.getAuxVars());
        newAuxVars.retainAll(freeVars);
        newInVars.putAll(IcfgEdgeBuilder.filterValues(oldTf.getInVars(), a -> !oldFreeVars.contains(a)));
        newOutVars.putAll(IcfgEdgeBuilder.filterValues(oldTf.getOutVars(), a -> !oldFreeVars.contains(a)));
        TransFormulaBuilder tfb = new TransFormulaBuilder(newInVars, newOutVars, oldTf.getNonTheoryConsts().isEmpty(), oldTf.getNonTheoryConsts(), true, null, newAuxVars.isEmpty());
        tfb.setFormula(term);
        if (!newAuxVars.isEmpty()) {
            tfb.addAuxVarsButRenameToFreshCopies(newAuxVars, this.mManagedScript);
        }
        tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        UnmodifiableTransFormula tf = tfb.finishConstruction(this.mManagedScript);
        return this.constructAndConnectInternalTransition(oldTransition, source, target, tf);
    }

    public IcfgEdge constructAndConnectInternalTransition(IcfgEdge oldTransition, IcfgLocation source, IcfgLocation target, UnmodifiableTransFormula tf) {
        IcfgEdge edge = this.constructInternalTransition(oldTransition, source, target, tf);
        source.addOutgoing((IModifiableMultigraphEdge)edge);
        target.addIncoming((IModifiableMultigraphEdge)edge);
        return edge;
    }

    public IcfgEdge constructInternalTransition(IcfgEdge oldTransition, IcfgLocation source, IcfgLocation target, UnmodifiableTransFormula tf) {
        assert (IcfgEdgeBuilder.onlyInternal(oldTransition)) : "You cannot have calls or returns in normal sequential compositions";
        IcfgInternalTransition rtr = this.mEdgeFactory.createInternalTransition(source, target, null, tf);
        ModelUtils.copyAnnotations((IElement)oldTransition, (IElement)rtr);
        return rtr;
    }

    public IcfgForkThreadCurrentTransition constructForkCurrentTransition(IcfgForkThreadCurrentTransition oldTransition, UnmodifiableTransFormula tf, boolean connect) {
        IcfgForkThreadCurrentTransition rtr = this.mEdgeFactory.createForkThreadCurrentTransition((IcfgLocation)oldTransition.getSource(), (IcfgLocation)oldTransition.getTarget(), null, tf, oldTransition.getForkSmtArguments(), oldTransition.getNameOfForkedProcedure());
        ModelUtils.copyAnnotations((IElement)oldTransition, (IElement)rtr);
        if (connect) {
            ((IcfgLocation)oldTransition.getSource()).addOutgoing((IModifiableMultigraphEdge)rtr);
            ((IcfgLocation)oldTransition.getTarget()).addIncoming((IModifiableMultigraphEdge)rtr);
        }
        return rtr;
    }

    public IcfgForkThreadOtherTransition constructForkOtherTransition(IcfgForkThreadOtherTransition oldTransition, UnmodifiableTransFormula tf, boolean connect) {
        IcfgForkThreadOtherTransition rtr = this.mEdgeFactory.createForkThreadOtherTransition((IcfgLocation)oldTransition.getSource(), (IcfgLocation)oldTransition.getTarget(), null, tf, oldTransition.getCorrespondingIIcfgForkTransitionCurrentThread());
        ModelUtils.copyAnnotations((IElement)oldTransition, (IElement)rtr);
        if (connect) {
            ((IcfgLocation)oldTransition.getSource()).addOutgoing((IModifiableMultigraphEdge)rtr);
            ((IcfgLocation)oldTransition.getTarget()).addIncoming((IModifiableMultigraphEdge)rtr);
        }
        return rtr;
    }

    public IcfgJoinThreadCurrentTransition constructJoinCurrentTransition(IcfgJoinThreadCurrentTransition oldTransition, UnmodifiableTransFormula tf, boolean connect) {
        IcfgJoinThreadCurrentTransition rtr = this.mEdgeFactory.createJoinThreadCurrentTransition((IcfgLocation)oldTransition.getSource(), (IcfgLocation)oldTransition.getTarget(), null, tf, oldTransition.getJoinSmtArguments());
        ModelUtils.copyAnnotations((IElement)oldTransition, (IElement)rtr);
        if (connect) {
            ((IcfgLocation)oldTransition.getSource()).addOutgoing((IModifiableMultigraphEdge)rtr);
            ((IcfgLocation)oldTransition.getTarget()).addIncoming((IModifiableMultigraphEdge)rtr);
        }
        return rtr;
    }

    public IcfgJoinThreadOtherTransition constructJoinOtherTransition(IcfgJoinThreadOtherTransition oldTransition, UnmodifiableTransFormula tf, boolean connect) {
        IcfgJoinThreadOtherTransition rtr = this.mEdgeFactory.createJoinThreadOtherTransition((IcfgLocation)oldTransition.getSource(), (IcfgLocation)oldTransition.getTarget(), null, tf, oldTransition.getCorrespondingIIcfgJoinTransitionCurrentThread());
        ModelUtils.copyAnnotations((IElement)oldTransition, (IElement)rtr);
        if (connect) {
            ((IcfgLocation)oldTransition.getSource()).addOutgoing((IModifiableMultigraphEdge)rtr);
            ((IcfgLocation)oldTransition.getTarget()).addIncoming((IModifiableMultigraphEdge)rtr);
        }
        return rtr;
    }

    public IcfgEdge constructInternalTransition(IcfgEdge oldTransition, IcfgLocation source, IcfgLocation target, UnmodifiableTransFormula tf, UnmodifiableTransFormula tfWithBe, boolean connect) {
        assert (IcfgEdgeBuilder.onlyInternal(oldTransition)) : "You cannot have calls or returns in normal sequential compositions";
        IcfgInternalTransition rtr = this.mEdgeFactory.createInternalTransition(source, target, null, tf, tfWithBe);
        ModelUtils.copyAnnotations((IElement)oldTransition, (IElement)rtr);
        if (connect) {
            source.addOutgoing((IModifiableMultigraphEdge)rtr);
            target.addIncoming((IModifiableMultigraphEdge)rtr);
        }
        return rtr;
    }

    private static <K, V> Map<K, V> filterValues(Map<K, V> map, Predicate<V> funValueTest) {
        if (map == null) {
            return Collections.emptyMap();
        }
        return map.entrySet().stream().filter(a -> funValueTest.test(a.getValue())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }
}

