/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure;

import de.uni_freiburg.informatik.ultimate.core.lib.models.VisualizationNode;
import de.uni_freiburg.informatik.ultimate.core.model.models.IExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.debugidentifiers.ArtificialRootDebugIdentifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import java.util.Map;

public final class IcfgGraphProvider {
    public static <LOC extends IcfgLocation> VisualizationNode getVisualizationGraph(IIcfg<LOC> cont) {
        IExplicitEdgesMultigraph<IcfgLocation, IcfgEdge, IcfgLocation, IcfgEdge, VisualizationNode> artificialRoot = IcfgGraphProvider.getVirtualRoot(cont);
        return new VisualizationNode(artificialRoot);
    }

    public static <LOC extends IcfgLocation> IExplicitEdgesMultigraph<IcfgLocation, IcfgEdge, IcfgLocation, IcfgEdge, VisualizationNode> getVirtualRoot(IIcfg<LOC> cont) {
        IcfgVirtualRoot artificialRoot = new IcfgVirtualRoot();
        if (cont instanceof IAnnotations) {
            artificialRoot.getPayload().getAnnotations().put(cont.getClass().getSimpleName(), (IAnnotations)cont);
        }
        for (Map.Entry<String, LOC> entry : cont.getProcedureEntryNodes().entrySet()) {
            IcfgVirtualRootEdge edge = new IcfgVirtualRootEdge(artificialRoot, (IcfgLocation)entry.getValue());
            edge.redirectSource((IModifiableExplicitEdgesMultigraph)artificialRoot);
            edge.redirectTarget((IModifiableExplicitEdgesMultigraph)((IcfgLocation)entry.getValue()));
        }
        return artificialRoot;
    }

    private static final class IcfgVirtualRoot
    extends IcfgLocation {
        private static final long serialVersionUID = 7322581913329216222L;

        protected IcfgVirtualRoot() {
            super(ArtificialRootDebugIdentifier.DEFAULT, "");
        }
    }

    private static final class IcfgVirtualRootEdge
    extends IcfgEdge {
        private static final long serialVersionUID = 7322581913329216222L;

        protected IcfgVirtualRootEdge(IcfgLocation source, IcfgLocation target) {
            super(source, target, null);
        }

        @Override
        public UnmodifiableTransFormula getTransformula() {
            throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + " does not have a transformula");
        }
    }
}

