/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure;

import de.uni_freiburg.informatik.ultimate.core.model.models.IPayload;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.AbstractIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IActionWithBranchEncoders;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import java.util.Objects;

public final class IcfgInternalTransition
extends AbstractIcfgTransition
implements IIcfgInternalTransition<IcfgLocation>,
IActionWithBranchEncoders {
    private static final long serialVersionUID = -4893486021673688404L;
    private final UnmodifiableTransFormula mTransFormula;
    private final UnmodifiableTransFormula mTransFormulaWithBranchEncoders;

    protected IcfgInternalTransition(IcfgLocation source, IcfgLocation target, IPayload payload, UnmodifiableTransFormula transFormula, UnmodifiableTransFormula transFormulaWithBranchEncoders, int id) {
        super(source, target, payload, id);
        this.mTransFormula = Objects.requireNonNull(transFormula, "A transformula is missing");
        this.mTransFormulaWithBranchEncoders = Objects.requireNonNull(transFormulaWithBranchEncoders, "A transformula is missing");
        assert (TransFormulaUtils.hasInternalNormalForm(this.mTransFormula)) : "Expected TF in internal normal form";
        assert (TransFormulaUtils.hasInternalNormalForm(this.mTransFormulaWithBranchEncoders)) : "Expected TF in internal normal form";
    }

    @Override
    @Visualizable
    public UnmodifiableTransFormula getTransformula() {
        return this.mTransFormula;
    }

    @Override
    public String toString() {
        return this.toDebugString(this.mTransFormula.toString());
    }

    @Override
    public UnmodifiableTransFormula getTransitionFormulaWithBranchEncoders() {
        return this.mTransFormulaWithBranchEncoders;
    }
}

