/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public class IcfgLocationIterator<LOC extends IcfgLocation>
implements Iterator<LOC> {
    private final Deque<LOC> mWorklist;
    private final Set<LOC> mFinished = new HashSet<LOC>();

    public IcfgLocationIterator(LOC location) {
        this((Collection<LOC>)Collections.singleton(location));
    }

    public IcfgLocationIterator(Collection<LOC> locations) {
        this.mWorklist = new ArrayDeque<LOC>();
        this.mWorklist.addAll(locations);
        this.mFinished.addAll(this.mWorklist);
    }

    public IcfgLocationIterator(IIcfg<LOC> icfg) {
        this((Collection<LOC>)icfg.getInitialNodes());
    }

    @Override
    public boolean hasNext() {
        return !this.mWorklist.isEmpty();
    }

    @Override
    public LOC next() {
        IcfgLocation current = (IcfgLocation)this.mWorklist.removeFirst();
        current.getOutgoingEdges().stream().map(a -> (IcfgLocation)a.getTarget()).filter(this.mFinished::add).forEachOrdered(this.mWorklist::add);
        return (LOC)current;
    }

    public Stream<LOC> asStream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this, 16), false);
    }

    public static <LOC extends IcfgLocation> Stream<LOC> asStream(IIcfg<LOC> icfg) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(new IcfgLocationIterator<LOC>(icfg), 16), false);
    }
}

