/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations;

import de.uni_freiburg.informatik.ultimate.core.lib.translation.DefaultTranslator;
import de.uni_freiburg.informatik.ultimate.core.lib.translation.ProgramExecutionFormatter;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;

public class BlockEncodingBacktranslator
extends DefaultTranslator<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>, Term, Term, IcfgLocation, IcfgLocation> {
    private static final boolean PRINT_MAPPINGS = false;
    private final Map<IIcfgTransition<IcfgLocation>, List<IIcfgTransition<IcfgLocation>>> mSequentialCompositions = new HashMap<IIcfgTransition<IcfgLocation>, List<IIcfgTransition<IcfgLocation>>>();
    private final Map<IIcfgTransition<IcfgLocation>, Set<IIcfgTransition<IcfgLocation>>> mParallelCompositions = new HashMap<IIcfgTransition<IcfgLocation>, Set<IIcfgTransition<IcfgLocation>>>();
    private final Map<IIcfgTransition<IcfgLocation>, TermVariable> mBranchEncoderMapping = new HashMap<IIcfgTransition<IcfgLocation>, TermVariable>();
    private final Map<IIcfgTransition<IcfgLocation>, Consumer<AtomicTraceElement.AtomicTraceElementBuilder<IIcfgTransition<IcfgLocation>>>> mAteTransformer = new HashMap<IIcfgTransition<IcfgLocation>, Consumer<AtomicTraceElement.AtomicTraceElementBuilder<IIcfgTransition<IcfgLocation>>>>();
    private final Map<IcfgLocation, IcfgLocation> mLocationMapping = new HashMap<IcfgLocation, IcfgLocation>();
    private final ILogger mLogger;
    private final Set<IIcfgTransition<IcfgLocation>> mIntermediateEdges = new HashSet<IIcfgTransition<IcfgLocation>>();
    private Function<Term, Term> mTermTranslator = x -> x;
    private Set<Term> mVariableBlacklist = Collections.emptySet();

    public BlockEncodingBacktranslator(Class<? extends IIcfgTransition<IcfgLocation>> traceElementType, Class<Term> expressionType, ILogger logger) {
        super(traceElementType, traceElementType, expressionType, expressionType);
        this.mLogger = logger;
    }

    public IProgramExecution<IIcfgTransition<IcfgLocation>, Term> translateProgramExecution(IProgramExecution<IIcfgTransition<IcfgLocation>, Term> oldPe) {
        if (oldPe == null) {
            throw new IllegalArgumentException("programExecution is null");
        }
        if (!(oldPe instanceof IcfgProgramExecution)) {
            throw new IllegalArgumentException("argument is not IcfgProgramExecution but " + oldPe.getClass());
        }
        IcfgProgramExecution oldIcfgPe = (IcfgProgramExecution)oldPe;
        Map<TermVariable, Boolean>[] oldBranchEncoders = oldIcfgPe.getBranchEncoders();
        assert (oldBranchEncoders.length == oldIcfgPe.getLength()) : "incorrect number of branch encoders: expected " + oldIcfgPe.getLength() + ", actual " + oldBranchEncoders.length;
        assert (this.checkCallStackSourceProgramExecution(this.mLogger, oldIcfgPe)) : "callstack of initial program execution already broken";
        ArrayList newTrace = new ArrayList();
        ArrayList<IProgramExecution.ProgramState<Term>> newValues = new ArrayList<IProgramExecution.ProgramState<Term>>();
        ArrayList<Map<TermVariable, Boolean>> newBranchEncoders = new ArrayList<Map<TermVariable, Boolean>>();
        int i = 0;
        while (i < oldIcfgPe.getLength()) {
            AtomicTraceElement currentATE = oldIcfgPe.getTraceElement(i);
            Collection<IIcfgTransition<IcfgLocation>> mappedEdges = this.translateBack((IIcfgTransition)currentATE.getTraceElement(), oldBranchEncoders[i]);
            Iterator<IIcfgTransition<IcfgLocation>> iter = mappedEdges.iterator();
            while (iter.hasNext()) {
                IIcfgTransition<IcfgLocation> currentEdge = iter.next();
                AtomicTraceElement.AtomicTraceElementBuilder builder = AtomicTraceElement.AtomicTraceElementBuilder.fromReplaceElementAndStep(currentATE, currentEdge);
                Consumer<AtomicTraceElement.AtomicTraceElementBuilder<IIcfgTransition<IcfgLocation>>> transformer = this.mAteTransformer.get(currentATE.getTraceElement());
                if (transformer != null) {
                    transformer.accept((AtomicTraceElement.AtomicTraceElementBuilder<IIcfgTransition<IcfgLocation>>)builder);
                }
                newTrace.add(builder.build());
                if (!iter.hasNext()) continue;
                newValues.add(null);
                newBranchEncoders.add(oldBranchEncoders[i]);
            }
            IProgramExecution.ProgramState<Term> newProgramState = this.translateProgramState(oldIcfgPe.getProgramState(i));
            newValues.add(newProgramState);
            newBranchEncoders.add(oldBranchEncoders[i]);
            ++i;
        }
        HashMap<Integer, IProgramExecution.ProgramState<Term>> newValuesMap = new HashMap<Integer, IProgramExecution.ProgramState<Term>>();
        newValuesMap.put(-1, oldIcfgPe.getInitialProgramState());
        int i2 = 0;
        while (i2 < newValues.size()) {
            newValuesMap.put(i2, (IProgramExecution.ProgramState)newValues.get(i2));
            ++i2;
        }
        IcfgProgramExecution<IIcfgTransition<IcfgLocation>> newPe = new IcfgProgramExecution<IIcfgTransition<IcfgLocation>>(newTrace, newValuesMap, newBranchEncoders.toArray(new Map[newBranchEncoders.size()]), oldIcfgPe.isConcurrent(), IcfgProgramExecution.getClassFromAtomicTraceElements(newTrace));
        assert (this.checkCallStackTargetProgramExecution(this.mLogger, newPe)) : "callstack broke during translation";
        return newPe;
    }

    private Collection<IIcfgTransition<IcfgLocation>> translateBack(IIcfgTransition<IcfgLocation> transition, Map<TermVariable, Boolean> branchEncoders) {
        ArrayDeque<IIcfgTransition<IcfgLocation>> result = new ArrayDeque<IIcfgTransition<IcfgLocation>>();
        ArrayDeque<IIcfgTransition<IcfgLocation>> stack = new ArrayDeque<IIcfgTransition<IcfgLocation>>();
        stack.push(transition);
        while (!stack.isEmpty()) {
            IIcfgTransition current = (IIcfgTransition)stack.pop();
            if (this.mSequentialCompositions.containsKey(current)) {
                List<IIcfgTransition<IcfgLocation>> sequence = this.mSequentialCompositions.get(current);
                assert (sequence != null);
                for (IIcfgTransition<IcfgLocation> component : sequence) {
                    stack.push(component);
                }
                continue;
            }
            if (this.mParallelCompositions.containsKey(current)) {
                Set<IIcfgTransition<IcfgLocation>> choices = this.mParallelCompositions.get(current);
                assert (choices != null);
                if (branchEncoders == null) {
                    this.mLogger.warn((Object)"Failed to translate choice composition: Branch encoders not available.");
                    result.addFirst(current);
                    continue;
                }
                boolean choiceFound = false;
                for (IIcfgTransition<IcfgLocation> choice : choices) {
                    assert (this.mBranchEncoderMapping.get(choice) != null) : "Choice composition is missing branch encoder";
                    TermVariable indicator = this.mBranchEncoderMapping.get(choice);
                    assert (branchEncoders.get(indicator) != null) : "Branch indicator value was unknown";
                    if (!branchEncoders.get(indicator).booleanValue()) continue;
                    stack.push(choice);
                    choiceFound = true;
                    break;
                }
                assert (choiceFound) : "Could not determine correct choice for choice composition";
                continue;
            }
            result.addFirst(current);
        }
        return result;
    }

    public void mapEdges(IIcfgTransition<IcfgLocation> newEdge, IIcfgTransition<IcfgLocation> originalEdge) {
        List<IIcfgTransition<IcfgLocation>> limboEdges = this.mSequentialCompositions.get(originalEdge);
        if (limboEdges != null) {
            this.mIntermediateEdges.add(originalEdge);
            for (IIcfgTransition<IcfgLocation> limboEdge : limboEdges) {
                this.mapEdges(newEdge, limboEdge);
            }
            return;
        }
        List originalEdges = this.mSequentialCompositions.computeIfAbsent(newEdge, x -> new ArrayList());
        originalEdges.add(originalEdge);
    }

    public void mapEdges(IIcfgTransition<IcfgLocation> newEdge, Map<TermVariable, IIcfgTransition<IcfgLocation>> originalEdges) {
        for (Map.Entry<TermVariable, IIcfgTransition<IcfgLocation>> entry : originalEdges.entrySet()) {
            this.mapEdges(newEdge, entry.getValue(), entry.getKey());
        }
    }

    public void mapEdges(IIcfgTransition<IcfgLocation> newEdge, IIcfgTransition<IcfgLocation> originalEdge, TermVariable branchEncoder) {
        TermVariable oldEncoder = this.mBranchEncoderMapping.get(originalEdge);
        assert (oldEncoder == null || oldEncoder == branchEncoder) : "Ambiguous branch encoder for transition";
        this.mBranchEncoderMapping.put(originalEdge, branchEncoder);
        Set<IIcfgTransition<IcfgLocation>> limboEdges = this.mParallelCompositions.get(originalEdge);
        if (limboEdges != null) {
            this.mIntermediateEdges.add(originalEdge);
            for (IIcfgTransition<IcfgLocation> limboEdge : limboEdges) {
                this.mapEdges(newEdge, limboEdge, this.mBranchEncoderMapping.get(limboEdge));
            }
            return;
        }
        Set originalEdges = this.mParallelCompositions.computeIfAbsent(newEdge, x -> new HashSet());
        originalEdges.add(originalEdge);
    }

    public void removeIntermediateMappings() {
        if (this.mIntermediateEdges.isEmpty()) {
            return;
        }
        for (IIcfgTransition<IcfgLocation> edge : this.mIntermediateEdges) {
            assert (this.mSequentialCompositions.values().stream().noneMatch(s -> s.contains(edge))) : "Intermediate edge should not be used in sequential composition";
            assert (this.mParallelCompositions.values().stream().noneMatch(s -> s.contains(edge))) : "Intermediate edge should not be used in parallel composition";
            this.mSequentialCompositions.remove(edge);
            this.mParallelCompositions.remove(edge);
        }
        this.mIntermediateEdges.clear();
    }

    private void printMapping(IIcfgTransition<IcfgLocation> newEdge, List<IIcfgTransition<IcfgLocation>> originalEdges) {
        this.mLogger.info((Object)(String.valueOf(BlockEncodingBacktranslator.markCodeblock(newEdge)) + newEdge.hashCode() + " is mapped to " + BlockEncodingBacktranslator.getCollectionString(originalEdges)));
    }

    private void printMapping(IIcfgTransition<IcfgLocation> newEdge, Set<IIcfgTransition<IcfgLocation>> originalEdges) {
        this.mLogger.info((Object)(String.valueOf(BlockEncodingBacktranslator.markCodeblock(newEdge)) + newEdge.hashCode() + " is mapped (in parallel) to " + BlockEncodingBacktranslator.getCollectionString(originalEdges)));
    }

    private static String getCollectionString(Collection<IIcfgTransition<IcfgLocation>> originalEdges) {
        return originalEdges.stream().map(a -> String.valueOf(BlockEncodingBacktranslator.markCodeblock(a)) + String.valueOf(a.hashCode())).collect(Collectors.joining(","));
    }

    public void addAteTransformer(IIcfgTransition<IcfgLocation> newEdge, Consumer<AtomicTraceElement.AtomicTraceElementBuilder<IIcfgTransition<IcfgLocation>>> transformer) {
        this.mAteTransformer.merge(newEdge, transformer, Consumer::andThen);
    }

    private static String markCodeblock(IIcfgTransition<IcfgLocation> newEdge) {
        return "";
    }

    public void mapLocations(IcfgLocation newLoc, IcfgLocation oldLoc) {
        IcfgLocation realOldLoc = this.mLocationMapping.get(oldLoc);
        if (realOldLoc != null) {
            this.mLocationMapping.put(newLoc, realOldLoc);
        } else {
            this.mLocationMapping.put(newLoc, oldLoc);
        }
    }

    public Map<IcfgLocation, IcfgLocation> getLocationMapping() {
        return Collections.unmodifiableMap(this.mLocationMapping);
    }

    @Deprecated
    public Map<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>> getEdgeMapping() {
        HashMap<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>> rtr = new HashMap<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>>();
        for (Map.Entry<IIcfgTransition<IcfgLocation>, List<IIcfgTransition<IcfgLocation>>> entry : this.mSequentialCompositions.entrySet()) {
            if (entry.getValue().size() > 1) {
                throw new UnsupportedOperationException("The new edge " + entry.getKey() + " is mapped to multiple edges");
            }
            rtr.put(entry.getKey(), entry.getValue().isEmpty() ? null : entry.getValue().get(0));
        }
        return rtr;
    }

    protected void printBrokenCallStackSource(List<AtomicTraceElement<IIcfgTransition<IcfgLocation>>> trace, int breakpointIndex) {
        List teList = trace.stream().limit(breakpointIndex).map(a -> (IIcfgTransition)a.getTraceElement()).collect(Collectors.toList());
        this.mLogger.fatal((Object)new ProgramExecutionFormatter(new IcfgBacktranslationValueProvider()).formatProgramExecution(IcfgProgramExecution.create(teList, Collections.emptyMap())));
    }

    protected void printBrokenCallStackTarget(List<AtomicTraceElement<IIcfgTransition<IcfgLocation>>> trace, int breakpointIndex) {
        this.printBrokenCallStackSource(trace, breakpointIndex);
    }

    public void setTermTranslator(Function<Term, Term> termTranslator) {
        this.mTermTranslator = termTranslator;
    }

    public Term translateExpression(Term expression) {
        Term result = this.mTermTranslator.apply(expression);
        return result;
    }

    public IProgramExecution.ProgramState<Term> translateProgramState(IProgramExecution.ProgramState<Term> oldProgramState) {
        if (oldProgramState == null) {
            return null;
        }
        HashMap variable2Values = new HashMap();
        for (Term oldVariable : oldProgramState.getVariables()) {
            if (this.mVariableBlacklist.contains(oldVariable)) continue;
            Term newVariable = this.translateExpression(oldVariable);
            ArrayList<Term> newValues = new ArrayList<Term>();
            for (Term oldValue : oldProgramState.getValues((Object)oldVariable)) {
                newValues.add(this.translateExpression(oldValue));
            }
            variable2Values.put(newVariable, newValues);
        }
        return new IProgramExecution.ProgramState(variable2Values, this.getTargetExpressionClass());
    }

    public void setVariableBlacklist(Set<Term> variableBlacklist) {
        this.mVariableBlacklist = variableBlacklist;
    }
}

